/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.xmss;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.pqc.crypto.StateAwareMessageSigner;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.BDS;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.BDSStateMap;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTSignature;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSNode;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSReducedSignature;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.d;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.h;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.j;
import com.enterprisedt.bouncycastle.util.Arrays;

public class XMSSMTSigner
implements StateAwareMessageSigner {
    private XMSSMTPrivateKeyParameters a;
    private XMSSMTPublicKeyParameters b;
    private XMSSMTParameters c;
    private XMSSParameters d;
    private d e;
    private boolean f;
    private boolean g;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            this.g = true;
            this.f = false;
            this.a = (XMSSMTPrivateKeyParameters)param;
            this.c = this.a.getParameters();
            this.d = this.c.getXMSSParameters();
        } else {
            this.g = false;
            this.b = (XMSSMTPublicKeyParameters)param;
            this.c = this.b.getParameters();
            this.d = this.c.getXMSSParameters();
        }
        this.e = this.c.getWOTSPlus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] generateSignature(byte[] message) {
        if (message == null) {
            throw new NullPointerException("message == null");
        }
        if (this.g) {
            if (this.a == null) {
                throw new IllegalStateException("signing key no longer usable");
            }
        } else {
            throw new IllegalStateException("signer not initialized for signature generation");
        }
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = this.a;
        synchronized (xMSSMTPrivateKeyParameters) {
            byte[] byArray;
            if (this.a.getUsagesRemaining() <= 0L) {
                throw new IllegalStateException("no usages of private key remaining");
            }
            if (this.a.a().isEmpty()) {
                throw new IllegalStateException("not initialized");
            }
            try {
                BDSStateMap bDSStateMap = this.a.a();
                long l2 = this.a.getIndex();
                int n2 = this.c.getHeight();
                int n3 = this.d.getHeight();
                if (this.a.getUsagesRemaining() <= 0L) {
                    throw new IllegalStateException("index out of bounds");
                }
                byte[] byArray2 = this.e.b().d(this.a.getSecretKeyPRF(), XMSSUtil.toBytesBigEndian(l2, 32));
                byte[] byArray3 = Arrays.concatenate(byArray2, this.a.getRoot(), XMSSUtil.toBytesBigEndian(l2, this.c.getTreeDigestSize()));
                byte[] byArray4 = this.e.b().c(byArray3, message);
                this.f = true;
                XMSSMTSignature xMSSMTSignature = new XMSSMTSignature.Builder(this.c).withIndex(l2).withRandom(byArray2).build();
                long l3 = XMSSUtil.getTreeIndex(l2, n3);
                int n4 = XMSSUtil.getLeafIndex(l2, n3);
                this.e.a(new byte[this.c.getTreeDigestSize()], this.a.getPublicSeed());
                OTSHashAddress oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withTreeAddress(l3)).withOTSAddress(n4).build();
                if (bDSStateMap.a(0) == null || n4 == 0) {
                    bDSStateMap.a(0, new BDS(this.d, this.a.getPublicSeed(), this.a.getSecretKeySeed(), oTSHashAddress));
                }
                h h2 = this.a(byArray4, oTSHashAddress);
                XMSSReducedSignature xMSSReducedSignature = new XMSSReducedSignature.Builder(this.d).withWOTSPlusSignature(h2).withAuthPath(bDSStateMap.a(0).getAuthenticationPath()).build();
                xMSSMTSignature.getReducedSignatures().add(xMSSReducedSignature);
                for (int i2 = 1; i2 < this.c.getLayers(); ++i2) {
                    XMSSNode xMSSNode = bDSStateMap.a(i2 - 1).getRoot();
                    n4 = XMSSUtil.getLeafIndex(l3, n3);
                    l3 = XMSSUtil.getTreeIndex(l3, n3);
                    oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(i2)).withTreeAddress(l3)).withOTSAddress(n4).build();
                    h2 = this.a(xMSSNode.getValue(), oTSHashAddress);
                    if (bDSStateMap.a(i2) == null || XMSSUtil.isNewBDSInitNeeded(l2, n3, i2)) {
                        bDSStateMap.a(i2, new BDS(this.d, this.a.getPublicSeed(), this.a.getSecretKeySeed(), oTSHashAddress));
                    }
                    xMSSReducedSignature = new XMSSReducedSignature.Builder(this.d).withWOTSPlusSignature(h2).withAuthPath(bDSStateMap.a(i2).getAuthenticationPath()).build();
                    xMSSMTSignature.getReducedSignatures().add(xMSSReducedSignature);
                }
                byArray = xMSSMTSignature.toByteArray();
                this.a.b();
            }
            catch (Throwable throwable) {
                this.a.b();
                throw throwable;
            }
            return byArray;
        }
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] signature) {
        if (message == null) {
            throw new NullPointerException("message == null");
        }
        if (signature == null) {
            throw new NullPointerException("signature == null");
        }
        if (this.b == null) {
            throw new NullPointerException("publicKey == null");
        }
        XMSSMTSignature xMSSMTSignature = new XMSSMTSignature.Builder(this.c).withSignature(signature).build();
        byte[] byArray = Arrays.concatenate(xMSSMTSignature.getRandom(), this.b.getRoot(), XMSSUtil.toBytesBigEndian(xMSSMTSignature.getIndex(), this.c.getTreeDigestSize()));
        byte[] byArray2 = this.e.b().c(byArray, message);
        long l2 = xMSSMTSignature.getIndex();
        int n2 = this.d.getHeight();
        long l3 = XMSSUtil.getTreeIndex(l2, n2);
        int n3 = XMSSUtil.getLeafIndex(l2, n2);
        this.e.a(new byte[this.c.getTreeDigestSize()], this.b.getPublicSeed());
        OTSHashAddress oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withTreeAddress(l3)).withOTSAddress(n3).build();
        XMSSReducedSignature xMSSReducedSignature = xMSSMTSignature.getReducedSignatures().get(0);
        XMSSNode xMSSNode = j.a(this.e, n2, byArray2, xMSSReducedSignature, oTSHashAddress, n3);
        for (int i2 = 1; i2 < this.c.getLayers(); ++i2) {
            xMSSReducedSignature = xMSSMTSignature.getReducedSignatures().get(i2);
            n3 = XMSSUtil.getLeafIndex(l3, n2);
            l3 = XMSSUtil.getTreeIndex(l3, n2);
            oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(i2)).withTreeAddress(l3)).withOTSAddress(n3).build();
            xMSSNode = j.a(this.e, n2, xMSSNode.getValue(), xMSSReducedSignature, oTSHashAddress, n3);
        }
        return Arrays.constantTimeAreEqual(xMSSNode.getValue(), this.b.getRoot());
    }

    private h a(byte[] byArray, OTSHashAddress oTSHashAddress) {
        if (byArray.length != this.c.getTreeDigestSize()) {
            throw new IllegalArgumentException("size of messageDigest needs to be equal to size of digest");
        }
        if (oTSHashAddress == null) {
            throw new NullPointerException("otsHashAddress == null");
        }
        this.e.a(this.e.b(this.a.getSecretKeySeed(), oTSHashAddress), this.a.getPublicSeed());
        return this.e.a(byArray, oTSHashAddress);
    }

    public long getUsagesRemaining() {
        return this.a.getUsagesRemaining();
    }

    @Override
    public AsymmetricKeyParameter getUpdatedPrivateKey() {
        if (this.f) {
            XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = this.a;
            this.a = null;
            return xMSSMTPrivateKeyParameters;
        }
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = this.a;
        if (xMSSMTPrivateKeyParameters != null) {
            this.a = this.a.getNextKey();
        }
        return xMSSMTPrivateKeyParameters;
    }
}

