/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.legacy.crypto.gmss;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.pqc.crypto.MessageSigner;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.gmss.GMSSDigestProvider;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.gmss.GMSSKeyParameters;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.gmss.GMSSParameters;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.gmss.GMSSPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.gmss.GMSSPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.gmss.util.GMSSRandom;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.gmss.util.GMSSUtil;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.gmss.util.WinternitzOTSVerify;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.gmss.util.WinternitzOTSignature;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class GMSSSigner
implements MessageSigner {
    private GMSSUtil b = new GMSSUtil();
    private byte[] c;
    private Digest d;
    private int e;
    private int f;
    private Digest g;
    private WinternitzOTSignature h;
    private GMSSDigestProvider i;
    private int[] j;
    private byte[][][] k;
    private byte[][] l;
    private GMSSParameters m;
    private GMSSRandom n;
    GMSSKeyParameters a;
    private SecureRandom o;

    public GMSSSigner(GMSSDigestProvider digest) {
        this.i = digest;
        this.g = this.d = digest.get();
        this.e = this.d.getDigestSize();
        this.n = new GMSSRandom(this.d);
    }

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)param;
                this.o = parametersWithRandom.getRandom();
                this.a = (GMSSPrivateKeyParameters)parametersWithRandom.getParameters();
                this.a();
            } else {
                this.o = CryptoServicesRegistrar.getSecureRandom();
                this.a = (GMSSPrivateKeyParameters)param;
                this.a();
            }
        } else {
            this.a = (GMSSPublicKeyParameters)param;
            this.b();
        }
    }

    private void a() {
        int n2;
        this.d.reset();
        GMSSPrivateKeyParameters gMSSPrivateKeyParameters = (GMSSPrivateKeyParameters)this.a;
        if (gMSSPrivateKeyParameters.isUsed()) {
            throw new IllegalStateException("Private key already used");
        }
        if (gMSSPrivateKeyParameters.getIndex(0) >= gMSSPrivateKeyParameters.getNumLeafs(0)) {
            throw new IllegalStateException("No more signatures can be generated");
        }
        this.m = gMSSPrivateKeyParameters.getParameters();
        this.f = this.m.getNumOfLayers();
        byte[] byArray = gMSSPrivateKeyParameters.getCurrentSeeds()[this.f - 1];
        byte[] byArray2 = new byte[this.e];
        byte[] byArray3 = new byte[this.e];
        System.arraycopy(byArray, 0, byArray3, 0, this.e);
        byArray2 = this.n.nextSeed(byArray3);
        this.h = new WinternitzOTSignature(byArray2, this.i.get(), this.m.getWinternitzParameter()[this.f - 1]);
        byte[][][] byArray4 = gMSSPrivateKeyParameters.getCurrentAuthPaths();
        this.k = new byte[this.f][][];
        for (int i2 = 0; i2 < this.f; ++i2) {
            this.k[i2] = new byte[byArray4[i2].length][this.e];
            for (n2 = 0; n2 < byArray4[i2].length; ++n2) {
                System.arraycopy(byArray4[i2][n2], 0, this.k[i2][n2], 0, this.e);
            }
        }
        this.j = new int[this.f];
        System.arraycopy(gMSSPrivateKeyParameters.getIndex(), 0, this.j, 0, this.f);
        this.l = new byte[this.f - 1][];
        for (n2 = 0; n2 < this.f - 1; ++n2) {
            byte[] byArray5 = gMSSPrivateKeyParameters.getSubtreeRootSig(n2);
            this.l[n2] = new byte[byArray5.length];
            System.arraycopy(byArray5, 0, this.l[n2], 0, byArray5.length);
        }
        gMSSPrivateKeyParameters.markUsed();
    }

    @Override
    public byte[] generateSignature(byte[] message) {
        byte[] byArray = new byte[this.e];
        byArray = this.h.getSignature(message);
        byte[] byArray2 = this.b.concatenateArray(this.k[this.f - 1]);
        byte[] byArray3 = this.b.intToBytesLittleEndian(this.j[this.f - 1]);
        byte[] byArray4 = new byte[byArray3.length + byArray.length + byArray2.length];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        System.arraycopy(byArray, 0, byArray4, byArray3.length, byArray.length);
        System.arraycopy(byArray2, 0, byArray4, byArray3.length + byArray.length, byArray2.length);
        byte[] byArray5 = new byte[]{};
        for (int i2 = this.f - 1 - 1; i2 >= 0; --i2) {
            byArray2 = this.b.concatenateArray(this.k[i2]);
            byArray3 = this.b.intToBytesLittleEndian(this.j[i2]);
            byte[] byArray6 = new byte[byArray5.length];
            System.arraycopy(byArray5, 0, byArray6, 0, byArray5.length);
            byArray5 = new byte[byArray6.length + byArray3.length + this.l[i2].length + byArray2.length];
            System.arraycopy(byArray6, 0, byArray5, 0, byArray6.length);
            System.arraycopy(byArray3, 0, byArray5, byArray6.length, byArray3.length);
            System.arraycopy(this.l[i2], 0, byArray5, byArray6.length + byArray3.length, this.l[i2].length);
            System.arraycopy(byArray2, 0, byArray5, byArray6.length + byArray3.length + this.l[i2].length, byArray2.length);
        }
        byte[] byArray7 = new byte[byArray4.length + byArray5.length];
        System.arraycopy(byArray4, 0, byArray7, 0, byArray4.length);
        System.arraycopy(byArray5, 0, byArray7, byArray4.length, byArray5.length);
        return byArray7;
    }

    private void b() {
        this.d.reset();
        GMSSPublicKeyParameters gMSSPublicKeyParameters = (GMSSPublicKeyParameters)this.a;
        this.c = gMSSPublicKeyParameters.getPublicKey();
        this.m = gMSSPublicKeyParameters.getParameters();
        this.f = this.m.getNumOfLayers();
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] signature) {
        boolean bl = false;
        this.g.reset();
        byte[] byArray = message;
        int n2 = 0;
        for (int i2 = this.f - 1; i2 >= 0; --i2) {
            int n3;
            WinternitzOTSVerify winternitzOTSVerify = new WinternitzOTSVerify(this.i.get(), this.m.getWinternitzParameter()[i2]);
            int n4 = winternitzOTSVerify.getSignatureLength();
            message = byArray;
            int n5 = this.b.bytesToIntLittleEndian(signature, n2);
            byte[] byArray2 = new byte[n4];
            System.arraycopy(signature, n2 += 4, byArray2, 0, n4);
            n2 += n4;
            byte[] byArray3 = winternitzOTSVerify.Verify(message, byArray2);
            if (byArray3 == null) {
                System.err.println("OTS Public Key is null in GMSSSignature.verify");
                return false;
            }
            byte[][] byArray4 = new byte[this.m.getHeightOfTrees()[i2]][this.e];
            for (n3 = 0; n3 < byArray4.length; ++n3) {
                System.arraycopy(signature, n2, byArray4[n3], 0, this.e);
                n2 += this.e;
            }
            byArray = new byte[this.e];
            byArray = byArray3;
            n3 = 1 << byArray4.length;
            n3 += n5;
            for (int i3 = 0; i3 < byArray4.length; ++i3) {
                byte[] byArray5 = new byte[this.e << 1];
                if (n3 % 2 == 0) {
                    System.arraycopy(byArray, 0, byArray5, 0, this.e);
                    System.arraycopy(byArray4[i3], 0, byArray5, this.e, this.e);
                    n3 /= 2;
                } else {
                    System.arraycopy(byArray4[i3], 0, byArray5, 0, this.e);
                    System.arraycopy(byArray, 0, byArray5, this.e, byArray.length);
                    n3 = (n3 - 1) / 2;
                }
                this.d.update(byArray5, 0, byArray5.length);
                byArray = new byte[this.d.getDigestSize()];
                this.d.doFinal(byArray, 0);
            }
        }
        if (Arrays.areEqual(this.c, byArray)) {
            bl = true;
        }
        return bl;
    }
}

