/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.legacy.crypto.mceliece;

import com.enterprisedt.bouncycastle.pqc.legacy.crypto.mceliece.McElieceCCA2KeyParameters;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2Matrix;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2mField;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GoppaCode;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.Permutation;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.PolynomialGF2mSmallM;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.PolynomialRingGF2m;

public class McElieceCCA2PrivateKeyParameters
extends McElieceCCA2KeyParameters {
    private int b;
    private int c;
    private GF2mField d;
    private PolynomialGF2mSmallM e;
    private Permutation f;
    private GF2Matrix g;
    private PolynomialGF2mSmallM[] h;

    public McElieceCCA2PrivateKeyParameters(int n2, int k2, GF2mField field, PolynomialGF2mSmallM gp, Permutation p2, String digest) {
        this(n2, k2, field, gp, GoppaCode.createCanonicalCheckMatrix(field, gp), p2, digest);
    }

    public McElieceCCA2PrivateKeyParameters(int n2, int k2, GF2mField field, PolynomialGF2mSmallM gp, GF2Matrix canonicalCheckMatrix, Permutation p2, String digest) {
        super(true, digest);
        this.b = n2;
        this.c = k2;
        this.d = field;
        this.e = gp;
        this.g = canonicalCheckMatrix;
        this.f = p2;
        PolynomialRingGF2m polynomialRingGF2m = new PolynomialRingGF2m(field, gp);
        this.h = polynomialRingGF2m.getSquareRootMatrix();
    }

    public int getN() {
        return this.b;
    }

    public int getK() {
        return this.c;
    }

    public int getT() {
        return this.e.getDegree();
    }

    public GF2mField getField() {
        return this.d;
    }

    public PolynomialGF2mSmallM getGoppaPoly() {
        return this.e;
    }

    public Permutation getP() {
        return this.f;
    }

    public GF2Matrix getH() {
        return this.g;
    }

    public PolynomialGF2mSmallM[] getQInv() {
        return this.h;
    }
}

