/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.legacy.crypto.mceliece;

import com.enterprisedt.bouncycastle.pqc.legacy.crypto.mceliece.McElieceKeyParameters;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2Matrix;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2mField;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GoppaCode;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.Permutation;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.PolynomialGF2mSmallM;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.PolynomialRingGF2m;

public class McEliecePrivateKeyParameters
extends McElieceKeyParameters {
    private int b;
    private int c;
    private GF2mField d;
    private PolynomialGF2mSmallM e;
    private GF2Matrix f;
    private Permutation g;
    private Permutation h;
    private GF2Matrix i;
    private PolynomialGF2mSmallM[] j;

    public McEliecePrivateKeyParameters(int n2, int k2, GF2mField field, PolynomialGF2mSmallM gp, Permutation p1, Permutation p2, GF2Matrix sInv) {
        super(true, null);
        this.c = k2;
        this.b = n2;
        this.d = field;
        this.e = gp;
        this.f = sInv;
        this.g = p1;
        this.h = p2;
        this.i = GoppaCode.createCanonicalCheckMatrix(field, gp);
        PolynomialRingGF2m polynomialRingGF2m = new PolynomialRingGF2m(field, gp);
        this.j = polynomialRingGF2m.getSquareRootMatrix();
    }

    public McEliecePrivateKeyParameters(int n2, int k2, byte[] encField, byte[] encGoppaPoly, byte[] encSInv, byte[] encP1, byte[] encP2, byte[] encH, byte[][] encQInv) {
        super(true, null);
        this.b = n2;
        this.c = k2;
        this.d = new GF2mField(encField);
        this.e = new PolynomialGF2mSmallM(this.d, encGoppaPoly);
        this.f = new GF2Matrix(encSInv);
        this.g = new Permutation(encP1);
        this.h = new Permutation(encP2);
        this.i = new GF2Matrix(encH);
        this.j = new PolynomialGF2mSmallM[encQInv.length];
        for (int i2 = 0; i2 < encQInv.length; ++i2) {
            this.j[i2] = new PolynomialGF2mSmallM(this.d, encQInv[i2]);
        }
    }

    public int getN() {
        return this.b;
    }

    public int getK() {
        return this.c;
    }

    public GF2mField getField() {
        return this.d;
    }

    public PolynomialGF2mSmallM getGoppaPoly() {
        return this.e;
    }

    public GF2Matrix getSInv() {
        return this.f;
    }

    public Permutation getP1() {
        return this.g;
    }

    public Permutation getP2() {
        return this.h;
    }

    public GF2Matrix getH() {
        return this.i;
    }

    public PolynomialGF2mSmallM[] getQInv() {
        return this.j;
    }
}

