/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra;

import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2Polynomial;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2nElement;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2nField;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2nONBElement;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2nONBField;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2nPolynomialElement;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2nPolynomialField;
import com.enterprisedt.bouncycastle.util.Arrays;

public class GF2nPolynomial {
    private GF2nElement[] a;
    private int b;

    public GF2nPolynomial(int deg, GF2nElement elem) {
        this.b = deg;
        this.a = new GF2nElement[this.b];
        for (int i2 = 0; i2 < this.b; ++i2) {
            this.a[i2] = (GF2nElement)elem.clone();
        }
    }

    private GF2nPolynomial(int deg) {
        this.b = deg;
        this.a = new GF2nElement[this.b];
    }

    public GF2nPolynomial(GF2nPolynomial a2) {
        this.a = new GF2nElement[a2.b];
        this.b = a2.b;
        for (int i2 = 0; i2 < this.b; ++i2) {
            this.a[i2] = (GF2nElement)a2.a[i2].clone();
        }
    }

    public GF2nPolynomial(GF2Polynomial polynomial, GF2nField B1) {
        this.b = B1.getDegree() + 1;
        this.a = new GF2nElement[this.b];
        if (B1 instanceof GF2nONBField) {
            for (int i2 = 0; i2 < this.b; ++i2) {
                this.a[i2] = polynomial.testBit(i2) ? GF2nONBElement.ONE((GF2nONBField)B1) : GF2nONBElement.ZERO((GF2nONBField)B1);
            }
        } else if (B1 instanceof GF2nPolynomialField) {
            for (int i3 = 0; i3 < this.b; ++i3) {
                this.a[i3] = polynomial.testBit(i3) ? GF2nPolynomialElement.ONE((GF2nPolynomialField)B1) : GF2nPolynomialElement.ZERO((GF2nPolynomialField)B1);
            }
        } else {
            throw new IllegalArgumentException("PolynomialGF2n(Bitstring, GF2nField): B1 must be an instance of GF2nONBField or GF2nPolynomialField!");
        }
    }

    public final void assignZeroToElements() {
        for (int i2 = 0; i2 < this.b; ++i2) {
            this.a[i2].a();
        }
    }

    public final int size() {
        return this.b;
    }

    public final int getDegree() {
        for (int i2 = this.b - 1; i2 >= 0; --i2) {
            if (this.a[i2].isZero()) continue;
            return i2;
        }
        return -1;
    }

    public final void enlarge(int k2) {
        if (k2 <= this.b) {
            return;
        }
        GF2nElement[] gF2nElementArray = new GF2nElement[k2];
        System.arraycopy(this.a, 0, gF2nElementArray, 0, this.b);
        GF2nField gF2nField = this.a[0].getField();
        if (this.a[0] instanceof GF2nPolynomialElement) {
            for (int i2 = this.b; i2 < k2; ++i2) {
                gF2nElementArray[i2] = GF2nPolynomialElement.ZERO((GF2nPolynomialField)gF2nField);
            }
        } else if (this.a[0] instanceof GF2nONBElement) {
            for (int i3 = this.b; i3 < k2; ++i3) {
                gF2nElementArray[i3] = GF2nONBElement.ZERO((GF2nONBField)gF2nField);
            }
        }
        this.b = k2;
        this.a = gF2nElementArray;
    }

    public final void shrink() {
        int n2;
        for (n2 = this.b - 1; this.a[n2].isZero() && n2 > 0; --n2) {
        }
        if (++n2 < this.b) {
            GF2nElement[] gF2nElementArray = new GF2nElement[n2];
            System.arraycopy(this.a, 0, gF2nElementArray, 0, n2);
            this.a = gF2nElementArray;
            this.b = n2;
        }
    }

    public final void set(int index, GF2nElement elem) {
        if (!(elem instanceof GF2nPolynomialElement) && !(elem instanceof GF2nONBElement)) {
            throw new IllegalArgumentException("PolynomialGF2n.set f must be an instance of either GF2nPolynomialElement or GF2nONBElement!");
        }
        this.a[index] = (GF2nElement)elem.clone();
    }

    public final GF2nElement at(int index) {
        return this.a[index];
    }

    public final boolean isZero() {
        for (int i2 = 0; i2 < this.b; ++i2) {
            if (this.a[i2] == null || this.a[i2].isZero()) continue;
            return false;
        }
        return true;
    }

    public final boolean equals(Object other) {
        if (other == null || !(other instanceof GF2nPolynomial)) {
            return false;
        }
        GF2nPolynomial gF2nPolynomial = (GF2nPolynomial)other;
        if (this.getDegree() != gF2nPolynomial.getDegree()) {
            return false;
        }
        for (int i2 = 0; i2 < this.b; ++i2) {
            if (this.a[i2].equals(gF2nPolynomial.a[i2])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getDegree() * 7 + Arrays.hashCode(this.a);
    }

    public final GF2nPolynomial add(GF2nPolynomial b2) {
        GF2nPolynomial gF2nPolynomial;
        if (this.size() >= b2.size()) {
            int n2;
            gF2nPolynomial = new GF2nPolynomial(this.size());
            for (n2 = 0; n2 < b2.size(); ++n2) {
                gF2nPolynomial.a[n2] = (GF2nElement)this.a[n2].add(b2.a[n2]);
            }
            while (n2 < this.size()) {
                gF2nPolynomial.a[n2] = this.a[n2];
                ++n2;
            }
        } else {
            int n3;
            gF2nPolynomial = new GF2nPolynomial(b2.size());
            for (n3 = 0; n3 < this.size(); ++n3) {
                gF2nPolynomial.a[n3] = (GF2nElement)this.a[n3].add(b2.a[n3]);
            }
            while (n3 < b2.size()) {
                gF2nPolynomial.a[n3] = b2.a[n3];
                ++n3;
            }
        }
        return gF2nPolynomial;
    }

    public final GF2nPolynomial scalarMultiply(GF2nElement s2) {
        GF2nPolynomial gF2nPolynomial = new GF2nPolynomial(this.size());
        for (int i2 = 0; i2 < this.size(); ++i2) {
            gF2nPolynomial.a[i2] = (GF2nElement)this.a[i2].multiply(s2);
        }
        return gF2nPolynomial;
    }

    public final GF2nPolynomial multiply(GF2nPolynomial b2) {
        int n2;
        int n3 = this.size();
        if (n3 != (n2 = b2.size())) {
            throw new IllegalArgumentException("PolynomialGF2n.multiply: this and b must have the same size!");
        }
        GF2nPolynomial gF2nPolynomial = new GF2nPolynomial((n3 << 1) - 1);
        for (int i2 = 0; i2 < this.size(); ++i2) {
            for (int i3 = 0; i3 < b2.size(); ++i3) {
                gF2nPolynomial.a[i2 + i3] = gF2nPolynomial.a[i2 + i3] == null ? (GF2nElement)this.a[i2].multiply(b2.a[i3]) : (GF2nElement)gF2nPolynomial.a[i2 + i3].add(this.a[i2].multiply(b2.a[i3]));
            }
        }
        return gF2nPolynomial;
    }

    public final GF2nPolynomial multiplyAndReduce(GF2nPolynomial b2, GF2nPolynomial g2) {
        return this.multiply(b2).reduce(g2);
    }

    public final GF2nPolynomial reduce(GF2nPolynomial g2) throws RuntimeException, ArithmeticException {
        return this.remainder(g2);
    }

    public final void shiftThisLeft(int amount) {
        block3: {
            int n2;
            GF2nField gF2nField;
            block4: {
                if (amount <= 0) break block3;
                int n3 = this.b;
                gF2nField = this.a[0].getField();
                this.enlarge(this.b + amount);
                for (n2 = n3 - 1; n2 >= 0; --n2) {
                    this.a[n2 + amount] = this.a[n2];
                }
                if (!(this.a[0] instanceof GF2nPolynomialElement)) break block4;
                for (n2 = amount - 1; n2 >= 0; --n2) {
                    this.a[n2] = GF2nPolynomialElement.ZERO((GF2nPolynomialField)gF2nField);
                }
                break block3;
            }
            if (!(this.a[0] instanceof GF2nONBElement)) break block3;
            for (n2 = amount - 1; n2 >= 0; --n2) {
                this.a[n2] = GF2nONBElement.ZERO((GF2nONBField)gF2nField);
            }
        }
    }

    public final GF2nPolynomial shiftLeft(int amount) {
        if (amount <= 0) {
            return new GF2nPolynomial(this);
        }
        GF2nPolynomial gF2nPolynomial = new GF2nPolynomial(this.b + amount, this.a[0]);
        gF2nPolynomial.assignZeroToElements();
        for (int i2 = 0; i2 < this.b; ++i2) {
            gF2nPolynomial.a[i2 + amount] = this.a[i2];
        }
        return gF2nPolynomial;
    }

    public final GF2nPolynomial[] divide(GF2nPolynomial b2) {
        GF2nPolynomial[] gF2nPolynomialArray = new GF2nPolynomial[2];
        GF2nPolynomial gF2nPolynomial = new GF2nPolynomial(this);
        gF2nPolynomial.shrink();
        int n2 = b2.getDegree();
        GF2nElement gF2nElement = (GF2nElement)b2.a[n2].invert();
        if (gF2nPolynomial.getDegree() < n2) {
            gF2nPolynomialArray[0] = new GF2nPolynomial(this);
            gF2nPolynomialArray[0].assignZeroToElements();
            gF2nPolynomialArray[0].shrink();
            gF2nPolynomialArray[1] = new GF2nPolynomial(this);
            gF2nPolynomialArray[1].shrink();
            return gF2nPolynomialArray;
        }
        gF2nPolynomialArray[0] = new GF2nPolynomial(this);
        gF2nPolynomialArray[0].assignZeroToElements();
        int n3 = gF2nPolynomial.getDegree() - n2;
        while (n3 >= 0) {
            GF2nElement gF2nElement2 = (GF2nElement)gF2nPolynomial.a[gF2nPolynomial.getDegree()].multiply(gF2nElement);
            GF2nPolynomial gF2nPolynomial2 = b2.scalarMultiply(gF2nElement2);
            gF2nPolynomial2.shiftThisLeft(n3);
            gF2nPolynomial = gF2nPolynomial.add(gF2nPolynomial2);
            gF2nPolynomial.shrink();
            gF2nPolynomialArray[0].a[n3] = (GF2nElement)gF2nElement2.clone();
            n3 = gF2nPolynomial.getDegree() - n2;
        }
        gF2nPolynomialArray[1] = gF2nPolynomial;
        gF2nPolynomialArray[0].shrink();
        return gF2nPolynomialArray;
    }

    public final GF2nPolynomial remainder(GF2nPolynomial b2) throws RuntimeException, ArithmeticException {
        GF2nPolynomial[] gF2nPolynomialArray = new GF2nPolynomial[2];
        gF2nPolynomialArray = this.divide(b2);
        return gF2nPolynomialArray[1];
    }

    public final GF2nPolynomial quotient(GF2nPolynomial b2) throws RuntimeException, ArithmeticException {
        GF2nPolynomial[] gF2nPolynomialArray = new GF2nPolynomial[2];
        gF2nPolynomialArray = this.divide(b2);
        return gF2nPolynomialArray[0];
    }

    public final GF2nPolynomial gcd(GF2nPolynomial g2) {
        GF2nPolynomial gF2nPolynomial = new GF2nPolynomial(this);
        GF2nPolynomial gF2nPolynomial2 = new GF2nPolynomial(g2);
        gF2nPolynomial.shrink();
        gF2nPolynomial2.shrink();
        while (!gF2nPolynomial2.isZero()) {
            GF2nPolynomial gF2nPolynomial3 = gF2nPolynomial.remainder(gF2nPolynomial2);
            gF2nPolynomial = gF2nPolynomial2;
            gF2nPolynomial2 = gF2nPolynomial3;
        }
        GF2nElement gF2nElement = gF2nPolynomial.a[gF2nPolynomial.getDegree()];
        GF2nPolynomial gF2nPolynomial4 = gF2nPolynomial.scalarMultiply((GF2nElement)gF2nElement.invert());
        return gF2nPolynomial4;
    }
}

