/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.legacy.math.ntru.polynomial;

import com.enterprisedt.bouncycastle.pqc.legacy.math.ntru.polynomial.BigDecimalPolynomial;
import com.enterprisedt.bouncycastle.pqc.legacy.math.ntru.polynomial.Constants;
import com.enterprisedt.bouncycastle.pqc.legacy.math.ntru.polynomial.IntegerPolynomial;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.math.BigDecimal;
import java.math.BigInteger;

public class BigIntPolynomial {
    private static final double b = Math.log10(2.0);
    BigInteger[] a;

    BigIntPolynomial(int N) {
        this.a = new BigInteger[N];
        for (int i2 = 0; i2 < N; ++i2) {
            this.a[i2] = Constants.a;
        }
    }

    BigIntPolynomial(BigInteger[] coeffs) {
        this.a = coeffs;
    }

    public BigIntPolynomial(IntegerPolynomial p2) {
        this.a = new BigInteger[p2.coeffs.length];
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            this.a[i2] = BigInteger.valueOf(p2.coeffs[i2]);
        }
    }

    public BigIntPolynomial mult(BigIntPolynomial poly2) {
        int n2 = this.a.length;
        if (poly2.a.length != n2) {
            throw new IllegalArgumentException("Number of coefficients must be the same");
        }
        BigIntPolynomial bigIntPolynomial = this.a(poly2);
        if (bigIntPolynomial.a.length > n2) {
            for (int i2 = n2; i2 < bigIntPolynomial.a.length; ++i2) {
                bigIntPolynomial.a[i2 - n2] = bigIntPolynomial.a[i2 - n2].add(bigIntPolynomial.a[i2]);
            }
            bigIntPolynomial.a = Arrays.copyOf(bigIntPolynomial.a, n2);
        }
        return bigIntPolynomial;
    }

    private BigIntPolynomial a(BigIntPolynomial bigIntPolynomial) {
        int n2;
        BigInteger[] bigIntegerArray = this.a;
        BigInteger[] bigIntegerArray2 = bigIntPolynomial.a;
        int n3 = bigIntPolynomial.a.length;
        if (n3 <= 1) {
            BigInteger[] bigIntegerArray3 = Arrays.clone(this.a);
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                bigIntegerArray3[i2] = bigIntegerArray3[i2].multiply(bigIntPolynomial.a[0]);
            }
            return new BigIntPolynomial(bigIntegerArray3);
        }
        int n4 = n3 / 2;
        BigIntPolynomial bigIntPolynomial2 = new BigIntPolynomial(Arrays.copyOf(bigIntegerArray, n4));
        BigIntPolynomial bigIntPolynomial3 = new BigIntPolynomial(Arrays.copyOfRange(bigIntegerArray, n4, n3));
        BigIntPolynomial bigIntPolynomial4 = new BigIntPolynomial(Arrays.copyOf(bigIntegerArray2, n4));
        BigIntPolynomial bigIntPolynomial5 = new BigIntPolynomial(Arrays.copyOfRange(bigIntegerArray2, n4, n3));
        BigIntPolynomial bigIntPolynomial6 = (BigIntPolynomial)bigIntPolynomial2.clone();
        bigIntPolynomial6.add(bigIntPolynomial3);
        BigIntPolynomial bigIntPolynomial7 = (BigIntPolynomial)bigIntPolynomial4.clone();
        bigIntPolynomial7.add(bigIntPolynomial5);
        BigIntPolynomial bigIntPolynomial8 = bigIntPolynomial2.a(bigIntPolynomial4);
        BigIntPolynomial bigIntPolynomial9 = bigIntPolynomial3.a(bigIntPolynomial5);
        BigIntPolynomial bigIntPolynomial10 = bigIntPolynomial6.a(bigIntPolynomial7);
        bigIntPolynomial10.sub(bigIntPolynomial8);
        bigIntPolynomial10.sub(bigIntPolynomial9);
        BigIntPolynomial bigIntPolynomial11 = new BigIntPolynomial(2 * n3 - 1);
        for (n2 = 0; n2 < bigIntPolynomial8.a.length; ++n2) {
            bigIntPolynomial11.a[n2] = bigIntPolynomial8.a[n2];
        }
        for (n2 = 0; n2 < bigIntPolynomial10.a.length; ++n2) {
            bigIntPolynomial11.a[n4 + n2] = bigIntPolynomial11.a[n4 + n2].add(bigIntPolynomial10.a[n2]);
        }
        for (n2 = 0; n2 < bigIntPolynomial9.a.length; ++n2) {
            bigIntPolynomial11.a[2 * n4 + n2] = bigIntPolynomial11.a[2 * n4 + n2].add(bigIntPolynomial9.a[n2]);
        }
        return bigIntPolynomial11;
    }

    public void add(BigIntPolynomial b2) {
        int n2;
        if (b2.a.length > this.a.length) {
            n2 = this.a.length;
            this.a = Arrays.copyOf(this.a, b2.a.length);
            for (int i2 = n2; i2 < this.a.length; ++i2) {
                this.a[i2] = Constants.a;
            }
        }
        for (n2 = 0; n2 < b2.a.length; ++n2) {
            this.a[n2] = this.a[n2].add(b2.a[n2]);
        }
    }

    public void sub(BigIntPolynomial b2) {
        int n2;
        if (b2.a.length > this.a.length) {
            n2 = this.a.length;
            this.a = Arrays.copyOf(this.a, b2.a.length);
            for (int i2 = n2; i2 < this.a.length; ++i2) {
                this.a[i2] = Constants.a;
            }
        }
        for (n2 = 0; n2 < b2.a.length; ++n2) {
            this.a[n2] = this.a[n2].subtract(b2.a[n2]);
        }
    }

    public void mult(BigInteger factor) {
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            this.a[i2] = this.a[i2].multiply(factor);
        }
    }

    public void div(BigInteger divisor) {
        BigInteger bigInteger = divisor.add(Constants.b).divide(BigInteger.valueOf(2L));
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            this.a[i2] = this.a[i2].compareTo(Constants.a) > 0 ? this.a[i2].add(bigInteger) : this.a[i2].add(bigInteger.negate());
            this.a[i2] = this.a[i2].divide(divisor);
        }
    }

    public BigDecimalPolynomial div(BigDecimal divisor, int decimalPlaces) {
        BigInteger bigInteger = this.a();
        int n2 = (int)((double)bigInteger.bitLength() * b) + 1;
        BigDecimal bigDecimal = Constants.c.divide(divisor, n2 + decimalPlaces + 1, 6);
        BigDecimalPolynomial bigDecimalPolynomial = new BigDecimalPolynomial(this.a.length);
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            bigDecimalPolynomial.a[i2] = new BigDecimal(this.a[i2]).multiply(bigDecimal).setScale(decimalPlaces, 6);
        }
        return bigDecimalPolynomial;
    }

    public int getMaxCoeffLength() {
        return (int)((double)this.a().bitLength() * b) + 1;
    }

    private BigInteger a() {
        BigInteger bigInteger = this.a[0].abs();
        for (int i2 = 1; i2 < this.a.length; ++i2) {
            BigInteger bigInteger2 = this.a[i2].abs();
            if (bigInteger2.compareTo(bigInteger) <= 0) continue;
            bigInteger = bigInteger2;
        }
        return bigInteger;
    }

    public void mod(BigInteger modulus) {
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            this.a[i2] = this.a[i2].mod(modulus);
        }
    }

    public Object clone() {
        return new BigIntPolynomial((BigInteger[])this.a.clone());
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + Arrays.hashCode(this.a);
        return n3;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigIntPolynomial bigIntPolynomial = (BigIntPolynomial)obj;
        return Arrays.areEqual(this.a, bigIntPolynomial.a);
    }

    public BigInteger[] getCoeffs() {
        return Arrays.clone(this.a);
    }
}

