/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.legacy.math.ntru.util;

import com.enterprisedt.bouncycastle.pqc.legacy.math.ntru.util.Util;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class ArrayEncoder {
    private static final int[] a = new int[]{0, 0, 0, 1, 1, 1, -1, -1};
    private static final int[] b = new int[]{0, 1, -1, 0, 1, -1, 0, 1};
    private static final int[] c = new int[]{1, 1, 1, 0, 0, 0, 1, 0, 1};
    private static final int[] d = new int[]{1, 1, 1, 1, 0, 0, 0, 1, 0};
    private static final int[] e = new int[]{1, 0, 1, 0, 0, 1, 1, 1, 0};

    public static byte[] encodeModQ(int[] a2, int q2) {
        int n2 = 31 - Integer.numberOfLeadingZeros(q2);
        int n3 = a2.length * n2;
        int n4 = (n3 + 7) / 8;
        byte[] byArray = new byte[n4];
        int n5 = 0;
        int n6 = 0;
        for (int i2 = 0; i2 < a2.length; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                int n7 = a2[i2] >> i3 & 1;
                int n8 = n6++;
                byArray[n8] = (byte)(byArray[n8] | n7 << n5);
                if (n5 == 7) {
                    n5 = 0;
                    continue;
                }
                ++n5;
            }
        }
        return byArray;
    }

    public static int[] decodeModQ(byte[] data, int N, int q2) {
        int[] nArray = new int[N];
        int n2 = 31 - Integer.numberOfLeadingZeros(q2);
        int n3 = N * n2;
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (i2 <= 0 || i2 % n2 == 0) {
                // empty if block
            }
            int n5 = ArrayEncoder.a(data, i2);
            int n6 = ++n4;
            nArray[n6] = nArray[n6] + (n5 << i2 % n2);
        }
        return nArray;
    }

    public static int[] decodeModQ(InputStream is, int N, int q2) throws IOException {
        int n2 = 31 - Integer.numberOfLeadingZeros(q2);
        int n3 = (N * n2 + 7) / 8;
        byte[] byArray = Util.readFullLength(is, n3);
        return ArrayEncoder.decodeModQ(byArray, N, q2);
    }

    public static int[] decodeMod3Sves(byte[] data, int N) {
        int[] nArray = new int[N];
        int n2 = 0;
        int n3 = 0;
        while (n3 < data.length * 8) {
            int n4 = ArrayEncoder.a(data, n3++);
            int n5 = ArrayEncoder.a(data, n3++);
            int n6 = ArrayEncoder.a(data, n3++);
            int n7 = n4 * 4 + n5 * 2 + n6;
            nArray[n2++] = a[n7];
            nArray[n2++] = b[n7];
            if (n2 <= N - 2) continue;
            break;
        }
        return nArray;
    }

    public static byte[] encodeMod3Sves(int[] arr) {
        int n2 = (arr.length * 3 + 1) / 2;
        int n3 = (n2 + 7) / 8;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < arr.length / 2 * 2) {
            int n7 = arr[n6++] + 1;
            int n8 = arr[n6++] + 1;
            if (n7 == 0 && n8 == 0) {
                throw new IllegalStateException("Illegal encoding!");
            }
            int n9 = n7 * 3 + n8;
            int[] nArray = new int[]{c[n9], d[n9], e[n9]};
            for (int i2 = 0; i2 < 3; ++i2) {
                int n10 = n5++;
                byArray[n10] = (byte)(byArray[n10] | nArray[i2] << n4);
                if (n4 == 7) {
                    n4 = 0;
                    continue;
                }
                ++n4;
            }
        }
        return byArray;
    }

    public static byte[] encodeMod3Tight(int[] intArray) {
        int n2;
        BigInteger bigInteger = BigInteger.ZERO;
        for (n2 = intArray.length - 1; n2 >= 0; --n2) {
            bigInteger = bigInteger.multiply(BigInteger.valueOf(3L));
            bigInteger = bigInteger.add(BigInteger.valueOf(intArray[n2] + 1));
        }
        n2 = (BigInteger.valueOf(3L).pow(intArray.length).bitLength() + 7) / 8;
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length < n2) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, n2 - byArray.length, byArray.length);
            return byArray2;
        }
        if (byArray.length > n2) {
            byArray = Arrays.copyOfRange(byArray, 1, byArray.length);
        }
        return byArray;
    }

    public static int[] decodeMod3Tight(byte[] b2, int N) {
        BigInteger bigInteger = new BigInteger(1, b2);
        int[] nArray = new int[N];
        for (int i2 = 0; i2 < N; ++i2) {
            nArray[i2] = bigInteger.mod(BigInteger.valueOf(3L)).intValue() - 1;
            if (nArray[i2] > 1) {
                int n2 = i2;
                nArray[n2] = nArray[n2] - 3;
            }
            bigInteger = bigInteger.divide(BigInteger.valueOf(3L));
        }
        return nArray;
    }

    public static int[] decodeMod3Tight(InputStream is, int N) throws IOException {
        int n2 = (int)Math.ceil((double)N * Math.log(3.0) / Math.log(2.0) / 8.0);
        byte[] byArray = Util.readFullLength(is, n2);
        return ArrayEncoder.decodeMod3Tight(byArray, N);
    }

    private static int a(byte[] byArray, int n2) {
        int n3 = n2 / 8;
        int n4 = byArray[n3] & 0xFF;
        return n4 >> n2 % 8 & 1;
    }
}

