/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.AbstractTlsPeer;
import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.CertificateRequest;
import com.enterprisedt.bouncycastle.tls.CertificateStatus;
import com.enterprisedt.bouncycastle.tls.CertificateStatusRequest;
import com.enterprisedt.bouncycastle.tls.MaxFragmentLength;
import com.enterprisedt.bouncycastle.tls.NamedGroup;
import com.enterprisedt.bouncycastle.tls.NewSessionTicket;
import com.enterprisedt.bouncycastle.tls.ProtocolName;
import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.tls.TlsDHUtils;
import com.enterprisedt.bouncycastle.tls.TlsECCUtils;
import com.enterprisedt.bouncycastle.tls.TlsExtensionsUtils;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsPSKExternal;
import com.enterprisedt.bouncycastle.tls.TlsPSKIdentityManager;
import com.enterprisedt.bouncycastle.tls.TlsSRPLoginParameters;
import com.enterprisedt.bouncycastle.tls.TlsServer;
import com.enterprisedt.bouncycastle.tls.TlsServerContext;
import com.enterprisedt.bouncycastle.tls.TlsSession;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.TlsDHConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsECConfig;
import com.enterprisedt.bouncycastle.util.Integers;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AbstractTlsServer
extends AbstractTlsPeer
implements TlsServer {
    protected TlsServerContext context;
    protected ProtocolVersion[] protocolVersions;
    protected int[] cipherSuites;
    protected int[] offeredCipherSuites;
    protected Hashtable clientExtensions;
    protected boolean encryptThenMACOffered;
    protected short maxFragmentLengthOffered;
    protected boolean truncatedHMacOffered;
    protected boolean clientSentECPointFormats;
    protected CertificateStatusRequest certificateStatusRequest;
    protected Vector statusRequestV2;
    protected Vector trustedCAKeys;
    protected int selectedCipherSuite;
    protected Vector clientProtocolNames;
    protected ProtocolName selectedProtocolName;
    protected final Hashtable serverExtensions = new Hashtable();

    public AbstractTlsServer(TlsCrypto crypto) {
        super(crypto);
    }

    protected boolean allowCertificateStatus() {
        return true;
    }

    protected boolean allowEncryptThenMAC() {
        return true;
    }

    protected boolean allowMultiCertStatus() {
        return false;
    }

    protected boolean allowTruncatedHMac() {
        return false;
    }

    protected boolean allowTrustedCAIndication() {
        return false;
    }

    protected Hashtable checkServerExtensions() {
        return this.serverExtensions;
    }

    protected String getDetailMessageNoCipherSuite() {
        return "No selectable cipher suite";
    }

    protected int getMaximumNegotiableCurveBits() {
        int n2 = 0;
        int[] nArray = this.context.getSecurityParametersHandshake().getClientSupportedGroups();
        if (nArray != null) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                n2 = Math.max(n2, NamedGroup.getCurveBits(nArray[i2]));
            }
        } else {
            n2 = NamedGroup.getMaximumCurveBits();
        }
        return n2;
    }

    protected int getMaximumNegotiableFiniteFieldBits() {
        int n2 = 0;
        boolean bl = false;
        int[] nArray = this.context.getSecurityParametersHandshake().getClientSupportedGroups();
        if (nArray != null) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                bl |= NamedGroup.isFiniteField(nArray[i2]);
                n2 = Math.max(n2, NamedGroup.getFiniteFieldBits(nArray[i2]));
            }
        }
        if (!bl) {
            n2 = NamedGroup.getMaximumFiniteFieldBits();
        }
        return n2;
    }

    protected Vector getProtocolNames() {
        return null;
    }

    protected boolean isSelectableCipherSuite(int cipherSuite, int availCurveBits, int availFiniteFieldBits, Vector sigAlgs) {
        return TlsUtils.isValidVersionForCipherSuite(cipherSuite, this.context.getServerVersion()) && availCurveBits >= TlsECCUtils.getMinimumCurveBits(cipherSuite) && availFiniteFieldBits >= TlsDHUtils.getMinimumFiniteFieldBits(cipherSuite) && TlsUtils.isValidCipherSuiteForSignatureAlgorithms(cipherSuite, sigAlgs);
    }

    protected boolean preferLocalCipherSuites() {
        return false;
    }

    protected boolean selectCipherSuite(int cipherSuite) throws IOException {
        this.selectedCipherSuite = cipherSuite;
        return true;
    }

    protected int selectDH(int minimumFiniteFieldBits) {
        int[] nArray = this.context.getSecurityParametersHandshake().getClientSupportedGroups();
        if (nArray == null) {
            return this.selectDHDefault(minimumFiniteFieldBits);
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            if (NamedGroup.getFiniteFieldBits(n2) < minimumFiniteFieldBits) continue;
            return n2;
        }
        return -1;
    }

    protected int selectDHDefault(int minimumFiniteFieldBits) {
        return minimumFiniteFieldBits <= 2048 ? 256 : (minimumFiniteFieldBits <= 3072 ? 257 : (minimumFiniteFieldBits <= 4096 ? 258 : (minimumFiniteFieldBits <= 6144 ? 259 : (minimumFiniteFieldBits <= 8192 ? 260 : -1))));
    }

    protected int selectECDH(int minimumCurveBits) {
        int[] nArray = this.context.getSecurityParametersHandshake().getClientSupportedGroups();
        if (nArray == null) {
            return this.selectECDHDefault(minimumCurveBits);
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            if (NamedGroup.getCurveBits(n2) < minimumCurveBits) continue;
            return n2;
        }
        return -1;
    }

    protected int selectECDHDefault(int minimumCurveBits) {
        return minimumCurveBits <= 256 ? 23 : (minimumCurveBits <= 384 ? 24 : (minimumCurveBits <= 521 ? 25 : -1));
    }

    protected ProtocolName selectProtocolName() throws IOException {
        Vector vector = this.getProtocolNames();
        if (null == vector || vector.isEmpty()) {
            return null;
        }
        ProtocolName protocolName = this.selectProtocolName(this.clientProtocolNames, vector);
        if (null == protocolName) {
            throw new TlsFatalAlert(120);
        }
        return protocolName;
    }

    protected ProtocolName selectProtocolName(Vector clientProtocolNames, Vector serverProtocolNames) {
        for (int i2 = 0; i2 < serverProtocolNames.size(); ++i2) {
            ProtocolName protocolName = (ProtocolName)serverProtocolNames.elementAt(i2);
            if (!clientProtocolNames.contains(protocolName)) continue;
            return protocolName;
        }
        return null;
    }

    protected boolean shouldSelectProtocolNameEarly() {
        return true;
    }

    protected boolean preferLocalClientCertificateTypes() {
        return false;
    }

    protected short[] getAllowedClientCertificateTypes() {
        return null;
    }

    protected byte[] getNewConnectionID() {
        return null;
    }

    @Override
    public void init(TlsServerContext context) {
        this.context = context;
        this.protocolVersions = this.getSupportedVersions();
        this.cipherSuites = this.getSupportedCipherSuites();
    }

    @Override
    public ProtocolVersion[] getProtocolVersions() {
        return this.protocolVersions;
    }

    @Override
    public int[] getCipherSuites() {
        return this.cipherSuites;
    }

    @Override
    public void notifyHandshakeBeginning() throws IOException {
        super.notifyHandshakeBeginning();
        this.offeredCipherSuites = null;
        this.clientExtensions = null;
        this.encryptThenMACOffered = false;
        this.maxFragmentLengthOffered = 0;
        this.truncatedHMacOffered = false;
        this.clientSentECPointFormats = false;
        this.certificateStatusRequest = null;
        this.selectedCipherSuite = -1;
        this.selectedProtocolName = null;
        this.serverExtensions.clear();
    }

    @Override
    public TlsSession getSessionToResume(byte[] sessionID) {
        return null;
    }

    @Override
    public byte[] getNewSessionID() {
        return null;
    }

    @Override
    public TlsPSKExternal getExternalPSK(Vector identities) {
        return null;
    }

    @Override
    public void notifySession(TlsSession session) {
    }

    @Override
    public void notifyClientVersion(ProtocolVersion clientVersion) throws IOException {
    }

    @Override
    public void notifyFallback(boolean isFallback) throws IOException {
        if (isFallback) {
            ProtocolVersion protocolVersion;
            ProtocolVersion[] protocolVersionArray = this.getProtocolVersions();
            ProtocolVersion protocolVersion2 = this.context.getClientVersion();
            if (protocolVersion2.isTLS()) {
                protocolVersion = ProtocolVersion.getLatestTLS(protocolVersionArray);
            } else if (protocolVersion2.isDTLS()) {
                protocolVersion = ProtocolVersion.getLatestDTLS(protocolVersionArray);
            } else {
                throw new TlsFatalAlert(80);
            }
            if (null != protocolVersion && protocolVersion.isLaterVersionOf(protocolVersion2)) {
                throw new TlsFatalAlert(86);
            }
        }
    }

    @Override
    public void notifyOfferedCipherSuites(int[] offeredCipherSuites) throws IOException {
        this.offeredCipherSuites = offeredCipherSuites;
    }

    @Override
    public void processClientExtensions(Hashtable clientExtensions) throws IOException {
        this.clientExtensions = clientExtensions;
        if (null != clientExtensions) {
            this.clientProtocolNames = TlsExtensionsUtils.getALPNExtensionClient(clientExtensions);
            if (this.shouldSelectProtocolNameEarly() && null != this.clientProtocolNames && !this.clientProtocolNames.isEmpty()) {
                this.selectedProtocolName = this.selectProtocolName();
            }
            this.encryptThenMACOffered = TlsExtensionsUtils.hasEncryptThenMACExtension(clientExtensions);
            this.truncatedHMacOffered = TlsExtensionsUtils.hasTruncatedHMacExtension(clientExtensions);
            this.statusRequestV2 = TlsExtensionsUtils.getStatusRequestV2Extension(clientExtensions);
            this.trustedCAKeys = TlsExtensionsUtils.getTrustedCAKeysExtensionClient(clientExtensions);
            this.clientSentECPointFormats = null != TlsExtensionsUtils.getSupportedPointFormatsExtension(clientExtensions);
            this.certificateStatusRequest = TlsExtensionsUtils.getStatusRequestExtension(clientExtensions);
            this.maxFragmentLengthOffered = TlsExtensionsUtils.getMaxFragmentLengthExtension(clientExtensions);
            if (this.maxFragmentLengthOffered >= 0 && !MaxFragmentLength.isValid(this.maxFragmentLengthOffered)) {
                throw new TlsFatalAlert(47);
            }
        }
    }

    @Override
    public ProtocolVersion getServerVersion() throws IOException {
        ProtocolVersion[] protocolVersionArray = this.getProtocolVersions();
        ProtocolVersion[] protocolVersionArray2 = this.context.getClientSupportedVersions();
        for (int i2 = 0; i2 < protocolVersionArray2.length; ++i2) {
            ProtocolVersion protocolVersion = protocolVersionArray2[i2];
            if (!ProtocolVersion.contains(protocolVersionArray, protocolVersion)) continue;
            return protocolVersion;
        }
        throw new TlsFatalAlert(70);
    }

    @Override
    public int[] getSupportedGroups() throws IOException {
        return new int[]{29, 30, 23, 24, 256, 257, 258};
    }

    @Override
    public int getSelectedCipherSuite() throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        ProtocolVersion protocolVersion = securityParameters.getNegotiatedVersion();
        if (TlsUtils.isTLSv13(protocolVersion)) {
            int n2 = TlsUtils.getCommonCipherSuite13(protocolVersion, this.offeredCipherSuites, this.getCipherSuites(), this.preferLocalCipherSuites());
            if (n2 >= 0 && this.selectCipherSuite(n2)) {
                return n2;
            }
        } else {
            Vector vector = TlsUtils.getUsableSignatureAlgorithms(securityParameters.getClientSigAlgs());
            int n3 = this.getMaximumNegotiableCurveBits();
            int n4 = this.getMaximumNegotiableFiniteFieldBits();
            int[] nArray = TlsUtils.getCommonCipherSuites(this.offeredCipherSuites, this.getCipherSuites(), this.preferLocalCipherSuites());
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                int n5 = nArray[i2];
                if (!this.isSelectableCipherSuite(n5, n3, n4, vector) || !this.selectCipherSuite(n5)) continue;
                return n5;
            }
        }
        throw new TlsFatalAlert(40, this.getDetailMessageNoCipherSuite());
    }

    @Override
    public Hashtable getServerExtensions() throws IOException {
        short[] sArray;
        Object object;
        short[] sArray2;
        boolean bl = TlsUtils.isTLSv13(this.context);
        if (bl) {
            if (null != this.certificateStatusRequest && this.allowCertificateStatus()) {
                // empty if block
            }
        } else {
            if (this.encryptThenMACOffered && this.allowEncryptThenMAC() && TlsUtils.isBlockCipherSuite(this.selectedCipherSuite)) {
                TlsExtensionsUtils.addEncryptThenMACExtension(this.serverExtensions);
            }
            if (this.truncatedHMacOffered && this.allowTruncatedHMac()) {
                TlsExtensionsUtils.addTruncatedHMacExtension(this.serverExtensions);
            }
            if (this.clientSentECPointFormats && TlsECCUtils.isECCCipherSuite(this.selectedCipherSuite)) {
                TlsExtensionsUtils.addSupportedPointFormatsExtension(this.serverExtensions, new short[]{0});
            }
            if (null != this.statusRequestV2 && this.allowMultiCertStatus()) {
                TlsExtensionsUtils.addEmptyExtensionData(this.serverExtensions, TlsExtensionsUtils.EXT_status_request_v2);
            } else if (null != this.certificateStatusRequest && this.allowCertificateStatus()) {
                TlsExtensionsUtils.addEmptyExtensionData(this.serverExtensions, TlsExtensionsUtils.EXT_status_request);
            }
            if (null != this.trustedCAKeys && this.allowTrustedCAIndication()) {
                TlsExtensionsUtils.addTrustedCAKeysExtensionServer(this.serverExtensions);
            }
        }
        if (this.maxFragmentLengthOffered >= 0 && MaxFragmentLength.isValid(this.maxFragmentLengthOffered)) {
            TlsExtensionsUtils.addMaxFragmentLengthExtension(this.serverExtensions, this.maxFragmentLengthOffered);
        }
        if ((sArray2 = TlsExtensionsUtils.getServerCertificateTypeExtensionClient(this.clientExtensions)) != null && (object = this.getCredentials()) != null) {
            short s2 = object.getCertificate().getCertificateType();
            if (1 == s2 && bl) {
                throw new TlsFatalAlert(80, "The OpenPGP certificate type MUST NOT be used with TLS 1.3");
            }
            if (!TlsUtils.a(sArray2, 0, sArray2.length, s2)) {
                throw new TlsFatalAlert(43);
            }
            TlsExtensionsUtils.addServerCertificateTypeExtensionServer(this.serverExtensions, s2);
        }
        if ((object = (Object)TlsExtensionsUtils.getClientCertificateTypeExtensionClient(this.clientExtensions)) != null && (sArray = this.getAllowedClientCertificateTypes()) != null) {
            Object object2;
            Object object3;
            if (this.preferLocalClientCertificateTypes()) {
                object3 = sArray;
                object2 = object;
            } else {
                object3 = object;
                object2 = sArray;
            }
            short s3 = -1;
            for (int i2 = 0; i2 < ((short[])object3).length; ++i2) {
                short s4 = object3[i2];
                if (1 == s4 && bl || !TlsUtils.a((short[])object2, 0, ((Object)object2).length, s4)) continue;
                s3 = s4;
                break;
            }
            if (s3 == -1) {
                throw new TlsFatalAlert(43);
            }
            TlsExtensionsUtils.addClientCertificateTypeExtensionServer(this.serverExtensions, s3);
        }
        return this.serverExtensions;
    }

    @Override
    public void getServerExtensionsForConnection(Hashtable serverExtensions) throws IOException {
        byte[] byArray;
        if (!this.shouldSelectProtocolNameEarly() && null != this.clientProtocolNames && !this.clientProtocolNames.isEmpty()) {
            this.selectedProtocolName = this.selectProtocolName();
        }
        if (null == this.selectedProtocolName) {
            serverExtensions.remove(TlsExtensionsUtils.EXT_application_layer_protocol_negotiation);
        } else {
            TlsExtensionsUtils.addALPNExtensionServer(serverExtensions, this.selectedProtocolName);
        }
        if (ProtocolVersion.DTLSv12.equals(this.context.getServerVersion()) && this.clientExtensions != null && this.clientExtensions.containsKey(Integers.valueOf(54)) && (byArray = this.getNewConnectionID()) != null) {
            TlsExtensionsUtils.addConnectionIDExtension(serverExtensions, byArray);
        }
    }

    @Override
    public Vector getServerSupplementalData() throws IOException {
        return null;
    }

    @Override
    public CertificateStatus getCertificateStatus() throws IOException {
        return null;
    }

    @Override
    public CertificateRequest getCertificateRequest() throws IOException {
        return null;
    }

    @Override
    public TlsPSKIdentityManager getPSKIdentityManager() throws IOException {
        return null;
    }

    @Override
    public TlsSRPLoginParameters getSRPLoginParameters() throws IOException {
        return null;
    }

    @Override
    public TlsDHConfig getDHConfig() throws IOException {
        int n2 = TlsDHUtils.getMinimumFiniteFieldBits(this.selectedCipherSuite);
        int n3 = this.selectDH(n2);
        return TlsDHUtils.createNamedDHConfig(this.context, n3);
    }

    @Override
    public TlsECConfig getECDHConfig() throws IOException {
        int n2 = TlsECCUtils.getMinimumCurveBits(this.selectedCipherSuite);
        int n3 = this.selectECDH(n2);
        return TlsECCUtils.createNamedECConfig(this.context, n3);
    }

    @Override
    public void processClientSupplementalData(Vector clientSupplementalData) throws IOException {
        if (clientSupplementalData != null) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public NewSessionTicket getNewSessionTicket() throws IOException {
        return new NewSessionTicket(0L, TlsUtils.EMPTY_BYTES);
    }
}

