/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.MaxFragmentLength;
import com.enterprisedt.bouncycastle.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsProtocol;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.e;
import com.enterprisedt.bouncycastle.tls.f;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;

public abstract class DTLSProtocol {
    protected DTLSProtocol() {
    }

    protected void processFinished(byte[] body, byte[] expected_verify_data) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        byte[] byArray = TlsUtils.readFully(expected_verify_data.length, (InputStream)byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        if (!Arrays.constantTimeAreEqual(expected_verify_data, byArray)) {
            throw new TlsFatalAlert(40);
        }
    }

    protected static void applyMaxFragmentLengthExtension(e recordLayer, short maxFragmentLength) throws IOException {
        if (maxFragmentLength >= 0) {
            if (!MaxFragmentLength.isValid(maxFragmentLength)) {
                throw new TlsFatalAlert(80);
            }
            int n2 = 1 << 8 + maxFragmentLength;
            recordLayer.a(n2);
        }
    }

    protected static short evaluateMaxFragmentLengthExtension(boolean resumedSession, Hashtable clientExtensions, Hashtable serverExtensions, short alertDescription) throws IOException {
        return TlsUtils.a(resumedSession ? null : clientExtensions, serverExtensions, alertDescription);
    }

    protected static byte[] generateCertificate(TlsContext context, Certificate certificate, OutputStream endPointHash) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificate.encode(context, byteArrayOutputStream, endPointHash);
        return byteArrayOutputStream.toByteArray();
    }

    protected static byte[] generateSupplementalData(Vector supplementalData) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsProtocol.writeSupplementalData(byteArrayOutputStream, supplementalData);
        return byteArrayOutputStream.toByteArray();
    }

    protected static void sendCertificateMessage(TlsContext context, f handshake, Certificate certificate, OutputStream endPointHash) throws IOException {
        SecurityParameters securityParameters = context.getSecurityParametersHandshake();
        if (null != securityParameters.getLocalCertificate()) {
            throw new TlsFatalAlert(80);
        }
        if (null == certificate) {
            certificate = Certificate.EMPTY_CHAIN;
        }
        byte[] byArray = DTLSProtocol.generateCertificate(context, certificate, endPointHash);
        handshake.a((short)11, byArray);
        securityParameters.R = certificate;
    }

    protected static int validateSelectedCipherSuite(int selectedCipherSuite, short alertDescription) throws IOException {
        switch (TlsUtils.getEncryptionAlgorithm(selectedCipherSuite)) {
            case -1: 
            case 1: 
            case 2: {
                throw new TlsFatalAlert(alertDescription);
            }
        }
        return selectedCipherSuite;
    }
}

