/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.ClientHello;
import com.enterprisedt.bouncycastle.tls.DTLSRequest;
import com.enterprisedt.bouncycastle.tls.DatagramSender;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.TlsHMAC;
import com.enterprisedt.bouncycastle.tls.crypto.TlsMACOutputStream;
import com.enterprisedt.bouncycastle.tls.e;
import com.enterprisedt.bouncycastle.tls.f;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DTLSVerifier {
    private final TlsCrypto a;
    private final byte[] b;

    public DTLSVerifier(TlsCrypto crypto) {
        this.a = crypto;
        this.b = new byte[32];
        crypto.getSecureRandom().nextBytes(this.b);
    }

    public DTLSRequest verifyRequest(byte[] clientID, byte[] data, int dataOff, int dataLen, DatagramSender sender) {
        try {
            int n2 = e.a(data, dataOff, dataLen);
            if (n2 < 0) {
                return null;
            }
            int n3 = n2 - 12;
            if (n3 < 39) {
                return null;
            }
            int n4 = dataOff + 13;
            ByteArrayInputStream byteArrayInputStream = f.a(data, n4, n2);
            if (byteArrayInputStream == null) {
                return null;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n3);
            ClientHello clientHello = ClientHello.parse(byteArrayInputStream, byteArrayOutputStream);
            if (clientHello == null) {
                return null;
            }
            long l2 = TlsUtils.readUint48(data, dataOff + 5);
            byte[] byArray = clientHello.getCookie();
            TlsHMAC tlsHMAC = this.a.createHMAC(3);
            tlsHMAC.setKey(this.b, 0, this.b.length);
            tlsHMAC.update(clientID, 0, clientID.length);
            byteArrayOutputStream.writeTo(new TlsMACOutputStream(tlsHMAC));
            byte[] byArray2 = tlsHMAC.calculateMAC();
            if (Arrays.constantTimeAreEqual(byArray2, byArray)) {
                byte[] byArray3 = TlsUtils.copyOfRangeExact(data, n4, n4 + n2);
                return new DTLSRequest(l2, byArray3, clientHello);
            }
            f.a(sender, l2, byArray2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

