/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.TlsDHGroupVerifier;
import com.enterprisedt.bouncycastle.tls.crypto.DHGroup;
import com.enterprisedt.bouncycastle.tls.crypto.DHStandardGroups;
import java.math.BigInteger;
import java.util.Vector;

public class DefaultTlsDHGroupVerifier
implements TlsDHGroupVerifier {
    public static final int DEFAULT_MINIMUM_PRIME_BITS = 2048;
    private static final Vector a = new Vector();
    protected Vector groups;
    protected int minimumPrimeBits;

    private static void a(DHGroup dHGroup) {
        a.addElement(dHGroup);
    }

    public DefaultTlsDHGroupVerifier() {
        this(2048);
    }

    public DefaultTlsDHGroupVerifier(int minimumPrimeBits) {
        this(a, minimumPrimeBits);
    }

    public DefaultTlsDHGroupVerifier(Vector groups, int minimumPrimeBits) {
        this.groups = new Vector(groups);
        this.minimumPrimeBits = minimumPrimeBits;
    }

    @Override
    public boolean accept(DHGroup dhGroup) {
        return this.checkMinimumPrimeBits(dhGroup) && this.checkGroup(dhGroup);
    }

    public int getMinimumPrimeBits() {
        return this.minimumPrimeBits;
    }

    protected boolean areGroupsEqual(DHGroup a2, DHGroup b2) {
        return a2 == b2 || this.areParametersEqual(a2.getP(), b2.getP()) && this.areParametersEqual(a2.getG(), b2.getG());
    }

    protected boolean areParametersEqual(BigInteger a2, BigInteger b2) {
        return a2 == b2 || a2.equals(b2);
    }

    protected boolean checkGroup(DHGroup dhGroup) {
        for (int i2 = 0; i2 < this.groups.size(); ++i2) {
            if (!this.areGroupsEqual(dhGroup, (DHGroup)this.groups.elementAt(i2))) continue;
            return true;
        }
        return false;
    }

    protected boolean checkMinimumPrimeBits(DHGroup dhGroup) {
        return dhGroup.getP().bitLength() >= this.getMinimumPrimeBits();
    }

    static {
        DefaultTlsDHGroupVerifier.a(DHStandardGroups.rfc3526_2048);
        DefaultTlsDHGroupVerifier.a(DHStandardGroups.rfc3526_3072);
        DefaultTlsDHGroupVerifier.a(DHStandardGroups.rfc3526_4096);
        DefaultTlsDHGroupVerifier.a(DHStandardGroups.rfc3526_6144);
        DefaultTlsDHGroupVerifier.a(DHStandardGroups.rfc3526_8192);
        DefaultTlsDHGroupVerifier.a(DHStandardGroups.rfc7919_ffdhe2048);
        DefaultTlsDHGroupVerifier.a(DHStandardGroups.rfc7919_ffdhe3072);
        DefaultTlsDHGroupVerifier.a(DHStandardGroups.rfc7919_ffdhe4096);
        DefaultTlsDHGroupVerifier.a(DHStandardGroups.rfc7919_ffdhe6144);
        DefaultTlsDHGroupVerifier.a(DHStandardGroups.rfc7919_ffdhe8192);
    }
}

