/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.AbstractTlsKeyExchangeFactory;
import com.enterprisedt.bouncycastle.tls.TlsDHEKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsDHGroupVerifier;
import com.enterprisedt.bouncycastle.tls.TlsDHKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsDHanonKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsECDHEKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsECDHKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsECDHanonKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsPSKIdentity;
import com.enterprisedt.bouncycastle.tls.TlsPSKIdentityManager;
import com.enterprisedt.bouncycastle.tls.TlsPSKKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsRSAKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsSRPConfigVerifier;
import com.enterprisedt.bouncycastle.tls.TlsSRPIdentity;
import com.enterprisedt.bouncycastle.tls.TlsSRPKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsSRPLoginParameters;
import com.enterprisedt.bouncycastle.tls.crypto.TlsDHConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsECConfig;
import java.io.IOException;

public class DefaultTlsKeyExchangeFactory
extends AbstractTlsKeyExchangeFactory {
    @Override
    public TlsKeyExchange createDHKeyExchange(int keyExchange) throws IOException {
        return new TlsDHKeyExchange(keyExchange);
    }

    @Override
    public TlsKeyExchange createDHanonKeyExchangeClient(int keyExchange, TlsDHGroupVerifier dhGroupVerifier) throws IOException {
        return new TlsDHanonKeyExchange(keyExchange, dhGroupVerifier);
    }

    @Override
    public TlsKeyExchange createDHanonKeyExchangeServer(int keyExchange, TlsDHConfig dhConfig) throws IOException {
        return new TlsDHanonKeyExchange(keyExchange, dhConfig);
    }

    @Override
    public TlsKeyExchange createDHEKeyExchangeClient(int keyExchange, TlsDHGroupVerifier dhGroupVerifier) throws IOException {
        return new TlsDHEKeyExchange(keyExchange, dhGroupVerifier);
    }

    @Override
    public TlsKeyExchange createDHEKeyExchangeServer(int keyExchange, TlsDHConfig dhConfig) throws IOException {
        return new TlsDHEKeyExchange(keyExchange, dhConfig);
    }

    @Override
    public TlsKeyExchange createECDHKeyExchange(int keyExchange) throws IOException {
        return new TlsECDHKeyExchange(keyExchange);
    }

    @Override
    public TlsKeyExchange createECDHanonKeyExchangeClient(int keyExchange) throws IOException {
        return new TlsECDHanonKeyExchange(keyExchange);
    }

    @Override
    public TlsKeyExchange createECDHanonKeyExchangeServer(int keyExchange, TlsECConfig ecConfig) throws IOException {
        return new TlsECDHanonKeyExchange(keyExchange, ecConfig);
    }

    @Override
    public TlsKeyExchange createECDHEKeyExchangeClient(int keyExchange) throws IOException {
        return new TlsECDHEKeyExchange(keyExchange);
    }

    @Override
    public TlsKeyExchange createECDHEKeyExchangeServer(int keyExchange, TlsECConfig ecConfig) throws IOException {
        return new TlsECDHEKeyExchange(keyExchange, ecConfig);
    }

    @Override
    public TlsKeyExchange createPSKKeyExchangeClient(int keyExchange, TlsPSKIdentity pskIdentity, TlsDHGroupVerifier dhGroupVerifier) throws IOException {
        return new TlsPSKKeyExchange(keyExchange, pskIdentity, dhGroupVerifier);
    }

    @Override
    public TlsKeyExchange createPSKKeyExchangeServer(int keyExchange, TlsPSKIdentityManager pskIdentityManager, TlsDHConfig dhConfig, TlsECConfig ecConfig) throws IOException {
        return new TlsPSKKeyExchange(keyExchange, pskIdentityManager, dhConfig, ecConfig);
    }

    @Override
    public TlsKeyExchange createRSAKeyExchange(int keyExchange) throws IOException {
        return new TlsRSAKeyExchange(keyExchange);
    }

    @Override
    public TlsKeyExchange createSRPKeyExchangeClient(int keyExchange, TlsSRPIdentity srpIdentity, TlsSRPConfigVerifier srpConfigVerifier) throws IOException {
        return new TlsSRPKeyExchange(keyExchange, srpIdentity, srpConfigVerifier);
    }

    @Override
    public TlsKeyExchange createSRPKeyExchangeServer(int keyExchange, TlsSRPLoginParameters loginParameters) throws IOException {
        return new TlsSRPKeyExchange(keyExchange, loginParameters);
    }
}

