/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.PskIdentity;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsHandshakeHash;
import com.enterprisedt.bouncycastle.tls.TlsPSK;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCryptoUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsHash;
import com.enterprisedt.bouncycastle.tls.crypto.TlsHashOutputStream;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class OfferedPsks {
    protected final Vector identities;
    protected final Vector binders;
    protected final int bindersSize;

    public OfferedPsks(Vector identities) {
        this(identities, null, -1);
    }

    private OfferedPsks(Vector identities, Vector binders, int bindersSize) {
        if (null == identities || identities.isEmpty()) {
            throw new IllegalArgumentException("'identities' cannot be null or empty");
        }
        if (null != binders && identities.size() != binders.size()) {
            throw new IllegalArgumentException("'binders' must be the same length as 'identities' (or null)");
        }
        if (null != binders != bindersSize >= 0) {
            throw new IllegalArgumentException("'bindersSize' must be >= 0 iff 'binders' are present");
        }
        this.identities = identities;
        this.binders = binders;
        this.bindersSize = bindersSize;
    }

    public Vector getBinders() {
        return this.binders;
    }

    public int getBindersSize() {
        return this.bindersSize;
    }

    public Vector getIdentities() {
        return this.identities;
    }

    public int getIndexOfIdentity(PskIdentity pskIdentity) {
        int n2 = this.identities.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!pskIdentity.equals(this.identities.elementAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    public void encode(OutputStream output) throws IOException {
        Object object;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.identities.size(); ++n2) {
            object = (PskIdentity)this.identities.elementAt(n2);
            n3 += ((PskIdentity)object).getEncodedLength();
        }
        TlsUtils.checkUint16(n3);
        TlsUtils.writeUint16(n3, output);
        for (n2 = 0; n2 < this.identities.size(); ++n2) {
            object = (PskIdentity)this.identities.elementAt(n2);
            ((PskIdentity)object).encode(output);
        }
        if (null != this.binders) {
            n3 = 0;
            for (n2 = 0; n2 < this.binders.size(); ++n2) {
                object = (byte[])this.binders.elementAt(n2);
                n3 += 1 + ((Object)object).length;
            }
            TlsUtils.checkUint16(n3);
            TlsUtils.writeUint16(n3, output);
            for (n2 = 0; n2 < this.binders.size(); ++n2) {
                object = (byte[])this.binders.elementAt(n2);
                TlsUtils.writeOpaque8((byte[])object, output);
            }
        }
    }

    static void a(OutputStream outputStream, TlsCrypto tlsCrypto, TlsHandshakeHash tlsHandshakeHash, a a2) throws IOException {
        TlsPSK[] tlsPSKArray = a2.a;
        TlsSecret[] tlsSecretArray = a2.c;
        int n2 = a2.d - 2;
        TlsUtils.checkUint16(n2);
        TlsUtils.writeUint16(n2, outputStream);
        int n3 = 0;
        for (int i2 = 0; i2 < tlsPSKArray.length; ++i2) {
            TlsPSK tlsPSK = tlsPSKArray[i2];
            TlsSecret tlsSecret = tlsSecretArray[i2];
            boolean bl = true;
            int n4 = TlsCryptoUtils.getHashForPRF(tlsPSK.getPRFAlgorithm());
            TlsHash tlsHash = tlsCrypto.createHash(n4);
            tlsHandshakeHash.copyBufferTo(new TlsHashOutputStream(tlsHash));
            byte[] byArray = tlsHash.calculateHash();
            byte[] byArray2 = TlsUtils.a(tlsCrypto, bl, n4, tlsSecret, byArray);
            n3 += 1 + byArray2.length;
            TlsUtils.writeOpaque8(byArray2, outputStream);
        }
        if (n2 != n3) {
            throw new TlsFatalAlert(80);
        }
    }

    static int a(TlsPSK[] tlsPSKArray) throws IOException {
        int n2 = 0;
        for (int i2 = 0; i2 < tlsPSKArray.length; ++i2) {
            TlsPSK tlsPSK = tlsPSKArray[i2];
            int n3 = tlsPSK.getPRFAlgorithm();
            int n4 = TlsCryptoUtils.getHashForPRF(n3);
            n2 += 1 + TlsCryptoUtils.getHashOutputSize(n4);
        }
        TlsUtils.checkUint16(n2);
        return 2 + n2;
    }

    public static OfferedPsks parse(InputStream input) throws IOException {
        Object object;
        Vector<PskIdentity> vector = new Vector<PskIdentity>();
        int n2 = TlsUtils.readUint16(input);
        if (n2 < 7) {
            throw new TlsFatalAlert(50);
        }
        byte[] byArray = TlsUtils.readFully(n2, input);
        Object object2 = new ByteArrayInputStream(byArray);
        do {
            object = PskIdentity.parse((InputStream)object2);
            vector.add((PskIdentity)object);
        } while (((ByteArrayInputStream)object2).available() > 0);
        Vector<byte[]> vector2 = new Vector<byte[]>();
        int n3 = TlsUtils.readUint16(input);
        if (n3 < 33) {
            throw new TlsFatalAlert(50);
        }
        object2 = TlsUtils.readFully(n3, input);
        object = new ByteArrayInputStream((byte[])object2);
        do {
            byte[] byArray2 = TlsUtils.readOpaque8((InputStream)object, 32);
            vector2.add(byArray2);
        } while (((ByteArrayInputStream)object).available() > 0);
        return new OfferedPsks(vector, vector2, 2 + n3);
    }

    static class b {
        final int a;
        final TlsPSK b;
        final short[] c;
        final TlsSecret d;

        b(int n2, TlsPSK tlsPSK, short[] sArray, TlsSecret tlsSecret) {
            this.a = n2;
            this.b = tlsPSK;
            this.c = sArray;
            this.d = tlsSecret;
        }
    }

    static class a {
        final TlsPSK[] a;
        final short[] b;
        final TlsSecret[] c;
        final int d;

        a(TlsPSK[] tlsPSKArray, short[] sArray, TlsSecret[] tlsSecretArray, int n2) {
            this.a = tlsPSKArray;
            this.b = sArray;
            this.c = tlsSecretArray;
            this.d = n2;
        }
    }
}

