/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.AbstractTlsServer;
import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.TlsCredentialedDecryptor;
import com.enterprisedt.bouncycastle.tls.TlsCredentials;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsPSKIdentityManager;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCrypto;
import java.io.IOException;

public class PSKTlsServer
extends AbstractTlsServer {
    private static final int[] a = new int[]{52396, 49208, 49207, 49206, 49205, 52397, 171, 170, 179, 178, 145, 144};
    protected TlsPSKIdentityManager pskIdentityManager;

    public PSKTlsServer(TlsCrypto crypto, TlsPSKIdentityManager pskIdentityManager) {
        super(crypto);
        this.pskIdentityManager = pskIdentityManager;
    }

    protected TlsCredentialedDecryptor getRSAEncryptionCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    protected ProtocolVersion[] getSupportedVersions() {
        return ProtocolVersion.TLSv12.only();
    }

    @Override
    protected int[] getSupportedCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.getCrypto(), a);
    }

    @Override
    public TlsCredentials getCredentials() throws IOException {
        int n2 = this.context.getSecurityParametersHandshake().getKeyExchangeAlgorithm();
        switch (n2) {
            case 13: 
            case 14: 
            case 24: {
                return null;
            }
            case 15: {
                return this.getRSAEncryptionCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsPSKIdentityManager getPSKIdentityManager() {
        return this.pskIdentityManager;
    }
}

