/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsProtocol;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public class ServerHello {
    private static final byte[] a = new byte[]{-49, 33, -83, 116, -27, -102, 97, 17, -66, 29, -116, 2, 30, 101, -72, -111, -62, -94, 17, 22, 122, -69, -116, 94, 7, -98, 9, -30, -56, -88, 51, -100};
    private final ProtocolVersion b;
    private final byte[] c;
    private final byte[] d;
    private final int e;
    private final Hashtable f;

    public ServerHello(byte[] sessionID, int cipherSuite, Hashtable extensions) {
        this(ProtocolVersion.TLSv12, Arrays.clone(a), sessionID, cipherSuite, extensions);
    }

    public ServerHello(ProtocolVersion version, byte[] random, byte[] sessionID, int cipherSuite, Hashtable extensions) {
        this.b = version;
        this.c = random;
        this.d = sessionID;
        this.e = cipherSuite;
        this.f = extensions;
    }

    public int getCipherSuite() {
        return this.e;
    }

    public Hashtable getExtensions() {
        return this.f;
    }

    public byte[] getRandom() {
        return this.c;
    }

    public byte[] getSessionID() {
        return this.d;
    }

    public ProtocolVersion getVersion() {
        return this.b;
    }

    public boolean isHelloRetryRequest() {
        return Arrays.areEqual(a, this.c);
    }

    public void encode(TlsContext context, OutputStream output) throws IOException {
        TlsUtils.writeVersion(this.b, output);
        output.write(this.c);
        TlsUtils.writeOpaque8(this.d, output);
        TlsUtils.writeUint16(this.e, output);
        TlsUtils.writeUint8((short)0, output);
        TlsProtocol.writeExtensions(output, this.f);
    }

    public static ServerHello parse(ByteArrayInputStream input) throws IOException {
        ProtocolVersion protocolVersion = TlsUtils.readVersion(input);
        byte[] byArray = TlsUtils.readFully(32, (InputStream)input);
        byte[] byArray2 = TlsUtils.readOpaque8(input, 0, 32);
        int n2 = TlsUtils.readUint16(input);
        short s2 = TlsUtils.readUint8(input);
        if (0 != s2) {
            throw new TlsFatalAlert(47);
        }
        Hashtable hashtable = TlsProtocol.readExtensions(input);
        return new ServerHello(protocolVersion, byArray, byArray2, n2, hashtable);
    }
}

