/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.AbstractTlsKeyExchange;
import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.TlsCredentialedSigner;
import com.enterprisedt.bouncycastle.tls.TlsCredentials;
import com.enterprisedt.bouncycastle.tls.TlsDHGroupVerifier;
import com.enterprisedt.bouncycastle.tls.TlsDHUtils;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsAgreement;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCertificate;
import com.enterprisedt.bouncycastle.tls.crypto.TlsDHConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import com.enterprisedt.bouncycastle.tls.i;
import com.enterprisedt.bouncycastle.util.io.TeeInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TlsDHEKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsDHGroupVerifier dhGroupVerifier;
    protected TlsDHConfig dhConfig;
    protected TlsCredentialedSigner serverCredentials = null;
    protected TlsCertificate serverCertificate = null;
    protected TlsAgreement agreement;

    private static int a(int n2) {
        switch (n2) {
            case 3: 
            case 5: {
                return n2;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsDHEKeyExchange(int keyExchange, TlsDHGroupVerifier dhGroupVerifier) {
        this(keyExchange, dhGroupVerifier, null);
    }

    public TlsDHEKeyExchange(int keyExchange, TlsDHConfig dhConfig) {
        this(keyExchange, null, dhConfig);
    }

    private TlsDHEKeyExchange(int keyExchange, TlsDHGroupVerifier dhGroupVerifier, TlsDHConfig dhConfig) {
        super(TlsDHEKeyExchange.a(keyExchange));
        this.dhGroupVerifier = dhGroupVerifier;
        this.dhConfig = dhConfig;
    }

    @Override
    public void skipServerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        this.serverCredentials = TlsUtils.c(serverCredentials);
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        this.serverCertificate = serverCertificate.getCertificateAt(0);
    }

    @Override
    public boolean requiresServerKeyExchange() {
        return true;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        i i2 = new i();
        TlsDHUtils.writeDHConfig(this.dhConfig, i2);
        this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
        byte[] byArray = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque16(byArray, i2);
        TlsUtils.a(this.context, this.serverCredentials, null, i2);
        return i2.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        i i2 = new i();
        TeeInputStream teeInputStream = new TeeInputStream(input, i2);
        this.dhConfig = TlsDHUtils.receiveDHConfig(this.context, this.dhGroupVerifier, teeInputStream);
        byte[] byArray = TlsUtils.readOpaque16(teeInputStream, 1);
        TlsUtils.a(this.context, input, this.serverCertificate, null, i2);
        this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
        this.agreement.receivePeerValue(byArray);
    }

    @Override
    public short[] getClientCertificateTypes() {
        return new short[]{2, 64, 1};
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        TlsUtils.c(clientCredentials);
    }

    @Override
    public void generateClientKeyExchange(OutputStream output) throws IOException {
        byte[] byArray = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque16(byArray, output);
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
        this.agreement.receivePeerValue(TlsUtils.readOpaque16(input, 1));
    }

    @Override
    public TlsSecret generatePreMasterSecret() throws IOException {
        return this.agreement.calculateSecret();
    }
}

