/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.AbstractTlsKeyExchange;
import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.TlsCredentials;
import com.enterprisedt.bouncycastle.tls.TlsDHGroupVerifier;
import com.enterprisedt.bouncycastle.tls.TlsDHUtils;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsAgreement;
import com.enterprisedt.bouncycastle.tls.crypto.TlsDHConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TlsDHanonKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsDHGroupVerifier dhGroupVerifier;
    protected TlsDHConfig dhConfig;
    protected TlsAgreement agreement;

    private static int a(int n2) {
        switch (n2) {
            case 11: {
                return n2;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsDHanonKeyExchange(int keyExchange, TlsDHGroupVerifier dhGroupVerifier) {
        this(keyExchange, dhGroupVerifier, null);
    }

    public TlsDHanonKeyExchange(int keyExchange, TlsDHConfig dhConfig) {
        this(keyExchange, null, dhConfig);
    }

    private TlsDHanonKeyExchange(int keyExchange, TlsDHGroupVerifier dhGroupVerifier, TlsDHConfig dhConfig) {
        super(TlsDHanonKeyExchange.a(keyExchange));
        this.dhGroupVerifier = dhGroupVerifier;
        this.dhConfig = dhConfig;
    }

    @Override
    public void skipServerCredentials() throws IOException {
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public boolean requiresServerKeyExchange() {
        return true;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsDHUtils.writeDHConfig(this.dhConfig, byteArrayOutputStream);
        this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
        byte[] byArray = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque16(byArray, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        this.dhConfig = TlsDHUtils.receiveDHConfig(this.context, this.dhGroupVerifier, input);
        byte[] byArray = TlsUtils.readOpaque16(input, 1);
        this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
        this.agreement.receivePeerValue(byArray);
    }

    @Override
    public short[] getClientCertificateTypes() {
        return null;
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void generateClientKeyExchange(OutputStream output) throws IOException {
        byte[] byArray = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque16(byArray, output);
    }

    @Override
    public void processClientCertificate(Certificate clientCertificate) throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
        byte[] byArray = TlsUtils.readOpaque16(input, 1);
        this.agreement.receivePeerValue(byArray);
    }

    @Override
    public TlsSecret generatePreMasterSecret() throws IOException {
        return this.agreement.calculateSecret();
    }
}

