/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.AbstractTlsKeyExchange;
import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.TlsCredentialedSigner;
import com.enterprisedt.bouncycastle.tls.TlsCredentials;
import com.enterprisedt.bouncycastle.tls.TlsECCUtils;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsAgreement;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCertificate;
import com.enterprisedt.bouncycastle.tls.crypto.TlsECConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import com.enterprisedt.bouncycastle.tls.i;
import com.enterprisedt.bouncycastle.util.io.TeeInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TlsECDHEKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsECConfig ecConfig;
    protected TlsCredentialedSigner serverCredentials = null;
    protected TlsCertificate serverCertificate = null;
    protected TlsAgreement agreement;

    private static int a(int n2) {
        switch (n2) {
            case 17: 
            case 19: {
                return n2;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsECDHEKeyExchange(int keyExchange) {
        this(keyExchange, null);
    }

    public TlsECDHEKeyExchange(int keyExchange, TlsECConfig ecConfig) {
        super(TlsECDHEKeyExchange.a(keyExchange));
        this.ecConfig = ecConfig;
    }

    @Override
    public void skipServerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        this.serverCredentials = TlsUtils.c(serverCredentials);
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        this.serverCertificate = serverCertificate.getCertificateAt(0);
    }

    @Override
    public boolean requiresServerKeyExchange() {
        return true;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        i i2 = new i();
        TlsECCUtils.writeECConfig(this.ecConfig, i2);
        this.agreement = this.context.getCrypto().createECDomain(this.ecConfig).createECDH();
        this.generateEphemeral(i2);
        TlsUtils.a(this.context, this.serverCredentials, null, i2);
        return i2.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        i i2 = new i();
        TeeInputStream teeInputStream = new TeeInputStream(input, i2);
        this.ecConfig = TlsECCUtils.receiveECDHConfig(this.context, teeInputStream);
        byte[] byArray = TlsUtils.readOpaque8(teeInputStream, 1);
        TlsUtils.a(this.context, input, this.serverCertificate, null, i2);
        this.agreement = this.context.getCrypto().createECDomain(this.ecConfig).createECDH();
        this.processEphemeral(byArray);
    }

    @Override
    public short[] getClientCertificateTypes() {
        return new short[]{2, 64, 1};
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        TlsUtils.c(clientCredentials);
    }

    @Override
    public void generateClientKeyExchange(OutputStream output) throws IOException {
        this.generateEphemeral(output);
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
        byte[] byArray = TlsUtils.readOpaque8(input, 1);
        this.processEphemeral(byArray);
    }

    @Override
    public TlsSecret generatePreMasterSecret() throws IOException {
        return this.agreement.calculateSecret();
    }

    protected void generateEphemeral(OutputStream output) throws IOException {
        byte[] byArray = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque8(byArray, output);
    }

    protected void processEphemeral(byte[] point) throws IOException {
        TlsECCUtils.checkPointEncoding(this.ecConfig.getNamedGroup(), point);
        this.agreement.receivePeerValue(point);
    }
}

