/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.x500.X500Name;
import com.enterprisedt.bouncycastle.tls.CertificateStatusRequest;
import com.enterprisedt.bouncycastle.tls.CertificateStatusRequestItemV2;
import com.enterprisedt.bouncycastle.tls.HeartbeatExtension;
import com.enterprisedt.bouncycastle.tls.KeyShareEntry;
import com.enterprisedt.bouncycastle.tls.OfferedPsks;
import com.enterprisedt.bouncycastle.tls.ProtocolName;
import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.ServerNameList;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsProtocol;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.TrustedAuthority;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Integers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TlsExtensionsUtils {
    public static final Integer EXT_application_layer_protocol_negotiation = Integers.valueOf(16);
    public static final Integer EXT_certificate_authorities = Integers.valueOf(47);
    public static final Integer EXT_client_certificate_type = Integers.valueOf(19);
    public static final Integer EXT_client_certificate_url = Integers.valueOf(2);
    public static final Integer EXT_compress_certificate = Integers.valueOf(27);
    public static final Integer EXT_connection_id = Integers.valueOf(54);
    public static final Integer EXT_cookie = Integers.valueOf(44);
    public static final Integer EXT_early_data = Integers.valueOf(42);
    public static final Integer EXT_ec_point_formats = Integers.valueOf(11);
    public static final Integer EXT_encrypt_then_mac = Integers.valueOf(22);
    public static final Integer EXT_extended_master_secret = Integers.valueOf(23);
    public static final Integer EXT_heartbeat = Integers.valueOf(15);
    public static final Integer EXT_key_share = Integers.valueOf(51);
    public static final Integer EXT_max_fragment_length = Integers.valueOf(1);
    public static final Integer EXT_oid_filters = Integers.valueOf(48);
    public static final Integer EXT_padding = Integers.valueOf(21);
    public static final Integer EXT_post_handshake_auth = Integers.valueOf(49);
    public static final Integer EXT_pre_shared_key = Integers.valueOf(41);
    public static final Integer EXT_psk_key_exchange_modes = Integers.valueOf(45);
    public static final Integer EXT_record_size_limit = Integers.valueOf(28);
    public static final Integer EXT_server_certificate_type = Integers.valueOf(20);
    public static final Integer EXT_server_name = Integers.valueOf(0);
    public static final Integer EXT_signature_algorithms = Integers.valueOf(13);
    public static final Integer EXT_signature_algorithms_cert = Integers.valueOf(50);
    public static final Integer EXT_status_request = Integers.valueOf(5);
    public static final Integer EXT_status_request_v2 = Integers.valueOf(17);
    public static final Integer EXT_supported_groups = Integers.valueOf(10);
    public static final Integer EXT_supported_versions = Integers.valueOf(43);
    public static final Integer EXT_truncated_hmac = Integers.valueOf(4);
    public static final Integer EXT_trusted_ca_keys = Integers.valueOf(3);

    public static Hashtable ensureExtensionsInitialised(Hashtable extensions) {
        return extensions == null ? new Hashtable() : extensions;
    }

    public static void addALPNExtensionClient(Hashtable extensions, Vector protocolNameList) throws IOException {
        extensions.put(EXT_application_layer_protocol_negotiation, TlsExtensionsUtils.createALPNExtensionClient(protocolNameList));
    }

    public static void addALPNExtensionServer(Hashtable extensions, ProtocolName protocolName) throws IOException {
        extensions.put(EXT_application_layer_protocol_negotiation, TlsExtensionsUtils.createALPNExtensionServer(protocolName));
    }

    public static void addCertificateAuthoritiesExtension(Hashtable extensions, Vector authorities) throws IOException {
        extensions.put(EXT_certificate_authorities, TlsExtensionsUtils.createCertificateAuthoritiesExtension(authorities));
    }

    public static void addClientCertificateTypeExtensionClient(Hashtable extensions, short[] certificateTypes) throws IOException {
        extensions.put(EXT_client_certificate_type, TlsExtensionsUtils.createCertificateTypeExtensionClient(certificateTypes));
    }

    public static void addClientCertificateTypeExtensionServer(Hashtable extensions, short certificateType) throws IOException {
        extensions.put(EXT_client_certificate_type, TlsExtensionsUtils.createCertificateTypeExtensionServer(certificateType));
    }

    public static void addClientCertificateURLExtension(Hashtable extensions) {
        extensions.put(EXT_client_certificate_url, TlsExtensionsUtils.createClientCertificateURLExtension());
    }

    public static void addCompressCertificateExtension(Hashtable extensions, int[] algorithms) throws IOException {
        extensions.put(EXT_compress_certificate, TlsExtensionsUtils.createCompressCertificateExtension(algorithms));
    }

    public static void addConnectionIDExtension(Hashtable extensions, byte[] connectionID) throws IOException {
        extensions.put(EXT_connection_id, TlsExtensionsUtils.createConnectionIDExtension(connectionID));
    }

    public static void addCookieExtension(Hashtable extensions, byte[] cookie) throws IOException {
        extensions.put(EXT_cookie, TlsExtensionsUtils.createCookieExtension(cookie));
    }

    public static void addEarlyDataIndication(Hashtable extensions) {
        extensions.put(EXT_early_data, TlsExtensionsUtils.createEarlyDataIndication());
    }

    public static void addEarlyDataMaxSize(Hashtable extensions, long maxSize) throws IOException {
        extensions.put(EXT_early_data, TlsExtensionsUtils.createEarlyDataMaxSize(maxSize));
    }

    public static void addEmptyExtensionData(Hashtable extensions, Integer extType) {
        extensions.put(extType, TlsExtensionsUtils.createEmptyExtensionData());
    }

    public static void addEncryptThenMACExtension(Hashtable extensions) {
        extensions.put(EXT_encrypt_then_mac, TlsExtensionsUtils.createEncryptThenMACExtension());
    }

    public static void addExtendedMasterSecretExtension(Hashtable extensions) {
        extensions.put(EXT_extended_master_secret, TlsExtensionsUtils.createExtendedMasterSecretExtension());
    }

    public static void addHeartbeatExtension(Hashtable extensions, HeartbeatExtension heartbeatExtension) throws IOException {
        extensions.put(EXT_heartbeat, TlsExtensionsUtils.createHeartbeatExtension(heartbeatExtension));
    }

    public static void addKeyShareClientHello(Hashtable extensions, Vector clientShares) throws IOException {
        extensions.put(EXT_key_share, TlsExtensionsUtils.createKeyShareClientHello(clientShares));
    }

    public static void addKeyShareHelloRetryRequest(Hashtable extensions, int namedGroup) throws IOException {
        extensions.put(EXT_key_share, TlsExtensionsUtils.createKeyShareHelloRetryRequest(namedGroup));
    }

    public static void addKeyShareServerHello(Hashtable extensions, KeyShareEntry serverShare) throws IOException {
        extensions.put(EXT_key_share, TlsExtensionsUtils.createKeyShareServerHello(serverShare));
    }

    public static void addMaxFragmentLengthExtension(Hashtable extensions, short maxFragmentLength) throws IOException {
        extensions.put(EXT_max_fragment_length, TlsExtensionsUtils.createMaxFragmentLengthExtension(maxFragmentLength));
    }

    public static void addOIDFiltersExtension(Hashtable extensions, Hashtable filters) throws IOException {
        extensions.put(EXT_oid_filters, TlsExtensionsUtils.createOIDFiltersExtension(filters));
    }

    public static void addPaddingExtension(Hashtable extensions, int dataLength) throws IOException {
        extensions.put(EXT_padding, TlsExtensionsUtils.createPaddingExtension(dataLength));
    }

    public static void addPostHandshakeAuthExtension(Hashtable extensions) {
        extensions.put(EXT_post_handshake_auth, TlsExtensionsUtils.createPostHandshakeAuthExtension());
    }

    public static void addPreSharedKeyClientHello(Hashtable extensions, OfferedPsks offeredPsks) throws IOException {
        extensions.put(EXT_pre_shared_key, TlsExtensionsUtils.createPreSharedKeyClientHello(offeredPsks));
    }

    public static void addPreSharedKeyServerHello(Hashtable extensions, int selectedIdentity) throws IOException {
        extensions.put(EXT_pre_shared_key, TlsExtensionsUtils.createPreSharedKeyServerHello(selectedIdentity));
    }

    public static void addPSKKeyExchangeModesExtension(Hashtable extensions, short[] modes) throws IOException {
        extensions.put(EXT_psk_key_exchange_modes, TlsExtensionsUtils.createPSKKeyExchangeModesExtension(modes));
    }

    public static void addRecordSizeLimitExtension(Hashtable extensions, int recordSizeLimit) throws IOException {
        extensions.put(EXT_record_size_limit, TlsExtensionsUtils.createRecordSizeLimitExtension(recordSizeLimit));
    }

    public static void addServerCertificateTypeExtensionClient(Hashtable extensions, short[] certificateTypes) throws IOException {
        extensions.put(EXT_server_certificate_type, TlsExtensionsUtils.createCertificateTypeExtensionClient(certificateTypes));
    }

    public static void addServerCertificateTypeExtensionServer(Hashtable extensions, short certificateType) throws IOException {
        extensions.put(EXT_server_certificate_type, TlsExtensionsUtils.createCertificateTypeExtensionServer(certificateType));
    }

    public static void addServerNameExtensionClient(Hashtable extensions, Vector serverNameList) throws IOException {
        extensions.put(EXT_server_name, TlsExtensionsUtils.createServerNameExtensionClient(serverNameList));
    }

    public static void addServerNameExtensionServer(Hashtable extensions) throws IOException {
        extensions.put(EXT_server_name, TlsExtensionsUtils.createServerNameExtensionServer());
    }

    public static void addSignatureAlgorithmsExtension(Hashtable extensions, Vector supportedSignatureAlgorithms) throws IOException {
        extensions.put(EXT_signature_algorithms, TlsExtensionsUtils.createSignatureAlgorithmsExtension(supportedSignatureAlgorithms));
    }

    public static void addSignatureAlgorithmsCertExtension(Hashtable extensions, Vector supportedSignatureAlgorithms) throws IOException {
        extensions.put(EXT_signature_algorithms_cert, TlsExtensionsUtils.createSignatureAlgorithmsCertExtension(supportedSignatureAlgorithms));
    }

    public static void addStatusRequestExtension(Hashtable extensions, CertificateStatusRequest statusRequest) throws IOException {
        extensions.put(EXT_status_request, TlsExtensionsUtils.createStatusRequestExtension(statusRequest));
    }

    public static void addStatusRequestV2Extension(Hashtable extensions, Vector statusRequestV2) throws IOException {
        extensions.put(EXT_status_request_v2, TlsExtensionsUtils.createStatusRequestV2Extension(statusRequestV2));
    }

    public static void addSupportedGroupsExtension(Hashtable extensions, Vector namedGroups) throws IOException {
        extensions.put(EXT_supported_groups, TlsExtensionsUtils.createSupportedGroupsExtension(namedGroups));
    }

    public static void addSupportedPointFormatsExtension(Hashtable extensions, short[] ecPointFormats) throws IOException {
        extensions.put(EXT_ec_point_formats, TlsExtensionsUtils.createSupportedPointFormatsExtension(ecPointFormats));
    }

    public static void addSupportedVersionsExtensionClient(Hashtable extensions, ProtocolVersion[] versions) throws IOException {
        extensions.put(EXT_supported_versions, TlsExtensionsUtils.createSupportedVersionsExtensionClient(versions));
    }

    public static void addSupportedVersionsExtensionServer(Hashtable extensions, ProtocolVersion selectedVersion) throws IOException {
        extensions.put(EXT_supported_versions, TlsExtensionsUtils.createSupportedVersionsExtensionServer(selectedVersion));
    }

    public static void addTruncatedHMacExtension(Hashtable extensions) {
        extensions.put(EXT_truncated_hmac, TlsExtensionsUtils.createTruncatedHMacExtension());
    }

    public static void addTrustedCAKeysExtensionClient(Hashtable extensions, Vector trustedAuthoritiesList) throws IOException {
        extensions.put(EXT_trusted_ca_keys, TlsExtensionsUtils.createTrustedCAKeysExtensionClient(trustedAuthoritiesList));
    }

    public static void addTrustedCAKeysExtensionServer(Hashtable extensions) {
        extensions.put(EXT_trusted_ca_keys, TlsExtensionsUtils.createTrustedCAKeysExtensionServer());
    }

    public static Vector getALPNExtensionClient(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_application_layer_protocol_negotiation);
        return byArray == null ? null : TlsExtensionsUtils.readALPNExtensionClient(byArray);
    }

    public static ProtocolName getALPNExtensionServer(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_application_layer_protocol_negotiation);
        return byArray == null ? null : TlsExtensionsUtils.readALPNExtensionServer(byArray);
    }

    public static Vector getCertificateAuthoritiesExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_certificate_authorities);
        return byArray == null ? null : TlsExtensionsUtils.readCertificateAuthoritiesExtension(byArray);
    }

    public static short[] getClientCertificateTypeExtensionClient(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_client_certificate_type);
        return byArray == null ? null : TlsExtensionsUtils.readCertificateTypeExtensionClient(byArray);
    }

    public static short getClientCertificateTypeExtensionServer(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_client_certificate_type);
        return byArray == null ? (short)-1 : (short)TlsExtensionsUtils.readCertificateTypeExtensionServer(byArray);
    }

    public static short getClientCertificateTypeExtensionServer(Hashtable extensions, short defaultValue) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_client_certificate_type);
        return byArray == null ? defaultValue : TlsExtensionsUtils.readCertificateTypeExtensionServer(byArray);
    }

    public static int[] getCompressCertificateExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_compress_certificate);
        return byArray == null ? null : TlsExtensionsUtils.readCompressCertificateExtension(byArray);
    }

    public static byte[] getConnectionIDExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_connection_id);
        return byArray == null ? null : TlsExtensionsUtils.readConnectionIDExtension(byArray);
    }

    public static byte[] getCookieExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_cookie);
        return byArray == null ? null : TlsExtensionsUtils.readCookieExtension(byArray);
    }

    public static long getEarlyDataMaxSize(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_early_data);
        return byArray == null ? -1L : TlsExtensionsUtils.readEarlyDataMaxSize(byArray);
    }

    public static HeartbeatExtension getHeartbeatExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_heartbeat);
        return byArray == null ? null : TlsExtensionsUtils.readHeartbeatExtension(byArray);
    }

    public static Vector getKeyShareClientHello(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_key_share);
        return byArray == null ? null : TlsExtensionsUtils.readKeyShareClientHello(byArray);
    }

    public static int getKeyShareHelloRetryRequest(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_key_share);
        return byArray == null ? -1 : TlsExtensionsUtils.readKeyShareHelloRetryRequest(byArray);
    }

    public static KeyShareEntry getKeyShareServerHello(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_key_share);
        return byArray == null ? null : TlsExtensionsUtils.readKeyShareServerHello(byArray);
    }

    public static short getMaxFragmentLengthExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_max_fragment_length);
        return byArray == null ? (short)-1 : (short)TlsExtensionsUtils.readMaxFragmentLengthExtension(byArray);
    }

    public static Hashtable getOIDFiltersExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_oid_filters);
        return byArray == null ? null : TlsExtensionsUtils.readOIDFiltersExtension(byArray);
    }

    public static int getPaddingExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_padding);
        return byArray == null ? -1 : TlsExtensionsUtils.readPaddingExtension(byArray);
    }

    public static OfferedPsks getPreSharedKeyClientHello(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_pre_shared_key);
        return byArray == null ? null : TlsExtensionsUtils.readPreSharedKeyClientHello(byArray);
    }

    public static int getPreSharedKeyServerHello(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_pre_shared_key);
        return byArray == null ? -1 : TlsExtensionsUtils.readPreSharedKeyServerHello(byArray);
    }

    public static short[] getPSKKeyExchangeModesExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_psk_key_exchange_modes);
        return byArray == null ? null : TlsExtensionsUtils.readPSKKeyExchangeModesExtension(byArray);
    }

    public static int getRecordSizeLimitExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_record_size_limit);
        return byArray == null ? -1 : TlsExtensionsUtils.readRecordSizeLimitExtension(byArray);
    }

    public static short[] getServerCertificateTypeExtensionClient(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_server_certificate_type);
        return byArray == null ? null : TlsExtensionsUtils.readCertificateTypeExtensionClient(byArray);
    }

    public static short getServerCertificateTypeExtensionServer(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_server_certificate_type);
        return byArray == null ? (short)-1 : (short)TlsExtensionsUtils.readCertificateTypeExtensionServer(byArray);
    }

    public static short getServerCertificateTypeExtensionServer(Hashtable extensions, short defaultValue) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_server_certificate_type);
        return byArray == null ? defaultValue : TlsExtensionsUtils.readCertificateTypeExtensionServer(byArray);
    }

    public static Vector getServerNameExtensionClient(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_server_name);
        return byArray == null ? null : TlsExtensionsUtils.readServerNameExtensionClient(byArray);
    }

    public static Vector getSignatureAlgorithmsExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_signature_algorithms);
        return byArray == null ? null : TlsExtensionsUtils.readSignatureAlgorithmsExtension(byArray);
    }

    public static Vector getSignatureAlgorithmsCertExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_signature_algorithms_cert);
        return byArray == null ? null : TlsExtensionsUtils.readSignatureAlgorithmsCertExtension(byArray);
    }

    public static CertificateStatusRequest getStatusRequestExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_status_request);
        return byArray == null ? null : TlsExtensionsUtils.readStatusRequestExtension(byArray);
    }

    public static Vector getStatusRequestV2Extension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_status_request_v2);
        return byArray == null ? null : TlsExtensionsUtils.readStatusRequestV2Extension(byArray);
    }

    public static int[] getSupportedGroupsExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_supported_groups);
        return byArray == null ? null : TlsExtensionsUtils.readSupportedGroupsExtension(byArray);
    }

    public static short[] getSupportedPointFormatsExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_ec_point_formats);
        return byArray == null ? null : TlsExtensionsUtils.readSupportedPointFormatsExtension(byArray);
    }

    public static ProtocolVersion[] getSupportedVersionsExtensionClient(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_supported_versions);
        return byArray == null ? null : TlsExtensionsUtils.readSupportedVersionsExtensionClient(byArray);
    }

    public static ProtocolVersion getSupportedVersionsExtensionServer(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_supported_versions);
        return byArray == null ? null : TlsExtensionsUtils.readSupportedVersionsExtensionServer(byArray);
    }

    public static Vector getTrustedCAKeysExtensionClient(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_trusted_ca_keys);
        return byArray == null ? null : TlsExtensionsUtils.readTrustedCAKeysExtensionClient(byArray);
    }

    public static boolean hasClientCertificateURLExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_client_certificate_url);
        return byArray == null ? false : TlsExtensionsUtils.readClientCertificateURLExtension(byArray);
    }

    public static boolean hasEarlyDataIndication(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_early_data);
        return byArray == null ? false : TlsExtensionsUtils.readEarlyDataIndication(byArray);
    }

    public static boolean hasEncryptThenMACExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_encrypt_then_mac);
        return byArray == null ? false : TlsExtensionsUtils.readEncryptThenMACExtension(byArray);
    }

    public static boolean hasExtendedMasterSecretExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_extended_master_secret);
        return byArray == null ? false : TlsExtensionsUtils.readExtendedMasterSecretExtension(byArray);
    }

    public static boolean hasServerNameExtensionServer(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_server_name);
        return byArray == null ? false : TlsExtensionsUtils.readServerNameExtensionServer(byArray);
    }

    public static boolean hasPostHandshakeAuthExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_post_handshake_auth);
        return byArray == null ? false : TlsExtensionsUtils.readPostHandshakeAuthExtension(byArray);
    }

    public static boolean hasTruncatedHMacExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_truncated_hmac);
        return byArray == null ? false : TlsExtensionsUtils.readTruncatedHMacExtension(byArray);
    }

    public static boolean hasTrustedCAKeysExtensionServer(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_trusted_ca_keys);
        return byArray == null ? false : TlsExtensionsUtils.readTrustedCAKeysExtensionServer(byArray);
    }

    public static byte[] createALPNExtensionClient(Vector protocolNameList) throws IOException {
        if (protocolNameList == null || protocolNameList.size() < 1) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint16(0, byteArrayOutputStream);
        for (int i2 = 0; i2 < protocolNameList.size(); ++i2) {
            ProtocolName protocolName = (ProtocolName)protocolNameList.elementAt(i2);
            protocolName.encode(byteArrayOutputStream);
        }
        return TlsExtensionsUtils.a(byteArrayOutputStream);
    }

    public static byte[] createALPNExtensionServer(ProtocolName protocolName) throws IOException {
        Vector<ProtocolName> vector = new Vector<ProtocolName>();
        vector.addElement(protocolName);
        return TlsExtensionsUtils.createALPNExtensionClient(vector);
    }

    public static byte[] createCertificateAuthoritiesExtension(Vector authorities) throws IOException {
        if (null == authorities || authorities.isEmpty()) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint16(0, byteArrayOutputStream);
        for (int i2 = 0; i2 < authorities.size(); ++i2) {
            X500Name x500Name = (X500Name)authorities.elementAt(i2);
            byte[] byArray = x500Name.getEncoded("DER");
            TlsUtils.writeOpaque16(byArray, byteArrayOutputStream);
        }
        return TlsExtensionsUtils.a(byteArrayOutputStream);
    }

    public static byte[] createCertificateTypeExtensionClient(short[] certificateTypes) throws IOException {
        if (TlsUtils.isNullOrEmpty(certificateTypes) || certificateTypes.length > 255) {
            throw new TlsFatalAlert(80);
        }
        return TlsUtils.encodeUint8ArrayWithUint8Length(certificateTypes);
    }

    public static byte[] createCertificateTypeExtensionServer(short certificateType) throws IOException {
        return TlsUtils.encodeUint8(certificateType);
    }

    public static byte[] createClientCertificateURLExtension() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createCompressCertificateExtension(int[] algorithms) throws IOException {
        if (TlsUtils.isNullOrEmpty(algorithms) || algorithms.length > 127) {
            throw new TlsFatalAlert(80);
        }
        return TlsUtils.encodeUint16ArrayWithUint8Length(algorithms);
    }

    public static byte[] createConnectionIDExtension(byte[] connectionID) throws IOException {
        if (connectionID == null) {
            throw new TlsFatalAlert(80);
        }
        return TlsUtils.encodeOpaque8(connectionID);
    }

    public static byte[] createCookieExtension(byte[] cookie) throws IOException {
        if (TlsUtils.isNullOrEmpty(cookie) || cookie.length >= 65536) {
            throw new TlsFatalAlert(80);
        }
        return TlsUtils.encodeOpaque16(cookie);
    }

    public static byte[] createEarlyDataIndication() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createEarlyDataMaxSize(long maxSize) throws IOException {
        return TlsUtils.encodeUint32(maxSize);
    }

    public static byte[] createEmptyExtensionData() {
        return TlsUtils.EMPTY_BYTES;
    }

    public static byte[] createEncryptThenMACExtension() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createExtendedMasterSecretExtension() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createHeartbeatExtension(HeartbeatExtension heartbeatExtension) throws IOException {
        if (heartbeatExtension == null) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        heartbeatExtension.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] createKeyShareClientHello(Vector clientShares) throws IOException {
        if (clientShares == null || clientShares.isEmpty()) {
            return TlsUtils.encodeUint16(0);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint16(0, byteArrayOutputStream);
        for (int i2 = 0; i2 < clientShares.size(); ++i2) {
            KeyShareEntry keyShareEntry = (KeyShareEntry)clientShares.elementAt(i2);
            keyShareEntry.encode(byteArrayOutputStream);
        }
        return TlsExtensionsUtils.a(byteArrayOutputStream);
    }

    public static byte[] createKeyShareHelloRetryRequest(int namedGroup) throws IOException {
        return TlsUtils.encodeUint16(namedGroup);
    }

    public static byte[] createKeyShareServerHello(KeyShareEntry serverShare) throws IOException {
        if (serverShare == null) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        serverShare.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] createMaxFragmentLengthExtension(short maxFragmentLength) throws IOException {
        return TlsUtils.encodeUint8(maxFragmentLength);
    }

    public static byte[] createOIDFiltersExtension(Hashtable filters) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint16(0, byteArrayOutputStream);
        if (null != filters) {
            Enumeration enumeration = filters.keys();
            while (enumeration.hasMoreElements()) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
                byte[] byArray = (byte[])filters.get(aSN1ObjectIdentifier);
                if (null == aSN1ObjectIdentifier || null == byArray) {
                    throw new TlsFatalAlert(80);
                }
                byte[] byArray2 = aSN1ObjectIdentifier.getEncoded("DER");
                TlsUtils.writeOpaque8(byArray2, byteArrayOutputStream);
                TlsUtils.writeOpaque16(byArray, byteArrayOutputStream);
            }
        }
        return TlsExtensionsUtils.a(byteArrayOutputStream);
    }

    public static byte[] createPaddingExtension(int dataLength) throws IOException {
        TlsUtils.checkUint16(dataLength);
        return new byte[dataLength];
    }

    public static byte[] createPostHandshakeAuthExtension() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createPreSharedKeyClientHello(OfferedPsks offeredPsks) throws IOException {
        if (offeredPsks == null) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        offeredPsks.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] createPreSharedKeyServerHello(int selectedIdentity) throws IOException {
        return TlsUtils.encodeUint16(selectedIdentity);
    }

    public static byte[] createPSKKeyExchangeModesExtension(short[] modes) throws IOException {
        if (TlsUtils.isNullOrEmpty(modes) || modes.length > 255) {
            throw new TlsFatalAlert(80);
        }
        return TlsUtils.encodeUint8ArrayWithUint8Length(modes);
    }

    public static byte[] createRecordSizeLimitExtension(int recordSizeLimit) throws IOException {
        if (recordSizeLimit < 64) {
            throw new TlsFatalAlert(80);
        }
        return TlsUtils.encodeUint16(recordSizeLimit);
    }

    public static byte[] createServerNameExtensionClient(Vector serverNameList) throws IOException {
        if (serverNameList == null) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        new ServerNameList(serverNameList).encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] createServerNameExtensionServer() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createSignatureAlgorithmsExtension(Vector supportedSignatureAlgorithms) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.encodeSupportedSignatureAlgorithms(supportedSignatureAlgorithms, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] createSignatureAlgorithmsCertExtension(Vector supportedSignatureAlgorithms) throws IOException {
        return TlsExtensionsUtils.createSignatureAlgorithmsExtension(supportedSignatureAlgorithms);
    }

    public static byte[] createStatusRequestExtension(CertificateStatusRequest statusRequest) throws IOException {
        if (statusRequest == null) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        statusRequest.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] createStatusRequestV2Extension(Vector statusRequestV2) throws IOException {
        if (statusRequestV2 == null || statusRequestV2.isEmpty()) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint16(0, byteArrayOutputStream);
        for (int i2 = 0; i2 < statusRequestV2.size(); ++i2) {
            CertificateStatusRequestItemV2 certificateStatusRequestItemV2 = (CertificateStatusRequestItemV2)statusRequestV2.elementAt(i2);
            certificateStatusRequestItemV2.encode(byteArrayOutputStream);
        }
        return TlsExtensionsUtils.a(byteArrayOutputStream);
    }

    public static byte[] createSupportedGroupsExtension(Vector namedGroups) throws IOException {
        if (namedGroups == null || namedGroups.isEmpty()) {
            throw new TlsFatalAlert(80);
        }
        int n2 = namedGroups.size();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = (Integer)namedGroups.elementAt(i2);
        }
        return TlsUtils.encodeUint16ArrayWithUint16Length(nArray);
    }

    public static byte[] createSupportedPointFormatsExtension(short[] ecPointFormats) throws IOException {
        if (ecPointFormats == null || !Arrays.contains(ecPointFormats, (short)0)) {
            ecPointFormats = Arrays.prepend(ecPointFormats, (short)0);
        }
        return TlsUtils.encodeUint8ArrayWithUint8Length(ecPointFormats);
    }

    public static byte[] createSupportedVersionsExtensionClient(ProtocolVersion[] versions) throws IOException {
        if (TlsUtils.isNullOrEmpty(versions) || versions.length > 127) {
            throw new TlsFatalAlert(80);
        }
        int n2 = versions.length;
        byte[] byArray = new byte[1 + n2 * 2];
        TlsUtils.writeUint8(n2 * 2, byArray, 0);
        for (int i2 = 0; i2 < n2; ++i2) {
            TlsUtils.writeVersion(versions[i2], byArray, 1 + i2 * 2);
        }
        return byArray;
    }

    public static byte[] createSupportedVersionsExtensionServer(ProtocolVersion selectedVersion) throws IOException {
        return TlsUtils.encodeVersion(selectedVersion);
    }

    public static byte[] createTruncatedHMacExtension() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createTrustedCAKeysExtensionClient(Vector trustedAuthoritiesList) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint16(0, byteArrayOutputStream);
        if (trustedAuthoritiesList != null) {
            for (int i2 = 0; i2 < trustedAuthoritiesList.size(); ++i2) {
                TrustedAuthority trustedAuthority = (TrustedAuthority)trustedAuthoritiesList.elementAt(i2);
                trustedAuthority.encode(byteArrayOutputStream);
            }
        }
        return TlsExtensionsUtils.a(byteArrayOutputStream);
    }

    public static byte[] createTrustedCAKeysExtensionServer() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    private static boolean a(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        if (byArray.length != 0) {
            throw new TlsFatalAlert(47);
        }
        return true;
    }

    public static Vector readALPNExtensionClient(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extensionData);
        int n2 = TlsUtils.readUint16(byteArrayInputStream);
        if (n2 != extensionData.length - 2) {
            throw new TlsFatalAlert(50);
        }
        Vector<ProtocolName> vector = new Vector<ProtocolName>();
        while (byteArrayInputStream.available() > 0) {
            ProtocolName protocolName = ProtocolName.parse(byteArrayInputStream);
            vector.addElement(protocolName);
        }
        return vector;
    }

    public static ProtocolName readALPNExtensionServer(byte[] extensionData) throws IOException {
        Vector vector = TlsExtensionsUtils.readALPNExtensionClient(extensionData);
        if (vector.size() != 1) {
            throw new TlsFatalAlert(50);
        }
        return (ProtocolName)vector.elementAt(0);
    }

    public static Vector readCertificateAuthoritiesExtension(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        if (extensionData.length < 5) {
            throw new TlsFatalAlert(50);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extensionData);
        int n2 = TlsUtils.readUint16(byteArrayInputStream);
        if (n2 != extensionData.length - 2) {
            throw new TlsFatalAlert(50);
        }
        Vector<X500Name> vector = new Vector<X500Name>();
        while (byteArrayInputStream.available() > 0) {
            byte[] byArray = TlsUtils.readOpaque16(byteArrayInputStream, 1);
            ASN1Primitive aSN1Primitive = TlsUtils.readASN1Object(byArray);
            X500Name x500Name = X500Name.getInstance(aSN1Primitive);
            TlsUtils.requireDEREncoding(x500Name, byArray);
            vector.addElement(x500Name);
        }
        return vector;
    }

    public static short[] readCertificateTypeExtensionClient(byte[] extensionData) throws IOException {
        short[] sArray = TlsUtils.decodeUint8ArrayWithUint8Length(extensionData);
        if (sArray.length < 1) {
            throw new TlsFatalAlert(50);
        }
        return sArray;
    }

    public static short readCertificateTypeExtensionServer(byte[] extensionData) throws IOException {
        return TlsUtils.decodeUint8(extensionData);
    }

    public static boolean readClientCertificateURLExtension(byte[] extensionData) throws IOException {
        return TlsExtensionsUtils.a(extensionData);
    }

    public static int[] readCompressCertificateExtension(byte[] extensionData) throws IOException {
        int[] nArray = TlsUtils.decodeUint16ArrayWithUint8Length(extensionData);
        if (nArray.length < 1) {
            throw new TlsFatalAlert(50);
        }
        return nArray;
    }

    public static byte[] readConnectionIDExtension(byte[] extensionData) throws IOException {
        return TlsUtils.decodeOpaque8(extensionData);
    }

    public static byte[] readCookieExtension(byte[] extensionData) throws IOException {
        return TlsUtils.decodeOpaque16(extensionData, 1);
    }

    public static boolean readEarlyDataIndication(byte[] extensionData) throws IOException {
        return TlsExtensionsUtils.a(extensionData);
    }

    public static long readEarlyDataMaxSize(byte[] extensionData) throws IOException {
        return TlsUtils.decodeUint32(extensionData);
    }

    public static boolean readEncryptThenMACExtension(byte[] extensionData) throws IOException {
        return TlsExtensionsUtils.a(extensionData);
    }

    public static boolean readExtendedMasterSecretExtension(byte[] extensionData) throws IOException {
        return TlsExtensionsUtils.a(extensionData);
    }

    public static HeartbeatExtension readHeartbeatExtension(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extensionData);
        HeartbeatExtension heartbeatExtension = HeartbeatExtension.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return heartbeatExtension;
    }

    public static Vector readKeyShareClientHello(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extensionData);
        int n2 = TlsUtils.readUint16(byteArrayInputStream);
        if (n2 != extensionData.length - 2) {
            throw new TlsFatalAlert(50);
        }
        Vector<KeyShareEntry> vector = new Vector<KeyShareEntry>();
        while (byteArrayInputStream.available() > 0) {
            KeyShareEntry keyShareEntry = KeyShareEntry.parse(byteArrayInputStream);
            vector.addElement(keyShareEntry);
        }
        return vector;
    }

    public static int readKeyShareHelloRetryRequest(byte[] extensionData) throws IOException {
        return TlsUtils.decodeUint16(extensionData);
    }

    public static KeyShareEntry readKeyShareServerHello(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extensionData);
        KeyShareEntry keyShareEntry = KeyShareEntry.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return keyShareEntry;
    }

    public static short readMaxFragmentLengthExtension(byte[] extensionData) throws IOException {
        return TlsUtils.decodeUint8(extensionData);
    }

    public static Hashtable readOIDFiltersExtension(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        if (extensionData.length < 2) {
            throw new TlsFatalAlert(50);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extensionData);
        int n2 = TlsUtils.readUint16(byteArrayInputStream);
        if (n2 != extensionData.length - 2) {
            throw new TlsFatalAlert(50);
        }
        Hashtable<ASN1ObjectIdentifier, byte[]> hashtable = new Hashtable<ASN1ObjectIdentifier, byte[]>();
        while (byteArrayInputStream.available() > 0) {
            byte[] byArray = TlsUtils.readOpaque8(byteArrayInputStream, 1);
            ASN1Primitive aSN1Primitive = TlsUtils.readASN1Object(byArray);
            ASN1ObjectIdentifier aSN1ObjectIdentifier = ASN1ObjectIdentifier.getInstance(aSN1Primitive);
            TlsUtils.requireDEREncoding(aSN1ObjectIdentifier, byArray);
            if (hashtable.containsKey(aSN1ObjectIdentifier)) {
                throw new TlsFatalAlert(47);
            }
            byte[] byArray2 = TlsUtils.readOpaque16(byteArrayInputStream);
            hashtable.put(aSN1ObjectIdentifier, byArray2);
        }
        return hashtable;
    }

    public static int readPaddingExtension(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        int n2 = 0;
        for (int i2 = 0; i2 < extensionData.length; ++i2) {
            n2 |= extensionData[i2];
        }
        if (n2 != 0) {
            throw new TlsFatalAlert(47);
        }
        return extensionData.length;
    }

    public static boolean readPostHandshakeAuthExtension(byte[] extensionData) throws IOException {
        return TlsExtensionsUtils.a(extensionData);
    }

    public static OfferedPsks readPreSharedKeyClientHello(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extensionData);
        OfferedPsks offeredPsks = OfferedPsks.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return offeredPsks;
    }

    public static int readPreSharedKeyServerHello(byte[] extensionData) throws IOException {
        return TlsUtils.decodeUint16(extensionData);
    }

    public static short[] readPSKKeyExchangeModesExtension(byte[] extensionData) throws IOException {
        short[] sArray = TlsUtils.decodeUint8ArrayWithUint8Length(extensionData);
        if (sArray.length < 1) {
            throw new TlsFatalAlert(50);
        }
        return sArray;
    }

    public static int readRecordSizeLimitExtension(byte[] extensionData) throws IOException {
        int n2 = TlsUtils.decodeUint16(extensionData);
        if (n2 < 64) {
            throw new TlsFatalAlert(47);
        }
        return n2;
    }

    public static Vector readServerNameExtensionClient(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extensionData);
        ServerNameList serverNameList = ServerNameList.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return serverNameList.getServerNameList();
    }

    public static boolean readServerNameExtensionServer(byte[] extensionData) throws IOException {
        return TlsExtensionsUtils.a(extensionData);
    }

    public static Vector readSignatureAlgorithmsExtension(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extensionData);
        Vector vector = TlsUtils.parseSupportedSignatureAlgorithms(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return vector;
    }

    public static Vector readSignatureAlgorithmsCertExtension(byte[] extensionData) throws IOException {
        return TlsExtensionsUtils.readSignatureAlgorithmsExtension(extensionData);
    }

    public static CertificateStatusRequest readStatusRequestExtension(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extensionData);
        CertificateStatusRequest certificateStatusRequest = CertificateStatusRequest.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return certificateStatusRequest;
    }

    public static Vector readStatusRequestV2Extension(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        if (extensionData.length < 3) {
            throw new TlsFatalAlert(50);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extensionData);
        int n2 = TlsUtils.readUint16(byteArrayInputStream);
        if (n2 != extensionData.length - 2) {
            throw new TlsFatalAlert(50);
        }
        Vector<CertificateStatusRequestItemV2> vector = new Vector<CertificateStatusRequestItemV2>();
        while (byteArrayInputStream.available() > 0) {
            CertificateStatusRequestItemV2 certificateStatusRequestItemV2 = CertificateStatusRequestItemV2.parse(byteArrayInputStream);
            vector.add(certificateStatusRequestItemV2);
        }
        return vector;
    }

    public static int[] readSupportedGroupsExtension(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extensionData);
        int n2 = TlsUtils.readUint16(byteArrayInputStream);
        if (n2 < 2 || (n2 & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        int[] nArray = TlsUtils.readUint16Array(n2 / 2, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return nArray;
    }

    public static short[] readSupportedPointFormatsExtension(byte[] extensionData) throws IOException {
        short[] sArray = TlsUtils.decodeUint8ArrayWithUint8Length(extensionData);
        if (!Arrays.contains(sArray, (short)0)) {
            throw new TlsFatalAlert(47);
        }
        return sArray;
    }

    public static ProtocolVersion[] readSupportedVersionsExtensionClient(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        if (extensionData.length < 3 || extensionData.length > 255 || (extensionData.length & 1) == 0) {
            throw new TlsFatalAlert(50);
        }
        short s2 = TlsUtils.readUint8(extensionData, 0);
        if (s2 != extensionData.length - 1) {
            throw new TlsFatalAlert(50);
        }
        int n2 = s2 / 2;
        ProtocolVersion[] protocolVersionArray = new ProtocolVersion[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            protocolVersionArray[i2] = TlsUtils.readVersion(extensionData, 1 + i2 * 2);
        }
        return protocolVersionArray;
    }

    public static ProtocolVersion readSupportedVersionsExtensionServer(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        if (extensionData.length != 2) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readVersion(extensionData, 0);
    }

    public static boolean readTruncatedHMacExtension(byte[] extensionData) throws IOException {
        return TlsExtensionsUtils.a(extensionData);
    }

    public static Vector readTrustedCAKeysExtensionClient(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        if (extensionData.length < 2) {
            throw new TlsFatalAlert(50);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extensionData);
        int n2 = TlsUtils.readUint16(byteArrayInputStream);
        if (n2 != extensionData.length - 2) {
            throw new TlsFatalAlert(50);
        }
        Vector<TrustedAuthority> vector = new Vector<TrustedAuthority>();
        while (byteArrayInputStream.available() > 0) {
            TrustedAuthority trustedAuthority = TrustedAuthority.parse(byteArrayInputStream);
            vector.addElement(trustedAuthority);
        }
        return vector;
    }

    public static boolean readTrustedCAKeysExtensionServer(byte[] extensionData) throws IOException {
        return TlsExtensionsUtils.a(extensionData);
    }

    private static byte[] a(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        int n2 = byteArrayOutputStream.size() - 2;
        TlsUtils.checkUint16(n2);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        TlsUtils.writeUint16(n2, byArray, 0);
        return byArray;
    }
}

