/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.ByteQueue;
import com.enterprisedt.bouncycastle.tls.ByteQueueInputStream;
import com.enterprisedt.bouncycastle.tls.ByteQueueOutputStream;
import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.DigitallySigned;
import com.enterprisedt.bouncycastle.tls.ExtensionType;
import com.enterprisedt.bouncycastle.tls.HandshakeMessageInput;
import com.enterprisedt.bouncycastle.tls.HandshakeType;
import com.enterprisedt.bouncycastle.tls.KeyUpdateRequest;
import com.enterprisedt.bouncycastle.tls.MaxFragmentLength;
import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.RecordPreview;
import com.enterprisedt.bouncycastle.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.tls.SessionParameters;
import com.enterprisedt.bouncycastle.tls.SupplementalDataEntry;
import com.enterprisedt.bouncycastle.tls.TlsCloseable;
import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsExtensionsUtils;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlertReceived;
import com.enterprisedt.bouncycastle.tls.TlsHandshakeHash;
import com.enterprisedt.bouncycastle.tls.TlsKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsNoCloseNotifyException;
import com.enterprisedt.bouncycastle.tls.TlsPeer;
import com.enterprisedt.bouncycastle.tls.TlsSession;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.a;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import com.enterprisedt.bouncycastle.tls.h;
import com.enterprisedt.bouncycastle.tls.j;
import com.enterprisedt.bouncycastle.tls.l;
import com.enterprisedt.bouncycastle.tls.p;
import com.enterprisedt.bouncycastle.tls.q;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Integers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class TlsProtocol
implements TlsCloseable {
    protected static final Integer EXT_RenegotiationInfo = Integers.valueOf(65281);
    protected static final Integer EXT_SessionTicket = Integers.valueOf(35);
    protected static final short CS_START = 0;
    protected static final short CS_CLIENT_HELLO = 1;
    protected static final short CS_SERVER_HELLO_RETRY_REQUEST = 2;
    protected static final short CS_CLIENT_HELLO_RETRY = 3;
    protected static final short CS_SERVER_HELLO = 4;
    protected static final short CS_SERVER_ENCRYPTED_EXTENSIONS = 5;
    protected static final short CS_SERVER_SUPPLEMENTAL_DATA = 6;
    protected static final short CS_SERVER_CERTIFICATE = 7;
    protected static final short CS_SERVER_CERTIFICATE_STATUS = 8;
    protected static final short CS_SERVER_CERTIFICATE_VERIFY = 9;
    protected static final short CS_SERVER_KEY_EXCHANGE = 10;
    protected static final short CS_SERVER_CERTIFICATE_REQUEST = 11;
    protected static final short CS_SERVER_HELLO_DONE = 12;
    protected static final short CS_CLIENT_END_OF_EARLY_DATA = 13;
    protected static final short CS_CLIENT_SUPPLEMENTAL_DATA = 14;
    protected static final short CS_CLIENT_CERTIFICATE = 15;
    protected static final short CS_CLIENT_KEY_EXCHANGE = 16;
    protected static final short CS_CLIENT_CERTIFICATE_VERIFY = 17;
    protected static final short CS_CLIENT_FINISHED = 18;
    protected static final short CS_SERVER_SESSION_TICKET = 19;
    protected static final short CS_SERVER_FINISHED = 20;
    protected static final short CS_END = 21;
    protected static final short ADS_MODE_1_Nsub1 = 0;
    protected static final short ADS_MODE_0_N = 1;
    protected static final short ADS_MODE_0_N_FIRSTONLY = 2;
    private ByteQueue a = new ByteQueue(0);
    private ByteQueue b = new ByteQueue(2);
    private ByteQueue f = new ByteQueue(0);
    final l c;
    final Object d = new Object();
    private int g = -1;
    TlsHandshakeHash e;
    private p h = null;
    private q i = null;
    private volatile boolean j = false;
    private volatile boolean k = false;
    private volatile boolean l = false;
    private volatile boolean m = true;
    private volatile boolean n = false;
    private volatile boolean o = false;
    private volatile boolean p = false;
    private volatile int q = 0;
    protected TlsSession tlsSession = null;
    protected SessionParameters sessionParameters = null;
    protected TlsSecret sessionMasterSecret = null;
    protected byte[] retryCookie = null;
    protected int retryGroup = -1;
    protected Hashtable clientExtensions = null;
    protected Hashtable serverExtensions = null;
    protected short connection_state = 0;
    protected boolean selectedPSK13 = false;
    protected boolean receivedChangeCipherSpec = false;
    protected boolean expectSessionTicket = false;
    protected boolean blocking;
    protected ByteQueueInputStream inputBuffers;
    protected ByteQueueOutputStream outputBuffer;

    protected boolean isLegacyConnectionState() {
        switch (this.connection_state) {
            case 0: 
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return true;
            }
        }
        return false;
    }

    protected boolean isTLSv13ConnectionState() {
        switch (this.connection_state) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                return true;
            }
        }
        return false;
    }

    protected TlsProtocol() {
        this.blocking = false;
        this.inputBuffers = new ByteQueueInputStream();
        this.outputBuffer = new ByteQueueOutputStream();
        this.c = new l(this, this.inputBuffers, this.outputBuffer);
    }

    protected TlsProtocol(InputStream input, OutputStream output) {
        this.blocking = true;
        this.c = new l(this, input, output);
    }

    public void resumeHandshake() throws IOException {
        if (!this.blocking) {
            throw new IllegalStateException("Cannot use resumeHandshake() in non-blocking mode!");
        }
        if (!this.isHandshaking()) {
            throw new IllegalStateException("No handshake in progress");
        }
        this.blockForHandshake();
    }

    protected void closeConnection() throws IOException {
        this.c.i();
    }

    protected abstract TlsContext getContext();

    abstract a a();

    protected abstract TlsPeer getPeer();

    protected int getRenegotiationPolicy() {
        return 0;
    }

    protected void handleAlertMessage(short alertLevel, short alertDescription) throws IOException {
        this.getPeer().notifyAlertReceived(alertLevel, alertDescription);
        if (alertLevel != 1) {
            this.handleFailure();
            throw new TlsFatalAlertReceived(alertDescription);
        }
        this.handleAlertWarningMessage(alertDescription);
    }

    protected void handleAlertWarningMessage(short alertDescription) throws IOException {
        switch (alertDescription) {
            case 0: {
                if (!this.l) {
                    throw new TlsFatalAlert(40);
                }
                this.handleClose(false);
                break;
            }
            case 41: {
                throw new TlsFatalAlert(10);
            }
            case 100: {
                throw new TlsFatalAlert(40);
            }
        }
    }

    protected void handleChangeCipherSpecMessage() throws IOException {
    }

    protected void handleClose(boolean user_canceled) throws IOException {
        if (!this.j) {
            this.j = true;
            if (!this.l) {
                this.cleanupHandshake();
                if (user_canceled) {
                    this.raiseAlertWarning((short)90, "User canceled handshake");
                }
            }
            this.raiseAlertWarning((short)0, "Connection closed");
            this.closeConnection();
            this.getPeer().notifyConnectionClosed();
        }
    }

    protected void handleException(short alertDescription, String message, Throwable e2) throws IOException {
        if ((this.l || this.isResumableHandshake()) && e2 instanceof InterruptedIOException) {
            return;
        }
        if (!this.j) {
            this.raiseAlertFatal(alertDescription, message, e2);
            this.handleFailure();
        }
    }

    protected void handleFailure() throws IOException {
        this.j = true;
        this.k = true;
        this.invalidateSession();
        if (!this.l) {
            this.cleanupHandshake();
        }
        this.closeConnection();
        this.getPeer().notifyConnectionClosed();
    }

    protected abstract void handleHandshakeMessage(short var1, HandshakeMessageInput var2) throws IOException;

    protected boolean handleRenegotiation() throws IOException {
        int n2 = 0;
        SecurityParameters securityParameters = this.getContext().getSecurityParametersConnection();
        if (null != securityParameters && securityParameters.isSecureRenegotiation() && (!securityParameters.isResumedSession() || securityParameters.isExtendedMasterSecret())) {
            Certificate certificate;
            Certificate certificate2 = certificate = 0 == securityParameters.getEntity() ? securityParameters.getLocalCertificate() : securityParameters.getPeerCertificate();
            if (null != certificate && !certificate.isEmpty()) {
                n2 = this.getRenegotiationPolicy();
            }
        }
        switch (n2) {
            case 2: {
                this.beginHandshake(true);
                return true;
            }
            case 1: {
                return false;
            }
        }
        this.refuseRenegotiation();
        return false;
    }

    protected void applyMaxFragmentLengthExtension(short maxFragmentLength) throws IOException {
        if (maxFragmentLength >= 0) {
            if (!MaxFragmentLength.isValid(maxFragmentLength)) {
                throw new TlsFatalAlert(80);
            }
            int n2 = 1 << 8 + maxFragmentLength;
            this.c.a(n2);
        }
    }

    protected void checkReceivedChangeCipherSpec(boolean expected) throws IOException {
        if (expected != this.receivedChangeCipherSpec) {
            throw new TlsFatalAlert(10);
        }
    }

    protected void blockForHandshake() throws IOException {
        while (this.connection_state != 21) {
            if (this.isClosed()) {
                throw new TlsFatalAlert(80);
            }
            this.safeReadRecord();
        }
    }

    protected void beginHandshake(boolean renegotiation) throws IOException {
        a a2 = this.a();
        TlsPeer tlsPeer = this.getPeer();
        this.g = Math.max(1024, tlsPeer.getMaxHandshakeMessageSize());
        this.e = new h(a2);
        this.connection_state = 0;
        this.selectedPSK13 = false;
        a2.a(tlsPeer);
        SecurityParameters securityParameters = a2.getSecurityParametersHandshake();
        if (renegotiation != securityParameters.isRenegotiating()) {
            throw new TlsFatalAlert(80);
        }
        securityParameters.E = tlsPeer.shouldUseExtendedPadding();
    }

    protected void cleanupHandshake() {
        SecurityParameters securityParameters;
        TlsContext tlsContext = this.getContext();
        if (null != tlsContext && null != (securityParameters = tlsContext.getSecurityParameters())) {
            securityParameters.a();
        }
        this.tlsSession = null;
        this.sessionParameters = null;
        this.sessionMasterSecret = null;
        this.retryCookie = null;
        this.retryGroup = -1;
        this.clientExtensions = null;
        this.serverExtensions = null;
        this.selectedPSK13 = false;
        this.receivedChangeCipherSpec = false;
        this.expectSessionTicket = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeHandshake() throws IOException {
        try {
            a a2 = this.a();
            SecurityParameters securityParameters = a2.getSecurityParametersHandshake();
            if (!a2.b() || null == securityParameters.getLocalVerifyData() || null == securityParameters.getPeerVerifyData()) {
                throw new TlsFatalAlert(80);
            }
            this.c.d();
            this.connection_state = (short)21;
            this.e = new h(a2);
            this.b.shrink();
            this.f.shrink();
            ProtocolVersion protocolVersion = securityParameters.getNegotiatedVersion();
            this.m = !TlsUtils.isTLSv11(protocolVersion);
            this.l = true;
            this.n = TlsUtils.isTLSv13(protocolVersion);
            if (this.blocking) {
                this.h = new p(this);
                this.i = new q(this);
            }
            if (this.sessionParameters == null) {
                this.sessionMasterSecret = securityParameters.getMasterSecret();
                this.sessionParameters = new SessionParameters.Builder().setCipherSuite(securityParameters.getCipherSuite()).setExtendedMasterSecret(securityParameters.isExtendedMasterSecret()).setLocalCertificate(securityParameters.getLocalCertificate()).setMasterSecret(a2.getCrypto().adoptSecret(this.sessionMasterSecret)).setNegotiatedVersion(securityParameters.getNegotiatedVersion()).setPeerCertificate(securityParameters.getPeerCertificate()).setPSKIdentity(securityParameters.getPSKIdentity()).setSRPIdentity(securityParameters.getSRPIdentity()).setServerExtensions(this.serverExtensions).build();
                this.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), this.sessionParameters);
            } else {
                securityParameters.R = this.sessionParameters.getLocalCertificate();
                securityParameters.S = this.sessionParameters.getPeerCertificate();
                securityParameters.y = this.sessionParameters.getPSKIdentity();
                securityParameters.z = this.sessionParameters.getSRPIdentity();
            }
            a2.a(this.getPeer(), this.tlsSession);
        }
        finally {
            this.cleanupHandshake();
        }
    }

    protected void processRecord(short protocol, byte[] buf, int off, int len) throws IOException {
        switch (protocol) {
            case 21: {
                this.b.addData(buf, off, len);
                this.d();
                break;
            }
            case 23: {
                if (!this.l) {
                    throw new TlsFatalAlert(10);
                }
                this.a.addData(buf, off, len);
                this.c();
                break;
            }
            case 20: {
                this.b(buf, off, len);
                break;
            }
            case 22: {
                if (this.f.available() > 0) {
                    this.f.addData(buf, off, len);
                    this.a(this.f);
                    break;
                }
                ByteQueue byteQueue = new ByteQueue(buf, off, len);
                this.a(byteQueue);
                int n2 = byteQueue.available();
                if (n2 <= 0) break;
                this.f.addData(buf, off + len - n2, n2);
                break;
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    private void a(ByteQueue byteQueue) throws IOException {
        while (byteQueue.available() >= 4) {
            Object object;
            int n2 = byteQueue.readInt32();
            short s2 = (short)(n2 >>> 24);
            if (!HandshakeType.isRecognized(s2)) {
                throw new TlsFatalAlert(10, "Handshake message of unrecognized type: " + s2);
            }
            int n3 = n2 & 0xFFFFFF;
            if (n3 > this.g) {
                throw new TlsFatalAlert(80, "Handshake message length exceeds the maximum: " + HandshakeType.getText(s2) + ", " + n3 + " > " + this.g);
            }
            int n4 = 4 + n3;
            if (byteQueue.available() < n4) break;
            switch (s2) {
                case 0: {
                    break;
                }
                default: {
                    object = this.getContext().getServerVersion();
                    if (null != object && TlsUtils.isTLSv13((ProtocolVersion)object)) break;
                    this.checkReceivedChangeCipherSpec(20 == s2);
                    break;
                }
            }
            object = byteQueue.a(n4);
            switch (s2) {
                case 0: 
                case 24: {
                    break;
                }
                case 4: {
                    ProtocolVersion protocolVersion = this.getContext().getServerVersion();
                    if (null == protocolVersion || TlsUtils.isTLSv13(protocolVersion)) break;
                    ((HandshakeMessageInput)object).updateHash(this.e);
                    break;
                }
                case 1: 
                case 2: 
                case 15: 
                case 20: {
                    break;
                }
                default: {
                    ((HandshakeMessageInput)object).updateHash(this.e);
                }
            }
            ((ByteArrayInputStream)object).skip(4L);
            this.handleHandshakeMessage(s2, (HandshakeMessageInput)object);
        }
    }

    private void c() {
    }

    private void d() throws IOException {
        while (this.b.available() >= 2) {
            byte[] byArray = this.b.removeData(2, 0);
            short s2 = byArray[0];
            short s3 = byArray[1];
            this.handleAlertMessage(s2, s3);
        }
    }

    private void b(byte[] byArray, int n2, int n3) throws IOException {
        ProtocolVersion protocolVersion = this.getContext().getServerVersion();
        if (null == protocolVersion || TlsUtils.isTLSv13(protocolVersion)) {
            throw new TlsFatalAlert(10);
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            short s2 = TlsUtils.readUint8(byArray, n2 + i2);
            if (s2 != 1) {
                throw new TlsFatalAlert(50);
            }
            if (this.receivedChangeCipherSpec || this.b.available() > 0 || this.f.available() > 0) {
                throw new TlsFatalAlert(10);
            }
            this.c.b();
            this.receivedChangeCipherSpec = true;
            this.handleChangeCipherSpecMessage();
        }
    }

    public int applicationDataAvailable() {
        return this.a.available();
    }

    public int readApplicationData(byte[] buf, int off, int len) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        int n2 = buf.length - off;
        int n3 = n2 - len;
        if ((off | len | n2 | n3) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.l) {
            throw new IllegalStateException("Cannot read application data until initial handshake completed.");
        }
        if (len < 1) {
            return 0;
        }
        while (this.a.available() < 1) {
            if (this.j) {
                if (this.k) {
                    throw new IOException("Cannot read application data on failed TLS connection");
                }
                return -1;
            }
            this.safeReadRecord();
        }
        len = Math.min(len, this.a.available());
        this.a.removeData(buf, off, len, 0);
        return len;
    }

    protected RecordPreview safePreviewRecordHeader(byte[] recordHeader) throws IOException {
        try {
            return this.c.a(recordHeader);
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.handleException(tlsFatalAlert.getAlertDescription(), "Failed to read record", tlsFatalAlert);
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.handleException((short)80, "Failed to read record", iOException);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.handleException((short)80, "Failed to read record", runtimeException);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
    }

    protected void safeReadRecord() throws IOException {
        try {
            if (this.c.h()) {
                return;
            }
            if (!this.l) {
                throw new TlsFatalAlert(40);
            }
            if (!this.getPeer().requiresCloseNotify()) {
                this.handleClose(false);
                return;
            }
        }
        catch (TlsFatalAlertReceived tlsFatalAlertReceived) {
            throw tlsFatalAlertReceived;
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.handleException(tlsFatalAlert.getAlertDescription(), "Failed to read record", tlsFatalAlert);
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.handleException((short)80, "Failed to read record", iOException);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.handleException((short)80, "Failed to read record", runtimeException);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
        this.handleFailure();
        throw new TlsNoCloseNotifyException();
    }

    protected boolean safeReadFullRecord(byte[] input, int inputOff, int inputLen) throws IOException {
        try {
            return this.c.a(input, inputOff, inputLen);
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.handleException(tlsFatalAlert.getAlertDescription(), "Failed to process record", tlsFatalAlert);
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.handleException((short)80, "Failed to process record", iOException);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.handleException((short)80, "Failed to process record", runtimeException);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
    }

    protected void safeWriteRecord(short type, byte[] buf, int offset, int len) throws IOException {
        try {
            this.c.a(type, buf, offset, len);
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.handleException(tlsFatalAlert.getAlertDescription(), "Failed to write record", tlsFatalAlert);
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.handleException((short)80, "Failed to write record", iOException);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.handleException((short)80, "Failed to write record", runtimeException);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeApplicationData(byte[] buf, int off, int len) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        int n2 = buf.length - off;
        int n3 = n2 - len;
        if ((off | len | n2 | n3) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.l) {
            throw new IllegalStateException("Cannot write application data until initial handshake completed.");
        }
        Object object = this.d;
        synchronized (object) {
            while (len > 0) {
                if (this.j) {
                    throw new IOException("Cannot write application data on closed/failed TLS connection");
                }
                if (this.m) {
                    switch (this.q) {
                        case 2: {
                            this.m = false;
                        }
                        case 1: {
                            this.safeWriteRecord((short)23, TlsUtils.EMPTY_BYTES, 0, 0);
                            break;
                        }
                        default: {
                            if (len > 1) {
                                this.safeWriteRecord((short)23, buf, off, 1);
                                ++off;
                                --len;
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                } else if (this.n) {
                    if (this.o) {
                        this.send13KeyUpdate(false);
                    } else if (this.c.e()) {
                        this.send13KeyUpdate(true);
                    }
                }
                n3 = Math.min(len, this.c.a());
                this.safeWriteRecord((short)23, buf, off, n3);
                off += n3;
                len -= n3;
            }
        }
    }

    public int getAppDataSplitMode() {
        return this.q;
    }

    public void setAppDataSplitMode(int appDataSplitMode) {
        if (appDataSplitMode < 0 || appDataSplitMode > 2) {
            throw new IllegalArgumentException("Illegal appDataSplitMode mode: " + appDataSplitMode);
        }
        this.q = appDataSplitMode;
    }

    public boolean isResumableHandshake() {
        return this.p;
    }

    public void setResumableHandshake(boolean resumableHandshake) {
        this.p = resumableHandshake;
    }

    void a(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (n3 < 4) {
            throw new TlsFatalAlert(80);
        }
        short s2 = TlsUtils.readUint8(byArray, n2);
        switch (s2) {
            case 0: 
            case 24: {
                break;
            }
            case 4: {
                ProtocolVersion protocolVersion = this.getContext().getServerVersion();
                if (null == protocolVersion || TlsUtils.isTLSv13(protocolVersion)) break;
                this.e.update(byArray, n2, n3);
                break;
            }
            case 1: {
                break;
            }
            default: {
                this.e.update(byArray, n2, n3);
            }
        }
        int n5 = 0;
        do {
            n4 = Math.min(n3 - n5, this.c.a());
            this.safeWriteRecord((short)22, byArray, n2 + n5, n4);
        } while ((n5 += n4) < n3);
    }

    public OutputStream getOutputStream() {
        if (!this.blocking) {
            throw new IllegalStateException("Cannot use OutputStream in non-blocking mode! Use offerOutput() instead.");
        }
        return this.i;
    }

    public InputStream getInputStream() {
        if (!this.blocking) {
            throw new IllegalStateException("Cannot use InputStream in non-blocking mode! Use offerInput() instead.");
        }
        return this.h;
    }

    public void closeInput() throws IOException {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use closeInput() in blocking mode!");
        }
        if (this.j) {
            return;
        }
        if (this.inputBuffers.available() > 0) {
            throw new EOFException();
        }
        if (!this.l) {
            throw new TlsFatalAlert(40);
        }
        if (!this.getPeer().requiresCloseNotify()) {
            this.handleClose(false);
            return;
        }
        this.handleFailure();
        throw new TlsNoCloseNotifyException();
    }

    public RecordPreview previewInputRecord(byte[] recordHeader) throws IOException {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use previewInputRecord() in blocking mode!");
        }
        if (this.inputBuffers.available() != 0) {
            throw new IllegalStateException("Can only use previewInputRecord() for record-aligned input.");
        }
        if (this.j) {
            throw new IOException("Connection is closed, cannot accept any more input");
        }
        return this.safePreviewRecordHeader(recordHeader);
    }

    public int previewOutputRecord() {
        int n2;
        int n3;
        if (this.blocking) {
            throw new IllegalStateException("Cannot use previewOutputRecord() in blocking mode!");
        }
        ByteQueue byteQueue = this.outputBuffer.getBuffer();
        int n4 = byteQueue.available();
        if (n4 < 1) {
            return 0;
        }
        if (n4 >= 5 && n4 >= (n3 = 5 + (n2 = byteQueue.readUint16(3)))) {
            return n3;
        }
        throw new IllegalStateException("Can only use previewOutputRecord() for record-aligned output.");
    }

    public RecordPreview previewOutputRecord(int applicationDataSize) throws IOException {
        if (!this.l) {
            throw new IllegalStateException("Cannot use previewOutputRecord() until initial handshake completed.");
        }
        if (this.blocking) {
            throw new IllegalStateException("Cannot use previewOutputRecord() in blocking mode!");
        }
        if (this.outputBuffer.getBuffer().available() != 0) {
            throw new IllegalStateException("Can only use previewOutputRecord() for record-aligned output.");
        }
        if (this.j) {
            throw new IOException("Connection is closed, cannot produce any more output");
        }
        if (applicationDataSize < 1) {
            return new RecordPreview(0, 0);
        }
        if (this.m) {
            switch (this.q) {
                case 1: 
                case 2: {
                    RecordPreview recordPreview = this.c.b(0);
                    RecordPreview recordPreview2 = this.c.b(applicationDataSize);
                    return RecordPreview.a(recordPreview, recordPreview2);
                }
            }
            RecordPreview recordPreview = this.c.b(1);
            if (applicationDataSize > 1) {
                RecordPreview recordPreview3 = this.c.b(applicationDataSize - 1);
                recordPreview = RecordPreview.a(recordPreview, recordPreview3);
            }
            return recordPreview;
        }
        RecordPreview recordPreview = this.c.b(applicationDataSize);
        if (this.n && (this.o || this.c.e())) {
            int n2 = com.enterprisedt.bouncycastle.tls.j.a(1);
            int n3 = this.c.c(n2);
            recordPreview = RecordPreview.a(recordPreview, n3);
        }
        return recordPreview;
    }

    public void offerInput(byte[] input) throws IOException {
        this.offerInput(input, 0, input.length);
    }

    public void offerInput(byte[] input, int inputOff, int inputLen) throws IOException {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use offerInput() in blocking mode! Use getInputStream() instead.");
        }
        if (this.j) {
            throw new IOException("Connection is closed, cannot accept any more input");
        }
        if (this.inputBuffers.available() == 0 && this.safeReadFullRecord(input, inputOff, inputLen)) {
            if (this.j && !this.l) {
                throw new TlsFatalAlert(80);
            }
            return;
        }
        this.inputBuffers.addBytes(input, inputOff, inputLen);
        while (this.inputBuffers.available() >= 5) {
            byte[] byArray = new byte[5];
            if (5 != this.inputBuffers.peek(byArray)) {
                throw new TlsFatalAlert(80);
            }
            RecordPreview recordPreview = this.safePreviewRecordHeader(byArray);
            if (this.inputBuffers.available() < recordPreview.getRecordSize()) break;
            this.safeReadRecord();
            if (!this.j) continue;
            if (this.l) break;
            throw new TlsFatalAlert(80);
        }
    }

    public int getApplicationDataLimit() {
        return this.c.a();
    }

    public int getAvailableInputBytes() {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use getAvailableInputBytes() in blocking mode! Use getInputStream().available() instead.");
        }
        return this.applicationDataAvailable();
    }

    public int readInput(byte[] buffer, int offset, int length) {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use readInput() in blocking mode! Use getInputStream() instead.");
        }
        if ((length = Math.min(length, this.a.available())) < 1) {
            return 0;
        }
        this.a.removeData(buffer, offset, length, 0);
        return length;
    }

    public int readInput(ByteBuffer buffer, int length) {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use readInput() in blocking mode! Use getInputStream() instead.");
        }
        if ((length = Math.min(length, this.a.available())) < 1) {
            return 0;
        }
        this.a.removeData(buffer, length, 0);
        return length;
    }

    public int getAvailableOutputBytes() {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use getAvailableOutputBytes() in blocking mode! Use getOutputStream() instead.");
        }
        return this.outputBuffer.getBuffer().available();
    }

    public int readOutput(byte[] buffer, int offset, int length) {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use readOutput() in blocking mode! Use getOutputStream() instead.");
        }
        int n2 = Math.min(this.getAvailableOutputBytes(), length);
        this.outputBuffer.getBuffer().removeData(buffer, offset, n2, 0);
        return n2;
    }

    public int readOutput(ByteBuffer buffer, int length) {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use readOutput() in blocking mode! Use getOutputStream() instead.");
        }
        int n2 = Math.min(this.getAvailableOutputBytes(), length);
        this.outputBuffer.getBuffer().removeData(buffer, n2, 0);
        return n2;
    }

    protected boolean establishSession(TlsSession sessionToResume) {
        this.tlsSession = null;
        this.sessionParameters = null;
        this.sessionMasterSecret = null;
        if (null == sessionToResume || !sessionToResume.isResumable()) {
            return false;
        }
        SessionParameters sessionParameters = sessionToResume.exportSessionParameters();
        if (null == sessionParameters) {
            return false;
        }
        ProtocolVersion protocolVersion = sessionParameters.getNegotiatedVersion();
        if (null == protocolVersion || !protocolVersion.isTLS()) {
            return false;
        }
        boolean bl = sessionParameters.isExtendedMasterSecret();
        if (protocolVersion.isSSL() ? bl : !TlsUtils.a(protocolVersion) && !bl) {
            return false;
        }
        TlsCrypto tlsCrypto = this.getContext().getCrypto();
        TlsSecret tlsSecret = TlsUtils.a(tlsCrypto, sessionParameters.getMasterSecret());
        if (null == tlsSecret) {
            return false;
        }
        this.tlsSession = sessionToResume;
        this.sessionParameters = sessionParameters;
        this.sessionMasterSecret = tlsSecret;
        return true;
    }

    protected void cancelSession() {
        if (this.sessionMasterSecret != null) {
            this.sessionMasterSecret.destroy();
            this.sessionMasterSecret = null;
        }
        if (this.sessionParameters != null) {
            this.sessionParameters.clear();
            this.sessionParameters = null;
        }
        this.tlsSession = null;
    }

    protected void invalidateSession() {
        if (this.tlsSession != null) {
            this.tlsSession.invalidate();
        }
        this.cancelSession();
    }

    protected void processFinishedMessage(ByteArrayInputStream buf) throws IOException {
        TlsContext tlsContext = this.getContext();
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        boolean bl = tlsContext.isServer();
        byte[] byArray = TlsUtils.readFully(securityParameters.getVerifyDataLength(), (InputStream)buf);
        TlsProtocol.assertEmpty(buf);
        byte[] byArray2 = TlsUtils.a(tlsContext, this.e, !bl);
        if (!Arrays.constantTimeAreEqual(byArray2, byArray)) {
            throw new TlsFatalAlert(51);
        }
        securityParameters.Y = byArray2;
        if ((!securityParameters.isResumedSession() || securityParameters.isExtendedMasterSecret()) && null == securityParameters.getLocalVerifyData()) {
            securityParameters.B = byArray2;
        }
    }

    protected void process13FinishedMessage(ByteArrayInputStream buf) throws IOException {
        TlsContext tlsContext = this.getContext();
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        boolean bl = tlsContext.isServer();
        byte[] byArray = TlsUtils.readFully(securityParameters.getVerifyDataLength(), (InputStream)buf);
        TlsProtocol.assertEmpty(buf);
        byte[] byArray2 = TlsUtils.a(tlsContext, this.e, !bl);
        if (!Arrays.constantTimeAreEqual(byArray2, byArray)) {
            throw new TlsFatalAlert(51);
        }
        securityParameters.Y = byArray2;
        securityParameters.B = null;
    }

    protected void raiseAlertFatal(short alertDescription, String message, Throwable cause) throws IOException {
        this.getPeer().notifyAlertRaised((short)2, alertDescription, message, cause);
        byte[] byArray = new byte[]{2, (byte)alertDescription};
        try {
            this.c.a((short)21, byArray, 0, 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void raiseAlertWarning(short alertDescription, String message) throws IOException {
        this.getPeer().notifyAlertRaised((short)1, alertDescription, message, null);
        byte[] byArray = new byte[]{1, (byte)alertDescription};
        this.safeWriteRecord((short)21, byArray, 0, 2);
    }

    protected void receive13KeyUpdate(ByteArrayInputStream buf) throws IOException {
        if (!this.l || !this.n) {
            throw new TlsFatalAlert(10);
        }
        short s2 = TlsUtils.readUint8(buf);
        TlsProtocol.assertEmpty(buf);
        if (!KeyUpdateRequest.isValid(s2)) {
            throw new TlsFatalAlert(47);
        }
        boolean bl = 1 == s2;
        TlsUtils.b(this.getContext());
        this.c.f();
        this.o |= bl;
    }

    protected void sendCertificateMessage(Certificate certificate, OutputStream endPointHash) throws IOException {
        TlsContext tlsContext = this.getContext();
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        if (null != securityParameters.getLocalCertificate()) {
            throw new TlsFatalAlert(80);
        }
        if (null == certificate) {
            certificate = Certificate.EMPTY_CHAIN;
        }
        if (certificate.isEmpty() && !tlsContext.isServer() && securityParameters.getNegotiatedVersion().isSSL()) {
            String string = "SSLv3 client didn't provide credentials";
            this.raiseAlertWarning((short)41, string);
        } else {
            j j2 = new j(11);
            certificate.encode(tlsContext, j2, endPointHash);
            j2.a(this);
        }
        securityParameters.R = certificate;
    }

    protected void send13CertificateMessage(Certificate certificate) throws IOException {
        if (null == certificate) {
            throw new TlsFatalAlert(80);
        }
        TlsContext tlsContext = this.getContext();
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        if (null != securityParameters.getLocalCertificate()) {
            throw new TlsFatalAlert(80);
        }
        j j2 = new j(11);
        certificate.encode(tlsContext, j2, null);
        j2.a(this);
        securityParameters.R = certificate;
    }

    protected void send13CertificateVerifyMessage(DigitallySigned certificateVerify) throws IOException {
        j j2 = new j(15);
        certificateVerify.encode(j2);
        j2.a(this);
    }

    protected void sendChangeCipherSpec() throws IOException {
        this.sendChangeCipherSpecMessage();
        this.c.c();
    }

    protected void sendChangeCipherSpecMessage() throws IOException {
        byte[] byArray = new byte[]{1};
        this.safeWriteRecord((short)20, byArray, 0, byArray.length);
    }

    protected void sendFinishedMessage() throws IOException {
        TlsContext tlsContext = this.getContext();
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        boolean bl = tlsContext.isServer();
        byte[] byArray = TlsUtils.a(tlsContext, this.e, bl);
        securityParameters.X = byArray;
        if ((!securityParameters.isResumedSession() || securityParameters.isExtendedMasterSecret()) && null == securityParameters.getPeerVerifyData()) {
            securityParameters.B = byArray;
        }
        com.enterprisedt.bouncycastle.tls.j.a(this, (short)20, byArray);
    }

    protected void send13FinishedMessage() throws IOException {
        TlsContext tlsContext = this.getContext();
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        boolean bl = tlsContext.isServer();
        byte[] byArray = TlsUtils.a(tlsContext, this.e, bl);
        securityParameters.X = byArray;
        securityParameters.B = null;
        com.enterprisedt.bouncycastle.tls.j.a(this, (short)20, byArray);
    }

    protected void send13KeyUpdate(boolean updateRequested) throws IOException {
        if (!this.l || !this.n) {
            throw new TlsFatalAlert(80);
        }
        short s2 = updateRequested ? (short)1 : 0;
        com.enterprisedt.bouncycastle.tls.j.a(this, (short)24, TlsUtils.encodeUint8(s2));
        TlsUtils.a(this.getContext());
        this.c.g();
        this.o &= updateRequested;
    }

    protected void sendSupplementalDataMessage(Vector supplementalData) throws IOException {
        j j2 = new j(23);
        TlsProtocol.writeSupplementalData(j2, supplementalData);
        j2.a(this);
    }

    @Override
    public void close() throws IOException {
        this.handleClose(true);
    }

    public void flush() throws IOException {
    }

    boolean b() {
        return this.l;
    }

    public boolean isClosed() {
        return this.j;
    }

    public boolean isConnected() {
        if (this.j) {
            return false;
        }
        a a2 = this.a();
        return null != a2 && a2.a();
    }

    public boolean isHandshaking() {
        if (this.j) {
            return false;
        }
        a a2 = this.a();
        return null != a2 && a2.b();
    }

    protected short processMaxFragmentLengthExtension(Hashtable clientExtensions, Hashtable serverExtensions, short alertDescription) throws IOException {
        return TlsUtils.a(clientExtensions, serverExtensions, alertDescription);
    }

    protected void refuseRenegotiation() throws IOException {
        if (TlsUtils.isSSL(this.getContext())) {
            throw new TlsFatalAlert(40);
        }
        this.raiseAlertWarning((short)100, "Renegotiation not supported");
    }

    protected static void assertEmpty(ByteArrayInputStream buf) throws IOException {
        if (buf.available() > 0) {
            throw new TlsFatalAlert(50);
        }
    }

    protected static byte[] createRandomBlock(boolean useGMTUnixTime, TlsContext context) {
        byte[] byArray = context.getNonceGenerator().generateNonce(32);
        if (useGMTUnixTime) {
            TlsUtils.writeGMTUnixTime(byArray, 0);
        }
        return byArray;
    }

    protected static byte[] createRenegotiationInfo(byte[] renegotiated_connection) throws IOException {
        return TlsUtils.encodeOpaque8(renegotiated_connection);
    }

    protected static void establishMasterSecret(TlsContext context, TlsKeyExchange keyExchange) throws IOException {
        TlsSecret tlsSecret = keyExchange.generatePreMasterSecret();
        if (tlsSecret == null) {
            throw new TlsFatalAlert(80);
        }
        try {
            context.getSecurityParametersHandshake().r = TlsUtils.a(context, tlsSecret);
        }
        finally {
            tlsSecret.destroy();
        }
    }

    protected static Hashtable readExtensions(ByteArrayInputStream input) throws IOException {
        if (input.available() < 1) {
            return null;
        }
        byte[] byArray = TlsUtils.readOpaque16(input);
        TlsProtocol.assertEmpty(input);
        return TlsProtocol.readExtensionsData(byArray);
    }

    protected static Hashtable readExtensionsData(byte[] extBytes) throws IOException {
        Hashtable<Integer, byte[]> hashtable = new Hashtable<Integer, byte[]>();
        if (extBytes.length > 0) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extBytes);
            do {
                int n2 = TlsUtils.readUint16(byteArrayInputStream);
                byte[] byArray = TlsUtils.readOpaque16(byteArrayInputStream);
                if (null == hashtable.put(Integers.valueOf(n2), byArray)) continue;
                throw new TlsFatalAlert(47, "Repeated extension: " + ExtensionType.getText(n2));
            } while (byteArrayInputStream.available() > 0);
        }
        return hashtable;
    }

    protected static Hashtable readExtensionsData13(int handshakeType, byte[] extBytes) throws IOException {
        Hashtable<Integer, byte[]> hashtable = new Hashtable<Integer, byte[]>();
        if (extBytes.length > 0) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extBytes);
            do {
                int n2;
                if (!TlsUtils.a(handshakeType, n2 = TlsUtils.readUint16(byteArrayInputStream))) {
                    throw new TlsFatalAlert(47, "Invalid extension: " + ExtensionType.getText(n2));
                }
                byte[] byArray = TlsUtils.readOpaque16(byteArrayInputStream);
                if (null == hashtable.put(Integers.valueOf(n2), byArray)) continue;
                throw new TlsFatalAlert(47, "Repeated extension: " + ExtensionType.getText(n2));
            } while (byteArrayInputStream.available() > 0);
        }
        return hashtable;
    }

    protected static Hashtable readExtensionsDataClientHello(byte[] extBytes) throws IOException {
        Hashtable<Integer, byte[]> hashtable = new Hashtable<Integer, byte[]>();
        if (extBytes.length > 0) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extBytes);
            int n2 = -1;
            boolean bl = false;
            do {
                n2 = TlsUtils.readUint16(byteArrayInputStream);
                byte[] byArray = TlsUtils.readOpaque16(byteArrayInputStream);
                if (null != hashtable.put(Integers.valueOf(n2), byArray)) {
                    throw new TlsFatalAlert(47, "Repeated extension: " + ExtensionType.getText(n2));
                }
                bl |= 41 == n2;
            } while (byteArrayInputStream.available() > 0);
            if (bl && 41 != n2) {
                throw new TlsFatalAlert(47, "'pre_shared_key' MUST be last in ClientHello");
            }
        }
        return hashtable;
    }

    protected static Vector readSupplementalDataMessage(ByteArrayInputStream input) throws IOException {
        byte[] byArray = TlsUtils.readOpaque24(input, 1);
        TlsProtocol.assertEmpty(input);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Vector<SupplementalDataEntry> vector = new Vector<SupplementalDataEntry>();
        while (byteArrayInputStream.available() > 0) {
            int n2 = TlsUtils.readUint16(byteArrayInputStream);
            byte[] byArray2 = TlsUtils.readOpaque16(byteArrayInputStream);
            vector.addElement(new SupplementalDataEntry(n2, byArray2));
        }
        return vector;
    }

    protected static void writeExtensions(OutputStream output, Hashtable extensions) throws IOException {
        TlsProtocol.writeExtensions(output, extensions, 0);
    }

    protected static void writeExtensions(OutputStream output, Hashtable extensions, int bindersSize) throws IOException {
        if (null == extensions || extensions.isEmpty()) {
            return;
        }
        byte[] byArray = TlsProtocol.writeExtensionsData(extensions, bindersSize);
        int n2 = byArray.length + bindersSize;
        TlsUtils.checkUint16(n2);
        TlsUtils.writeUint16(n2, output);
        output.write(byArray);
    }

    protected static byte[] writeExtensionsData(Hashtable extensions) throws IOException {
        return TlsProtocol.writeExtensionsData(extensions, 0);
    }

    protected static byte[] writeExtensionsData(Hashtable extensions, int bindersSize) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsProtocol.writeExtensionsData(extensions, bindersSize, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected static void writeExtensionsData(Hashtable extensions, int bindersSize, ByteArrayOutputStream buf) throws IOException {
        TlsProtocol.writeSelectedExtensions(buf, extensions, true);
        TlsProtocol.writeSelectedExtensions(buf, extensions, false);
        TlsProtocol.writePreSharedKeyExtension(buf, extensions, bindersSize);
    }

    protected static void writePreSharedKeyExtension(OutputStream output, Hashtable extensions, int bindersSize) throws IOException {
        byte[] byArray = (byte[])extensions.get(TlsExtensionsUtils.EXT_pre_shared_key);
        if (null != byArray) {
            TlsUtils.checkUint16(41);
            TlsUtils.writeUint16(41, output);
            int n2 = byArray.length + bindersSize;
            TlsUtils.checkUint16(n2);
            TlsUtils.writeUint16(n2, output);
            output.write(byArray);
        }
    }

    protected static void writeSelectedExtensions(OutputStream output, Hashtable extensions, boolean selectEmpty) throws IOException {
        Enumeration enumeration = extensions.keys();
        while (enumeration.hasMoreElements()) {
            byte[] byArray;
            Integer n2 = (Integer)enumeration.nextElement();
            int n3 = n2;
            if (41 == n3 || selectEmpty != ((byArray = (byte[])extensions.get(n2)).length == 0)) continue;
            TlsUtils.checkUint16(n3);
            TlsUtils.writeUint16(n3, output);
            TlsUtils.writeOpaque16(byArray, output);
        }
    }

    protected static void writeSupplementalData(OutputStream output, Vector supplementalData) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < supplementalData.size(); ++i2) {
            SupplementalDataEntry supplementalDataEntry = (SupplementalDataEntry)supplementalData.elementAt(i2);
            int n2 = supplementalDataEntry.getDataType();
            TlsUtils.checkUint16(n2);
            TlsUtils.writeUint16(n2, byteArrayOutputStream);
            TlsUtils.writeOpaque16(supplementalDataEntry.getData(), byteArrayOutputStream);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        TlsUtils.writeOpaque24(byArray, output);
    }
}

