/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.CertificateRequest;
import com.enterprisedt.bouncycastle.tls.CertificateStatus;
import com.enterprisedt.bouncycastle.tls.CertificateVerify;
import com.enterprisedt.bouncycastle.tls.ClientHello;
import com.enterprisedt.bouncycastle.tls.DigitallySigned;
import com.enterprisedt.bouncycastle.tls.HandshakeMessageInput;
import com.enterprisedt.bouncycastle.tls.KeyExchangeAlgorithm;
import com.enterprisedt.bouncycastle.tls.KeyShareEntry;
import com.enterprisedt.bouncycastle.tls.NamedGroup;
import com.enterprisedt.bouncycastle.tls.NewSessionTicket;
import com.enterprisedt.bouncycastle.tls.OfferedPsks;
import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.tls.ServerHello;
import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsCredentialedSigner;
import com.enterprisedt.bouncycastle.tls.TlsCredentials;
import com.enterprisedt.bouncycastle.tls.TlsExtensionsUtils;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsPeer;
import com.enterprisedt.bouncycastle.tls.TlsProtocol;
import com.enterprisedt.bouncycastle.tls.TlsServer;
import com.enterprisedt.bouncycastle.tls.TlsServerContext;
import com.enterprisedt.bouncycastle.tls.TlsSession;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.a;
import com.enterprisedt.bouncycastle.tls.crypto.TlsAgreement;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.TlsDHConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsECConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import com.enterprisedt.bouncycastle.tls.j;
import com.enterprisedt.bouncycastle.tls.s;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;

public class TlsServerProtocol
extends TlsProtocol {
    protected TlsServer tlsServer = null;
    s a = null;
    protected int[] offeredCipherSuites = null;
    protected TlsKeyExchange keyExchange = null;
    protected CertificateRequest certificateRequest = null;

    public TlsServerProtocol() {
    }

    public TlsServerProtocol(InputStream input, OutputStream output) {
        super(input, output);
    }

    public void accept(TlsServer tlsServer) throws IOException {
        if (tlsServer == null) {
            throw new IllegalArgumentException("'tlsServer' cannot be null");
        }
        if (this.tlsServer != null) {
            throw new IllegalStateException("'accept' can only be called once");
        }
        this.tlsServer = tlsServer;
        this.a = new s(tlsServer.getCrypto());
        tlsServer.init(this.a);
        tlsServer.notifyCloseHandle(this);
        this.beginHandshake(false);
        if (this.blocking) {
            this.blockForHandshake();
        }
    }

    @Override
    protected void cleanupHandshake() {
        super.cleanupHandshake();
        this.offeredCipherSuites = null;
        this.keyExchange = null;
        this.certificateRequest = null;
    }

    protected boolean expectCertificateVerifyMessage() {
        if (null == this.certificateRequest) {
            return false;
        }
        Certificate certificate = this.a.getSecurityParametersHandshake().getPeerCertificate();
        return null != certificate && !certificate.isEmpty() && (null == this.keyExchange || this.keyExchange.requiresCertificateVerify());
    }

    protected ServerHello generate13HelloRetryRequest(ClientHello clientHello) throws IOException {
        if (this.retryGroup < 0) {
            throw new TlsFatalAlert(80);
        }
        SecurityParameters securityParameters = this.a.getSecurityParametersHandshake();
        ProtocolVersion protocolVersion = securityParameters.getNegotiatedVersion();
        Hashtable hashtable = new Hashtable();
        TlsExtensionsUtils.addSupportedVersionsExtensionServer(hashtable, protocolVersion);
        if (this.retryGroup >= 0) {
            TlsExtensionsUtils.addKeyShareHelloRetryRequest(hashtable, this.retryGroup);
        }
        if (null != this.retryCookie) {
            TlsExtensionsUtils.addCookieExtension(hashtable, this.retryCookie);
        }
        TlsUtils.a(hashtable, 6, (short)80);
        return new ServerHello(clientHello.getSessionID(), securityParameters.getCipherSuite(), hashtable);
    }

    protected ServerHello generate13ServerHello(ClientHello clientHello, HandshakeMessageInput clientHelloMessage, boolean afterHelloRetryRequest) throws IOException {
        TlsAgreement tlsAgreement;
        int n2;
        Object object;
        Object object2;
        SecurityParameters securityParameters = this.a.getSecurityParametersHandshake();
        if (securityParameters.isRenegotiating()) {
            throw new TlsFatalAlert(80);
        }
        byte[] byArray = clientHello.getSessionID();
        Hashtable hashtable = clientHello.getExtensions();
        if (null == hashtable) {
            throw new TlsFatalAlert(109);
        }
        ProtocolVersion protocolVersion = securityParameters.getNegotiatedVersion();
        TlsCrypto tlsCrypto = this.a.getCrypto();
        OfferedPsks.b b2 = TlsUtils.a(this.a, this.tlsServer, hashtable, clientHelloMessage, this.e, afterHelloRetryRequest);
        Vector vector = TlsExtensionsUtils.getKeyShareClientHello(hashtable);
        KeyShareEntry keyShareEntry = null;
        if (afterHelloRetryRequest) {
            if (this.retryGroup < 0) {
                throw new TlsFatalAlert(80);
            }
            if (null == b2) {
                if (null == securityParameters.getClientSigAlgs()) {
                    throw new TlsFatalAlert(109);
                }
            } else if (b2.b.getPRFAlgorithm() != securityParameters.getPRFAlgorithm()) {
                throw new TlsFatalAlert(47);
            }
            if (!Arrays.areEqual(this.retryCookie, object2 = TlsExtensionsUtils.getCookieExtension(hashtable))) {
                throw new TlsFatalAlert(47);
            }
            this.retryCookie = null;
            keyShareEntry = TlsUtils.a(vector, this.retryGroup);
            if (null == keyShareEntry) {
                throw new TlsFatalAlert(47);
            }
        } else {
            securityParameters.v = TlsServerProtocol.createRandomBlock(false, this.a);
            if (!protocolVersion.equals(ProtocolVersion.getLatestTLS(this.tlsServer.getProtocolVersions()))) {
                TlsUtils.b(protocolVersion, securityParameters.getServerRandom());
            }
            this.clientExtensions = hashtable;
            securityParameters.d = false;
            TlsExtensionsUtils.getPaddingExtension(hashtable);
            securityParameters.J = TlsExtensionsUtils.getServerNameExtensionClient(hashtable);
            TlsUtils.a(securityParameters, hashtable);
            if (null == b2 && null == securityParameters.getClientSigAlgs()) {
                throw new TlsFatalAlert(109);
            }
            this.tlsServer.processClientExtensions(hashtable);
            securityParameters.b = false;
            this.tlsSession = TlsUtils.importSession(TlsUtils.EMPTY_BYTES, null);
            this.sessionParameters = null;
            this.sessionMasterSecret = null;
            securityParameters.x = this.tlsSession.getSessionID();
            this.tlsServer.notifySession(this.tlsSession);
            TlsUtils.b(this.a);
            int n3 = this.tlsServer.getSelectedCipherSuite();
            if (!TlsUtils.a(this.offeredCipherSuites, n3) || !TlsUtils.isValidVersionForCipherSuite(n3, protocolVersion)) {
                throw new TlsFatalAlert(80);
            }
            TlsUtils.b(securityParameters, n3);
            object2 = securityParameters.getClientSupportedGroups();
            object = securityParameters.getServerSupportedGroups();
            keyShareEntry = TlsUtils.a(tlsCrypto, protocolVersion, vector, (int[])object2, (int[])object);
            if (null == keyShareEntry) {
                this.retryGroup = TlsUtils.a(tlsCrypto, protocolVersion, (int[])object2, (int[])object);
                if (this.retryGroup < 0) {
                    throw new TlsFatalAlert(40);
                }
                this.retryCookie = this.a.getNonceGenerator().generateNonce(16);
                return this.generate13HelloRetryRequest(clientHello);
            }
            if (keyShareEntry.getNamedGroup() != object[0]) {
                // empty if block
            }
        }
        object2 = new Hashtable();
        object = TlsExtensionsUtils.ensureExtensionsInitialised(this.tlsServer.getServerExtensions());
        this.tlsServer.getServerExtensionsForConnection((Hashtable)object);
        ProtocolVersion protocolVersion2 = ProtocolVersion.TLSv12;
        TlsExtensionsUtils.addSupportedVersionsExtensionServer((Hashtable)object2, protocolVersion);
        securityParameters.D = true;
        securityParameters.G = TlsExtensionsUtils.getALPNExtensionServer((Hashtable)object);
        securityParameters.H = true;
        if (!((Hashtable)object).isEmpty()) {
            securityParameters.f = TlsUtils.a(securityParameters.isResumedSession() ? null : hashtable, (Hashtable)object, (short)80);
            if (!securityParameters.isResumedSession()) {
                securityParameters.V = TlsUtils.c(hashtable, (Hashtable)object, (short)80);
                securityParameters.W = TlsUtils.e(hashtable, (Hashtable)object, (short)80);
            }
        }
        securityParameters.C = false;
        securityParameters.F = false;
        securityParameters.U = hashtable.containsKey(TlsExtensionsUtils.EXT_status_request) ? 1 : 0;
        this.expectSessionTicket = false;
        TlsSecret tlsSecret = null;
        if (null != b2) {
            tlsSecret = b2.d;
            this.selectedPSK13 = true;
            TlsExtensionsUtils.addPreSharedKeyServerHello((Hashtable)object2, b2.a);
        }
        if (NamedGroup.refersToASpecificCurve(n2 = keyShareEntry.getNamedGroup())) {
            tlsAgreement = tlsCrypto.createECDomain(new TlsECConfig(n2)).createECDH();
        } else if (NamedGroup.refersToASpecificFiniteField(n2)) {
            tlsAgreement = tlsCrypto.createDHDomain(new TlsDHConfig(n2, true)).createDH();
        } else {
            throw new TlsFatalAlert(80);
        }
        byte[] byArray2 = tlsAgreement.generateEphemeral();
        KeyShareEntry keyShareEntry2 = new KeyShareEntry(n2, byArray2);
        TlsExtensionsUtils.addKeyShareServerHello((Hashtable)object2, keyShareEntry2);
        tlsAgreement.receivePeerValue(keyShareEntry.getKeyExchange());
        TlsSecret tlsSecret2 = tlsAgreement.calculateSecret();
        TlsUtils.a((TlsContext)this.a, tlsSecret, tlsSecret2);
        this.serverExtensions = object;
        this.applyMaxFragmentLengthExtension(securityParameters.getMaxFragmentLength());
        TlsUtils.a((Hashtable)object2, 2, (short)80);
        return new ServerHello(protocolVersion2, securityParameters.getServerRandom(), byArray, securityParameters.getCipherSuite(), (Hashtable)object2);
    }

    protected ServerHello generateServerHello(ClientHello clientHello, HandshakeMessageInput clientHelloMessage) throws IOException {
        int n2;
        boolean bl;
        Object object;
        ProtocolVersion protocolVersion;
        ProtocolVersion protocolVersion2 = clientHello.getVersion();
        if (!protocolVersion2.isTLS()) {
            throw new TlsFatalAlert(47);
        }
        this.offeredCipherSuites = clientHello.getCipherSuites();
        SecurityParameters securityParameters = this.a.getSecurityParametersHandshake();
        this.a.a(TlsExtensionsUtils.getSupportedVersionsExtensionClient(clientHello.getExtensions()));
        ProtocolVersion protocolVersion3 = protocolVersion2;
        if (null == this.a.getClientSupportedVersions()) {
            if (protocolVersion3.isLaterVersionOf(ProtocolVersion.TLSv12)) {
                protocolVersion3 = ProtocolVersion.TLSv12;
            }
            this.a.a(protocolVersion3.downTo(ProtocolVersion.SSLv3));
        } else {
            protocolVersion3 = ProtocolVersion.getLatestTLS(this.a.getClientSupportedVersions());
        }
        this.c.a(protocolVersion3);
        if (!ProtocolVersion.f.isEqualOrEarlierVersionOf(protocolVersion3)) {
            throw new TlsFatalAlert(70);
        }
        if (securityParameters.isRenegotiating()) {
            if (!protocolVersion3.equals(this.a.getClientVersion()) && !protocolVersion3.equals(this.a.getServerVersion())) {
                throw new TlsFatalAlert(47);
            }
        } else {
            this.a.a(protocolVersion3);
        }
        this.tlsServer.notifyClientVersion(this.a.getClientVersion());
        securityParameters.u = clientHello.getRandom();
        this.tlsServer.notifyFallback(Arrays.contains(this.offeredCipherSuites, 22016));
        this.tlsServer.notifyOfferedCipherSuites(this.offeredCipherSuites);
        if (securityParameters.isRenegotiating()) {
            protocolVersion = this.a.getServerVersion();
        } else {
            protocolVersion = this.tlsServer.getServerVersion();
            if (!ProtocolVersion.contains(this.a.getClientSupportedVersions(), protocolVersion)) {
                throw new TlsFatalAlert(80);
            }
            securityParameters.T = protocolVersion;
        }
        securityParameters.M = TlsExtensionsUtils.getSupportedGroupsExtension(clientHello.getExtensions());
        securityParameters.P = this.tlsServer.getSupportedGroups();
        if (ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(protocolVersion)) {
            this.c.a(true);
            this.c.a(ProtocolVersion.TLSv12);
            return this.generate13ServerHello(clientHello, clientHelloMessage, false);
        }
        this.c.a(protocolVersion);
        boolean bl2 = this.tlsServer.shouldUseGMTUnixTime();
        securityParameters.v = TlsServerProtocol.createRandomBlock(bl2, this.a);
        if (!protocolVersion.equals(ProtocolVersion.getLatestTLS(this.tlsServer.getProtocolVersions()))) {
            TlsUtils.b(protocolVersion, securityParameters.getServerRandom());
        }
        this.clientExtensions = clientHello.getExtensions();
        byte[] byArray = TlsUtils.getExtensionData(this.clientExtensions, EXT_RenegotiationInfo);
        if (securityParameters.isRenegotiating()) {
            if (!securityParameters.isSecureRenegotiation()) {
                throw new TlsFatalAlert(80);
            }
            if (Arrays.contains(this.offeredCipherSuites, 255)) {
                throw new TlsFatalAlert(40);
            }
            if (null == byArray) {
                throw new TlsFatalAlert(40);
            }
            object = this.a.getSecurityParametersConnection();
            byte[] byArray2 = ((SecurityParameters)object).getPeerVerifyData();
            if (!Arrays.constantTimeAreEqual(byArray, TlsServerProtocol.createRenegotiationInfo(byArray2))) {
                throw new TlsFatalAlert(40);
            }
        } else {
            if (Arrays.contains(this.offeredCipherSuites, 255)) {
                securityParameters.d = true;
            }
            if (byArray != null) {
                securityParameters.d = true;
                if (!Arrays.constantTimeAreEqual(byArray, TlsServerProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                    throw new TlsFatalAlert(40);
                }
            }
        }
        this.tlsServer.notifySecureRenegotiation(securityParameters.isSecureRenegotiation());
        if (this.clientExtensions != null) {
            TlsExtensionsUtils.getPaddingExtension(this.clientExtensions);
            securityParameters.J = TlsExtensionsUtils.getServerNameExtensionClient(this.clientExtensions);
            if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(protocolVersion3)) {
                TlsUtils.a(securityParameters, this.clientExtensions);
            }
            securityParameters.M = TlsExtensionsUtils.getSupportedGroupsExtension(this.clientExtensions);
            this.tlsServer.processClientExtensions(this.clientExtensions);
        }
        if ((bl = this.establishSession((TlsSession)(object = this.tlsServer.getSessionToResume(clientHello.getSessionID())))) && !protocolVersion.equals(this.sessionParameters.getNegotiatedVersion())) {
            bl = false;
        }
        boolean bl3 = false;
        if (TlsUtils.a(protocolVersion) && this.tlsServer.shouldUseExtendedMasterSecret()) {
            if (TlsExtensionsUtils.hasExtendedMasterSecretExtension(this.clientExtensions)) {
                bl3 = true;
            } else {
                if (this.tlsServer.requiresExtendedMasterSecret()) {
                    throw new TlsFatalAlert(40, "Extended Master Secret extension is required");
                }
                if (bl) {
                    if (this.sessionParameters.isExtendedMasterSecret()) {
                        throw new TlsFatalAlert(40, "Extended Master Secret extension is required for EMS session resumption");
                    }
                    if (!this.tlsServer.allowLegacyResumption()) {
                        throw new TlsFatalAlert(40, "Extended Master Secret extension is required for legacy session resumption");
                    }
                }
            }
        }
        if (bl && bl3 != this.sessionParameters.isExtendedMasterSecret()) {
            bl = false;
        }
        securityParameters.D = bl3;
        if (!bl) {
            this.cancelSession();
            byte[] byArray3 = this.tlsServer.getNewSessionID();
            if (null == byArray3) {
                byArray3 = TlsUtils.EMPTY_BYTES;
            }
            this.tlsSession = TlsUtils.importSession(byArray3, null);
        }
        securityParameters.b = bl;
        securityParameters.x = this.tlsSession.getSessionID();
        this.tlsServer.notifySession(this.tlsSession);
        TlsUtils.b(this.a);
        int n3 = n2 = bl ? this.sessionParameters.getCipherSuite() : this.tlsServer.getSelectedCipherSuite();
        if (!TlsUtils.a(this.offeredCipherSuites, n2) || !TlsUtils.isValidVersionForCipherSuite(n2, protocolVersion)) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.b(securityParameters, n2);
        this.a.b(protocolVersion2);
        Object object2 = bl ? this.sessionParameters.readServerExtensions() : this.tlsServer.getServerExtensions();
        this.serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised((Hashtable)object2);
        this.tlsServer.getServerExtensionsForConnection(this.serverExtensions);
        if (securityParameters.isRenegotiating()) {
            if (!securityParameters.isSecureRenegotiation()) {
                throw new TlsFatalAlert(80);
            }
            object2 = this.a.getSecurityParametersConnection();
            byte[] byArray4 = TlsUtils.a(((SecurityParameters)object2).getPeerVerifyData(), ((SecurityParameters)object2).getLocalVerifyData());
            this.serverExtensions.put(EXT_RenegotiationInfo, TlsServerProtocol.createRenegotiationInfo(byArray4));
        } else if (securityParameters.isSecureRenegotiation()) {
            boolean bl4;
            object2 = TlsUtils.getExtensionData(this.serverExtensions, EXT_RenegotiationInfo);
            boolean bl5 = bl4 = null == object2;
            if (bl4) {
                this.serverExtensions.put(EXT_RenegotiationInfo, TlsServerProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES));
            }
        }
        if (securityParameters.isExtendedMasterSecret()) {
            TlsExtensionsUtils.addExtendedMasterSecretExtension(this.serverExtensions);
        } else {
            this.serverExtensions.remove(TlsExtensionsUtils.EXT_extended_master_secret);
        }
        securityParameters.G = TlsExtensionsUtils.getALPNExtensionServer(this.serverExtensions);
        securityParameters.H = true;
        if (!this.serverExtensions.isEmpty()) {
            securityParameters.C = TlsExtensionsUtils.hasEncryptThenMACExtension(this.serverExtensions);
            securityParameters.f = TlsUtils.a(bl ? null : this.clientExtensions, this.serverExtensions, (short)80);
            securityParameters.F = TlsExtensionsUtils.hasTruncatedHMacExtension(this.serverExtensions);
            if (!bl) {
                if (TlsUtils.hasExpectedEmptyExtensionData(this.serverExtensions, TlsExtensionsUtils.EXT_status_request_v2, (short)80)) {
                    securityParameters.U = 2;
                } else if (TlsUtils.hasExpectedEmptyExtensionData(this.serverExtensions, TlsExtensionsUtils.EXT_status_request, (short)80)) {
                    securityParameters.U = 1;
                }
                securityParameters.V = TlsUtils.b(this.clientExtensions, this.serverExtensions, (short)80);
                securityParameters.W = TlsUtils.d(this.clientExtensions, this.serverExtensions, (short)80);
                this.expectSessionTicket = TlsUtils.hasExpectedEmptyExtensionData(this.serverExtensions, TlsProtocol.EXT_SessionTicket, (short)80);
            }
        }
        this.applyMaxFragmentLengthExtension(securityParameters.getMaxFragmentLength());
        return new ServerHello(protocolVersion, securityParameters.getServerRandom(), securityParameters.getSessionID(), securityParameters.getCipherSuite(), this.serverExtensions);
    }

    @Override
    protected TlsContext getContext() {
        return this.a;
    }

    @Override
    a a() {
        return this.a;
    }

    @Override
    protected TlsPeer getPeer() {
        return this.tlsServer;
    }

    protected void handle13HandshakeMessage(short type, HandshakeMessageInput buf) throws IOException {
        if (!this.isTLSv13ConnectionState()) {
            throw new TlsFatalAlert(80);
        }
        block0 : switch (type) {
            case 11: {
                switch (this.connection_state) {
                    case 20: {
                        this.receive13ClientCertificate(buf);
                        this.connection_state = (short)15;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 15: {
                switch (this.connection_state) {
                    case 15: {
                        this.receive13ClientCertificateVerify(buf);
                        buf.updateHash(this.e);
                        this.connection_state = (short)17;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 1: {
                switch (this.connection_state) {
                    case 0: {
                        throw new TlsFatalAlert(80);
                    }
                    case 2: {
                        ClientHello clientHello = this.receiveClientHelloMessage(buf);
                        this.connection_state = (short)3;
                        ServerHello serverHello = this.generate13ServerHello(clientHello, buf, true);
                        this.sendServerHelloMessage(serverHello);
                        this.connection_state = (short)4;
                        this.send13ServerHelloCoda(serverHello, true);
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 20: {
                        this.skip13ClientCertificate();
                    }
                    case 15: {
                        this.skip13ClientCertificateVerify();
                    }
                    case 17: {
                        this.receive13ClientFinished(buf);
                        this.connection_state = (short)18;
                        this.c.a(false);
                        this.c.b(false);
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 24: {
                this.receive13KeyUpdate(buf);
                break;
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    @Override
    protected void handleHandshakeMessage(short type, HandshakeMessageInput buf) throws IOException {
        SecurityParameters securityParameters = this.a.getSecurityParameters();
        if (this.connection_state > 1 && TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) {
            if (securityParameters.isResumedSession()) {
                throw new TlsFatalAlert(80);
            }
            this.handle13HandshakeMessage(type, buf);
            return;
        }
        if (!this.isLegacyConnectionState()) {
            throw new TlsFatalAlert(80);
        }
        if (securityParameters.isResumedSession() && type != 1) {
            if (type != 20 || this.connection_state != 20) {
                throw new TlsFatalAlert(10);
            }
            this.processFinishedMessage(buf);
            this.connection_state = (short)18;
            this.completeHandshake();
            return;
        }
        block0 : switch (type) {
            case 1: {
                if (this.b()) {
                    if (!this.handleRenegotiation()) break;
                    this.connection_state = 0;
                }
                switch (this.connection_state) {
                    case 21: {
                        throw new TlsFatalAlert(80);
                    }
                    case 0: {
                        ClientHello clientHello = this.receiveClientHelloMessage(buf);
                        this.connection_state = 1;
                        ServerHello serverHello = this.generateServerHello(clientHello, buf);
                        this.e.notifyPRFDetermined();
                        if (TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) {
                            this.e.sealHashAlgorithms();
                            if (serverHello.isHelloRetryRequest()) {
                                TlsUtils.b(this.e);
                                this.sendServerHelloMessage(serverHello);
                                this.connection_state = (short)2;
                                this.sendChangeCipherSpecMessage();
                                break block0;
                            }
                            this.sendServerHelloMessage(serverHello);
                            this.connection_state = (short)4;
                            this.sendChangeCipherSpecMessage();
                            this.send13ServerHelloCoda(serverHello, false);
                            break block0;
                        }
                        buf.updateHash(this.e);
                        this.sendServerHelloMessage(serverHello);
                        this.connection_state = (short)4;
                        if (securityParameters.isResumedSession()) {
                            securityParameters.r = this.sessionMasterSecret;
                            this.c.a(TlsUtils.c(this.a));
                            this.sendChangeCipherSpec();
                            this.sendFinishedMessage();
                            this.connection_state = (short)20;
                            break block0;
                        }
                        Vector vector = this.tlsServer.getServerSupplementalData();
                        if (vector != null) {
                            this.sendSupplementalDataMessage(vector);
                            this.connection_state = (short)6;
                        }
                        this.keyExchange = TlsUtils.a(this.a, this.tlsServer);
                        TlsCredentials tlsCredentials = null;
                        if (!KeyExchangeAlgorithm.isAnonymous(securityParameters.getKeyExchangeAlgorithm())) {
                            tlsCredentials = TlsUtils.a(this.tlsServer);
                        }
                        Object object = null;
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        if (null == tlsCredentials) {
                            this.keyExchange.skipServerCredentials();
                        } else {
                            this.keyExchange.processServerCredentials(tlsCredentials);
                            object = tlsCredentials.getCertificate();
                            this.sendCertificateMessage((Certificate)object, byteArrayOutputStream);
                            this.connection_state = (short)7;
                        }
                        securityParameters.A = byteArrayOutputStream.toByteArray();
                        if (null == object || ((Certificate)object).isEmpty()) {
                            securityParameters.U = 0;
                        }
                        if (securityParameters.getStatusRequestVersion() > 0 && (object = this.tlsServer.getCertificateStatus()) != null) {
                            this.sendCertificateStatusMessage((CertificateStatus)object);
                            this.connection_state = (short)8;
                        }
                        if ((object = (Object)this.keyExchange.generateServerKeyExchange()) != null) {
                            this.sendServerKeyExchangeMessage((byte[])object);
                            this.connection_state = (short)10;
                        }
                        if (null != tlsCredentials) {
                            this.certificateRequest = this.tlsServer.getCertificateRequest();
                            if (null == this.certificateRequest) {
                                if (!this.keyExchange.requiresCertificateVerify()) {
                                    throw new TlsFatalAlert(80);
                                }
                            } else {
                                if (TlsUtils.isTLSv12(this.a) != (this.certificateRequest.getSupportedSignatureAlgorithms() != null)) {
                                    throw new TlsFatalAlert(80);
                                }
                                this.certificateRequest = TlsUtils.a(this.certificateRequest, this.keyExchange);
                                TlsUtils.a(securityParameters, this.certificateRequest);
                                if (ProtocolVersion.TLSv12.equals(securityParameters.getNegotiatedVersion())) {
                                    TlsUtils.a(this.e, securityParameters.getServerSigAlgs());
                                    if (this.a.getCrypto().hasAnyStreamVerifiers(securityParameters.getServerSigAlgs())) {
                                        this.e.forceBuffering();
                                    }
                                } else if (this.a.getCrypto().hasAnyStreamVerifiersLegacy(this.certificateRequest.getCertificateTypes())) {
                                    this.e.forceBuffering();
                                }
                            }
                        }
                        this.e.sealHashAlgorithms();
                        if (null != this.certificateRequest) {
                            this.sendCertificateRequestMessage(this.certificateRequest);
                            this.connection_state = (short)11;
                        }
                        this.sendServerHelloDoneMessage();
                        this.connection_state = (short)12;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 23: {
                switch (this.connection_state) {
                    case 12: {
                        this.tlsServer.processClientSupplementalData(TlsServerProtocol.readSupplementalDataMessage(buf));
                        this.connection_state = (short)14;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 11: {
                switch (this.connection_state) {
                    case 12: {
                        this.tlsServer.processClientSupplementalData(null);
                    }
                    case 14: {
                        this.receiveCertificateMessage(buf);
                        this.connection_state = (short)15;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 16: {
                switch (this.connection_state) {
                    case 12: {
                        this.tlsServer.processClientSupplementalData(null);
                    }
                    case 14: {
                        if (null == this.certificateRequest) {
                            this.keyExchange.skipClientCredentials();
                        } else {
                            if (TlsUtils.isTLSv12(this.a)) {
                                throw new TlsFatalAlert(10);
                            }
                            if (TlsUtils.isSSL(this.a)) {
                                throw new TlsFatalAlert(10);
                            }
                            this.notifyClientCertificate(Certificate.EMPTY_CHAIN);
                        }
                    }
                    case 15: {
                        this.receiveClientKeyExchangeMessage(buf);
                        this.connection_state = (short)16;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 15: {
                switch (this.connection_state) {
                    case 16: {
                        if (!this.expectCertificateVerifyMessage()) {
                            throw new TlsFatalAlert(10);
                        }
                        this.receiveCertificateVerifyMessage(buf);
                        buf.updateHash(this.e);
                        this.connection_state = (short)17;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 16: {
                        if (this.expectCertificateVerifyMessage()) {
                            throw new TlsFatalAlert(10);
                        }
                    }
                    case 17: {
                        this.processFinishedMessage(buf);
                        buf.updateHash(this.e);
                        this.connection_state = (short)18;
                        if (this.expectSessionTicket) {
                            this.sendNewSessionTicketMessage(this.tlsServer.getNewSessionTicket());
                            this.connection_state = (short)19;
                        }
                        this.sendChangeCipherSpec();
                        this.sendFinishedMessage();
                        this.connection_state = (short)20;
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    @Override
    protected void handleAlertWarningMessage(short alertDescription) throws IOException {
        if (41 == alertDescription && null != this.certificateRequest && TlsUtils.isSSL(this.a)) {
            switch (this.connection_state) {
                case 12: {
                    this.tlsServer.processClientSupplementalData(null);
                }
                case 14: {
                    this.notifyClientCertificate(Certificate.EMPTY_CHAIN);
                    this.connection_state = (short)15;
                    return;
                }
            }
        }
        super.handleAlertWarningMessage(alertDescription);
    }

    protected void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        if (null == this.certificateRequest) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.a((TlsServerContext)this.a, clientCertificate, this.keyExchange, this.tlsServer);
    }

    protected void receive13ClientCertificate(ByteArrayInputStream buf) throws IOException {
        if (null == this.certificateRequest) {
            throw new TlsFatalAlert(10);
        }
        Certificate.ParseOptions parseOptions = new Certificate.ParseOptions().setCertificateType(this.a.getSecurityParametersHandshake().getClientCertificateType()).setMaxChainLength(this.tlsServer.getMaxCertificateChainLength());
        Certificate certificate = Certificate.parse(parseOptions, this.a, buf, null);
        TlsServerProtocol.assertEmpty(buf);
        this.notifyClientCertificate(certificate);
    }

    protected void receive13ClientCertificateVerify(ByteArrayInputStream buf) throws IOException {
        Certificate certificate = this.a.getSecurityParametersHandshake().getPeerCertificate();
        if (null == certificate || certificate.isEmpty()) {
            throw new TlsFatalAlert(80);
        }
        CertificateVerify certificateVerify = CertificateVerify.parse(this.a, buf);
        TlsServerProtocol.assertEmpty(buf);
        TlsUtils.a(this.a, this.e, certificateVerify);
    }

    protected void receive13ClientFinished(ByteArrayInputStream buf) throws IOException {
        this.process13FinishedMessage(buf);
    }

    protected void receiveCertificateMessage(ByteArrayInputStream buf) throws IOException {
        if (null == this.certificateRequest) {
            throw new TlsFatalAlert(10);
        }
        Certificate.ParseOptions parseOptions = new Certificate.ParseOptions().setCertificateType(this.a.getSecurityParametersHandshake().getClientCertificateType()).setMaxChainLength(this.tlsServer.getMaxCertificateChainLength());
        Certificate certificate = Certificate.parse(parseOptions, this.a, buf, null);
        TlsServerProtocol.assertEmpty(buf);
        this.notifyClientCertificate(certificate);
    }

    protected void receiveCertificateVerifyMessage(ByteArrayInputStream buf) throws IOException {
        DigitallySigned digitallySigned = DigitallySigned.parse(this.a, buf);
        TlsServerProtocol.assertEmpty(buf);
        TlsUtils.a((TlsServerContext)this.a, this.certificateRequest, digitallySigned, this.e);
        this.e.stopTracking();
    }

    protected ClientHello receiveClientHelloMessage(ByteArrayInputStream buf) throws IOException {
        return ClientHello.parse(buf, null);
    }

    protected void receiveClientKeyExchangeMessage(ByteArrayInputStream buf) throws IOException {
        this.keyExchange.processClientKeyExchange(buf);
        TlsServerProtocol.assertEmpty(buf);
        boolean bl = TlsUtils.isSSL(this.a);
        if (bl) {
            TlsServerProtocol.establishMasterSecret(this.a, this.keyExchange);
        }
        this.a.getSecurityParametersHandshake().w = TlsUtils.a(this.e);
        if (!bl) {
            TlsServerProtocol.establishMasterSecret(this.a, this.keyExchange);
        }
        this.c.a(TlsUtils.c(this.a));
        if (!this.expectCertificateVerifyMessage()) {
            this.e.stopTracking();
        }
    }

    protected void send13EncryptedExtensionsMessage(Hashtable serverExtensions) throws IOException {
        byte[] byArray = TlsServerProtocol.writeExtensionsData(serverExtensions);
        j j2 = new j(8);
        TlsUtils.writeOpaque16(byArray, j2);
        j2.a(this);
    }

    protected void send13ServerHelloCoda(ServerHello serverHello, boolean afterHelloRetryRequest) throws IOException {
        Object object;
        SecurityParameters securityParameters = this.a.getSecurityParametersHandshake();
        byte[] byArray = TlsUtils.a(this.e);
        TlsUtils.b(this.a, byArray, this.c);
        this.c.c();
        this.c.b(true);
        this.send13EncryptedExtensionsMessage(this.serverExtensions);
        this.connection_state = (short)5;
        if (!this.selectedPSK13) {
            this.certificateRequest = this.tlsServer.getCertificateRequest();
            if (null != this.certificateRequest) {
                if (!this.certificateRequest.hasCertificateRequestContext(TlsUtils.EMPTY_BYTES)) {
                    throw new TlsFatalAlert(80);
                }
                TlsUtils.a(securityParameters, this.certificateRequest);
                this.sendCertificateRequestMessage(this.certificateRequest);
                this.connection_state = (short)11;
            }
            if (null == (object = (Object)TlsUtils.b(this.tlsServer))) {
                throw new TlsFatalAlert(80);
            }
            Object object2 = object.getCertificate();
            this.send13CertificateMessage((Certificate)object2);
            securityParameters.A = null;
            this.connection_state = (short)7;
            object2 = TlsUtils.a((TlsContext)this.a, (TlsCredentialedSigner)object, this.e);
            this.send13CertificateVerifyMessage((DigitallySigned)object2);
            this.connection_state = (short)17;
        }
        this.send13FinishedMessage();
        this.connection_state = (short)20;
        object = TlsUtils.a(this.e);
        TlsUtils.a((TlsContext)this.a, (byte[])object, this.c);
        this.c.c();
    }

    protected void sendCertificateRequestMessage(CertificateRequest certificateRequest) throws IOException {
        j j2 = new j(13);
        certificateRequest.encode(this.a, j2);
        j2.a(this);
    }

    protected void sendCertificateStatusMessage(CertificateStatus certificateStatus) throws IOException {
        j j2 = new j(22);
        certificateStatus.encode(j2);
        j2.a(this);
    }

    protected void sendHelloRequestMessage() throws IOException {
        j.a(this, (short)0, TlsUtils.EMPTY_BYTES);
    }

    protected void sendNewSessionTicketMessage(NewSessionTicket newSessionTicket) throws IOException {
        if (newSessionTicket == null) {
            throw new TlsFatalAlert(80);
        }
        j j2 = new j(4);
        newSessionTicket.encode(j2);
        j2.a(this);
    }

    protected void sendServerHelloDoneMessage() throws IOException {
        j.a(this, (short)14, TlsUtils.EMPTY_BYTES);
    }

    protected void sendServerHelloMessage(ServerHello serverHello) throws IOException {
        j j2 = new j(2);
        serverHello.encode(this.a, j2);
        j2.a(this);
    }

    protected void sendServerKeyExchangeMessage(byte[] serverKeyExchange) throws IOException {
        j.a(this, (short)12, serverKeyExchange);
    }

    protected void skip13ClientCertificate() throws IOException {
        if (null != this.certificateRequest) {
            throw new TlsFatalAlert(10);
        }
    }

    protected void skip13ClientCertificateVerify() throws IOException {
        if (this.expectCertificateVerifyMessage()) {
            throw new TlsFatalAlert(10);
        }
    }
}

