/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto;

import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.enterprisedt.bouncycastle.tls.HashAlgorithm;
import com.enterprisedt.bouncycastle.tls.MACAlgorithm;
import com.enterprisedt.bouncycastle.tls.PRFAlgorithm;
import com.enterprisedt.bouncycastle.tls.SignatureAlgorithm;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import java.io.IOException;

public abstract class TlsCryptoUtils {
    private static final byte[] a = new byte[]{116, 108, 115, 49, 51, 32};

    public static int getHash(short hashAlgorithm) {
        switch (hashAlgorithm) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
        }
        throw new IllegalArgumentException("specified HashAlgorithm invalid: " + HashAlgorithm.getText(hashAlgorithm));
    }

    public static int getHashForHMAC(int macAlgorithm) {
        switch (macAlgorithm) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
        }
        throw new IllegalArgumentException("specified MACAlgorithm not an HMAC: " + MACAlgorithm.getText(macAlgorithm));
    }

    public static int getHashForPRF(int prfAlgorithm) {
        switch (prfAlgorithm) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("legacy PRF not a valid algorithm");
            }
            case 2: 
            case 4: {
                return 4;
            }
            case 3: 
            case 5: {
                return 5;
            }
            case 7: {
                return 7;
            }
        }
        throw new IllegalArgumentException("unknown PRFAlgorithm: " + PRFAlgorithm.getText(prfAlgorithm));
    }

    public static int getHashInternalSize(int cryptoHashAlgorithm) {
        switch (cryptoHashAlgorithm) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                return 64;
            }
            case 5: 
            case 6: {
                return 128;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int getHashOutputSize(int cryptoHashAlgorithm) {
        switch (cryptoHashAlgorithm) {
            case 1: {
                return 16;
            }
            case 2: {
                return 20;
            }
            case 3: {
                return 28;
            }
            case 4: 
            case 7: {
                return 32;
            }
            case 5: {
                return 48;
            }
            case 6: {
                return 64;
            }
        }
        throw new IllegalArgumentException();
    }

    public static ASN1ObjectIdentifier getOIDForHash(int cryptoHashAlgorithm) {
        switch (cryptoHashAlgorithm) {
            case 1: {
                return PKCSObjectIdentifiers.md5;
            }
            case 2: {
                return X509ObjectIdentifiers.id_SHA1;
            }
            case 3: {
                return NISTObjectIdentifiers.id_sha224;
            }
            case 4: {
                return NISTObjectIdentifiers.id_sha256;
            }
            case 5: {
                return NISTObjectIdentifiers.id_sha384;
            }
            case 6: {
                return NISTObjectIdentifiers.id_sha512;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int getSignature(short signatureAlgorithm) {
        switch (signatureAlgorithm) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
            case 26: {
                return 26;
            }
            case 27: {
                return 27;
            }
            case 28: {
                return 28;
            }
            case 64: {
                return 64;
            }
            case 65: {
                return 65;
            }
        }
        throw new IllegalArgumentException("specified SignatureAlgorithm invalid: " + SignatureAlgorithm.getText(signatureAlgorithm));
    }

    public static TlsSecret hkdfExpandLabel(TlsSecret secret, int cryptoHashAlgorithm, String label, byte[] context, int length) throws IOException {
        int n2 = label.length();
        if (n2 < 1) {
            throw new TlsFatalAlert(80);
        }
        int n3 = context.length;
        int n4 = a.length + n2;
        byte[] byArray = new byte[2 + (1 + n4) + (1 + n3)];
        TlsUtils.checkUint16(length);
        TlsUtils.writeUint16(length, byArray, 0);
        TlsUtils.checkUint8(n4);
        TlsUtils.writeUint8(n4, byArray, 2);
        System.arraycopy(a, 0, byArray, 3, a.length);
        int n5 = 2 + (1 + a.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = label.charAt(i2);
            byArray[n5 + i2] = (byte)c2;
        }
        TlsUtils.writeOpaque8(context, byArray, 2 + (1 + n4));
        return secret.hkdfExpand(cryptoHashAlgorithm, byArray, length);
    }
}

