/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl;

import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCipher;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCryptoParameters;
import com.enterprisedt.bouncycastle.tls.crypto.TlsDecodeResult;
import com.enterprisedt.bouncycastle.tls.crypto.TlsEncodeResult;
import com.enterprisedt.bouncycastle.tls.crypto.TlsHMAC;
import com.enterprisedt.bouncycastle.tls.crypto.impl.TlsImplUtils;
import com.enterprisedt.bouncycastle.tls.crypto.impl.TlsSuiteHMac;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;

public final class TlsNullCipher
implements TlsCipher {
    private final TlsSuiteHMac a;
    private final TlsSuiteHMac b;
    private final byte[] c;
    private final byte[] d;
    private final boolean e;
    private final boolean f;

    public TlsNullCipher(TlsCryptoParameters cryptoParams, TlsHMAC clientMac, TlsHMAC serverMac) throws IOException {
        SecurityParameters securityParameters = cryptoParams.getSecurityParametersHandshake();
        ProtocolVersion protocolVersion = securityParameters.getNegotiatedVersion();
        if (TlsImplUtils.isTLSv13(protocolVersion)) {
            throw new TlsFatalAlert(80);
        }
        this.c = securityParameters.getConnectionIDPeer();
        this.d = securityParameters.getConnectionIDLocal();
        this.e = !Arrays.isNullOrEmpty(this.c);
        this.f = !Arrays.isNullOrEmpty(this.d);
        int n2 = clientMac.getMacLength() + serverMac.getMacLength();
        byte[] byArray = TlsImplUtils.calculateKeyBlock(cryptoParams, n2);
        int n3 = 0;
        clientMac.setKey(byArray, n3, clientMac.getMacLength());
        serverMac.setKey(byArray, n3 += clientMac.getMacLength(), serverMac.getMacLength());
        if ((n3 += serverMac.getMacLength()) != n2) {
            throw new TlsFatalAlert(80);
        }
        if (cryptoParams.isServer()) {
            this.b = new TlsSuiteHMac(cryptoParams, serverMac);
            this.a = new TlsSuiteHMac(cryptoParams, clientMac);
        } else {
            this.b = new TlsSuiteHMac(cryptoParams, clientMac);
            this.a = new TlsSuiteHMac(cryptoParams, serverMac);
        }
    }

    @Override
    public int getCiphertextDecodeLimit(int plaintextLimit) {
        int n2 = plaintextLimit + (this.e ? 1 : 0);
        return n2 + this.a.getSize();
    }

    @Override
    public int getCiphertextEncodeLimit(int plaintextLimit) {
        int n2 = plaintextLimit + (this.f ? 1 : 0);
        return n2 + this.b.getSize();
    }

    @Override
    public int getPlaintextDecodeLimit(int ciphertextLimit) {
        int n2 = ciphertextLimit - this.a.getSize();
        return n2 - (this.e ? 1 : 0);
    }

    @Override
    public int getPlaintextEncodeLimit(int ciphertextLimit) {
        int n2 = ciphertextLimit - this.b.getSize();
        return n2 - (this.f ? 1 : 0);
    }

    @Override
    public TlsEncodeResult encodePlaintext(long seqNo, short contentType, ProtocolVersion recordVersion, int headerAllocation, byte[] plaintext, int offset, int len) throws IOException {
        int n2 = this.b.getSize();
        int n3 = len + (this.f ? 1 : 0);
        byte[] byArray = new byte[headerAllocation + n3 + n2];
        System.arraycopy(plaintext, offset, byArray, headerAllocation, len);
        short s2 = contentType;
        if (this.f) {
            byArray[headerAllocation + len] = (byte)contentType;
            s2 = 25;
        }
        byte[] byArray2 = this.b.calculateMac(seqNo, s2, this.d, byArray, headerAllocation, n3);
        System.arraycopy(byArray2, 0, byArray, headerAllocation + n3, byArray2.length);
        return new TlsEncodeResult(byArray, 0, byArray.length, s2);
    }

    @Override
    public TlsDecodeResult decodeCiphertext(long seqNo, short recordType, ProtocolVersion recordVersion, byte[] ciphertext, int offset, int len) throws IOException {
        int n2;
        short s2;
        block3: {
            byte by;
            boolean bl;
            int n3 = this.a.getSize();
            int n4 = len - n3;
            if (n4 < (this.e ? 1 : 0)) {
                throw new TlsFatalAlert(50);
            }
            byte[] byArray = this.a.calculateMac(seqNo, recordType, this.c, ciphertext, offset, n4);
            boolean bl2 = bl = !TlsUtils.constantTimeAreEqual(n3, byArray, 0, ciphertext, offset + n4);
            if (bl) {
                throw new TlsFatalAlert(20);
            }
            s2 = recordType;
            n2 = n4;
            if (!this.e) break block3;
            do {
                if (--n2 >= 0) continue;
                throw new TlsFatalAlert(10);
            } while (0 == (by = ciphertext[offset + n2]));
            s2 = (short)(by & 0xFF);
        }
        return new TlsDecodeResult(ciphertext, offset, n2, s2);
    }

    @Override
    public void rekeyDecoder() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void rekeyEncoder() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public boolean usesOpaqueRecordTypeDecode() {
        return this.e;
    }

    @Override
    public boolean usesOpaqueRecordTypeEncode() {
        return this.f;
    }
}

