/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl.bc;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.agreement.srp.SRP6Client;
import com.enterprisedt.bouncycastle.crypto.agreement.srp.SRP6Server;
import com.enterprisedt.bouncycastle.crypto.agreement.srp.SRP6VerifierGenerator;
import com.enterprisedt.bouncycastle.crypto.digests.MD5Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA1Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA224Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA256Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA384Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA512Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SM3Digest;
import com.enterprisedt.bouncycastle.crypto.engines.AESEngine;
import com.enterprisedt.bouncycastle.crypto.engines.ARIAEngine;
import com.enterprisedt.bouncycastle.crypto.engines.CamelliaEngine;
import com.enterprisedt.bouncycastle.crypto.engines.DESedeEngine;
import com.enterprisedt.bouncycastle.crypto.engines.SEEDEngine;
import com.enterprisedt.bouncycastle.crypto.engines.SM4Engine;
import com.enterprisedt.bouncycastle.crypto.macs.HMac;
import com.enterprisedt.bouncycastle.crypto.modes.AEADBlockCipher;
import com.enterprisedt.bouncycastle.crypto.modes.CBCBlockCipher;
import com.enterprisedt.bouncycastle.crypto.modes.CCMBlockCipher;
import com.enterprisedt.bouncycastle.crypto.modes.GCMBlockCipher;
import com.enterprisedt.bouncycastle.crypto.params.SRP6GroupParameters;
import com.enterprisedt.bouncycastle.crypto.prng.DigestRandomGenerator;
import com.enterprisedt.bouncycastle.tls.NamedGroup;
import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.enterprisedt.bouncycastle.tls.SignatureScheme;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCertificate;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCipher;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCryptoParameters;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCryptoUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsDHConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsDHDomain;
import com.enterprisedt.bouncycastle.tls.crypto.TlsECConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsECDomain;
import com.enterprisedt.bouncycastle.tls.crypto.TlsHMAC;
import com.enterprisedt.bouncycastle.tls.crypto.TlsHash;
import com.enterprisedt.bouncycastle.tls.crypto.TlsNonceGenerator;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSRP6Client;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSRP6Server;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSRP6VerifierGenerator;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSRPConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import com.enterprisedt.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.impl.TlsAEADCipher;
import com.enterprisedt.bouncycastle.tls.crypto.impl.TlsBlockCipher;
import com.enterprisedt.bouncycastle.tls.crypto.impl.TlsImplUtils;
import com.enterprisedt.bouncycastle.tls.crypto.impl.TlsNullCipher;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcChaCha20Poly1305;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsDHDomain;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsECDomain;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsRawKeyCertificate;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcX25519Domain;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcX448Domain;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.a;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.c;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.d;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.e;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.f;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.g;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.i;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.j;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.k;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Vector;

public class BcTlsCrypto
extends AbstractTlsCrypto {
    private final SecureRandom a;

    public BcTlsCrypto() {
        this(new SecureRandom());
    }

    public BcTlsCrypto(SecureRandom entropySource) {
        this.a = entropySource;
    }

    BcTlsSecret a(byte[] byArray) {
        return new BcTlsSecret(this, byArray);
    }

    @Override
    public SecureRandom getSecureRandom() {
        return this.a;
    }

    @Override
    public TlsCertificate createCertificate(byte[] encoding) throws IOException {
        return this.createCertificate((short)0, encoding);
    }

    @Override
    public TlsCertificate createCertificate(short type, byte[] encoding) throws IOException {
        switch (type) {
            case 0: {
                return new BcTlsCertificate(this, encoding);
            }
            case 2: {
                return new BcTlsRawKeyCertificate(this, encoding);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsCipher createCipher(TlsCryptoParameters cryptoParams, int encryptionAlgorithm, int macAlgorithm) throws IOException {
        switch (encryptionAlgorithm) {
            case 8: 
            case 12: 
            case 14: 
            case 22: 
            case 28: {
                return this.createCipher_CBC(cryptoParams, encryptionAlgorithm, 16, macAlgorithm);
            }
            case 7: {
                return this.createCipher_CBC(cryptoParams, encryptionAlgorithm, 24, macAlgorithm);
            }
            case 9: 
            case 13: 
            case 23: {
                return this.createCipher_CBC(cryptoParams, encryptionAlgorithm, 32, macAlgorithm);
            }
            case 15: {
                return this.createCipher_AES_CCM(cryptoParams, 16, 16);
            }
            case 16: {
                return this.createCipher_AES_CCM(cryptoParams, 16, 8);
            }
            case 10: {
                return this.createCipher_AES_GCM(cryptoParams, 16, 16);
            }
            case 17: {
                return this.createCipher_AES_CCM(cryptoParams, 32, 16);
            }
            case 18: {
                return this.createCipher_AES_CCM(cryptoParams, 32, 8);
            }
            case 11: {
                return this.createCipher_AES_GCM(cryptoParams, 32, 16);
            }
            case 24: {
                return this.createCipher_ARIA_GCM(cryptoParams, 16, 16);
            }
            case 25: {
                return this.createCipher_ARIA_GCM(cryptoParams, 32, 16);
            }
            case 19: {
                return this.createCipher_Camellia_GCM(cryptoParams, 16, 16);
            }
            case 20: {
                return this.createCipher_Camellia_GCM(cryptoParams, 32, 16);
            }
            case 21: {
                return this.createChaCha20Poly1305(cryptoParams);
            }
            case 0: {
                return this.createNullCipher(cryptoParams, macAlgorithm);
            }
            case 26: {
                return this.createCipher_SM4_CCM(cryptoParams);
            }
            case 27: {
                return this.createCipher_SM4_GCM(cryptoParams);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsDHDomain createDHDomain(TlsDHConfig dhConfig) {
        return new BcTlsDHDomain(this, dhConfig);
    }

    @Override
    public TlsECDomain createECDomain(TlsECConfig ecConfig) {
        switch (ecConfig.getNamedGroup()) {
            case 29: {
                return new BcX25519Domain(this);
            }
            case 30: {
                return new BcX448Domain(this);
            }
        }
        return new BcTlsECDomain(this, ecConfig);
    }

    @Override
    public TlsNonceGenerator createNonceGenerator(byte[] additionalSeedMaterial) {
        int n2 = 4;
        Digest digest = this.createDigest(n2);
        byte[] byArray = new byte[TlsCryptoUtils.getHashOutputSize(n2)];
        this.getSecureRandom().nextBytes(byArray);
        DigestRandomGenerator digestRandomGenerator = new DigestRandomGenerator(digest);
        digestRandomGenerator.addSeedMaterial(additionalSeedMaterial);
        digestRandomGenerator.addSeedMaterial(byArray);
        return new g(digestRandomGenerator);
    }

    @Override
    public boolean hasAnyStreamVerifiers(Vector signatureAndHashAlgorithms) {
        int n2 = signatureAndHashAlgorithms.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)signatureAndHashAlgorithms.elementAt(i2);
            switch (SignatureScheme.from(signatureAndHashAlgorithm)) {
                case 2055: 
                case 2056: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean hasAnyStreamVerifiersLegacy(short[] clientCertificateTypes) {
        return false;
    }

    @Override
    public boolean hasCryptoHashAlgorithm(int cryptoHashAlgorithm) {
        switch (cryptoHashAlgorithm) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasCryptoSignatureAlgorithm(int cryptoSignatureAlgorithm) {
        switch (cryptoSignatureAlgorithm) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasDHAgreement() {
        return true;
    }

    @Override
    public boolean hasECDHAgreement() {
        return true;
    }

    @Override
    public boolean hasEncryptionAlgorithm(int encryptionAlgorithm) {
        switch (encryptionAlgorithm) {
            case 0: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasHKDFAlgorithm(int cryptoHashAlgorithm) {
        switch (cryptoHashAlgorithm) {
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasMacAlgorithm(int macAlgorithm) {
        switch (macAlgorithm) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasNamedGroup(int namedGroup) {
        return NamedGroup.refersToASpecificGroup(namedGroup);
    }

    @Override
    public boolean hasRSAEncryption() {
        return true;
    }

    @Override
    public boolean hasSignatureAlgorithm(short signatureAlgorithm) {
        switch (signatureAlgorithm) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 26: 
            case 27: 
            case 28: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasSignatureAndHashAlgorithm(SignatureAndHashAlgorithm sigAndHashAlgorithm) {
        short s2 = sigAndHashAlgorithm.getSignature();
        switch (sigAndHashAlgorithm.getHash()) {
            case 1: {
                return 1 == s2 && this.hasSignatureAlgorithm(s2);
            }
        }
        return this.hasSignatureAlgorithm(s2);
    }

    @Override
    public boolean hasSignatureScheme(int signatureScheme) {
        switch (signatureScheme) {
            case 1800: {
                return false;
            }
        }
        short s2 = SignatureScheme.getSignatureAlgorithm(signatureScheme);
        switch (SignatureScheme.getCryptoHashAlgorithm(signatureScheme)) {
            case 1: {
                return 1 == s2 && this.hasSignatureAlgorithm(s2);
            }
        }
        return this.hasSignatureAlgorithm(s2);
    }

    @Override
    public boolean hasSRPAuthentication() {
        return true;
    }

    @Override
    public TlsSecret createSecret(byte[] data) {
        return this.a(Arrays.clone(data));
    }

    @Override
    public TlsSecret generateRSAPreMasterSecret(ProtocolVersion version) {
        byte[] byArray = new byte[48];
        this.getSecureRandom().nextBytes(byArray);
        TlsUtils.writeVersion(version, byArray, 0);
        return this.a(byArray);
    }

    public Digest cloneDigest(int cryptoHashAlgorithm, Digest digest) {
        switch (cryptoHashAlgorithm) {
            case 1: {
                return new MD5Digest((MD5Digest)digest);
            }
            case 2: {
                return new SHA1Digest((SHA1Digest)digest);
            }
            case 3: {
                return new SHA224Digest((SHA224Digest)digest);
            }
            case 4: {
                return SHA256Digest.newInstance(digest);
            }
            case 5: {
                return new SHA384Digest((SHA384Digest)digest);
            }
            case 6: {
                return new SHA512Digest((SHA512Digest)digest);
            }
            case 7: {
                return new SM3Digest((SM3Digest)digest);
            }
        }
        throw new IllegalArgumentException("invalid CryptoHashAlgorithm: " + cryptoHashAlgorithm);
    }

    public Digest createDigest(int cryptoHashAlgorithm) {
        switch (cryptoHashAlgorithm) {
            case 1: {
                return new MD5Digest();
            }
            case 2: {
                return new SHA1Digest();
            }
            case 3: {
                return new SHA224Digest();
            }
            case 4: {
                return new SHA256Digest();
            }
            case 5: {
                return new SHA384Digest();
            }
            case 6: {
                return new SHA512Digest();
            }
            case 7: {
                return new SM3Digest();
            }
        }
        throw new IllegalArgumentException("invalid CryptoHashAlgorithm: " + cryptoHashAlgorithm);
    }

    @Override
    public TlsHash createHash(int cryptoHashAlgorithm) {
        return new f(this, cryptoHashAlgorithm);
    }

    protected BlockCipher createBlockCipher(int encryptionAlgorithm) throws IOException {
        switch (encryptionAlgorithm) {
            case 7: {
                return this.createDESedeEngine();
            }
            case 8: 
            case 9: {
                return this.createAESEngine();
            }
            case 22: 
            case 23: {
                return this.createARIAEngine();
            }
            case 12: 
            case 13: {
                return this.createCamelliaEngine();
            }
            case 14: {
                return this.createSEEDEngine();
            }
            case 28: {
                return this.createSM4Engine();
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected BlockCipher createCBCBlockCipher(BlockCipher blockCipher) {
        return CBCBlockCipher.newInstance(blockCipher);
    }

    protected BlockCipher createCBCBlockCipher(int encryptionAlgorithm) throws IOException {
        return this.createCBCBlockCipher(this.createBlockCipher(encryptionAlgorithm));
    }

    protected TlsCipher createChaCha20Poly1305(TlsCryptoParameters cryptoParams) throws IOException {
        return new TlsAEADCipher(cryptoParams, new BcChaCha20Poly1305(true), new BcChaCha20Poly1305(false), 32, 16, 2);
    }

    protected TlsAEADCipher createCipher_AES_CCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        c c2 = new c(this.createAEADBlockCipher_AES_CCM(), true);
        c c3 = new c(this.createAEADBlockCipher_AES_CCM(), false);
        return new TlsAEADCipher(cryptoParams, c2, c3, cipherKeySize, macSize, 1);
    }

    protected TlsAEADCipher createCipher_AES_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        c c2 = new c(this.createAEADBlockCipher_AES_GCM(), true);
        c c3 = new c(this.createAEADBlockCipher_AES_GCM(), false);
        return new TlsAEADCipher(cryptoParams, c2, c3, cipherKeySize, macSize, 3);
    }

    protected TlsAEADCipher createCipher_ARIA_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        c c2 = new c(this.createAEADBlockCipher_ARIA_GCM(), true);
        c c3 = new c(this.createAEADBlockCipher_ARIA_GCM(), false);
        return new TlsAEADCipher(cryptoParams, c2, c3, cipherKeySize, macSize, 3);
    }

    protected TlsAEADCipher createCipher_Camellia_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        c c2 = new c(this.createAEADBlockCipher_Camellia_GCM(), true);
        c c3 = new c(this.createAEADBlockCipher_Camellia_GCM(), false);
        return new TlsAEADCipher(cryptoParams, c2, c3, cipherKeySize, macSize, 3);
    }

    protected TlsCipher createCipher_CBC(TlsCryptoParameters cryptoParams, int encryptionAlgorithm, int cipherKeySize, int macAlgorithm) throws IOException {
        d d2 = new d(this.createCBCBlockCipher(encryptionAlgorithm), true);
        d d3 = new d(this.createCBCBlockCipher(encryptionAlgorithm), false);
        TlsHMAC tlsHMAC = this.createMAC(cryptoParams, macAlgorithm);
        TlsHMAC tlsHMAC2 = this.createMAC(cryptoParams, macAlgorithm);
        return new TlsBlockCipher(cryptoParams, d2, d3, tlsHMAC, tlsHMAC2, cipherKeySize);
    }

    protected TlsAEADCipher createCipher_SM4_CCM(TlsCryptoParameters cryptoParams) throws IOException {
        c c2 = new c(this.createAEADBlockCipher_SM4_CCM(), true);
        c c3 = new c(this.createAEADBlockCipher_SM4_CCM(), false);
        return new TlsAEADCipher(cryptoParams, c2, c3, 16, 16, 1);
    }

    protected TlsAEADCipher createCipher_SM4_GCM(TlsCryptoParameters cryptoParams) throws IOException {
        c c2 = new c(this.createAEADBlockCipher_SM4_GCM(), true);
        c c3 = new c(this.createAEADBlockCipher_SM4_GCM(), false);
        return new TlsAEADCipher(cryptoParams, c2, c3, 16, 16, 3);
    }

    protected TlsNullCipher createNullCipher(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException {
        return new TlsNullCipher(cryptoParams, this.createMAC(cryptoParams, macAlgorithm), this.createMAC(cryptoParams, macAlgorithm));
    }

    protected BlockCipher createAESEngine() {
        return AESEngine.newInstance();
    }

    protected BlockCipher createARIAEngine() {
        return new ARIAEngine();
    }

    protected BlockCipher createCamelliaEngine() {
        return new CamelliaEngine();
    }

    protected BlockCipher createDESedeEngine() {
        return new DESedeEngine();
    }

    protected BlockCipher createSEEDEngine() {
        return new SEEDEngine();
    }

    protected BlockCipher createSM4Engine() {
        return new SM4Engine();
    }

    protected AEADBlockCipher createCCMMode(BlockCipher engine) {
        return new CCMBlockCipher(engine);
    }

    protected AEADBlockCipher createGCMMode(BlockCipher engine) {
        return GCMBlockCipher.newInstance(engine);
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_CCM() {
        return this.createCCMMode(this.createAESEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_GCM() {
        return this.createGCMMode(this.createAESEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_ARIA_GCM() {
        return this.createGCMMode(this.createARIAEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_Camellia_GCM() {
        return this.createGCMMode(this.createCamelliaEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_SM4_CCM() {
        return this.createCCMMode(this.createSM4Engine());
    }

    protected AEADBlockCipher createAEADBlockCipher_SM4_GCM() {
        return this.createGCMMode(this.createSM4Engine());
    }

    @Override
    public TlsHMAC createHMAC(int macAlgorithm) {
        switch (macAlgorithm) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return this.createHMACForHash(TlsCryptoUtils.getHashForHMAC(macAlgorithm));
            }
        }
        throw new IllegalArgumentException("invalid MACAlgorithm: " + macAlgorithm);
    }

    @Override
    public TlsHMAC createHMACForHash(int cryptoHashAlgorithm) {
        return new e(new HMac(this.createDigest(cryptoHashAlgorithm)));
    }

    protected TlsHMAC createHMAC_SSL(int macAlgorithm) throws IOException {
        switch (macAlgorithm) {
            case 1: {
                return new a(this.createDigest(1));
            }
            case 2: {
                return new a(this.createDigest(2));
            }
            case 3: {
                return new a(this.createDigest(4));
            }
            case 4: {
                return new a(this.createDigest(5));
            }
            case 5: {
                return new a(this.createDigest(6));
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsHMAC createMAC(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException {
        if (TlsImplUtils.isSSL(cryptoParams)) {
            return this.createHMAC_SSL(macAlgorithm);
        }
        return this.createHMAC(macAlgorithm);
    }

    @Override
    public TlsSRP6Client createSRP6Client(TlsSRPConfig srpConfig) {
        BigInteger[] bigIntegerArray = srpConfig.getExplicitNG();
        SRP6GroupParameters sRP6GroupParameters = new SRP6GroupParameters(bigIntegerArray[0], bigIntegerArray[1]);
        SRP6Client sRP6Client = new SRP6Client();
        sRP6Client.init(sRP6GroupParameters, this.createDigest(2), this.getSecureRandom());
        return new i(sRP6Client);
    }

    @Override
    public TlsSRP6Server createSRP6Server(TlsSRPConfig srpConfig, BigInteger srpVerifier) {
        BigInteger[] bigIntegerArray = srpConfig.getExplicitNG();
        SRP6GroupParameters sRP6GroupParameters = new SRP6GroupParameters(bigIntegerArray[0], bigIntegerArray[1]);
        SRP6Server sRP6Server = new SRP6Server();
        sRP6Server.init(sRP6GroupParameters, srpVerifier, this.createDigest(2), this.getSecureRandom());
        return new j(sRP6Server);
    }

    @Override
    public TlsSRP6VerifierGenerator createSRP6VerifierGenerator(TlsSRPConfig srpConfig) {
        BigInteger[] bigIntegerArray = srpConfig.getExplicitNG();
        SRP6VerifierGenerator sRP6VerifierGenerator = new SRP6VerifierGenerator();
        sRP6VerifierGenerator.init(bigIntegerArray[0], bigIntegerArray[1], this.createDigest(2));
        return new k(sRP6VerifierGenerator);
    }

    @Override
    public TlsSecret hkdfInit(int cryptoHashAlgorithm) {
        return this.a(new byte[TlsCryptoUtils.getHashOutputSize(cryptoHashAlgorithm)]);
    }
}

