/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.util;

import com.enterprisedt.bouncycastle.util.Objects;
import java.math.BigInteger;
import java.util.NoSuchElementException;

public final class Arrays {
    private Arrays() {
    }

    public static boolean areAllZeroes(byte[] buf, int off, int len) {
        int n2 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            n2 |= buf[off + i2];
        }
        return n2 == 0;
    }

    public static boolean areEqual(boolean[] a2, boolean[] b2) {
        return java.util.Arrays.equals(a2, b2);
    }

    public static boolean areEqual(byte[] a2, byte[] b2) {
        return java.util.Arrays.equals(a2, b2);
    }

    public static boolean areEqual(byte[] a2, int aFromIndex, int aToIndex, byte[] b2, int bFromIndex, int bToIndex) {
        int n2 = aToIndex - aFromIndex;
        int n3 = bToIndex - bFromIndex;
        if (n2 != n3) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (a2[aFromIndex + i2] == b2[bFromIndex + i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(char[] a2, char[] b2) {
        return java.util.Arrays.equals(a2, b2);
    }

    public static boolean areEqual(int[] a2, int[] b2) {
        return java.util.Arrays.equals(a2, b2);
    }

    public static boolean areEqual(long[] a2, long[] b2) {
        return java.util.Arrays.equals(a2, b2);
    }

    public static boolean areEqual(Object[] a2, Object[] b2) {
        return java.util.Arrays.equals(a2, b2);
    }

    public static boolean areEqual(short[] a2, short[] b2) {
        return java.util.Arrays.equals(a2, b2);
    }

    public static boolean constantTimeAreEqual(byte[] expected, byte[] supplied) {
        int n2;
        if (expected == null || supplied == null) {
            return false;
        }
        if (expected == supplied) {
            return true;
        }
        int n3 = expected.length < supplied.length ? expected.length : supplied.length;
        int n4 = expected.length ^ supplied.length;
        for (n2 = 0; n2 != n3; ++n2) {
            n4 |= expected[n2] ^ supplied[n2];
        }
        for (n2 = n3; n2 < supplied.length; ++n2) {
            n4 |= supplied[n2] ^ ~supplied[n2];
        }
        return n4 == 0;
    }

    public static boolean constantTimeAreEqual(int len, byte[] a2, int aOff, byte[] b2, int bOff) {
        if (null == a2) {
            throw new NullPointerException("'a' cannot be null");
        }
        if (null == b2) {
            throw new NullPointerException("'b' cannot be null");
        }
        if (len < 0) {
            throw new IllegalArgumentException("'len' cannot be negative");
        }
        if (aOff > a2.length - len) {
            throw new IndexOutOfBoundsException("'aOff' value invalid for specified length");
        }
        if (bOff > b2.length - len) {
            throw new IndexOutOfBoundsException("'bOff' value invalid for specified length");
        }
        int n2 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            n2 |= a2[aOff + i2] ^ b2[bOff + i2];
        }
        return 0 == n2;
    }

    public static boolean constantTimeAreEqual(char[] expected, char[] supplied) {
        int n2;
        if (expected == null || supplied == null) {
            return false;
        }
        if (expected == supplied) {
            return true;
        }
        int n3 = Math.min(expected.length, supplied.length);
        int n4 = expected.length ^ supplied.length;
        for (n2 = 0; n2 != n3; ++n2) {
            n4 |= expected[n2] ^ supplied[n2];
        }
        for (n2 = n3; n2 < supplied.length; ++n2) {
            n4 |= (byte)supplied[n2] ^ (byte)(~supplied[n2]);
        }
        return n4 == 0;
    }

    public static int compareUnsigned(byte[] a2, byte[] b2) {
        if (a2 == b2) {
            return 0;
        }
        if (a2 == null) {
            return -1;
        }
        if (b2 == null) {
            return 1;
        }
        int n2 = Math.min(a2.length, b2.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = a2[i2] & 0xFF;
            int n4 = b2[i2] & 0xFF;
            if (n3 < n4) {
                return -1;
            }
            if (n3 <= n4) continue;
            return 1;
        }
        if (a2.length < b2.length) {
            return -1;
        }
        if (a2.length > b2.length) {
            return 1;
        }
        return 0;
    }

    public static boolean contains(boolean[] a2, boolean val) {
        for (int i2 = 0; i2 < a2.length; ++i2) {
            if (a2[i2] != val) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(byte[] a2, byte val) {
        for (int i2 = 0; i2 < a2.length; ++i2) {
            if (a2[i2] != val) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(char[] a2, char val) {
        for (int i2 = 0; i2 < a2.length; ++i2) {
            if (a2[i2] != val) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(int[] a2, int val) {
        for (int i2 = 0; i2 < a2.length; ++i2) {
            if (a2[i2] != val) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(long[] a2, long val) {
        for (int i2 = 0; i2 < a2.length; ++i2) {
            if (a2[i2] != val) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(short[] a2, short val) {
        for (int i2 = 0; i2 < a2.length; ++i2) {
            if (a2[i2] != val) continue;
            return true;
        }
        return false;
    }

    public static void fill(boolean[] a2, boolean val) {
        java.util.Arrays.fill(a2, val);
    }

    public static void fill(boolean[] a2, int fromIndex, int toIndex, boolean val) {
        java.util.Arrays.fill(a2, fromIndex, toIndex, val);
    }

    public static void fill(byte[] a2, byte val) {
        java.util.Arrays.fill(a2, val);
    }

    public static void fill(byte[] a2, int fromIndex, int toIndex, byte val) {
        java.util.Arrays.fill(a2, fromIndex, toIndex, val);
    }

    public static void fill(char[] a2, char val) {
        java.util.Arrays.fill(a2, val);
    }

    public static void fill(char[] a2, int fromIndex, int toIndex, char val) {
        java.util.Arrays.fill(a2, fromIndex, toIndex, val);
    }

    public static void fill(int[] a2, int val) {
        java.util.Arrays.fill(a2, val);
    }

    public static void fill(int[] a2, int fromIndex, int toIndex, int val) {
        java.util.Arrays.fill(a2, fromIndex, toIndex, val);
    }

    public static void fill(long[] a2, long val) {
        java.util.Arrays.fill(a2, val);
    }

    public static void fill(long[] a2, int fromIndex, int toIndex, long val) {
        java.util.Arrays.fill(a2, fromIndex, toIndex, val);
    }

    public static void fill(Object[] a2, Object val) {
        java.util.Arrays.fill(a2, val);
    }

    public static void fill(Object[] a2, int fromIndex, int toIndex, Object val) {
        java.util.Arrays.fill(a2, fromIndex, toIndex, val);
    }

    public static void fill(short[] a2, short val) {
        java.util.Arrays.fill(a2, val);
    }

    public static void fill(short[] a2, int fromIndex, int toIndex, short val) {
        java.util.Arrays.fill(a2, fromIndex, toIndex, val);
    }

    public static int hashCode(byte[] data) {
        if (data == null) {
            return 0;
        }
        int n2 = data.length;
        int n3 = n2 + 1;
        while (--n2 >= 0) {
            n3 *= 257;
            n3 ^= data[n2];
        }
        return n3;
    }

    public static int hashCode(byte[] data, int off, int len) {
        if (data == null) {
            return 0;
        }
        int n2 = len;
        int n3 = n2 + 1;
        while (--n2 >= 0) {
            n3 *= 257;
            n3 ^= data[off + n2];
        }
        return n3;
    }

    public static int hashCode(char[] data) {
        if (data == null) {
            return 0;
        }
        int n2 = data.length;
        int n3 = n2 + 1;
        while (--n2 >= 0) {
            n3 *= 257;
            n3 ^= data[n2];
        }
        return n3;
    }

    public static int hashCode(int[][] ints) {
        int n2 = 0;
        for (int i2 = 0; i2 != ints.length; ++i2) {
            n2 = n2 * 257 + Arrays.hashCode(ints[i2]);
        }
        return n2;
    }

    public static int hashCode(int[] data) {
        if (data == null) {
            return 0;
        }
        int n2 = data.length;
        int n3 = n2 + 1;
        while (--n2 >= 0) {
            n3 *= 257;
            n3 ^= data[n2];
        }
        return n3;
    }

    public static int hashCode(int[] data, int off, int len) {
        if (data == null) {
            return 0;
        }
        int n2 = len;
        int n3 = n2 + 1;
        while (--n2 >= 0) {
            n3 *= 257;
            n3 ^= data[off + n2];
        }
        return n3;
    }

    public static int hashCode(long[] data) {
        if (data == null) {
            return 0;
        }
        int n2 = data.length;
        int n3 = n2 + 1;
        while (--n2 >= 0) {
            long l2 = data[n2];
            n3 *= 257;
            n3 ^= (int)l2;
            n3 *= 257;
            n3 ^= (int)(l2 >>> 32);
        }
        return n3;
    }

    public static int hashCode(long[] data, int off, int len) {
        if (data == null) {
            return 0;
        }
        int n2 = len;
        int n3 = n2 + 1;
        while (--n2 >= 0) {
            long l2 = data[off + n2];
            n3 *= 257;
            n3 ^= (int)l2;
            n3 *= 257;
            n3 ^= (int)(l2 >>> 32);
        }
        return n3;
    }

    public static int hashCode(short[][][] shorts) {
        int n2 = 0;
        for (int i2 = 0; i2 != shorts.length; ++i2) {
            n2 = n2 * 257 + Arrays.hashCode(shorts[i2]);
        }
        return n2;
    }

    public static int hashCode(short[][] shorts) {
        int n2 = 0;
        for (int i2 = 0; i2 != shorts.length; ++i2) {
            n2 = n2 * 257 + Arrays.hashCode(shorts[i2]);
        }
        return n2;
    }

    public static int hashCode(short[] data) {
        if (data == null) {
            return 0;
        }
        int n2 = data.length;
        int n3 = n2 + 1;
        while (--n2 >= 0) {
            n3 *= 257;
            n3 ^= data[n2] & 0xFF;
        }
        return n3;
    }

    public static int hashCode(Object[] data) {
        if (data == null) {
            return 0;
        }
        int n2 = data.length;
        int n3 = n2 + 1;
        while (--n2 >= 0) {
            n3 *= 257;
            n3 ^= Objects.hashCode(data[n2]);
        }
        return n3;
    }

    public static boolean[] clone(boolean[] data) {
        return null == data ? null : (boolean[])data.clone();
    }

    public static byte[] clone(byte[] data) {
        return null == data ? null : (byte[])data.clone();
    }

    public static char[] clone(char[] data) {
        return null == data ? null : (char[])data.clone();
    }

    public static int[] clone(int[] data) {
        return null == data ? null : (int[])data.clone();
    }

    public static long[] clone(long[] data) {
        return null == data ? null : (long[])data.clone();
    }

    public static short[] clone(short[] data) {
        return null == data ? null : (short[])data.clone();
    }

    public static BigInteger[] clone(BigInteger[] data) {
        return null == data ? null : (BigInteger[])data.clone();
    }

    public static byte[] clone(byte[] data, byte[] existing) {
        if (data == null) {
            return null;
        }
        if (existing == null || existing.length != data.length) {
            return Arrays.clone(data);
        }
        System.arraycopy(data, 0, existing, 0, existing.length);
        return existing;
    }

    public static long[] clone(long[] data, long[] existing) {
        if (data == null) {
            return null;
        }
        if (existing == null || existing.length != data.length) {
            return Arrays.clone(data);
        }
        System.arraycopy(data, 0, existing, 0, existing.length);
        return existing;
    }

    public static byte[][] clone(byte[][] data) {
        if (data == null) {
            return null;
        }
        byte[][] byArrayArray = new byte[data.length][];
        for (int i2 = 0; i2 != byArrayArray.length; ++i2) {
            byArrayArray[i2] = Arrays.clone(data[i2]);
        }
        return byArrayArray;
    }

    public static byte[][][] clone(byte[][][] data) {
        if (data == null) {
            return null;
        }
        byte[][][] byArrayArray = new byte[data.length][][];
        for (int i2 = 0; i2 != byArrayArray.length; ++i2) {
            byArrayArray[i2] = Arrays.clone(data[i2]);
        }
        return byArrayArray;
    }

    public static boolean[] copyOf(boolean[] original, int newLength) {
        boolean[] blArray = new boolean[newLength];
        System.arraycopy(original, 0, blArray, 0, Math.min(original.length, newLength));
        return blArray;
    }

    public static byte[] copyOf(byte[] original, int newLength) {
        byte[] byArray = new byte[newLength];
        System.arraycopy(original, 0, byArray, 0, Math.min(original.length, newLength));
        return byArray;
    }

    public static char[] copyOf(char[] original, int newLength) {
        char[] cArray = new char[newLength];
        System.arraycopy(original, 0, cArray, 0, Math.min(original.length, newLength));
        return cArray;
    }

    public static int[] copyOf(int[] original, int newLength) {
        int[] nArray = new int[newLength];
        System.arraycopy(original, 0, nArray, 0, Math.min(original.length, newLength));
        return nArray;
    }

    public static long[] copyOf(long[] original, int newLength) {
        long[] lArray = new long[newLength];
        System.arraycopy(original, 0, lArray, 0, Math.min(original.length, newLength));
        return lArray;
    }

    public static short[] copyOf(short[] original, int newLength) {
        short[] sArray = new short[newLength];
        System.arraycopy(original, 0, sArray, 0, Math.min(original.length, newLength));
        return sArray;
    }

    public static BigInteger[] copyOf(BigInteger[] original, int newLength) {
        BigInteger[] bigIntegerArray = new BigInteger[newLength];
        System.arraycopy(original, 0, bigIntegerArray, 0, Math.min(original.length, newLength));
        return bigIntegerArray;
    }

    public static boolean[] copyOfRange(boolean[] original, int from, int to) {
        int n2 = Arrays.a(from, to);
        boolean[] blArray = new boolean[n2];
        System.arraycopy(original, from, blArray, 0, Math.min(original.length - from, n2));
        return blArray;
    }

    public static byte[] copyOfRange(byte[] original, int from, int to) {
        int n2 = Arrays.a(from, to);
        byte[] byArray = new byte[n2];
        System.arraycopy(original, from, byArray, 0, Math.min(original.length - from, n2));
        return byArray;
    }

    public static char[] copyOfRange(char[] original, int from, int to) {
        int n2 = Arrays.a(from, to);
        char[] cArray = new char[n2];
        System.arraycopy(original, from, cArray, 0, Math.min(original.length - from, n2));
        return cArray;
    }

    public static int[] copyOfRange(int[] original, int from, int to) {
        int n2 = Arrays.a(from, to);
        int[] nArray = new int[n2];
        System.arraycopy(original, from, nArray, 0, Math.min(original.length - from, n2));
        return nArray;
    }

    public static long[] copyOfRange(long[] original, int from, int to) {
        int n2 = Arrays.a(from, to);
        long[] lArray = new long[n2];
        System.arraycopy(original, from, lArray, 0, Math.min(original.length - from, n2));
        return lArray;
    }

    public static short[] copyOfRange(short[] original, int from, int to) {
        int n2 = Arrays.a(from, to);
        short[] sArray = new short[n2];
        System.arraycopy(original, from, sArray, 0, Math.min(original.length - from, n2));
        return sArray;
    }

    public static BigInteger[] copyOfRange(BigInteger[] original, int from, int to) {
        int n2 = Arrays.a(from, to);
        BigInteger[] bigIntegerArray = new BigInteger[n2];
        System.arraycopy(original, from, bigIntegerArray, 0, Math.min(original.length - from, n2));
        return bigIntegerArray;
    }

    private static int a(int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw new IllegalArgumentException(n2 + " > " + n3);
        }
        return n4;
    }

    public static byte[] append(byte[] a2, byte b2) {
        if (a2 == null) {
            return new byte[]{b2};
        }
        int n2 = a2.length;
        byte[] byArray = new byte[n2 + 1];
        System.arraycopy(a2, 0, byArray, 0, n2);
        byArray[n2] = b2;
        return byArray;
    }

    public static short[] append(short[] a2, short b2) {
        if (a2 == null) {
            return new short[]{b2};
        }
        int n2 = a2.length;
        short[] sArray = new short[n2 + 1];
        System.arraycopy(a2, 0, sArray, 0, n2);
        sArray[n2] = b2;
        return sArray;
    }

    public static int[] append(int[] a2, int b2) {
        if (a2 == null) {
            return new int[]{b2};
        }
        int n2 = a2.length;
        int[] nArray = new int[n2 + 1];
        System.arraycopy(a2, 0, nArray, 0, n2);
        nArray[n2] = b2;
        return nArray;
    }

    public static String[] append(String[] a2, String b2) {
        if (a2 == null) {
            return new String[]{b2};
        }
        int n2 = a2.length;
        String[] stringArray = new String[n2 + 1];
        System.arraycopy(a2, 0, stringArray, 0, n2);
        stringArray[n2] = b2;
        return stringArray;
    }

    public static byte[] concatenate(byte[] a2, byte[] b2) {
        if (null == a2) {
            return Arrays.clone(b2);
        }
        if (null == b2) {
            return Arrays.clone(a2);
        }
        byte[] byArray = new byte[a2.length + b2.length];
        System.arraycopy(a2, 0, byArray, 0, a2.length);
        System.arraycopy(b2, 0, byArray, a2.length, b2.length);
        return byArray;
    }

    public static short[] concatenate(short[] a2, short[] b2) {
        if (null == a2) {
            return Arrays.clone(b2);
        }
        if (null == b2) {
            return Arrays.clone(a2);
        }
        short[] sArray = new short[a2.length + b2.length];
        System.arraycopy(a2, 0, sArray, 0, a2.length);
        System.arraycopy(b2, 0, sArray, a2.length, b2.length);
        return sArray;
    }

    public static byte[] concatenate(byte[] a2, byte[] b2, byte[] c2) {
        if (null == a2) {
            return Arrays.concatenate(b2, c2);
        }
        if (null == b2) {
            return Arrays.concatenate(a2, c2);
        }
        if (null == c2) {
            return Arrays.concatenate(a2, b2);
        }
        byte[] byArray = new byte[a2.length + b2.length + c2.length];
        int n2 = 0;
        System.arraycopy(a2, 0, byArray, n2, a2.length);
        System.arraycopy(b2, 0, byArray, n2 += a2.length, b2.length);
        System.arraycopy(c2, 0, byArray, n2 += b2.length, c2.length);
        return byArray;
    }

    public static byte[] concatenate(byte[] a2, byte[] b2, byte[] c2, byte[] d2) {
        if (null == a2) {
            return Arrays.concatenate(b2, c2, d2);
        }
        if (null == b2) {
            return Arrays.concatenate(a2, c2, d2);
        }
        if (null == c2) {
            return Arrays.concatenate(a2, b2, d2);
        }
        if (null == d2) {
            return Arrays.concatenate(a2, b2, c2);
        }
        byte[] byArray = new byte[a2.length + b2.length + c2.length + d2.length];
        int n2 = 0;
        System.arraycopy(a2, 0, byArray, n2, a2.length);
        System.arraycopy(b2, 0, byArray, n2 += a2.length, b2.length);
        System.arraycopy(c2, 0, byArray, n2 += b2.length, c2.length);
        System.arraycopy(d2, 0, byArray, n2 += c2.length, d2.length);
        return byArray;
    }

    public static byte[] concatenate(byte[][] arrays) {
        int n2 = 0;
        for (int i2 = 0; i2 != arrays.length; ++i2) {
            n2 += arrays[i2].length;
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (int i3 = 0; i3 != arrays.length; ++i3) {
            System.arraycopy(arrays[i3], 0, byArray, n3, arrays[i3].length);
            n3 += arrays[i3].length;
        }
        return byArray;
    }

    public static int[] concatenate(int[] a2, int[] b2) {
        if (null == a2) {
            return Arrays.clone(b2);
        }
        if (null == b2) {
            return Arrays.clone(a2);
        }
        int[] nArray = new int[a2.length + b2.length];
        System.arraycopy(a2, 0, nArray, 0, a2.length);
        System.arraycopy(b2, 0, nArray, a2.length, b2.length);
        return nArray;
    }

    public static byte[] prepend(byte[] a2, byte b2) {
        if (a2 == null) {
            return new byte[]{b2};
        }
        int n2 = a2.length;
        byte[] byArray = new byte[n2 + 1];
        System.arraycopy(a2, 0, byArray, 1, n2);
        byArray[0] = b2;
        return byArray;
    }

    public static short[] prepend(short[] a2, short b2) {
        if (a2 == null) {
            return new short[]{b2};
        }
        int n2 = a2.length;
        short[] sArray = new short[n2 + 1];
        System.arraycopy(a2, 0, sArray, 1, n2);
        sArray[0] = b2;
        return sArray;
    }

    public static int[] prepend(int[] a2, int b2) {
        if (a2 == null) {
            return new int[]{b2};
        }
        int n2 = a2.length;
        int[] nArray = new int[n2 + 1];
        System.arraycopy(a2, 0, nArray, 1, n2);
        nArray[0] = b2;
        return nArray;
    }

    public static byte[] reverse(byte[] a2) {
        if (a2 == null) {
            return null;
        }
        int n2 = 0;
        int n3 = a2.length;
        byte[] byArray = new byte[n3];
        while (--n3 >= 0) {
            byArray[n3] = a2[n2++];
        }
        return byArray;
    }

    public static int[] reverse(int[] a2) {
        if (a2 == null) {
            return null;
        }
        int n2 = 0;
        int n3 = a2.length;
        int[] nArray = new int[n3];
        while (--n3 >= 0) {
            nArray[n3] = a2[n2++];
        }
        return nArray;
    }

    public static void reverse(byte[] input, byte[] output) {
        int n2 = input.length - 1;
        for (int i2 = 0; i2 <= n2; ++i2) {
            output[i2] = input[n2 - i2];
        }
    }

    public static byte[] reverseInPlace(byte[] a2) {
        if (null == a2) {
            return null;
        }
        int n2 = 0;
        int n3 = a2.length - 1;
        while (n2 < n3) {
            byte by = a2[n2];
            byte by2 = a2[n3];
            a2[n2++] = by2;
            a2[n3--] = by;
        }
        return a2;
    }

    public static void reverseInPlace(byte[] a2, int aOff, int aLen) {
        int n2 = aOff;
        int n3 = aOff + aLen - 1;
        while (n2 < n3) {
            byte by = a2[n2];
            byte by2 = a2[n3];
            a2[n2++] = by2;
            a2[n3--] = by;
        }
    }

    public static short[] reverseInPlace(short[] a2) {
        if (null == a2) {
            return null;
        }
        int n2 = 0;
        int n3 = a2.length - 1;
        while (n2 < n3) {
            short s2 = a2[n2];
            short s3 = a2[n3];
            a2[n2++] = s3;
            a2[n3--] = s2;
        }
        return a2;
    }

    public static int[] reverseInPlace(int[] a2) {
        if (null == a2) {
            return null;
        }
        int n2 = 0;
        int n3 = a2.length - 1;
        while (n2 < n3) {
            int n4 = a2[n2];
            int n5 = a2[n3];
            a2[n2++] = n5;
            a2[n3--] = n4;
        }
        return a2;
    }

    public static void clear(byte[] data) {
        if (null != data) {
            java.util.Arrays.fill(data, (byte)0);
        }
    }

    public static void clear(int[] data) {
        if (null != data) {
            java.util.Arrays.fill(data, 0);
        }
    }

    public static boolean isNullOrContainsNull(Object[] array) {
        if (null == array) {
            return true;
        }
        int n2 = array.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (null != array[i2]) continue;
            return true;
        }
        return false;
    }

    public static boolean isNullOrEmpty(byte[] array) {
        return null == array || array.length < 1;
    }

    public static boolean isNullOrEmpty(int[] array) {
        return null == array || array.length < 1;
    }

    public static boolean isNullOrEmpty(Object[] array) {
        return null == array || array.length < 1;
    }

    public static class Iterator<T>
    implements java.util.Iterator<T> {
        private final T[] a;
        private int b = 0;

        public Iterator(T[] dataArray) {
            this.a = dataArray;
        }

        @Override
        public boolean hasNext() {
            return this.b < this.a.length;
        }

        @Override
        public T next() {
            if (this.b == this.a.length) {
                throw new NoSuchElementException("Out of elements: " + this.b);
            }
            return this.a[this.b++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove element from an Array.");
        }
    }
}

