/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.util;

public class IPAddress {
    public static boolean isValid(String address) {
        return IPAddress.isValidIPv4(address) || IPAddress.isValidIPv6(address);
    }

    public static boolean isValidWithNetMask(String address) {
        return IPAddress.isValidIPv4WithNetmask(address) || IPAddress.isValidIPv6WithNetmask(address);
    }

    public static boolean isValidIPv4(String address) {
        int n2 = address.length();
        if (n2 < 7 || n2 > 15) {
            return false;
        }
        int n3 = 0;
        for (int i2 = 0; i2 < 3; ++i2) {
            int n4 = address.indexOf(46, n3);
            if (!IPAddress.a(address, n3, n4)) {
                return false;
            }
            n3 = n4 + 1;
        }
        return IPAddress.a(address, n3, n2);
    }

    public static boolean isValidIPv4WithNetmask(String address) {
        int n2 = address.indexOf("/");
        if (n2 < 1) {
            return false;
        }
        String string = address.substring(0, n2);
        String string2 = address.substring(n2 + 1);
        return IPAddress.isValidIPv4(string) && (IPAddress.isValidIPv4(string2) || IPAddress.a(string2));
    }

    public static boolean isValidIPv6(String address) {
        int n2;
        if (address.length() == 0) {
            return false;
        }
        char c2 = address.charAt(0);
        if (c2 != ':' && Character.digit(c2, 16) < 0) {
            return false;
        }
        int n3 = 0;
        String string = address + ":";
        boolean bl = false;
        int n4 = 0;
        while (n4 < string.length() && (n2 = string.indexOf(58, n4)) >= n4) {
            if (n3 == 8) {
                return false;
            }
            if (n4 != n2) {
                String string2 = string.substring(n4, n2);
                if (n2 == string.length() - 1 && string2.indexOf(46) > 0) {
                    if (++n3 == 8) {
                        return false;
                    }
                    if (!IPAddress.isValidIPv4(string2)) {
                        return false;
                    }
                } else if (!IPAddress.b(string, n4, n2)) {
                    return false;
                }
            } else {
                if (n2 != 1 && n2 != string.length() - 1 && bl) {
                    return false;
                }
                bl = true;
            }
            n4 = n2 + 1;
            ++n3;
        }
        return n3 == 8 || bl;
    }

    public static boolean isValidIPv6WithNetmask(String address) {
        int n2 = address.indexOf("/");
        if (n2 < 1) {
            return false;
        }
        String string = address.substring(0, n2);
        String string2 = address.substring(n2 + 1);
        return IPAddress.isValidIPv6(string) && (IPAddress.isValidIPv6(string2) || IPAddress.b(string2));
    }

    private static boolean a(String string) {
        return IPAddress.a(string, 0, string.length(), 10, 2, false, 0, 32);
    }

    private static boolean a(String string, int n2, int n3) {
        return IPAddress.a(string, n2, n3, 10, 3, true, 0, 255);
    }

    private static boolean b(String string) {
        return IPAddress.a(string, 0, string.length(), 10, 3, false, 1, 128);
    }

    private static boolean b(String string, int n2, int n3) {
        return IPAddress.a(string, n2, n3, 16, 4, true, 0, 65535);
    }

    private static boolean a(String string, int n2, int n3, int n4, int n5, boolean bl, int n6, int n7) {
        int n8 = n3 - n2;
        if (n8 < 1 | n8 > n5) {
            return false;
        }
        boolean bl2 = n8 > 1 & !bl;
        if (bl2 && Character.digit(string.charAt(n2), n4) <= 0) {
            return false;
        }
        int n9 = 0;
        while (n2 < n3) {
            char c2;
            int n10;
            if ((n10 = Character.digit(c2 = string.charAt(n2++), n4)) < 0) {
                return false;
            }
            n9 *= n4;
            n9 += n10;
        }
        return n9 >= n6 & n9 <= n7;
    }
}

