/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.util.io.pem;

import com.enterprisedt.bouncycastle.util.Strings;
import com.enterprisedt.bouncycastle.util.encoders.Base64;
import com.enterprisedt.bouncycastle.util.io.pem.PemHeader;
import com.enterprisedt.bouncycastle.util.io.pem.PemObject;
import com.enterprisedt.bouncycastle.util.io.pem.PemObjectGenerator;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class PemWriter
extends BufferedWriter {
    private final int a;
    private char[] b = new char[64];

    public PemWriter(Writer out) {
        super(out);
        String string = Strings.lineSeparator();
        this.a = string != null ? string.length() : 2;
    }

    public int getOutputSize(PemObject obj) {
        int n2 = 2 * (obj.getType().length() + 10 + this.a) + 6 + 4;
        if (!obj.getHeaders().isEmpty()) {
            for (PemHeader pemHeader : obj.getHeaders()) {
                n2 += pemHeader.getName().length() + ": ".length() + pemHeader.getValue().length() + this.a;
            }
            n2 += this.a;
        }
        int n3 = (obj.getContent().length + 2) / 3 * 4;
        return n2 += n3 + (n3 + 64 - 1) / 64 * this.a;
    }

    public void writeObject(PemObjectGenerator objGen) throws IOException {
        PemObject pemObject = objGen.generate();
        this.a(pemObject.getType());
        if (!pemObject.getHeaders().isEmpty()) {
            for (PemHeader pemHeader : pemObject.getHeaders()) {
                this.write(pemHeader.getName());
                this.write(": ");
                this.write(pemHeader.getValue());
                this.newLine();
            }
            this.newLine();
        }
        this.a(pemObject.getContent());
        this.b(pemObject.getType());
    }

    private void a(byte[] byArray) throws IOException {
        byArray = Base64.encode(byArray);
        for (int i2 = 0; i2 < byArray.length; i2 += this.b.length) {
            int n2;
            for (n2 = 0; n2 != this.b.length && i2 + n2 < byArray.length; ++n2) {
                this.b[n2] = (char)byArray[i2 + n2];
            }
            this.write(this.b, 0, n2);
            this.newLine();
        }
    }

    private void a(String string) throws IOException {
        this.write("-----BEGIN " + string + "-----");
        this.newLine();
    }

    private void b(String string) throws IOException {
        this.write("-----END " + string + "-----");
        this.newLine();
    }
}

