/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.rsa;

import com.enterprisedt.cryptix.CryptixException;
import com.enterprisedt.cryptix.provider.rsa.RSAAlgorithm;
import com.enterprisedt.cryptix.util.core.Debug;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import xjava.security.interfaces.RSAFactors;
import xjava.security.interfaces.RSAKey;

public abstract class Any_RSA_PKCS1Signature
extends Signature {
    private static final boolean a = Debug.GLOBAL_DEBUG;
    private static final int b = a ? Debug.getLevel("RSA", "Any_RSA_PKCS1Signature") : 0;
    private BigInteger c;
    private BigInteger d;
    private BigInteger e;
    private BigInteger f;
    private BigInteger g;
    public MessageDigest md;

    protected Any_RSA_PKCS1Signature(String mdAlgorithm) {
        super(mdAlgorithm + "/RSA/PKCS#1");
        try {
            this.md = MessageDigest.getInstance(mdAlgorithm, "CryptixEDT");
        }
        catch (Exception exception) {
            throw new CryptixException(this.getAlgorithm() + ": Unable to instantiate the " + mdAlgorithm + " MessageDigest\n" + exception);
        }
    }

    @Override
    protected void engineInitSign(PrivateKey key) throws InvalidKeyException {
        Object object;
        if (key instanceof RSAPrivateKey) {
            object = (RSAPrivateKey)key;
            this.c = object.getModulus();
            this.d = object.getPrivateExponent();
        } else if (key instanceof RSAKey) {
            object = (RSAKey)((Object)key);
            this.c = object.getModulus();
            this.d = object.getExponent();
        } else {
            throw new InvalidKeyException(this.getAlgorithm() + ": " + key.getClass().getName() + " is not an RSA private key - ");
        }
        if (key instanceof RSAFactors) {
            object = (RSAFactors)((Object)key);
            this.e = object.getP();
            this.f = object.getQ();
            this.g = object.getInverseOfQModP();
        }
        this.md.reset();
        int n2 = this.md.digest().length;
        int n3 = (this.c.bitLength() + 7) / 8;
        int n4 = this.getAlgorithmEncoding().length;
        int n5 = n3 - 3 - n4 - n2;
        if (n5 < 0) {
            throw new InvalidKeyException("Signer's public key modulus too short.");
        }
    }

    @Override
    protected void engineInitVerify(PublicKey key) throws InvalidKeyException {
        Object object;
        if (key instanceof RSAPublicKey) {
            object = (RSAPublicKey)key;
            this.c = object.getModulus();
            this.d = object.getPublicExponent();
        } else if (key instanceof RSAKey) {
            object = (RSAKey)((Object)key);
            this.c = object.getModulus();
            this.d = object.getExponent();
        } else {
            throw new InvalidKeyException(this.getAlgorithm() + ": " + key.getClass().getName() + " is not an RSA public key - ");
        }
        if (key instanceof RSAFactors) {
            object = (RSAFactors)((Object)key);
            this.e = object.getP();
            this.f = object.getQ();
            this.g = object.getInverseOfQModP();
        }
        this.md.reset();
        int n2 = this.md.digest().length;
        int n3 = (this.c.bitLength() + 7) / 8;
        int n4 = this.getAlgorithmEncoding().length;
        int n5 = n3 - 3 - n4 - n2;
        if (n5 < 0) {
            throw new InvalidKeyException("Signer's public key modulus too short.");
        }
    }

    @Override
    protected void engineUpdate(byte b2) throws SignatureException {
        this.md.update(b2);
    }

    @Override
    protected void engineUpdate(byte[] in, int offset, int length) throws SignatureException {
        this.md.update(in, offset, length);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        BigInteger bigInteger = this.a();
        BigInteger bigInteger2 = RSAAlgorithm.rsa(bigInteger, this.c, this.d, this.e, this.f, this.g);
        return this.sigToBytes(bigInteger2);
    }

    @Override
    protected boolean engineVerify(byte[] signature) throws SignatureException {
        BigInteger bigInteger = new BigInteger(1, signature);
        BigInteger bigInteger2 = RSAAlgorithm.rsa(bigInteger, this.c, this.d, this.e, this.f, this.g);
        BigInteger bigInteger3 = this.a();
        boolean bl = bigInteger2.equals(bigInteger3);
        return bl;
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new InvalidParameterException(this.getAlgorithm() + ": " + param);
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new InvalidParameterException(this.getAlgorithm() + ": " + param);
    }

    private BigInteger a() throws SignatureException {
        byte[] byArray = this.md.digest();
        int n2 = byArray.length;
        int n3 = (this.c.bitLength() + 7) / 8;
        byte[] byArray2 = new byte[n3];
        byArray2[0] = 0;
        byArray2[1] = 1;
        byte[] byArray3 = this.getAlgorithmEncoding();
        int n4 = byArray3.length;
        int n5 = n3 - 3 - n4 - n2;
        if (n5 < 0) {
            throw new SignatureException("Signer's public key modulus too short.");
        }
        int n6 = 0;
        while (n6 < n5) {
            byArray2[2 + n6++] = -1;
        }
        System.arraycopy(byArray3, 0, byArray2, n5 + 3, n4);
        System.arraycopy(byArray, 0, byArray2, n3 - n2, n2);
        return new BigInteger(byArray2);
    }

    protected byte[] sigToBytes(BigInteger num) {
        int n2;
        byte[] byArray = num.toByteArray();
        if (byArray.length == (n2 = this.b())) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        if (byArray.length < n2) {
            int n3;
            for (n3 = 0; n3 < n2 - byArray.length; ++n3) {
                byArray2[n3] = 0;
            }
            System.arraycopy(byArray, 0, byArray2, n3, byArray.length);
        } else {
            int n4;
            for (n4 = 0; n4 < byArray.length - n2; ++n4) {
                if (byArray[n4] == 0) continue;
                throw new InternalError("RSA signature error");
            }
            System.arraycopy(byArray, n4, byArray2, 0, n2);
        }
        return byArray2;
    }

    private int b() {
        int n2 = this.c.bitLength() / 8;
        return n2 += this.c.bitLength() % 8 > 0 ? 1 : 0;
    }

    protected abstract byte[] getAlgorithmEncoding();
}

