/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.Protocol;
import com.enterprisedt.net.ftp.async.AsyncCallback;
import com.enterprisedt.net.ftp.async.AsyncResult;
import com.enterprisedt.net.ftp.async.ConnectResult;
import com.enterprisedt.net.ftp.async.DisconnectResult;
import com.enterprisedt.net.ftp.async.ErrorListener;
import com.enterprisedt.net.ftp.async.internal.ConnectFTPSETask;
import com.enterprisedt.net.ftp.async.internal.ConnectFTPSITask;
import com.enterprisedt.net.ftp.async.internal.ConnectFTPTask;
import com.enterprisedt.net.ftp.async.internal.ConnectSCPTask;
import com.enterprisedt.net.ftp.async.internal.ConnectSFTPTask;
import com.enterprisedt.net.ftp.async.internal.ConnectTask;
import com.enterprisedt.net.ftp.async.internal.ConnectionException;
import com.enterprisedt.net.ftp.async.internal.DisconnectTask;
import com.enterprisedt.net.ftp.async.internal.FTPConnection;
import com.enterprisedt.net.ftp.async.internal.FTPConnectionPool;
import com.enterprisedt.net.ftp.async.internal.SecureConnectionContext;
import com.enterprisedt.net.ftp.async.internal.Task;
import com.enterprisedt.net.ftp.async.internal.TaskState;
import com.enterprisedt.net.ftp.async.internal.TaskType;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class FTPTaskProcessor {
    protected static Logger log = Logger.getLogger("FTPTaskProcessor");
    protected int staleTime = 15;
    protected int maxIdleTime = 600;
    private int a = 0;
    private b[] b = null;
    private FTPReply c;
    protected SecureConnectionContext masterContext = null;
    protected Hashtable threadContexts = new Hashtable();
    protected Vector taskQueue = null;
    private Vector d = new Vector();
    protected AsyncCallback.Disconnect disconnectCallback;
    protected boolean shutdown = true;
    protected FTPConnectionPool pool;
    protected a keepAlive = null;

    public FTPTaskProcessor(int nThreads, FTPConnectionPool pool, SecureConnectionContext masterContext) {
        this.a = nThreads;
        this.pool = pool;
        this.masterContext = masterContext;
        this.taskQueue = new Vector();
    }

    public void start() {
        this.shutdown = false;
        this.b = new b[this.a];
        for (int i2 = 0; i2 < this.a; ++i2) {
            this.b[i2] = new b("FTPThread_edt_" + i2);
            this.b[i2].start();
        }
    }

    void a() {
        if (this.keepAlive == null) {
            log.info("Starting FTPKeepAlive thread");
            this.keepAlive = new a("FTPKeepAlive", this.masterContext.getTimeout());
            this.keepAlive.start();
        }
    }

    public FTPReply getLastReply() {
        return this.c;
    }

    public int getThreadCount() {
        return this.a;
    }

    FTPConnectionPool b() {
        return this.pool;
    }

    public SecureConnectionContext getMasterContext() {
        return this.masterContext;
    }

    public void setDisconnectCallback(AsyncCallback.Disconnect callback) {
        this.disconnectCallback = callback;
    }

    public AsyncCallback.Disconnect getDisconnectCallback() {
        return this.disconnectCallback;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTasks() {
        Vector vector = this.taskQueue;
        synchronized (vector) {
            this.taskQueue.removeAllElements();
        }
    }

    public void shutdown(boolean immediate) {
        if (this.shutdown) {
            log.warn("Task processor already shutdown");
            return;
        }
        log.debug("shutdown(" + immediate + ") called");
        this.shutdown = true;
        this.clearTasks();
        this.threadContexts.clear();
        if (this.keepAlive != null) {
            log.debug("Interrupting keepalive thread");
            this.keepAlive.interrupt();
            try {
                this.keepAlive.join();
            }
            catch (InterruptedException interruptedException) {
                log.warn("join() interrupted in shutdown", interruptedException);
            }
            this.keepAlive = null;
        }
        if (immediate) {
            for (int i2 = 0; i2 < this.b.length; ++i2) {
                if (this.b[i2].getName().equals(Thread.currentThread().getName())) continue;
                log.debug("Interrupting " + this.b[i2].getName());
                this.b[i2].interrupt();
            }
        }
        for (int i3 = 0; i3 < this.b.length; ++i3) {
            try {
                if (this.b[i3].getName().equals(Thread.currentThread().getName())) continue;
                log.debug("Waiting for " + this.b[i3].getName() + " to terminate");
                this.b[i3].join();
                log.debug(this.b[i3].getName() + " has terminated");
                continue;
            }
            catch (InterruptedException interruptedException) {
                log.warn("join() interrupted in shutdown", interruptedException);
            }
        }
        log.debug("FTPThreadPool shutdown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Task t2) {
        if (this.shutdown) {
            String string = "FTPThreadPool shutdown - cannot add task " + t2.getId();
            log.error(string);
            throw new RuntimeException(string);
        }
        this.a(t2, this.masterContext);
        Vector vector = this.taskQueue;
        synchronized (vector) {
            this.taskQueue.addElement(t2);
            this.taskQueue.notifyAll();
        }
        log.debug("Added task " + t2.getId() + " to the queue for processing");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Task task, SecureConnectionContext secureConnectionContext) {
        SecureConnectionContext secureConnectionContext2;
        SecureConnectionContext secureConnectionContext3 = secureConnectionContext2 = this.getApplicableContext();
        synchronized (secureConnectionContext3) {
            task.setContext((SecureConnectionContext)secureConnectionContext2.clone());
        }
    }

    public boolean inTaskThread() {
        String string = Thread.currentThread().getName();
        return this.threadContexts.get(string) != null;
    }

    public SecureConnectionContext getApplicableContext() {
        SecureConnectionContext secureConnectionContext = null;
        String string = Thread.currentThread().getName();
        secureConnectionContext = (SecureConnectionContext)this.threadContexts.get(string);
        if (secureConnectionContext == null) {
            log.debug("Using the master context");
            secureConnectionContext = this.masterContext;
        } else {
            log.debug("Using the current thread context");
        }
        return secureConnectionContext;
    }

    public void addErrorListener(ErrorListener listener) {
        this.d.addElement(listener);
    }

    void a(AsyncResult asyncResult, Throwable throwable) {
        log.warn("Exception thrown in callback: " + throwable.getMessage(), throwable);
        for (int i2 = 0; i2 < this.d.size(); ++i2) {
            ErrorListener errorListener = (ErrorListener)this.d.elementAt(i2);
            try {
                errorListener.onError(asyncResult, throwable);
                continue;
            }
            catch (Throwable throwable2) {
                log.warn("Exception thrown in error handler ignored", throwable2);
            }
        }
    }

    protected FTPConnection createConnection() throws ConnectionException {
        FTPConnection fTPConnection = null;
        try {
            fTPConnection = this.pool.createConnection();
        }
        catch (Exception exception) {
            String string = "Failed to create a connection";
            log.error(string, exception);
            throw new ConnectionException(string);
        }
        ConnectResult connectResult = new ConnectResult();
        ConnectTask connectTask = this.createConnectTask(connectResult);
        this.a(connectTask, this.masterContext);
        ((Task)connectTask).run(fTPConnection);
        if (!connectResult.isSuccessful()) {
            throw new ConnectionException("Failed to obtain a connection");
        }
        log.debug("Connection created");
        return fTPConnection;
    }

    protected ConnectTask createConnectTask(ConnectResult result) throws ConnectionException {
        Protocol protocol = this.masterContext.getProtocol();
        if (protocol.equals(Protocol.FTP)) {
            return new ConnectFTPTask(this, result, new ReconnectCallback());
        }
        if (protocol.equals(Protocol.SFTP)) {
            return new ConnectSFTPTask(this, result, new ReconnectCallback());
        }
        if (protocol.equals(Protocol.SCP)) {
            return new ConnectSCPTask(this, result, new ReconnectCallback());
        }
        if (protocol.equals(Protocol.FTPS_EXPLICIT)) {
            return new ConnectFTPSETask(this, result, new ReconnectCallback());
        }
        if (protocol.equals(Protocol.FTPS_IMPLICIT)) {
            return new ConnectFTPSITask(this, result, new ReconnectCallback());
        }
        throw new ConnectionException("Unknown protocol: " + protocol.toString());
    }

    protected class ReconnectCallback
    implements AsyncCallback.Connect {
        protected ReconnectCallback() {
        }

        @Override
        public void onConnect(ConnectResult cr) throws FTPException, IOException {
            log.debug("Reconnection succeeded");
            cr.notifyComplete();
            cr.endAsync();
        }
    }

    class a
    extends Thread {
        private int b;

        a(String string, int n2) {
            super(string);
            this.b = 30000;
            if (this.b * 2 > n2 && n2 > 0) {
                this.b = n2 / 2;
            }
            log.debug("KeepAlive sleeptime=" + this.b);
        }

        private void a(int n2) {
            FTPTaskProcessor.this.pool.disconnect(false);
            if (FTPTaskProcessor.this.disconnectCallback != null) {
                try {
                    DisconnectResult disconnectResult = new DisconnectResult(false);
                    disconnectResult.setAsIfCompleted();
                    disconnectResult.setReason(n2);
                    FTPTaskProcessor.this.disconnectCallback.onDisconnect(disconnectResult);
                }
                catch (Exception exception) {
                    log.error("Error calling disconnect callback: " + exception.getMessage(), exception);
                }
            }
        }

        @Override
        public void run() {
            while (!FTPTaskProcessor.this.shutdown && FTPTaskProcessor.this.pool.isConnected()) {
                long l2 = FTPTaskProcessor.this.pool.getLastUsedTime();
                if (l2 + (long)(FTPTaskProcessor.this.maxIdleTime * 1000) < System.currentTimeMillis()) {
                    log.warn("Idle time has exceeded the maximum (" + FTPTaskProcessor.this.maxIdleTime + " s) - disconnecting");
                    this.a(1);
                    break;
                }
                FTPConnection fTPConnection = null;
                try {
                    fTPConnection = FTPTaskProcessor.this.pool.getFreeConnection();
                }
                catch (ConnectionException connectionException) {
                    log.warn("Failed to get connection from pool", connectionException);
                }
                if (FTPTaskProcessor.this.shutdown) {
                    log.debug("Shutting down " + this.getName());
                    break;
                }
                if (fTPConnection != null) {
                    block14: {
                        boolean bl = false;
                        long l3 = Math.max(fTPConnection.getLastUsedTime(), fTPConnection.getLastWokenTime());
                        if (l3 + (long)(FTPTaskProcessor.this.staleTime * 1000) < System.currentTimeMillis()) {
                            log.debug("Calling keepAlive() on stale connection " + fTPConnection.toString() + " (maxtime=" + l3 + ")");
                            if (!fTPConnection.isConnected()) {
                                FTPTaskProcessor.this.pool.clearConnection(fTPConnection);
                                if (FTPTaskProcessor.this.pool.getCurrentPoolSize() < FTPTaskProcessor.this.pool.getInitialPoolSize()) {
                                    log.debug("Creating new connection to replace trashed connection");
                                    try {
                                        fTPConnection = null;
                                        fTPConnection = FTPTaskProcessor.this.createConnection();
                                        break block14;
                                    }
                                    catch (Exception exception) {
                                        log.error("Failed to create new connection - disconnecting", exception);
                                        this.a(2);
                                        break;
                                    }
                                }
                                log.debug("Pool size sufficient - not replacing trashed connection (yet)");
                            }
                        }
                    }
                    if (fTPConnection != null) {
                        FTPTaskProcessor.this.pool.freeConnection(fTPConnection);
                    }
                }
                try {
                    log.debug("Keep alive thread: sleeping for " + this.b + " ms");
                    com.enterprisedt.net.ftp.async.internal.FTPTaskProcessor$a.sleep(this.b);
                }
                catch (InterruptedException interruptedException) {}
            }
            log.debug("Exiting FTPKeepAlive thread");
        }
    }

    class b
    extends Thread {
        b(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!FTPTaskProcessor.this.shutdown) {
                Task task;
                Object object = FTPTaskProcessor.this.taskQueue;
                synchronized (object) {
                    while (FTPTaskProcessor.this.taskQueue.isEmpty() && !FTPTaskProcessor.this.shutdown) {
                        try {
                            FTPTaskProcessor.this.taskQueue.wait(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            log.debug("Interrupted " + this.getName());
                        }
                    }
                    if (FTPTaskProcessor.this.shutdown) {
                        log.debug("Shutting down " + this.getName());
                        break;
                    }
                    task = (Task)FTPTaskProcessor.this.taskQueue.elementAt(0);
                    FTPTaskProcessor.this.taskQueue.removeElementAt(0);
                }
                object = null;
                boolean bl = false;
                try {
                    log.info("Processing task " + task.toString());
                    if (task.getState().equals(TaskState.DISCARDED_STATE)) {
                        log.debug("Task " + task.toString() + " is discarded - not running");
                        continue;
                    }
                    FTPTaskProcessor.this.threadContexts.put(this.getName(), task.getContext());
                    boolean bl2 = false;
                    try {
                        if (task.getTaskType().equals(TaskType.a)) {
                            object = FTPTaskProcessor.this.pool.createConnection();
                        } else if (task.getTaskType().equals(TaskType.b)) {
                            bl2 = true;
                        } else {
                            object = FTPTaskProcessor.this.pool.getConnection();
                            if (object != null && !((FTPConnection)object).isConnected()) {
                                log.debug("Invalid connection retrieved - clearing");
                                FTPTaskProcessor.this.pool.clearConnection((FTPConnection)object);
                                object = null;
                            }
                            if (object == null) {
                                log.debug("Creating new connection");
                                object = FTPTaskProcessor.this.createConnection();
                            }
                            task.getContext().checkCompatible(((FTPConnection)object).getContext());
                        }
                    }
                    catch (Throwable throwable) {
                        task.setFailed(throwable);
                        throw throwable;
                    }
                    try {
                        task.run((FTPConnection)object);
                    }
                    finally {
                        if (task.getTaskCallback() != null) {
                            task.getTaskCallback().onComplete(task);
                        }
                        if (object != null && !((FTPConnection)object).getContext().getProtocol().equals(Protocol.SFTP) && !((FTPConnection)object).getContext().getProtocol().equals(Protocol.SCP)) {
                            FTPTaskProcessor.this.c = ((FTPClient)((Object)((FTPConnection)object).getClient())).getLastReply();
                        }
                    }
                    log.info("Processed task " + task.toString());
                    if (!bl2 || FTPTaskProcessor.this.disconnectCallback == null) continue;
                    AsyncCallback.Disconnect disconnect = ((DisconnectTask)task).getCallback();
                    if (disconnect != FTPTaskProcessor.this.disconnectCallback) {
                        log.debug("Notifying disconnect callback");
                        task.getResult().setLocalContext(task.getContext());
                        FTPTaskProcessor.this.disconnectCallback.onDisconnect((DisconnectResult)task.getResult());
                        task.getResult().setLocalContext(null);
                        continue;
                    }
                    log.debug("Disconnect callback == task callback: not renotifying");
                }
                catch (com.enterprisedt.net.ftp.async.internal.a a2) {
                    log.error("FTPThread[" + this.getName() + "] - task " + task.toString() + " failed", a2);
                    bl = true;
                }
                catch (Throwable throwable) {
                    log.error("FTPThread[" + this.getName() + "] - task " + task.toString() + " failed", throwable);
                    bl = true;
                    FTPTaskProcessor.this.a(task.getResult(), throwable);
                }
                finally {
                    FTPTaskProcessor.this.threadContexts.remove(this.getName());
                    if (object != null) {
                        if (bl) {
                            FTPTaskProcessor.this.pool.clearConnection((FTPConnection)object);
                            log.info("Cleared connection for task " + task.getId());
                        } else {
                            FTPTaskProcessor.this.pool.freeConnection((FTPConnection)object);
                            FTPTaskProcessor.this.pool.markConnectionAsFresh((FTPConnection)object);
                            log.info("Freed connection for task " + task.getId());
                        }
                    }
                    log.info("Task " + task.getId() + " complete (FTPThread[" + this.getName() + "])");
                }
            }
            log.info("FTPThread[" + this.getName() + "] exiting");
        }
    }
}

