/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.WildcardFilter;
import com.enterprisedt.net.ftp.async.AsyncCallback;
import com.enterprisedt.net.ftp.async.UploadMultipleResult;
import com.enterprisedt.net.ftp.async.internal.FTPConnection;
import com.enterprisedt.net.ftp.async.internal.FTPTaskProcessor;
import com.enterprisedt.net.ftp.async.internal.MultipleTransferTask;
import com.enterprisedt.net.ftp.async.internal.TaskState;
import com.enterprisedt.net.ftp.async.internal.TaskType;
import com.enterprisedt.util.debug.Logger;
import java.io.FileFilter;

public class UploadMultipleTask
extends MultipleTransferTask {
    private static Logger a = Logger.getLogger("UploadMultipleTask");
    private AsyncCallback.UploadMultiple b;
    private UploadMultipleResult c;

    public UploadMultipleTask(FTPTaskProcessor taskProcessor, UploadMultipleResult result, AsyncCallback.UploadMultiple callback) {
        super(taskProcessor, result, TaskType.n);
        this.b = callback;
        this.c = result;
    }

    @Override
    public String toString() {
        return this.getId() + ":" + this.getTaskType().getName() + "[" + this.c.getLocalDir() + "=>" + this.c.getRemoteDir() + "]";
    }

    @Override
    public void run(FTPConnection conn) {
        this.setState(TaskState.RUNNING_STATE);
        try {
            this.configureConnection(conn);
            if (!this.getState().equals(TaskState.RUNNING_STATE)) {
                a.debug("Task cancelled [" + this.toString() + "]");
            } else {
                this.setupProgressMonitoring(this.c.getNotifyInterval());
                this.configureMultipleUploads(conn);
                FileFilter fileFilter = this.c.getFilter();
                if (fileFilter == null && this.c.getWildcard() != null) {
                    fileFilter = new WildcardFilter(this.c.getWildcard());
                }
                conn.getClient().mput(this.c.getLocalDir(), this.c.getRemoteDir(), fileFilter, this.c.isRecursive());
                this.c.setSuccessful(true);
                this.setState(TaskState.COMPLETED_SUCCESS_STATE);
                conn.setLastUsedTime(System.currentTimeMillis());
            }
        }
        catch (Throwable throwable) {
            a.error(this.toString() + " failed", throwable);
            this.c.setThrowable(throwable);
            this.setState(TaskState.COMPLETED_FAILURE_STATE);
        }
        this.c.notifyComplete();
        this.c.setLocalContext(this.getContext());
        if (this.b != null) {
            try {
                this.b.onUploadMultiple(this.c);
            }
            catch (Throwable throwable) {
                this.taskProcessor.a(this.c, throwable);
            }
        }
        this.c.setLocalContext(this.getContext());
        try {
            if (!this.c.endAsyncCalled()) {
                this.c.endAsync();
            }
        }
        catch (Throwable throwable) {
            this.taskProcessor.a(this.c, throwable);
        }
    }
}

