/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPOutputStream;
import com.enterprisedt.net.ftp.FTPProgressMonitorEx;
import com.enterprisedt.net.ftp.FileTransferOutputStream;
import com.enterprisedt.net.ftp.Protocol;
import com.enterprisedt.net.ftp.TransferDirection;
import com.enterprisedt.net.ftp.WriteMode;
import com.enterprisedt.net.ftp.async.AsyncCallback;
import com.enterprisedt.net.ftp.async.UploadStreamResult;
import com.enterprisedt.net.ftp.async.internal.FTPConnection;
import com.enterprisedt.net.ftp.async.internal.FTPTaskProcessor;
import com.enterprisedt.net.ftp.async.internal.SingleTransferTask;
import com.enterprisedt.net.ftp.async.internal.TaskState;
import com.enterprisedt.net.ftp.async.internal.TaskType;
import com.enterprisedt.net.ftp.ssh.SSHFTPClient;
import com.enterprisedt.net.ftp.ssh.SSHFTPOutputStream;
import com.enterprisedt.util.debug.Logger;

public class UploadStreamTask
extends SingleTransferTask
implements FTPProgressMonitorEx {
    private static Logger a = Logger.getLogger("UploadStreamTask");
    private AsyncCallback.UploadStream b;
    private UploadStreamResult c;
    private Object d = new Object();
    private boolean e = false;

    public UploadStreamTask(FTPTaskProcessor taskProcessor, UploadStreamResult result, AsyncCallback.UploadStream callback) {
        super(taskProcessor, result, TaskType.c);
        this.b = callback;
        this.c = result;
    }

    @Override
    public String toString() {
        return this.getId() + ":" + this.getTaskType().getName() + "[stream => " + this.c.getRemoteFileName() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(FTPConnection conn) {
        block18: {
            this.setState(TaskState.RUNNING_STATE);
            try {
                Object object;
                this.configureConnection(conn);
                if (!this.getState().equals(TaskState.RUNNING_STATE)) {
                    a.debug("Task cancelled [" + this.toString() + "]");
                    break block18;
                }
                this.setupProgressMonitoring(this.c.getNotifyInterval());
                boolean bl = this.c.getWriteMode().equals(WriteMode.APPEND);
                FileTransferOutputStream fileTransferOutputStream = null;
                if (this.getContext().getProtocol().equals(Protocol.SFTP)) {
                    object = new SSHFTPOutputStream((SSHFTPClient)conn.getClient(), conn.convertPath(this.c.getRemoteFileName()), bl);
                    ((SSHFTPOutputStream)object).setMonitor(this, conn.getClient().getMonitorInterval());
                    fileTransferOutputStream = object;
                } else {
                    object = new FTPOutputStream((FTPClient)((Object)conn.getClient()), conn.convertPath(this.c.getRemoteFileName()), bl);
                    ((FTPOutputStream)object).setMonitor(this, conn.getClient().getMonitorInterval());
                    fileTransferOutputStream = object;
                }
                ((UploadStreamResult)this.result).setOutputStream(fileTransferOutputStream);
                this.result.setLocalContext(this.getContext());
                if (this.b != null) {
                    this.b.onUploadingStream(fileTransferOutputStream, this.c);
                }
                object = this.d;
                synchronized (object) {
                    try {
                        if (!this.e) {
                            a.debug("Waiting until stream transfer complete");
                            this.d.wait();
                            a.debug("Lock released");
                        }
                        this.result.setSuccessful(true);
                        this.setState(TaskState.COMPLETED_SUCCESS_STATE);
                    }
                    catch (InterruptedException interruptedException) {
                        a.error("Wait for task completion", interruptedException);
                    }
                }
                conn.setLastUsedTime(System.currentTimeMillis());
            }
            catch (Throwable throwable) {
                a.error(this.toString() + " failed (releasing lock)", throwable);
                this.result.setThrowable(throwable);
                this.setState(TaskState.COMPLETED_FAILURE_STATE);
                ((UploadStreamResult)this.result).setOutputStreamFailure(throwable);
            }
        }
        this.result.notifyComplete();
        if (this.b != null) {
            try {
                this.b.onUploadStream(this.c);
            }
            catch (Throwable throwable) {
                this.taskProcessor.a(this.result, throwable);
            }
        }
        this.result.setLocalContext(null);
        try {
            if (!this.c.endAsyncCalled()) {
                this.c.endAsync();
            }
        }
        catch (Throwable throwable) {
            this.taskProcessor.a(this.result, throwable);
        }
    }

    @Override
    public void transferStarted(TransferDirection direction, String remoteFile) {
        a.debug("Stream transfer started [" + remoteFile + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferComplete(TransferDirection direction, String remoteFile) {
        Object object = this.d;
        synchronized (object) {
            a.debug("Stream transfer complete - notifying task [" + remoteFile + "]");
            this.e = true;
            this.d.notifyAll();
        }
    }
}

