/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.ssh;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPProgressMonitorEx;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileTransferOutputStream;
import com.enterprisedt.net.ftp.TransferDirection;
import com.enterprisedt.net.ftp.ssh.SSHFTPClient;
import com.enterprisedt.net.j2ssh.SftpClient;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedOutputStream;
import java.io.IOException;

public class SSHFTPOutputStream
extends FileTransferOutputStream {
    private static Logger a = Logger.getLogger("SFTPOutputStream");
    private final byte[] b;
    private long c;
    private SSHFTPClient d;
    private SftpClient e;
    private BufferedOutputStream f;
    private boolean g = false;
    private long h = 0L;
    private FTPProgressMonitor i;
    private FTPProgressMonitorEx j;
    private byte[] k = new byte[SftpClient.FTP_LINE_SEPARATOR.length];
    private int l = 0;

    public SSHFTPOutputStream(SSHFTPClient client, String remoteFile) throws IOException, FTPException {
        this(client, remoteFile, false);
    }

    public SSHFTPOutputStream(SSHFTPClient client, String remoteFile, boolean append) throws IOException, FTPException {
        this.d = client;
        this.remoteFile = remoteFile;
        this.e = client.a();
        this.g = client.getType().equals(FTPTransferType.ASCII);
        this.b = client.getDetectedRemoteEOL().getBytes();
        this.f = new BufferedOutputStream(this.e.getOutputStream(remoteFile, append), 16384);
        this.c = client.getMonitorInterval();
        this.i = client.getProgressMonitor();
        a.debug("Mode=" + (this.g ? "ASCII" : "Binary"));
    }

    @Override
    public String getRemoteFile() {
        return this.remoteFile;
    }

    public void setMonitor(FTPProgressMonitorEx monitor, long monitorInterval) {
        this.i = monitor;
        this.j = monitor;
        this.c = monitorInterval;
    }

    @Override
    public void write(int b2) throws IOException {
        byte[] byArray = new byte[]{(byte)b2};
        this.write(byArray, 0, 1);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        if (this.g) {
            for (int i2 = off; i2 < off + len; ++i2) {
                if (b2[i2] == 10 && this.l == 0) {
                    this.f.write(this.b);
                    this.size += (long)this.b.length;
                    this.h += (long)this.b.length;
                    continue;
                }
                if (b2[i2] == SftpClient.FTP_LINE_SEPARATOR[this.l]) {
                    this.k[this.l] = b2[i2];
                    ++this.l;
                    if (this.l != SftpClient.FTP_LINE_SEPARATOR.length) continue;
                    this.f.write(this.b);
                    this.size += (long)this.b.length;
                    this.h += (long)this.b.length;
                    this.l = 0;
                    continue;
                }
                if (this.l > 0) {
                    this.f.write(this.b);
                    this.size += (long)this.b.length;
                    this.h += (long)this.b.length;
                }
                this.f.write(b2[i2]);
                ++this.size;
                ++this.h;
                this.l = 0;
            }
        } else {
            this.f.write(b2, off, len);
            this.size += (long)len;
            this.h += (long)len;
        }
        if (this.i != null && this.h > this.c) {
            this.i.bytesTransferred(this.size);
            this.h = 0L;
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.g && this.l > 0) {
                this.f.write(this.k, 0, this.l);
                this.size += (long)this.l;
                this.h += (long)this.l;
            }
            this.f.flush();
            this.f.close();
            try {
                this.d.cancelResume();
            }
            catch (FTPException fTPException) {
                // empty catch block
            }
            if (this.i != null) {
                this.i.bytesTransferred(this.size);
            }
            a.debug("Transferred " + this.size + " bytes from remote host");
            if (this.j != null) {
                this.j.transferComplete(TransferDirection.UPLOAD, this.remoteFile);
            }
        }
    }
}

