/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport;

import com.enterprisedt.net.j2ssh.SshException;
import com.enterprisedt.net.j2ssh.configuration.SshConnectionProperties;
import com.enterprisedt.net.j2ssh.transport.AlgorithmInitializationException;
import com.enterprisedt.net.j2ssh.transport.AlgorithmNotAgreedException;
import com.enterprisedt.net.j2ssh.transport.AlgorithmNotSupportedException;
import com.enterprisedt.net.j2ssh.transport.AlgorithmOperationException;
import com.enterprisedt.net.j2ssh.transport.HostKeyVerification;
import com.enterprisedt.net.j2ssh.transport.MessageAlreadyRegisteredException;
import com.enterprisedt.net.j2ssh.transport.MessageNotAvailableException;
import com.enterprisedt.net.j2ssh.transport.Service;
import com.enterprisedt.net.j2ssh.transport.SshMessage;
import com.enterprisedt.net.j2ssh.transport.SshMessageStore;
import com.enterprisedt.net.j2ssh.transport.SshMsgExtInfo;
import com.enterprisedt.net.j2ssh.transport.SshMsgKexInit;
import com.enterprisedt.net.j2ssh.transport.SshMsgServiceAccept;
import com.enterprisedt.net.j2ssh.transport.SshMsgServiceRequest;
import com.enterprisedt.net.j2ssh.transport.TransportProtocolCommon;
import com.enterprisedt.net.j2ssh.transport.TransportProtocolException;
import com.enterprisedt.net.j2ssh.transport.cipher.SshCipher;
import com.enterprisedt.net.j2ssh.transport.cipher.SshCipherFactory;
import com.enterprisedt.net.j2ssh.transport.compression.SshCompression;
import com.enterprisedt.net.j2ssh.transport.compression.SshCompressionFactory;
import com.enterprisedt.net.j2ssh.transport.hmac.SshHmac;
import com.enterprisedt.net.j2ssh.transport.hmac.SshHmacFactory;
import com.enterprisedt.net.j2ssh.transport.kex.KeyExchangeException;
import com.enterprisedt.net.j2ssh.transport.kex.SshKeyExchange;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPair;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPairFactory;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransportProtocolClient
extends TransportProtocolCommon {
    protected SshPublicKey pk;
    private HostKeyVerification a;
    private Map b = new HashMap();
    private SshMessageStore c = new SshMessageStore();
    private String d;
    private String[] e = null;
    private long f = 0L;

    public TransportProtocolClient(HostKeyVerification hosts, SshConnectionProperties properties, long timeout) throws TransportProtocolException {
        super(properties.isRekeyEnabled());
        Object object;
        Object object2;
        this.a = hosts;
        this.properties = properties;
        this.f = timeout;
        log.info("Timeout=" + timeout);
        try {
            object2 = InetAddress.getByName(properties.getHost());
            if (!((InetAddress)object2).getHostAddress().equals(properties.getHost())) {
                object = new StringBuffer();
                ((StringBuffer)object).append(this.a(((InetAddress)object2).getHostName(), properties.getPort(), hosts.isPortsInKnownHosts()));
                ((StringBuffer)object).append(",");
                ((StringBuffer)object).append(this.a(((InetAddress)object2).getHostAddress(), properties.getPort(), hosts.isPortsInKnownHosts()));
                this.d = ((StringBuffer)object).toString();
            } else {
                this.d = this.a(((InetAddress)object2).getHostAddress(), properties.getPort(), hosts.isPortsInKnownHosts());
            }
        }
        catch (UnknownHostException unknownHostException) {
            log.debug("The host " + properties.getHost() + " could not be resolved");
            this.d = this.a(properties.getHost(), properties.getPort(), hosts.isPortsInKnownHosts());
        }
        object2 = this.properties.getKeyPairFactory().getEnabledKeyPairs();
        object = hosts.getPreferredKeyPairs(this.d, (List)object2);
        this.properties.getKeyPairFactory().setEnabledKeyPairs((List)object);
    }

    private String a(String string, int n2, boolean bl) {
        boolean bl2;
        if (!bl) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl3 = bl2 = n2 != 22;
        if (bl2) {
            stringBuffer.append("[");
        }
        stringBuffer.append(string);
        if (bl2) {
            stringBuffer.append("]:");
            stringBuffer.append(n2);
        }
        return stringBuffer.toString();
    }

    @Override
    public void onMessageReceived(SshMessage msg) throws IOException {
        throw new IOException("No messages are registered");
    }

    @Override
    public void registerTransportMessages() throws MessageAlreadyRegisteredException {
        this.c.registerMessage(6, SshMsgServiceAccept.class);
        this.addMessageStore(this.c);
    }

    @Override
    protected void onMsgExtInfo(SshMsgExtInfo msg) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = msg.getSupportedAlgorithms();
        SshKeyPairFactory sshKeyPairFactory = this.properties.getKeyPairFactory();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!sshKeyPairFactory.isKeyEnabled(stringArray[i2])) continue;
            arrayList.add(stringArray[i2]);
        }
        this.e = arrayList.toArray(new String[arrayList.size()]);
    }

    public void requestService(Service service, int timeout) throws IOException {
        if (service.getState().getValue() != 1) {
            throw new IOException("The service instance must be uninitialized");
        }
        if (this.state.getValue() != 4 && this.state.getValue() != 3) {
            throw new IOException("The transport protocol is not connected");
        }
        try {
            this.state.waitForState(4, timeout);
        }
        catch (InterruptedException interruptedException) {
            throw new SshException("The operation was interrupted", interruptedException);
        }
        service.init(1, this);
        this.b.put(service.getServiceName(), service);
        SshMessage sshMessage = new SshMsgServiceRequest(service.getServiceName());
        this.sendMessage(sshMessage, this);
        int[] nArray = new int[]{6, 7};
        try {
            sshMessage = this.c.getMessage(6, timeout);
        }
        catch (InterruptedException interruptedException) {
            throw new SshException("The thread was interrupted whilst waiting for a transport protocol message", interruptedException);
        }
        catch (MessageNotAvailableException messageNotAvailableException) {
            throw new SshException("Timeout whilst waiting for a transport protocol message", messageNotAvailableException);
        }
    }

    @Override
    protected void onDisconnect() {
        for (Map.Entry entry : this.b.entrySet()) {
            ((Service)entry.getValue()).stop();
        }
        this.b.clear();
    }

    @Override
    protected String getDecryptionAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedSCEncryption(), this.serverKexInit.getSupportedSCEncryption());
    }

    @Override
    protected String getEncryptionAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedCSEncryption(), this.serverKexInit.getSupportedCSEncryption());
    }

    public String[] getSupportedAlgorithms() {
        return this.e;
    }

    @Override
    protected String getInputStreamCompAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedSCComp(), this.serverKexInit.getSupportedSCComp());
    }

    @Override
    protected String getInputStreamMacAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedSCMac(), this.serverKexInit.getSupportedSCMac());
    }

    @Override
    protected void setLocalIdent() {
        this.clientIdent = "SSH-2.0-" + SOFTWARE_VERSION_COMMENTS;
    }

    @Override
    public String getLocalId() {
        return this.clientIdent;
    }

    @Override
    protected void setLocalKexInit(SshMsgKexInit msg) {
        this.clientKexInit = msg;
    }

    @Override
    protected SshMsgKexInit getLocalKexInit() {
        return this.clientKexInit;
    }

    @Override
    protected String getOutputStreamCompAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedCSComp(), this.serverKexInit.getSupportedCSComp());
    }

    @Override
    protected String getOutputStreamMacAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedCSMac(), this.serverKexInit.getSupportedCSMac());
    }

    @Override
    protected void setRemoteIdent(String ident) {
        this.serverIdent = ident;
    }

    @Override
    public String getRemoteId() {
        return this.serverIdent;
    }

    @Override
    protected void setRemoteKexInit(SshMsgKexInit msg) {
        this.serverKexInit = msg;
    }

    @Override
    protected SshMsgKexInit getRemoteKexInit() {
        return this.serverKexInit;
    }

    public SshPublicKey getServerHostKey() {
        return this.pk;
    }

    @Override
    protected void onStartTransportProtocol() throws IOException {
        while (this.state.getValue() != 4 && this.state.getValue() != 5) {
            try {
                log.debug("Wait for state update timeout=" + this.f);
                if (this.state.waitForStateUpdate(this.f)) continue;
                throw new IOException("Time-out while starting transport protocol.");
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("Interrupted while starting transport protocol.");
            }
        }
        if (this.state.getValue() == 5) {
            if (this.state.hasError()) {
                throw this.state.getLastError();
            }
            throw new TransportProtocolException("The connection did not complete");
        }
    }

    @Override
    protected void performKeyExchange(SshKeyExchange kex) throws IOException {
        kex.performClientExchange(this.clientIdent, this.serverIdent, this.clientKexInit.toByteArray(), this.serverKexInit.getPayload());
        if (!this.verifyHostKey(kex.getHostKey(), kex.getSignature(), kex.getExchangeHash())) {
            String string = "The host signature is invalid or the host key was not accepted!";
            this.sendDisconnect(9, string, new KeyExchangeException(string, this.getServerHostKey()));
            this.disconnect(string);
        }
    }

    @Override
    protected void setupNewKeys(byte[] encryptCSKey, byte[] encryptCSIV, byte[] encryptSCKey, byte[] encryptSCIV, byte[] macCSKey, byte[] macSCKey) throws AlgorithmNotAgreedException, AlgorithmOperationException, AlgorithmNotSupportedException, AlgorithmInitializationException {
        log.debug("setupNewKeys");
        SshCipher sshCipher = SshCipherFactory.newInstance(this.getEncryptionAlgorithm());
        sshCipher.init(0, encryptCSIV, encryptCSKey);
        this.algorithmsOut.setCipher(sshCipher);
        sshCipher = SshCipherFactory.newInstance(this.getDecryptionAlgorithm());
        sshCipher.init(1, encryptSCIV, encryptSCKey);
        this.algorithmsIn.setCipher(sshCipher);
        SshHmac sshHmac = SshHmacFactory.newInstance(this.getOutputStreamMacAlgorithm());
        sshHmac.init(macCSKey);
        this.algorithmsOut.setHmac(sshHmac);
        sshHmac = SshHmacFactory.newInstance(this.getInputStreamMacAlgorithm());
        sshHmac.init(macSCKey);
        this.algorithmsIn.setHmac(sshHmac);
        this.setupCompression(false);
    }

    @Override
    public void setupCompression(boolean afterAuth) throws AlgorithmNotAgreedException, AlgorithmNotSupportedException {
        SshCompression sshCompression = SshCompressionFactory.newInstance(this.getInputStreamCompAlgorithm());
        if (sshCompression != null && (sshCompression.delayed() && afterAuth || !sshCompression.delayed() && !afterAuth)) {
            sshCompression.init(0, 0);
            this.algorithmsIn.setCompression(sshCompression);
        }
        if ((sshCompression = SshCompressionFactory.newInstance(this.getOutputStreamCompAlgorithm())) != null && (sshCompression.delayed() && afterAuth || !sshCompression.delayed() && !afterAuth)) {
            sshCompression.init(1, 6);
            this.algorithmsOut.setCompression(sshCompression);
        }
    }

    protected boolean verifyHostKey(byte[] key, byte[] sig, byte[] sigdata) throws TransportProtocolException {
        log.debug("Verifying host " + this.d);
        String string = this.determineAlgorithm(this.clientKexInit.getSupportedPublicKeys(), this.serverKexInit.getSupportedPublicKeys());
        log.debug("Selected algorithm " + string);
        SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance(string);
        this.pk = sshKeyPair.setPublicKey(key);
        if (!this.pk.verifySignature(sig, sigdata)) {
            log.debug("The host signature is invalid");
            return false;
        }
        if (!this.a.verifyHost(this.d, this.pk)) {
            log.debug("The host key is not accepted");
            return false;
        }
        return true;
    }
}

