/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport;

import com.enterprisedt.net.ftp.VersionDetails;
import com.enterprisedt.net.j2ssh.SshException;
import com.enterprisedt.net.j2ssh.SshThread;
import com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthBanner;
import com.enterprisedt.net.j2ssh.configuration.ConfigurationLoader;
import com.enterprisedt.net.j2ssh.configuration.SshConnectionProperties;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.AlgorithmInitializationException;
import com.enterprisedt.net.j2ssh.transport.AlgorithmNotAgreedException;
import com.enterprisedt.net.j2ssh.transport.AlgorithmNotSupportedException;
import com.enterprisedt.net.j2ssh.transport.AlgorithmOperationException;
import com.enterprisedt.net.j2ssh.transport.HostKeyVerification;
import com.enterprisedt.net.j2ssh.transport.MessageAlreadyRegisteredException;
import com.enterprisedt.net.j2ssh.transport.MessageNotRegisteredException;
import com.enterprisedt.net.j2ssh.transport.SshMessage;
import com.enterprisedt.net.j2ssh.transport.SshMessageStore;
import com.enterprisedt.net.j2ssh.transport.SshMsgDebug;
import com.enterprisedt.net.j2ssh.transport.SshMsgDisconnect;
import com.enterprisedt.net.j2ssh.transport.SshMsgExtInfo;
import com.enterprisedt.net.j2ssh.transport.SshMsgIgnore;
import com.enterprisedt.net.j2ssh.transport.SshMsgKexInit;
import com.enterprisedt.net.j2ssh.transport.SshMsgNewKeys;
import com.enterprisedt.net.j2ssh.transport.SshMsgUnimplemented;
import com.enterprisedt.net.j2ssh.transport.TransportProtocol;
import com.enterprisedt.net.j2ssh.transport.TransportProtocolAlgorithmSync;
import com.enterprisedt.net.j2ssh.transport.TransportProtocolEventHandler;
import com.enterprisedt.net.j2ssh.transport.TransportProtocolException;
import com.enterprisedt.net.j2ssh.transport.TransportProtocolState;
import com.enterprisedt.net.j2ssh.transport.a;
import com.enterprisedt.net.j2ssh.transport.b;
import com.enterprisedt.net.j2ssh.transport.kex.KeyExchangeException;
import com.enterprisedt.net.j2ssh.transport.kex.SshKeyExchange;
import com.enterprisedt.net.j2ssh.transport.kex.SshKeyExchangeFactory;
import com.enterprisedt.net.j2ssh.util.Hash;
import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.proxy.StreamSocket;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public abstract class TransportProtocolCommon
implements TransportProtocol,
Runnable {
    protected static Logger log = Logger.getLogger("TransportProtocolCommon");
    private static int a = 1;
    public static final int EOL_CRLF = 1;
    public static final int EOL_LF = 2;
    public static final String PROTOCOL_VERSION = "2.0";
    public static final int DEFAULT_PORT = 22;
    public static String SOFTWARE_VERSION_COMMENTS = "edtFTPjPRO_" + VersionDetails.getVersionString();
    private static String b = "SSH-";
    private int c = a++;
    protected BigInteger k = null;
    protected Boolean completeOnNewKeys = new Boolean(false);
    protected HostKeyVerification hosts;
    protected Map kexs = new HashMap();
    private boolean d = false;
    protected SshConnectionProperties properties;
    protected SshMessageStore messageStore = new SshMessageStore();
    protected SshMsgKexInit clientKexInit = null;
    protected SshMsgKexInit serverKexInit = null;
    protected String clientIdent = null;
    protected String serverIdent = null;
    protected TransportProtocolAlgorithmSync algorithmsIn;
    protected TransportProtocolAlgorithmSync algorithmsOut;
    protected TransportProtocolState state = new TransportProtocolState();
    private byte[] e = null;
    protected byte[] sessionIdentifier = null;
    protected byte[] hostKey = null;
    protected byte[] signature = null;
    private Vector f = new Vector();
    private List g = new ArrayList();
    private Map h = new HashMap();
    private Object i = new Object();
    private StreamSocket j;
    private SshThread l;
    private long m = 3540000L;
    private long n = 996147200L;
    private long o = System.currentTimeMillis();
    private long p = 0L;
    private boolean q = true;
    protected a sshIn;
    protected b sshOut;
    private int r = 1;
    private Vector s = new Vector();
    private String t;

    public TransportProtocolCommon(boolean enableRekey) {
        this.q = enableRekey;
    }

    public TransportProtocolCommon() {
        this(false);
    }

    public Thread getThread() {
        return this.l;
    }

    @Override
    public int getConnectionId() {
        return this.c;
    }

    public int getRemoteEOL() {
        return this.r;
    }

    public String getUserAuthBanner() {
        return this.t;
    }

    @Override
    public TransportProtocolState getState() {
        return this.state;
    }

    public SshConnectionProperties getProperties() {
        return this.properties;
    }

    protected abstract void onDisconnect();

    @Override
    public void disconnect(String description) {
        log.debug("Disconnect: " + description);
        try {
            this.state.setValue(5);
            this.state.setDisconnectReason(description);
            this.sendDisconnect(11, description);
        }
        catch (Exception exception) {
            log.warn("Failed to send disconnect", exception);
        }
    }

    public void disconnectImmediately(String description) {
        log.debug("DisconnectImmediately: " + description);
        this.state.setValue(5);
        this.state.setDisconnectReason(description);
    }

    public void setSendIgnore(boolean sendIgnore) {
        this.d = sendIgnore;
    }

    public void sendIgnore() throws TransportProtocolException {
        byte[] byArray = new byte[1];
        ConfigurationLoader.getRND().nextBytes(byArray);
        byte[] byArray2 = new byte[(byArray[0] & 0xFF) + 1];
        ConfigurationLoader.getRND().nextBytes(byArray2);
        SshMsgIgnore sshMsgIgnore = new SshMsgIgnore(new String(byArray2));
        if (log.isDebugEnabled()) {
            log.debug("Sending " + sshMsgIgnore.getMessageName());
        }
        this.sshOut.a(sshMsgIgnore);
    }

    public void setKexTimeout(long seconds) throws TransportProtocolException {
        if (seconds < 60L) {
            throw new TransportProtocolException("Keys can only be re-exchanged every minute or more");
        }
        this.m = seconds * 1000L;
    }

    public void setKexTransferLimit(long kilobytes) throws TransportProtocolException {
        if (kilobytes < 10L) {
            throw new TransportProtocolException("Keys can only be re-exchanged after every 10k of data, or more");
        }
        this.n = kilobytes * 1024L;
    }

    public long getOutgoingByteCount() {
        return this.sshOut.a();
    }

    public long getIncomingByteCount() {
        return this.sshIn.b();
    }

    public void addEventHandler(TransportProtocolEventHandler eventHandler) {
        if (eventHandler != null) {
            this.f.add(eventHandler);
        }
    }

    public abstract void registerTransportMessages() throws MessageAlreadyRegisteredException;

    @Override
    public byte[] getSessionIdentifier() {
        return (byte[])this.sessionIdentifier.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.state.setValue(2);
            log.debug("Registering transport protocol messages with inputstream");
            this.algorithmsOut = new TransportProtocolAlgorithmSync();
            this.algorithmsIn = new TransportProtocolAlgorithmSync();
            this.sshIn = new a(this, this.j.getInputStream(), this.algorithmsIn);
            this.sshOut = new b(this.j.getOutputStream(), this, this.algorithmsOut);
            this.messageStore.registerMessage(1, SshMsgDisconnect.class);
            this.messageStore.registerMessage(2, SshMsgIgnore.class);
            this.messageStore.registerMessage(3, SshMsgUnimplemented.class);
            this.messageStore.registerMessage(4, SshMsgDebug.class);
            this.messageStore.registerMessage(20, SshMsgKexInit.class);
            this.messageStore.registerMessage(21, SshMsgNewKeys.class);
            this.messageStore.registerMessage(53, SshMsgUserAuthBanner.class);
            this.messageStore.registerMessage(7, SshMsgExtInfo.class);
            this.registerTransportMessages();
            List list = SshKeyExchangeFactory.getSupportedKeyExchanges();
            for (String string : list) {
                SshKeyExchange sshKeyExchange = SshKeyExchangeFactory.newInstance(string);
                sshKeyExchange.init(this);
                this.kexs.put(string, sshKeyExchange);
            }
            this.setLocalIdent();
            this.a();
            this.startBinaryPacketProtocol();
        }
        catch (Throwable throwable) {
            if (throwable instanceof IOException) {
                this.state.setLastError((IOException)throwable);
            }
            if (this.state.getValue() != 5) {
                log.warn("The Transport Protocol thread failed: " + throwable.getMessage());
                this.stop();
                this.state.setValue(5);
            }
        }
        log.info("The Transport Protocol has been stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void sendMessage(SshMessage msg, Object sender) throws IOException {
        if (log.isEnabledFor(Level.ALL)) {
            log.log(Level.ALL, msg.toString(), null);
        } else if (log.isDebugEnabled()) {
            log.debug("Sending " + msg.getMessageName());
        }
        int n2 = this.state.getValue();
        if (sender instanceof SshKeyExchange || sender instanceof TransportProtocolCommon || n2 == 4) {
            this.sshOut.a(msg);
            if (n2 == 4 && this.d) {
                this.sendIgnore();
            }
        } else if (n2 == 3) {
            log.debug("Adding to message queue whilst in key exchange");
            List list = this.g;
            synchronized (list) {
                this.g.add(msg);
                if (log.isEnabledFor(Level.ALL)) {
                    log.log(Level.ALL, "Added message to queue. Msg=" + msg.toString(), null);
                }
            }
        } else {
            throw new TransportProtocolException("The transport protocol is disconnected");
        }
    }

    protected abstract void onStartTransportProtocol() throws IOException;

    public void startTransportProtocol(StreamSocket provider) throws IOException {
        this.j = provider;
        log.debug("Starting transport protocol");
        this.l = new SshThread(this, "Transport protocol", true);
        this.l.start();
        this.onStartTransportProtocol();
    }

    @Override
    public String getUnderlyingProviderDetail() {
        return this.j.getDetail();
    }

    public void unregisterMessage(Integer messageId, SshMessageStore store) throws MessageNotRegisteredException {
        if (log.isDebugEnabled()) {
            log.debug("Unregistering message Id " + messageId.toString());
        }
        if (!this.h.containsKey(messageId)) {
            throw new MessageNotRegisteredException(messageId);
        }
        SshMessageStore sshMessageStore = (SshMessageStore)this.h.get(messageId);
        if (!store.equals(sshMessageStore)) {
            throw new MessageNotRegisteredException(messageId, store);
        }
        this.h.remove(messageId);
    }

    protected abstract String getDecryptionAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract String getEncryptionAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract String getInputStreamCompAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract String getInputStreamMacAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract void setLocalIdent();

    public abstract String getLocalId();

    protected abstract void setLocalKexInit(SshMsgKexInit var1);

    protected abstract SshMsgKexInit getLocalKexInit();

    protected abstract String getOutputStreamCompAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract String getOutputStreamMacAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract void setRemoteIdent(String var1);

    public abstract String getRemoteId();

    protected abstract void setRemoteKexInit(SshMsgKexInit var1);

    protected abstract SshMsgKexInit getRemoteKexInit();

    protected abstract void performKeyExchange(SshKeyExchange var1) throws IOException, KeyExchangeException;

    protected String getKexAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedKex(), this.serverKexInit.getSupportedKex());
    }

    @Override
    public boolean isConnected() {
        return this.state.getValue() == 4 || this.state.getValue() == 3;
    }

    protected void beginKeyExchange() throws IOException, KeyExchangeException {
        log.debug("Starting key exchange");
        String string = "";
        try {
            string = this.getKexAlgorithm();
            if (log.isDebugEnabled()) {
                log.debug("Key exchange algorithm: " + string);
            }
            SshKeyExchange sshKeyExchange = (SshKeyExchange)this.kexs.get(string);
            this.performKeyExchange(sshKeyExchange);
            this.e = sshKeyExchange.getExchangeHash();
            if (this.sessionIdentifier == null) {
                this.sessionIdentifier = new byte[this.e.length];
                System.arraycopy(this.e, 0, this.sessionIdentifier, 0, this.sessionIdentifier.length);
                this.l.setSessionId(this.sessionIdentifier);
            }
            this.hostKey = sshKeyExchange.getHostKey();
            this.signature = sshKeyExchange.getSignature();
            this.k = sshKeyExchange.getSecret();
            this.sendNewKeys(sshKeyExchange);
            sshKeyExchange.reset();
        }
        catch (AlgorithmNotAgreedException algorithmNotAgreedException) {
            log.debug("beginKeyExchange()", algorithmNotAgreedException);
            this.sendDisconnect(3, "No suitable key exchange algorithm was agreed");
            throw new KeyExchangeException("No suitable key exchange algorithm could be agreed.", algorithmNotAgreedException);
        }
    }

    protected SshMsgKexInit createLocalKexInit() throws IOException {
        return new SshMsgKexInit(this.properties);
    }

    protected void onCorruptMac() {
        log.fatal("Corrupt Mac on Input");
        this.sendDisconnect(5, "Corrupt Mac on input", new SshException("Corrupt Mac on Imput"));
    }

    protected abstract void onMessageReceived(SshMessage var1) throws IOException;

    protected void sendDisconnect(int reason, String description) {
        SshMsgDisconnect sshMsgDisconnect = new SshMsgDisconnect(reason, description, "");
        if (log.isDebugEnabled()) {
            log.debug("sendDisconnect(" + reason + ",'" + description + "')");
        }
        try {
            this.sendMessage(sshMsgDisconnect, this);
            this.stop();
        }
        catch (Exception exception) {
            log.warn("Failed to send disconnect", exception);
        }
    }

    protected void sendDisconnect(int reason, String description, IOException error) {
        this.state.setLastError(error);
        this.sendDisconnect(reason, description);
    }

    protected void sendKeyExchangeInit() throws IOException {
        this.state.setValue(3);
        this.setLocalKexInit(this.createLocalKexInit());
        SshMsgKexInit sshMsgKexInit = this.getLocalKexInit();
        log.debug(sshMsgKexInit.toString());
        this.sendMessage(sshMsgKexInit, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendNewKeys(SshKeyExchange kex) throws IOException {
        SshMsgNewKeys sshMsgNewKeys = new SshMsgNewKeys();
        this.sendMessage(sshMsgNewKeys, this);
        TransportProtocolCommon transportProtocolCommon = this;
        synchronized (transportProtocolCommon) {
            this.algorithmsOut.lock();
            int[] nArray = new int[]{21};
            sshMsgNewKeys = (SshMsgNewKeys)this.readMessage(nArray);
            try {
                this.completeKeyExchange(kex);
            }
            finally {
                this.algorithmsIn.release();
                this.algorithmsOut.release();
            }
            this.sendOutstandingMessages();
            this.state.setValue(4);
        }
    }

    protected abstract void setupNewKeys(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6) throws AlgorithmNotAgreedException, AlgorithmOperationException, AlgorithmNotSupportedException, AlgorithmInitializationException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void sendOutstandingMessages() throws IOException {
        List list = this.g;
        synchronized (list) {
            Iterator iterator = this.g.iterator();
            log.debug("Sending queued messages");
            while (iterator.hasNext()) {
                SshMessage sshMessage = (SshMessage)iterator.next();
                this.sshOut.a(sshMessage);
            }
            this.g.clear();
        }
    }

    private int a(String string) throws KeyExchangeException {
        if (string.equals("3des-cbc")) {
            return 24;
        }
        if (string.equals("blowfish-cbc") || string.equals("aes128-cbc") || string.equals("aes128-ctr")) {
            return 16;
        }
        if (string.equals("aes192-cbc") || string.equals("aes192-ctr")) {
            return 24;
        }
        if (string.equals("aes256-cbc") || string.equals("aes256-ctr")) {
            return 32;
        }
        throw new KeyExchangeException("Unknown algorithm " + string);
    }

    private int b(String string) throws KeyExchangeException {
        if (string.equals("3des-cbc") || string.equals("blowfish-cbc")) {
            return 8;
        }
        if (string.equals("aes128-cbc") || string.equals("aes128-ctr") || string.equals("aes192-cbc") || string.equals("aes192-ctr") || string.equals("aes256-cbc") || string.equals("aes256-ctr")) {
            return 16;
        }
        throw new KeyExchangeException("Unknown algorithm " + string);
    }

    private int c(String string) throws KeyExchangeException {
        if (string.equals("hmac-sha1")) {
            return 20;
        }
        if (string.equals("hmac-md5")) {
            return 16;
        }
        if (string.equals("hmac-sha1-96")) {
            return 20;
        }
        if (string.equals("hmac-md5-96")) {
            return 16;
        }
        if (string.equals("hmac-sha2-256") || string.equals("hmac-sha256")) {
            return 32;
        }
        if (string.equals("hmac-sha2-512") || string.equals("hmac-sha512")) {
            return 64;
        }
        throw new KeyExchangeException("Unknown algorithm " + string);
    }

    protected void completeKeyExchange(SshKeyExchange kex) throws IOException {
        log.debug("Completing key exchange");
        try {
            log.debug("Making keys from key exchange output");
            int n2 = this.a(this.getEncryptionAlgorithm());
            int n3 = this.a(this.getDecryptionAlgorithm());
            int n4 = this.b(this.getEncryptionAlgorithm());
            int n5 = this.b(this.getDecryptionAlgorithm());
            int n6 = this.c(this.getOutputStreamMacAlgorithm());
            int n7 = this.c(this.getInputStreamMacAlgorithm());
            byte[] byArray = this.a(kex, 'C', n2);
            byte[] byArray2 = this.a(kex, 'A', n4);
            byte[] byArray3 = this.a(kex, 'D', n3);
            byte[] byArray4 = this.a(kex, 'B', n5);
            byte[] byArray5 = this.a(kex, 'E', n6);
            byte[] byArray6 = this.a(kex, 'F', n7);
            log.debug("Creating algorithm objects");
            this.setupNewKeys(byArray, byArray2, byArray3, byArray4, byArray5, byArray6);
            this.state.setValue(4);
        }
        catch (AlgorithmNotAgreedException algorithmNotAgreedException) {
            this.sendDisconnect(3, "Algorithm not agreed");
            throw new TransportProtocolException("The connection was disconnected because an algorithm could not be agreed", algorithmNotAgreedException);
        }
        catch (AlgorithmNotSupportedException algorithmNotSupportedException) {
            this.sendDisconnect(3, "Application error");
            throw new TransportProtocolException("The connection was disconnected because an algorithm class could not be loaded", algorithmNotSupportedException);
        }
        catch (AlgorithmOperationException algorithmOperationException) {
            this.sendDisconnect(3, "Algorithm operation error");
            throw new TransportProtocolException("The connection was disconnected because of an algorithm operation error", algorithmOperationException);
        }
        catch (AlgorithmInitializationException algorithmInitializationException) {
            this.sendDisconnect(3, "Algorithm initialization error");
            throw new TransportProtocolException("The connection was disconnected because of an algorithm initialization error", algorithmInitializationException);
        }
    }

    protected List getEventHandlers() {
        return this.f;
    }

    protected String determineAlgorithm(List clientAlgorithms, List serverAlgorithms) throws AlgorithmNotAgreedException {
        if (log.isDebugEnabled()) {
            log.debug("Determine Algorithm");
            log.debug("Client Algorithms: " + clientAlgorithms.toString());
            log.debug("Server Algorithms: " + serverAlgorithms.toString());
        }
        for (String string : clientAlgorithms) {
            for (String string2 : serverAlgorithms) {
                if (!string.equals(string2)) continue;
                log.debug("Returning " + string);
                return string;
            }
        }
        String string = "Could not agree algorithm";
        log.error(string);
        throw new AlgorithmNotAgreedException(string);
    }

    protected void startBinaryPacketProtocol() throws IOException {
        this.sendKeyExchangeInit();
        block9: while (this.state.getValue() != 5) {
            SshMessage sshMessage = this.processMessages();
            switch (sshMessage.getMessageId()) {
                case 20: {
                    this.a((SshMsgKexInit)sshMessage);
                    continue block9;
                }
                case 1: {
                    this.a((SshMsgDisconnect)sshMessage);
                    continue block9;
                }
                case 2: {
                    this.a((SshMsgIgnore)sshMessage);
                    continue block9;
                }
                case 7: {
                    this.onMsgExtInfo((SshMsgExtInfo)sshMessage);
                    continue block9;
                }
                case 53: {
                    this.a((SshMsgUserAuthBanner)sshMessage);
                    continue block9;
                }
                case 3: {
                    this.a((SshMsgUnimplemented)sshMessage);
                    continue block9;
                }
                case 4: {
                    this.a((SshMsgDebug)sshMessage);
                    continue block9;
                }
            }
            this.onMessageReceived(sshMessage);
        }
    }

    public final void stop() {
        log.debug("stop() called");
        this.onDisconnect();
        for (TransportProtocolEventHandler transportProtocolEventHandler : this.f) {
            transportProtocolEventHandler.onDisconnect(this);
        }
        if (this.messageStore != null) {
            this.messageStore.close();
        }
        Iterator iterator = this.s.iterator();
        while (iterator != null && iterator.hasNext()) {
            SshMessageStore sshMessageStore = (SshMessageStore)iterator.next();
            try {
                sshMessageStore.close();
            }
            catch (Exception exception) {}
        }
        this.s.clear();
        this.messageStore = null;
        try {
            this.j.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private byte[] a(SshKeyExchange sshKeyExchange, char c2, int n2) throws IOException {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byte[] byArray = null;
            Hash hash = sshKeyExchange.getHash();
            hash.putBigInteger(this.k);
            hash.putBytes(this.e);
            hash.putByte((byte)c2);
            hash.putBytes(this.sessionIdentifier);
            byte[] byArray2 = hash.doFinal();
            if (byArray2.length >= n2) {
                byteArrayWriter.write(byArray2, 0, n2);
                return byteArrayWriter.toByteArray();
            }
            hash.reset();
            hash.putBigInteger(this.k);
            hash.putBytes(this.e);
            hash.putBytes(byArray2);
            byte[] byArray3 = hash.doFinal();
            if (byArray2.length + byArray3.length >= n2) {
                byteArrayWriter.write(byArray2);
                byteArrayWriter.write(byArray3, 0, n2 - byArray2.length);
                return byteArrayWriter.toByteArray();
            }
            hash.reset();
            hash.putBigInteger(this.k);
            hash.putBytes(this.e);
            hash.putBytes(byArray2);
            hash.putBytes(byArray3);
            byte[] byArray4 = hash.doFinal();
            if (byArray2.length + byArray3.length + byArray4.length >= n2) {
                byteArrayWriter.write(byArray2);
                byteArrayWriter.write(byArray3);
                byteArrayWriter.write(byArray4, 0, n2 - (byArray2.length + byArray3.length));
                return byteArrayWriter.toByteArray();
            }
            hash.reset();
            hash.putBigInteger(this.k);
            hash.putBytes(this.e);
            hash.putBytes(byArray2);
            hash.putBytes(byArray3);
            hash.putBytes(byArray4);
            byArray = hash.doFinal();
            if (byArray2.length + byArray3.length + byArray4.length + byArray.length >= n2) {
                byteArrayWriter.write(byArray2);
                byteArrayWriter.write(byArray3);
                byteArrayWriter.write(byArray4);
                byteArrayWriter.write(byArray, 0, n2 - (byArray2.length + byArray3.length + byArray4.length));
                return byteArrayWriter.toByteArray();
            }
            throw new TransportProtocolException("necessary key length is too big");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            log.debug("makeSshKey()", noSuchProviderException);
            this.sendDisconnect(3, "Application error");
            throw new TransportProtocolException("Unknown provider", noSuchProviderException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            log.debug("makeSshKey()", noSuchAlgorithmException);
            this.sendDisconnect(3, "Application error");
            throw new TransportProtocolException("SHA algorithm not supported", noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            log.debug("makeSshKey()", iOException);
            this.sendDisconnect(3, "Application error");
            throw new TransportProtocolException("Error writing key data", iOException);
        }
    }

    private void a() throws IOException {
        String string;
        String string2 = "";
        log.debug("Negotiating protocol version");
        log.debug("Local identification: " + this.getLocalId());
        String string3 = this.getLocalId() + "\r\n";
        this.j.getOutputStream().write(string3.getBytes());
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 255;
        while (!string2.startsWith(b) && stringBuffer.length() < n3 && n2 != -1) {
            while ((n2 = this.j.getInputStream().read()) != -1 && stringBuffer.length() < n3 && n2 != 10) {
                stringBuffer.append((char)n2);
            }
            string2 = stringBuffer.toString();
            stringBuffer = new StringBuffer();
            log.debug("Read: '" + string2 + "'");
            if (!string2.startsWith(b)) continue;
            if (string2.endsWith("\r")) {
                this.r = 1;
                string2 = string2.substring(0, string2.length() - 1);
            } else {
                this.r = 2;
            }
            log.debug("EOL is guessed at " + (this.r == 1 ? "CR+LF" : "LF"));
        }
        if (!string2.startsWith(b)) {
            log.fatal("The remote computer does not appear to support the SSH protocol: '" + string2 + "'");
            throw new TransportProtocolException("The remote computer does not appear to support the SSH protocol");
        }
        int n4 = string2.indexOf("-");
        int n5 = string2.indexOf("-", n4 + 1);
        this.setRemoteIdent(string2);
        if (log.isDebugEnabled()) {
            log.debug("Remote identification: '" + this.getRemoteId() + "'");
        }
        if (!(string = string2.substring(n4 + 1, n5)).equals(PROTOCOL_VERSION) && !string.equals("1.99")) {
            log.fatal("The remote computer does not support protocol version 2.0");
            throw new TransportProtocolException("The protocol version of the remote computer is not supported!");
        }
        log.debug("Protocol negotiation complete");
    }

    private void a(SshMsgDebug sshMsgDebug) {
        log.debug(sshMsgDebug.getMessage());
    }

    private void a(SshMsgDisconnect sshMsgDisconnect) throws IOException {
        log.debug("The remote computer disconnected: " + sshMsgDisconnect.getDescription());
        this.state.setValue(5);
        this.state.setDisconnectReason(sshMsgDisconnect.getDescription());
        this.stop();
    }

    private void a(SshMsgIgnore sshMsgIgnore) {
    }

    protected abstract void onMsgExtInfo(SshMsgExtInfo var1);

    private void a(SshMsgUserAuthBanner sshMsgUserAuthBanner) {
        this.t = sshMsgUserAuthBanner.getBanner();
        log.debug("Received auth banner '" + this.t + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(SshMsgKexInit sshMsgKexInit) throws IOException {
        log.debug("Received " + sshMsgKexInit.toString());
        Object object = this.i;
        synchronized (object) {
            this.setRemoteKexInit(sshMsgKexInit);
            if (this.state.getValue() != 3) {
                this.sendKeyExchangeInit();
            }
            this.beginKeyExchange();
        }
    }

    private void a(SshMsgUnimplemented sshMsgUnimplemented) {
        if (log.isDebugEnabled()) {
            log.debug("The message with sequence no " + sshMsgUnimplemented.getSequenceNo() + " was reported as unimplemented by the remote end.");
        }
    }

    @Override
    public SshMessage readMessage(int[] filter) throws IOException {
        byte[] byArray = null;
        block8: while (this.state.getValue() != 5) {
            SshMessage sshMessage;
            boolean bl = false;
            while (!bl) {
                byArray = this.sshIn.c();
                bl = true;
            }
            Integer n2 = SshMessage.getMessageId(byArray);
            for (int i2 = 0; i2 < filter.length; ++i2) {
                if (filter[i2] != n2) continue;
                if (this.messageStore.isRegisteredMessage(n2)) {
                    sshMessage = this.messageStore.createMessage(byArray);
                    if (log.isEnabledFor(Level.ALL)) {
                        log.log(Level.ALL, "Received registered message: " + sshMessage.toString(), null);
                    } else if (log.isDebugEnabled()) {
                        log.debug("Received registered message: " + sshMessage.getMessageName());
                    }
                    return sshMessage;
                }
                SshMessageStore sshMessageStore = this.a(n2);
                sshMessage = sshMessageStore.createMessage(byArray);
                if (log.isEnabledFor(Level.ALL)) {
                    log.log(Level.ALL, "Received unregistered message: " + sshMessage.toString(), null);
                } else if (log.isDebugEnabled()) {
                    log.debug("Received unregistered message: " + sshMessage.getMessageName());
                }
                return sshMessage;
            }
            if (this.messageStore.isRegisteredMessage(n2)) {
                sshMessage = this.messageStore.createMessage(byArray);
                if (log.isEnabledFor(Level.ALL)) {
                    log.log(Level.ALL, "Received registered message: " + sshMessage.toString(), null);
                } else if (log.isDebugEnabled()) {
                    log.debug("Received registered message: " + sshMessage.getMessageName());
                }
                switch (n2) {
                    case 1: {
                        this.a((SshMsgDisconnect)sshMessage);
                        continue block8;
                    }
                    case 2: {
                        this.a((SshMsgIgnore)sshMessage);
                        continue block8;
                    }
                    case 3: {
                        this.a((SshMsgUnimplemented)sshMessage);
                        continue block8;
                    }
                    case 4: {
                        this.a((SshMsgDebug)sshMessage);
                        continue block8;
                    }
                }
                throw new IOException("Unexpected transport protocol message");
            }
            try {
                SshMessageStore sshMessageStore = this.a(n2);
                sshMessage = sshMessageStore.createMessage(byArray);
                if (log.isEnabledFor(Level.ALL)) {
                    log.log(Level.ALL, "Received unregistered message: " + sshMessage.toString(), null);
                } else if (log.isDebugEnabled()) {
                    log.debug("Received unregistered message: " + sshMessage.getMessageName());
                }
                sshMessageStore.addMessage(sshMessage);
            }
            catch (MessageNotRegisteredException messageNotRegisteredException) {
                log.debug("Unimplemented message received " + String.valueOf(n2));
                sshMessage = new SshMsgUnimplemented(this.sshIn.a());
                this.sendMessage(sshMessage, this);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SshMessage processMessages() throws IOException {
        byte[] byArray = null;
        while (this.state.getValue() != 5) {
            SshMessage sshMessage;
            long l2 = System.currentTimeMillis();
            long l3 = this.sshIn.b() + this.sshOut.a();
            long l4 = l3 - this.p;
            long l5 = l2 - this.o;
            Object object = this.i;
            synchronized (object) {
                if (l5 > this.m || l4 > this.n) {
                    if (this.q) {
                        this.o = l2;
                        this.p = l3;
                        if (log.isInfoEnabled()) {
                            log.info("rekeying after " + l3 + " bytes");
                        }
                        this.sendKeyExchangeInit();
                    } else {
                        log.info("rekeying disabled");
                    }
                }
            }
            boolean bl = false;
            while (!bl) {
                try {
                    byArray = this.sshIn.c();
                    bl = true;
                }
                catch (InterruptedIOException interruptedIOException) {
                    log.debug("Timeout on transport inputstream");
                    for (TransportProtocolEventHandler transportProtocolEventHandler : this.f) {
                        transportProtocolEventHandler.onSocketTimeout(this);
                    }
                    throw interruptedIOException;
                }
            }
            Integer n2 = SshMessage.getMessageId(byArray);
            if (!this.messageStore.isRegisteredMessage(n2)) {
                try {
                    SshMessageStore sshMessageStore = this.a(n2);
                    sshMessage = sshMessageStore.createMessage(byArray);
                    if (log.isEnabledFor(Level.ALL)) {
                        log.log(Level.ALL, "Received unregistered message: " + sshMessage.toString(), null);
                    } else if (log.isDebugEnabled()) {
                        log.debug("Received unregistered message: " + sshMessage.getMessageName());
                    }
                    sshMessageStore.addMessage(sshMessage);
                }
                catch (MessageNotRegisteredException messageNotRegisteredException) {
                    log.debug("Unimplemented message received " + String.valueOf(n2));
                    sshMessage = new SshMsgUnimplemented(this.sshIn.a());
                    this.sendMessage(sshMessage, this);
                }
                continue;
            }
            sshMessage = this.messageStore.createMessage(byArray);
            if (log.isEnabledFor(Level.ALL)) {
                log.log(Level.ALL, "Received registered message: " + sshMessage.toString(), null);
            } else if (log.isDebugEnabled()) {
                log.debug("Received registered message: " + sshMessage.getMessageName());
            }
            return sshMessage;
        }
        throw new IOException("The transport protocol has disconnected");
    }

    @Override
    public void addMessageStore(SshMessageStore store) throws MessageAlreadyRegisteredException {
        this.s.add(store);
    }

    private SshMessageStore a(Integer n2) throws MessageNotRegisteredException {
        Iterator iterator = this.s.iterator();
        while (iterator != null && iterator.hasNext()) {
            SshMessageStore sshMessageStore = (SshMessageStore)iterator.next();
            if (!sshMessageStore.isRegisteredMessage(n2)) continue;
            return sshMessageStore;
        }
        throw new MessageNotRegisteredException(n2);
    }

    public void removeMessageStore(SshMessageStore ms) {
        this.s.remove(ms);
    }
}

