/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey;

import com.enterprisedt.bouncycastle.crypto.digests.SHA256Digest;
import com.enterprisedt.bouncycastle.crypto.generators.Argon2BytesGenerator;
import com.enterprisedt.bouncycastle.crypto.macs.HMac;
import com.enterprisedt.bouncycastle.crypto.params.Argon2Parameters;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.util.encoders.Hex;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.cipher.SshCipher;
import com.enterprisedt.net.j2ssh.transport.cipher.SshCipherFactory;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.PuTTYPrivateKeyFormat;
import com.enterprisedt.util.debug.Logger;

public class PuTTYPrivateKeyFormat3
extends PuTTYPrivateKeyFormat {
    private static Logger a = Logger.getLogger("PuTTYPrivateKeyFormat3");
    private static String b = "PuTTY-User-Key-File-3";
    public static String KEY_DERIVATION = "Key-Derivation";
    private static String c = "Argon2-Memory";
    private static String d = "Argon2-Passes";
    private static String e = "Argon2-Parallelism";
    private static String f = "Argon2-Salt";
    private static String g = "Argon2d";
    private static String h = "Argon2i";
    private static String i = "Argon2id";
    private static int j = 32;
    private static int k = 16;
    private static int l = 32;
    private static int m = j + k + l;

    @Override
    public String getFormatType() {
        return b;
    }

    @Override
    public byte[] decryptKeyblob(byte[] formattedKey, String passphrase) throws InvalidSshKeyException {
        try {
            String string;
            Object object;
            Object object2;
            byte[] byArray;
            Object object3;
            String string2;
            a.info("Unpacking puTTY formatted private key 3");
            this.getKeyBlobs(formattedKey);
            if (this.isCipher && (passphrase == null || passphrase.length() == 0)) {
                String string3 = "A passphrase must be supplied";
                a.error(string3);
                throw new InvalidSshKeyException(string3);
            }
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            if (this.isCipher) {
                string2 = (String)this.headers.get(KEY_DERIVATION);
                int n2 = Integer.parseInt((String)this.headers.get(c));
                int n3 = Integer.parseInt((String)this.headers.get(d));
                int n4 = Integer.parseInt((String)this.headers.get(e));
                object3 = (String)this.headers.get(f);
                byArray = this.a(string2, passphrase, n2, n3, n4, (String)object3);
                object2 = new byte[j];
                System.arraycopy(byArray, 0, object2, 0, ((byte[])object2).length);
                object = new byte[k];
                System.arraycopy(byArray, j, object, 0, ((byte[])object).length);
                byArray3 = new byte[l];
                System.arraycopy(byArray, j + k, byArray3, 0, byArray3.length);
                string = (String)this.headers.get(ENCRYPTION_HEADER);
                SshCipher sshCipher = SshCipherFactory.newInstance(string);
                sshCipher.init(1, (byte[])object, (byte[])object2);
                byArray2 = sshCipher.transform(this.privBlob);
            } else {
                byArray2 = this.privBlob;
                byArray3 = new byte[]{};
            }
            string2 = (String)this.headers.get(b);
            String string4 = (String)this.headers.get(ENCRYPTION_HEADER);
            String string5 = (String)this.headers.get(COMMENT_HEADER);
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(string2);
            byteArrayWriter.writeString(string4);
            byteArrayWriter.writeString(string5);
            byteArrayWriter.writeBinaryString(this.pubBlob);
            byteArrayWriter.writeBinaryString(byArray2);
            object3 = byteArrayWriter.toByteArray();
            byArray = this.a((byte[])object3, byArray3);
            object2 = Hex.toHexString(byArray);
            object = (String)this.headers.get(MAC_HEADER);
            if (!((String)object2).toUpperCase().equals(((String)object).toUpperCase())) {
                string = this.isCipher ? "Wrong passphrase" : "MAC failed";
                a.error("MAC mismatch: " + string);
                throw new InvalidSshKeyException(string);
            }
            return this.readKeyPair(this.pubBlob, byArray2, string2);
        }
        catch (Exception exception) {
            throw new InvalidSshKeyException("Failed to read host key: " + exception.getMessage());
        }
    }

    private byte[] a(String string, String string2, int n2, int n3, int n4, String string3) throws InvalidSshKeyException {
        int n5 = 2;
        if (string.equals(h)) {
            n5 = 1;
        } else if (string.equals(g)) {
            n5 = 0;
        } else if (!string.equals(i)) {
            throw new InvalidSshKeyException("Unknown argon flavour " + string);
        }
        Argon2Parameters.Builder builder = new Argon2Parameters.Builder(n5).withVersion(19).withIterations(n3).withMemoryAsKB(n2).withParallelism(n4).withSalt(Hex.decode(string3));
        Argon2BytesGenerator argon2BytesGenerator = new Argon2BytesGenerator();
        argon2BytesGenerator.init(builder.build());
        byte[] byArray = new byte[m];
        argon2BytesGenerator.generateBytes(string2.getBytes(), byArray, 0, byArray.length);
        return byArray;
    }

    private byte[] a(byte[] byArray, byte[] byArray2) {
        HMac hMac = new HMac(new SHA256Digest());
        hMac.init(new KeyParameter(byArray2));
        byte[] byArray3 = new byte[hMac.getMacSize()];
        hMac.update(byArray, 0, byArray.length);
        hMac.doFinal(byArray3, 0);
        return byArray3;
    }

    @Override
    public byte[] encryptKeyblob(byte[] keyblob, String passphrase) throws InvalidSshKeyException {
        throw new InvalidSshKeyException("encryptKeyblob() not implemented");
    }

    @Override
    public boolean supportsAlgorithm(String algorithm) {
        return true;
    }

    @Override
    public String toString() {
        return this.getFormatType();
    }
}

