/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey;

import com.enterprisedt.net.j2ssh.transport.publickey.Base64EncodedFileFormat;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPairFactory;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKeyFormat;

public class SECSHPublicKeyFormat
extends Base64EncodedFileFormat
implements SshPublicKeyFormat {
    public SECSHPublicKeyFormat(String subject, String comment) {
        super("---- BEGIN SSH2 PUBLIC KEY ----", "---- END SSH2 PUBLIC KEY ----");
        this.setHeaderValue("Subject", subject);
        this.setComment(comment);
    }

    public SECSHPublicKeyFormat() {
        super("---- BEGIN SSH2 PUBLIC KEY ----", "---- END SSH2 PUBLIC KEY ----");
    }

    @Override
    public void setComment(String comment) {
        this.setHeaderValue("Comment", (comment.trim().startsWith("\"") ? "" : "\"") + comment.trim() + (comment.trim().endsWith("\"") ? "" : "\""));
    }

    @Override
    public String getComment() {
        return this.getHeaderValue("Comment");
    }

    @Override
    public String getFormatType() {
        return "SECSH-PublicKey-" + super.getFormatType();
    }

    @Override
    public boolean supportsAlgorithm(String algorithm) {
        return SshKeyPairFactory.supportsKey(algorithm);
    }
}

