/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.transport.AlgorithmNotSupportedException;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPair;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKey;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.net.j2ssh.transport.publickey.dsa.SshDssKeyPair;
import com.enterprisedt.net.j2ssh.transport.publickey.ecdsa.SshEcdsaNistp256KeyPair;
import com.enterprisedt.net.j2ssh.transport.publickey.ecdsa.SshEcdsaNistp384KeyPair;
import com.enterprisedt.net.j2ssh.transport.publickey.ecdsa.SshEcdsaNistp521KeyPair;
import com.enterprisedt.net.j2ssh.transport.publickey.rsa.SshRsaKeyPair;
import com.enterprisedt.net.j2ssh.transport.publickey.rsa.SshRsaSha256KeyPair;
import com.enterprisedt.net.j2ssh.transport.publickey.rsa.SshRsaSha512KeyPair;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SshKeyPairFactory {
    public static String DSA = "ssh-dss";
    public static String RSA = "ssh-rsa";
    public static String RSA_256 = "rsa-sha2-256";
    public static String RSA_512 = "rsa-sha2-512";
    public static String ECDSA_SHA2_NISTP256 = "ecdsa-sha2-nistp256";
    public static String ECDSA_SHA2_NISTP384 = "ecdsa-sha2-nistp384";
    public static String ECDSA_SHA2_NISTP521 = "ecdsa-sha2-nistp521";
    public static int MAX_ALGORITHM_NAME_LEN = 100;
    private static Map a;
    private static String b;
    private static Logger c;
    private List d = new ArrayList(a.keySet());

    public static void initialize() {
    }

    public static String getDefaultPublicKey() {
        return b;
    }

    public List getEnabledKeyPairs() {
        return this.d;
    }

    public void setEnabledKeyPairs(List enabled) {
        this.d = enabled;
    }

    public void disableAllKeys() {
        this.d.clear();
    }

    public void setPreferredKeyPair(String keyPair) {
        c.debug("Setting preferred keypair = " + keyPair);
        if (!a.containsKey(keyPair)) {
            c.warn(keyPair + " not set to preferred as not supported");
        } else {
            if (this.d.contains(keyPair)) {
                this.d.remove(keyPair);
            }
            this.d.add(0, keyPair);
        }
    }

    public void setKeyEnabled(String algorithmName, boolean enable) throws AlgorithmNotSupportedException {
        if (!a.containsKey(algorithmName)) {
            throw new AlgorithmNotSupportedException(algorithmName + " is not supported!");
        }
        if (enable) {
            if (!this.d.contains(algorithmName)) {
                this.d.add(algorithmName);
            }
        } else {
            this.d.remove(algorithmName);
        }
    }

    public boolean isKeyEnabled(String algorithmName) {
        return this.d.contains(algorithmName);
    }

    public static SshKeyPair newInstance(String methodName) throws AlgorithmNotSupportedException {
        try {
            return (SshKeyPair)((Class)a.get(methodName)).newInstance();
        }
        catch (Exception exception) {
            throw new AlgorithmNotSupportedException(methodName + " is not supported!", exception);
        }
    }

    public static boolean supportsKey(String algorithm) {
        return a.containsKey(algorithm);
    }

    public static SshPrivateKey decodePrivateKey(byte[] encoded) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(encoded);
            String string = byteArrayReader.readString(MAX_ALGORITHM_NAME_LEN);
            if (SshKeyPairFactory.supportsKey(string)) {
                SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance(string);
                return sshKeyPair.decodePrivateKey(encoded);
            }
            throw new AlgorithmNotSupportedException(string + " is not supported");
        }
        catch (IOException iOException) {
            throw new InvalidSshKeyException(iOException);
        }
    }

    public static SshPublicKey decodePublicKey(byte[] encoded) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(encoded);
            String string = byteArrayReader.readString(MAX_ALGORITHM_NAME_LEN);
            if (SshKeyPairFactory.supportsKey(string)) {
                SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance(string);
                return sshKeyPair.decodePublicKey(encoded);
            }
            throw new AlgorithmNotSupportedException(string + " is not supported");
        }
        catch (IOException iOException) {
            throw new InvalidSshKeyException(iOException);
        }
    }

    static {
        c = Logger.getLogger("SshKeyPairFactory");
        a = new LinkedHashMap();
        c.debug("Loading public key algorithms");
        a.put(RSA, SshRsaKeyPair.class);
        a.put(RSA_256, SshRsaSha256KeyPair.class);
        a.put(RSA_512, SshRsaSha512KeyPair.class);
        a.put(ECDSA_SHA2_NISTP256, SshEcdsaNistp256KeyPair.class);
        a.put(ECDSA_SHA2_NISTP384, SshEcdsaNistp384KeyPair.class);
        a.put(ECDSA_SHA2_NISTP521, SshEcdsaNistp521KeyPair.class);
        a.put(DSA, SshDssKeyPair.class);
        b = RSA;
    }
}

