/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey.ecdsa;

import com.enterprisedt.bouncycastle.asn1.x9.X9ECParameters;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.signers.ECDSASigner;
import com.enterprisedt.bouncycastle.crypto.signers.HMacDSAKCalculator;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPairFactory;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKey;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.math.BigInteger;

public abstract class SshEcdsaNistpPrivateKey
extends SshPrivateKey {
    private static Logger a = Logger.getLogger("SshEcdsaNistpPrivateKey");
    protected ECPublicKeyParameters pubkeyParams;
    protected BigInteger d;

    public SshEcdsaNistpPrivateKey(ECPublicKeyParameters pubkeyParams, BigInteger d2) {
        this.pubkeyParams = pubkeyParams;
        this.d = d2;
    }

    public BigInteger getD() {
        return this.d;
    }

    public SshEcdsaNistpPrivateKey(byte[] encoded) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(encoded);
            String string = byteArrayReader.readString(SshKeyPairFactory.MAX_ALGORITHM_NAME_LEN);
            if (!string.equals(this.getKeyFormatName())) {
                String string2 = "Header '" + string + "' does not match algorithm '" + this.getKeyFormatName() + "'";
                a.error(string2);
                throw new InvalidSshKeyException(string2);
            }
            X9ECParameters x9ECParameters = this.getCurve();
            String string3 = byteArrayReader.readString();
            ECPoint eCPoint = x9ECParameters.getCurve().decodePoint(byteArrayReader.readBinaryString());
            ECDomainParameters eCDomainParameters = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
            this.pubkeyParams = new ECPublicKeyParameters(eCPoint, eCDomainParameters);
            this.d = byteArrayReader.readBigInteger();
        }
        catch (InvalidSshKeyException invalidSshKeyException) {
            throw invalidSshKeyException;
        }
        catch (Exception exception) {
            String string = "Failed to create private key";
            a.error(string, exception);
            throw new InvalidSshKeyException(string);
        }
    }

    protected abstract X9ECParameters getCurve();

    protected abstract String getCurveName();

    protected abstract Digest getDigest();

    public boolean equals(Object obj) {
        if (obj instanceof SshEcdsaNistpPrivateKey) {
            return this.d.equals(((SshEcdsaNistpPrivateKey)obj).getD());
        }
        return false;
    }

    public int hashCode() {
        return this.d.hashCode();
    }

    @Override
    public byte[] getEncoded() {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(this.getCurveName());
            byteArrayWriter.write(this.getPublicKey().getEncoded());
            byteArrayWriter.writeBigInteger(this.d);
            return byteArrayWriter.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public byte[] generateSignature(byte[] data) {
        try {
            ECDSASigner eCDSASigner = new ECDSASigner(new HMacDSAKCalculator(this.getDigest()));
            ECPrivateKeyParameters eCPrivateKeyParameters = new ECPrivateKeyParameters(this.d, this.pubkeyParams.getParameters());
            eCDSASigner.init(true, eCPrivateKeyParameters);
            Digest digest = this.getDigest();
            digest.update(data, 0, data.length);
            byte[] byArray = new byte[digest.getDigestSize()];
            digest.doFinal(byArray, 0);
            BigInteger[] bigIntegerArray = eCDSASigner.generateSignature(byArray);
            byte[] byArray2 = this.a(bigIntegerArray[0], bigIntegerArray[1]);
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(this.getKeyFormatName());
            byteArrayWriter.writeBinaryString(byArray2);
            return byteArrayWriter.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private byte[] a(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeBigInteger(bigInteger);
        byteArrayWriter.writeBigInteger(bigInteger2);
        return byteArrayWriter.toByteArray();
    }
}

