/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey.rsa;

import com.enterprisedt.net.j2ssh.configuration.ConfigurationLoader;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPair;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPairFactory;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKey;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.net.j2ssh.transport.publickey.rsa.SshRsaPrivateKey;
import com.enterprisedt.net.j2ssh.transport.publickey.rsa.SshRsaPublicKey;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class SshRsaKeyPair
extends SshKeyPair {
    protected String algorithm = SshKeyPairFactory.RSA;

    @Override
    public SshPrivateKey decodePrivateKey(byte[] encoded) throws InvalidSshKeyException {
        SshRsaPrivateKey sshRsaPrivateKey = new SshRsaPrivateKey(encoded);
        sshRsaPrivateKey.setKeyAlgorithmName(this.algorithm);
        return sshRsaPrivateKey;
    }

    @Override
    public SshPublicKey decodePublicKey(byte[] encoded) throws InvalidSshKeyException {
        SshRsaPublicKey sshRsaPublicKey = new SshRsaPublicKey(encoded);
        sshRsaPublicKey.setKeyAlgorithmName(this.algorithm);
        return sshRsaPublicKey;
    }

    @Override
    public void generate(int bits) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "CryptixEDT");
            keyPairGenerator.initialize(bits, ConfigurationLoader.getRND());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            SshRsaPrivateKey sshRsaPrivateKey = new SshRsaPrivateKey((RSAPrivateKey)keyPair.getPrivate(), (RSAPublicKey)keyPair.getPublic());
            sshRsaPrivateKey.setKeyAlgorithmName(this.algorithm);
            this.setPrivateKey(sshRsaPrivateKey);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (NoSuchProviderException noSuchProviderException) {
        }
        catch (InvalidSshKeyException invalidSshKeyException) {
            // empty catch block
        }
    }

    public static String getSignatureName(String algorithmName) {
        if (algorithmName.equals(SshKeyPairFactory.RSA)) {
            return "SHA1withRSA";
        }
        if (algorithmName.equals(SshKeyPairFactory.RSA_256)) {
            return "SHA-256/RSA";
        }
        if (algorithmName.equals(SshKeyPairFactory.RSA_512)) {
            return "SHA-512/RSA";
        }
        return null;
    }
}

