/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey.rsa;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPairFactory;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKey;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.net.j2ssh.transport.publickey.rsa.SshRsaKeyPair;
import com.enterprisedt.net.j2ssh.transport.publickey.rsa.SshRsaPublicKey;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class SshRsaPrivateKey
extends SshPrivateKey {
    private static Logger a = Logger.getLogger("SshRsaPrivateKey");
    private RSAPrivateKey b;
    private RSAPublicKey c;
    private String d = SshKeyPairFactory.RSA;

    public SshRsaPrivateKey(RSAPrivateKey prv, RSAPublicKey pub) {
        this.b = prv;
        this.c = pub;
    }

    public SshRsaPrivateKey(byte[] encoded) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(encoded);
            String string = byteArrayReader.readString(SshKeyPairFactory.MAX_ALGORITHM_NAME_LEN);
            if (!string.equals(SshKeyPairFactory.RSA)) {
                String string2 = "Header '" + string + "' does not match algorithm name '" + SshKeyPairFactory.RSA + "'";
                a.error(string2);
                throw new InvalidSshKeyException(string2);
            }
            BigInteger bigInteger = byteArrayReader.readBigInteger();
            BigInteger bigInteger2 = byteArrayReader.readBigInteger();
            BigInteger bigInteger3 = byteArrayReader.readBigInteger();
            RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(bigInteger2, bigInteger3);
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger2, bigInteger);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            this.b = (RSAPrivateKey)keyFactory.generatePrivate(rSAPrivateKeySpec);
            this.c = (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
        }
        catch (InvalidSshKeyException invalidSshKeyException) {
            throw invalidSshKeyException;
        }
        catch (Exception exception) {
            String string = "Failed to create private key";
            a.error(string, exception);
            throw new InvalidSshKeyException(string);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof SshRsaPrivateKey) {
            return this.b.equals(((SshRsaPrivateKey)obj).b);
        }
        return false;
    }

    public int hashCode() {
        return this.b.hashCode();
    }

    @Override
    public String getKeyFormatName() {
        return SshKeyPairFactory.RSA;
    }

    @Override
    public void setKeyAlgorithmName(String algorithmName) throws InvalidSshKeyException {
        this.d = algorithmName;
    }

    @Override
    public String getKeyAlgorithmName() {
        return this.d;
    }

    @Override
    public int getBitLength() {
        return this.b.getModulus().bitLength();
    }

    @Override
    public byte[] getEncoded() {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.write(this.getPublicKey().getEncoded());
            byteArrayWriter.writeBigInteger(this.b.getPrivateExponent());
            return byteArrayWriter.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public SshPublicKey getPublicKey() {
        SshRsaPublicKey sshRsaPublicKey = new SshRsaPublicKey(this.c);
        try {
            sshRsaPublicKey.setKeyAlgorithmName(this.getKeyAlgorithmName());
        }
        catch (InvalidSshKeyException invalidSshKeyException) {
            a.warn(invalidSshKeyException.getCause().getMessage());
        }
        return sshRsaPublicKey;
    }

    @Override
    public byte[] generateSignature(byte[] data) {
        try {
            a.debug("generateSignature: keyAlgorithm=" + this.getKeyAlgorithmName());
            Signature signature = Signature.getInstance(SshRsaKeyPair.getSignatureName(this.getKeyAlgorithmName()), "CryptixEDT");
            signature.initSign(this.b);
            signature.update(data);
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(this.getKeyAlgorithmName());
            byteArrayWriter.writeBinaryString(signature.sign());
            return byteArrayWriter.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

