/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.DynamicVariable;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.event.ProgressNotifiers;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.data.DefaultVariables;
import com.izforge.izpack.core.data.DynamicVariableImpl;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import com.izforge.izpack.core.variable.EnvironmentValue;
import com.izforge.izpack.core.variable.ExecValue;
import com.izforge.izpack.core.variable.JarEntryConfigValue;
import com.izforge.izpack.core.variable.PlainConfigFileValue;
import com.izforge.izpack.core.variable.PlainValue;
import com.izforge.izpack.core.variable.RegistryValue;
import com.izforge.izpack.core.variable.ZipEntryConfigFileValue;
import com.izforge.izpack.core.variable.filters.CaseStyleFilter;
import com.izforge.izpack.core.variable.filters.LocationFilter;
import com.izforge.izpack.core.variable.filters.RegularExpressionFilter;
import com.izforge.izpack.event.AbstractProgressInstallerListener;
import com.izforge.izpack.event.ConfigurationAction;
import com.izforge.izpack.event.ConfigurationActionTask;
import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.config.ConfigFileTask;
import com.izforge.izpack.util.config.ConfigurableFileCopyTask;
import com.izforge.izpack.util.config.ConfigurableTask;
import com.izforge.izpack.util.config.IniFileCopyTask;
import com.izforge.izpack.util.config.OptionFileCopyTask;
import com.izforge.izpack.util.config.RegistryTask;
import com.izforge.izpack.util.config.SingleConfigurableTask;
import com.izforge.izpack.util.config.SingleIniFileTask;
import com.izforge.izpack.util.config.SingleOptionFileTask;
import com.izforge.izpack.util.config.SingleXmlFileMergeTask;
import com.izforge.izpack.util.file.FileNameMapper;
import com.izforge.izpack.util.file.GlobPatternMapper;
import com.izforge.izpack.util.file.types.FileSet;
import com.izforge.izpack.util.file.types.Mapper;
import com.izforge.izpack.util.helper.SpecHelper;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigurationInstallerListener
extends AbstractProgressInstallerListener {
    private static final Logger logger = Logger.getLogger(ConfigurationInstallerListener.class.getName());
    public static final String SPEC_FILE_NAME = "ConfigurationActionsSpec.xml";
    private static final String ERRMSG_CONFIGACTION_BADATTR = "Bad attribute value in configuration action: {0}=\"{1}\" not allowed";
    public static final String CONFIGURATIONACTION_ATTR = "configurationaction";
    public static final String CONFIGURABLESET_ATTR = "configurableset";
    public static final String CONFIGURABLE_ATTR = "configurable";
    public static final String CONDITION_ATTR = "condition";
    private final Map<String, Map<Object, List<ConfigurationAction>>> actions = new HashMap<String, Map<Object, List<ConfigurationAction>>>();
    private final Resources resources;
    private final VariableSubstitutor replacer;
    private SpecHelper spec;
    private VariableSubstitutor substlocal;

    public ConfigurationInstallerListener(InstallData installData, Resources resources, VariableSubstitutor replacer, ProgressNotifiers notifiers) {
        super(installData, notifiers);
        this.resources = resources;
        this.replacer = replacer;
    }

    public Map<String, Map<Object, List<ConfigurationAction>>> getActions() {
        return this.actions;
    }

    @Override
    public void initialise() {
        this.spec = new SpecHelper(this.resources);
        try {
            this.spec.readSpec(SPEC_FILE_NAME);
        }
        catch (Exception exception) {
            throw new IzPackException("Failed to read: ConfigurationActionsSpec.xml", exception);
        }
    }

    @Override
    public void beforePacks(List<Pack> packs) {
        if (this.spec.getSpec() == null) {
            return;
        }
        for (Pack p2 : packs) {
            logger.fine("Entering beforepacks configuration action for pack " + p2.getName());
            IXMLElement pack = this.spec.getPackForName(p2.getName());
            if (pack == null) continue;
            logger.fine("Found configuration action descriptor for pack " + p2.getName());
            HashMap packActions = new HashMap();
            packActions.put("beforepack", new ArrayList());
            packActions.put("afterpack", new ArrayList());
            packActions.put("beforepacks", new ArrayList());
            packActions.put("afterpacks", new ArrayList());
            List<IXMLElement> configActionEntries = pack.getChildrenNamed(CONFIGURATIONACTION_ATTR);
            if (configActionEntries != null) {
                logger.fine("Found " + configActionEntries.size() + " configuration actions");
                if (configActionEntries.size() >= 1) {
                    for (IXMLElement configActionEntry : configActionEntries) {
                        ConfigurationAction act = this.readConfigAction(configActionEntry);
                        if (act == null) continue;
                        logger.fine("Adding " + act.getOrder() + "configuration action with " + act.getActionTasks().size() + " tasks");
                        ((List)packActions.get(act.getOrder())).add(act);
                    }
                    if (((List)packActions.get("afterpacks")).size() > 0) {
                        this.setProgressNotifier();
                    }
                }
                if (((List)packActions.get("afterpacks")).size() > 0) {
                    this.setProgressNotifier();
                }
            }
            this.actions.put(p2.getName(), packActions);
        }
        for (Pack p2 : packs) {
            String currentPack = p2.getName();
            this.performAllActions(currentPack, "beforepacks", null);
        }
    }

    @Override
    public void beforePack(Pack pack) {
        this.performAllActions(pack.getName(), "beforepack", null);
    }

    @Override
    public void afterPack(Pack pack) {
        this.performAllActions(pack.getName(), "afterpack", null);
    }

    @Override
    public void afterPacks(List<Pack> packs, ProgressListener listener) {
        if (this.notifyProgress()) {
            listener.nextStep(this.getMessage("ConfigurationAction.pack"), this.getProgressNotifierId(), this.getActionCount(packs, "afterpacks"));
        }
        for (Pack pack : packs) {
            String currentPack = pack.getName();
            this.performAllActions(currentPack, "afterpacks", listener);
        }
    }

    private int getActionCount(List<Pack> packs, String order) {
        int retval = 0;
        for (Pack pack : packs) {
            String currentPack = pack.getName();
            List<ConfigurationAction> actList = this.getActions(currentPack, order);
            if (actList == null) continue;
            retval += actList.size();
        }
        return retval;
    }

    protected List<ConfigurationAction> getActions(String packName, String order) {
        Map<Object, List<ConfigurationAction>> packActions = this.actions.get(packName);
        if (packActions == null || packActions.size() == 0) {
            return null;
        }
        return packActions.get(order);
    }

    private void performAllActions(String packName, String order, ProgressListener listener) throws InstallerException {
        List<ConfigurationAction> actList = this.getActions(packName, order);
        if (actList == null || actList.size() == 0) {
            return;
        }
        logger.fine("Executing all " + order + " configuration actions for " + packName + " ...");
        for (ConfigurationAction act : actList) {
            if (this.notifyProgress() && order.equals("afterpacks")) {
                listener.progress(act.getMessageID() != null ? this.getMessage(act.getMessageID()) : "");
                continue;
            }
            try {
                act.performInstallAction();
            }
            catch (Exception e2) {
                throw new InstallerException(e2);
            }
        }
    }

    private ConfigurationAction readConfigAction(IXMLElement el) throws InstallerException {
        if (el == null) {
            return null;
        }
        ConfigurationAction act = new ConfigurationAction();
        try {
            act.setOrder(this.spec.getRequiredAttribute(el, "order"));
        }
        catch (Exception e2) {
            throw new InstallerException(e2);
        }
        this.substlocal = new VariableSubstitutorImpl(new DefaultVariables(this.readVariables(el)));
        act.setActionTasks(this.readConfigurables(el));
        act.addActionTasks(this.readConfigurableSets(el));
        return act;
    }

    private String substituteVariables(String name) {
        try {
            name = this.replacer.substitute(name);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Failed to substitute: " + name, exception);
        }
        if (this.substlocal != null) {
            try {
                name = this.substlocal.substitute(name);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Failed to substitute: " + name, exception);
            }
        }
        return name;
    }

    protected List<ConfigurationActionTask> readConfigurableSets(IXMLElement parent) throws InstallerException {
        ArrayList<ConfigurationActionTask> configtasks = new ArrayList<ConfigurationActionTask>();
        for (IXMLElement el : parent.getChildrenNamed(CONFIGURABLESET_ATTR)) {
            ConfigurableFileCopyTask task;
            ConfigType configType;
            String attrib = this.requireAttribute(el, "type");
            if (attrib != null) {
                configType = ConfigType.getFromAttribute(attrib);
                if (configType == null) {
                    throw new InstallerException("Unknown configurableset type '" + attrib + "'");
                }
            } else {
                throw new InstallerException("Missing configurableset type");
            }
            switch (configType) {
                case OPTIONS: {
                    task = new OptionFileCopyTask();
                    this.readConfigurableSetCommonAttributes(el, task);
                    break;
                }
                case INI: {
                    task = new IniFileCopyTask();
                    this.readConfigurableSetCommonAttributes(el, task);
                    break;
                }
                default: {
                    throw new InstallerException("Type '" + configType.getAttribute() + "' currently not allowed for ConfigurableSet");
                }
            }
            configtasks.add(new ConfigurationActionTask(task, this.getAttribute(el, CONDITION_ATTR), this.getInstallData().getRules()));
        }
        return configtasks;
    }

    private void readConfigurableSetCommonAttributes(IXMLElement el, ConfigurableFileCopyTask task) throws InstallerException {
        InstallData idata = this.getInstallData();
        task.setToDir(FileUtil.getAbsoluteFile(this.getAttribute(el, "todir"), idata.getInstallPath()));
        task.setToFile(FileUtil.getAbsoluteFile(this.getAttribute(el, "tofile"), idata.getInstallPath()));
        task.setFile(FileUtil.getAbsoluteFile(this.getAttribute(el, "fromfile"), idata.getInstallPath()));
        String boolattr = this.getAttribute(el, "keepOldKeys");
        if (boolattr != null) {
            task.setPatchPreserveEntries(Boolean.parseBoolean(boolattr));
        }
        if ((boolattr = this.getAttribute(el, "keepOldValues")) != null) {
            task.setPatchPreserveValues(Boolean.parseBoolean(boolattr));
        }
        if ((boolattr = this.getAttribute(el, "resolveExpressions")) != null) {
            task.setPatchResolveExpressions(Boolean.parseBoolean(boolattr));
        }
        if ((boolattr = this.getAttribute(el, "failonerror")) != null) {
            task.setFailOnError(Boolean.parseBoolean(boolattr));
        }
        if ((boolattr = this.getAttribute(el, "includeemptydirs")) != null) {
            task.setIncludeEmptyDirs(Boolean.parseBoolean(boolattr));
        }
        if ((boolattr = this.getAttribute(el, "overwrite")) != null) {
            task.setOverwrite(Boolean.parseBoolean(boolattr));
        }
        if ((boolattr = this.getAttribute(el, "preservelastmodified")) != null) {
            task.setPreserveLastModified(Boolean.parseBoolean(boolattr));
        }
        if ((boolattr = this.getAttribute(el, "enablemultiplemappings")) != null) {
            task.setEnableMultipleMappings(Boolean.parseBoolean(boolattr));
        }
        if ((boolattr = this.getAttribute(el, "cleanup")) != null) {
            task.setCleanup(Boolean.parseBoolean(boolattr));
        }
        for (FileSet fs : this.readFileSets(el)) {
            task.addFileSet(fs);
        }
        try {
            for (FileNameMapper mapper : this.readMapper(el)) {
                task.add(mapper);
            }
        }
        catch (Exception e2) {
            throw new InstallerException(e2.getMessage());
        }
    }

    private void readSingleConfigurableTaskCommonAttributes(IXMLElement el, SingleConfigurableTask task) throws InstallerException {
        String attr = this.getAttribute(el, "create");
        if (attr != null) {
            task.setCreate(Boolean.parseBoolean(attr));
        }
        if ((attr = this.getAttribute(el, "keepOldKeys")) != null) {
            task.setPatchPreserveEntries(Boolean.parseBoolean(attr));
        }
        if ((attr = this.getAttribute(el, "keepOldValues")) != null) {
            task.setPatchPreserveValues(Boolean.parseBoolean(attr));
        }
        if ((attr = this.getAttribute(el, "resolveExpressions")) != null) {
            task.setPatchResolveVariables(Boolean.parseBoolean(attr));
        }
        if ((attr = this.getAttribute(el, "escape")) != null) {
            task.setEscape(Boolean.parseBoolean(attr));
        }
        if ((attr = this.getAttribute(el, "escapeNewLine")) != null) {
            task.setEscapeNewLine(Boolean.parseBoolean(attr));
        }
        if ((attr = this.getAttribute(el, "headerComment")) != null) {
            task.setHeaderComment(Boolean.parseBoolean(attr));
        }
        if ((attr = this.getAttribute(el, "emptyLines")) != null) {
            task.setEmptyLines(Boolean.parseBoolean(attr));
        }
        if ((attr = this.getAttribute(el, "operator")) != null) {
            task.setOperator(attr);
        }
    }

    private void readConfigFileTaskCommonAttributes(InstallData idata, IXMLElement el, ConfigFileTask task) throws InstallerException {
        File tofile = FileUtil.getAbsoluteFile(this.replacer.substitute(this.requireAttribute(el, "tofile")), idata.getInstallPath());
        task.setToFile(tofile);
        task.setOldFile(FileUtil.getAbsoluteFile(this.getAttribute(el, "patchfile"), idata.getInstallPath()));
        File newfile = FileUtil.getAbsoluteFile(this.getAttribute(el, "originalfile"), idata.getInstallPath());
        task.setNewFile(newfile);
        String boolattr = this.getAttribute(el, "cleanup");
        if (boolattr != null) {
            task.setCleanup(Boolean.parseBoolean(boolattr));
        }
    }

    protected List<ConfigurationActionTask> readConfigurables(IXMLElement parent) throws InstallerException {
        ArrayList<ConfigurationActionTask> configtasks = new ArrayList<ConfigurationActionTask>();
        InstallData idata = this.getInstallData();
        for (IXMLElement el : parent.getChildrenNamed(CONFIGURABLE_ATTR)) {
            ConfigurableTask task;
            ConfigType configType;
            String attrib = this.requireAttribute(el, "type");
            if (attrib != null) {
                configType = ConfigType.getFromAttribute(attrib);
                if (configType == null) {
                    throw new InstallerException("Unknown configurable type '" + attrib + "'");
                }
            } else {
                throw new InstallerException("Missing configurable type");
            }
            switch (configType) {
                case OPTIONS: {
                    task = new SingleOptionFileTask();
                    this.readConfigFileTaskCommonAttributes(idata, el, (ConfigFileTask)task);
                    this.readSingleConfigurableTaskCommonAttributes(el, (SingleConfigurableTask)task);
                    this.readAndAddEntries(el, (SingleConfigurableTask)task);
                    break;
                }
                case INI: {
                    task = new SingleIniFileTask();
                    this.readConfigFileTaskCommonAttributes(idata, el, (ConfigFileTask)task);
                    this.readSingleConfigurableTaskCommonAttributes(el, (SingleConfigurableTask)task);
                    this.readAndAddEntries(el, (SingleConfigurableTask)task);
                    break;
                }
                case XML: {
                    task = new SingleXmlFileMergeTask();
                    File tofile = FileUtil.getAbsoluteFile(this.replacer.substitute(this.requireAttribute(el, "tofile")), idata.getInstallPath());
                    ((SingleXmlFileMergeTask)task).setToFile(tofile);
                    ((SingleXmlFileMergeTask)task).setPatchFile(FileUtil.getAbsoluteFile(this.getAttribute(el, "patchfile"), idata.getInstallPath()));
                    File originalfile = FileUtil.getAbsoluteFile(this.getAttribute(el, "originalfile"), idata.getInstallPath());
                    if (originalfile == null) {
                        originalfile = tofile;
                    }
                    ((SingleXmlFileMergeTask)task).setOriginalFile(originalfile);
                    ((SingleXmlFileMergeTask)task).setConfigFile(FileUtil.getAbsoluteFile(this.getAttribute(el, "configfile"), idata.getInstallPath()));
                    String boolattr = this.getAttribute(el, "cleanup");
                    if (boolattr != null) {
                        ((SingleXmlFileMergeTask)task).setCleanup(Boolean.parseBoolean(boolattr));
                    }
                    List<FileSet> fslist = this.readFileSets(el);
                    for (FileSet fs : fslist) {
                        ((SingleXmlFileMergeTask)task).addFileSet(fs);
                    }
                    this.readAndAddXPathProperties(el, (SingleXmlFileMergeTask)task);
                    break;
                }
                case REGISTRY: {
                    task = new RegistryTask();
                    ((RegistryTask)task).setFromKey(this.replacer.substitute(this.requireAttribute(el, "fromkey")));
                    ((RegistryTask)task).setKey(this.replacer.substitute(this.requireAttribute(el, "tokey")));
                    this.readSingleConfigurableTaskCommonAttributes(el, (SingleConfigurableTask)task);
                    break;
                }
                default: {
                    throw new InstallerException("Type '" + configType.getAttribute() + "' currently not allowed for Configurable");
                }
            }
            configtasks.add(new ConfigurationActionTask(task, this.getAttribute(el, CONDITION_ATTR), this.getInstallData().getRules()));
        }
        return configtasks;
    }

    public void readAndAddEntries(IXMLElement parent, SingleConfigurableTask task) throws InstallerException {
        for (IXMLElement el : parent.getChildrenNamed("entry")) {
            SingleConfigurableTask.Entry entry = this.createEntryFromXML(el);
            if (task instanceof SingleOptionFileTask) {
                entry.setKey(el.getAttribute("key"));
                entry.setValue(this.getAttribute(el, "value"));
            } else if (task instanceof SingleIniFileTask) {
                entry.setSection(el.getAttribute("section"));
                entry.setKey(el.getAttribute("key"));
                entry.setValue(this.getAttribute(el, "value"));
            } else if (task instanceof RegistryTask) {
                entry.setSection(el.getAttribute("key"));
                entry.setKey(this.replacer.substitute(el.getAttribute("value")));
                entry.setValue(this.getAttribute(el, "data"));
            }
            task.addEntry(entry);
        }
    }

    private SingleConfigurableTask.Entry createEntryFromXML(IXMLElement parent) throws InstallerException {
        SingleConfigurableTask.Entry e2 = new SingleConfigurableTask.Entry();
        String attrib = parent.getAttribute("dataType");
        if (attrib != null) {
            SingleConfigurableTask.Entry.Type type = SingleConfigurableTask.Entry.Type.getFromAttribute(attrib);
            if (type == null) {
                throw new InstallerException(MessageFormat.format(ERRMSG_CONFIGACTION_BADATTR, "dataType", attrib));
            }
            e2.setType(type);
        }
        if ((attrib = parent.getAttribute("lookupType")) != null) {
            SingleConfigurableTask.Entry.LookupType lookupType = SingleConfigurableTask.Entry.LookupType.getFromAttribute(attrib);
            if (lookupType == null) {
                throw new InstallerException(MessageFormat.format(ERRMSG_CONFIGACTION_BADATTR, "lookupType", attrib));
            }
            e2.setLookupType(lookupType);
        }
        if ((attrib = parent.getAttribute("operation")) != null) {
            SingleConfigurableTask.Entry.Operation operation = SingleConfigurableTask.Entry.Operation.getFromAttribute(attrib);
            if (operation == null) {
                throw new InstallerException(MessageFormat.format(ERRMSG_CONFIGACTION_BADATTR, "operation", attrib));
            }
            e2.setOperation(operation);
        }
        if ((attrib = parent.getAttribute("unit")) != null) {
            SingleConfigurableTask.Unit unit = SingleConfigurableTask.Unit.getFromAttribute(attrib);
            if (unit == null) {
                throw new InstallerException(MessageFormat.format(ERRMSG_CONFIGACTION_BADATTR, "unit", attrib));
            }
            e2.setUnit(unit);
        }
        e2.setDefault(this.replacer.substitute(parent.getAttribute("default")));
        e2.setPattern(parent.getAttribute("pattern"));
        return e2;
    }

    private void readAndAddXPathProperties(IXMLElement parent, SingleXmlFileMergeTask task) throws InstallerException {
        for (IXMLElement f2 : parent.getChildrenNamed("xpathproperty")) {
            task.addProperty(this.requireAttribute(f2, "key"), this.replacer.substitute(this.requireAttribute(f2, "value")));
        }
    }

    private List<FileSet> readFileSets(IXMLElement parent) throws InstallerException {
        Iterator<IXMLElement> iter = parent.getChildrenNamed("fileset").iterator();
        ArrayList<FileSet> fslist = new ArrayList<FileSet>();
        try {
            String installPath = this.getInstallData().getInstallPath();
            while (iter.hasNext()) {
                String boolval;
                IXMLElement f2 = iter.next();
                FileSet fs = new FileSet();
                String strattr = this.getAttribute(f2, "dir");
                if (strattr != null) {
                    fs.setDir(FileUtil.getAbsoluteFile(strattr, installPath));
                }
                if ((strattr = this.getAttribute(f2, "file")) != null) {
                    fs.setFile(FileUtil.getAbsoluteFile(strattr, installPath));
                } else if (fs.getDir() == null) {
                    throw new InstallerException("At least one of both attributes, 'dir' or 'file' required in fileset");
                }
                strattr = this.getAttribute(f2, "includes");
                if (strattr != null) {
                    fs.setIncludes(strattr);
                }
                if ((strattr = this.getAttribute(f2, "excludes")) != null) {
                    fs.setExcludes(strattr);
                }
                if ((boolval = this.getAttribute(f2, "casesensitive")) != null) {
                    fs.setCaseSensitive(Boolean.parseBoolean(boolval));
                }
                if ((boolval = this.getAttribute(f2, "defaultexcludes")) != null) {
                    fs.setDefaultexcludes(Boolean.parseBoolean(boolval));
                }
                if ((boolval = this.getAttribute(f2, "followsymlinks")) != null) {
                    fs.setFollowSymlinks(Boolean.parseBoolean(boolval));
                }
                this.readAndAddIncludes(f2, fs);
                this.readAndAddExcludes(f2, fs);
                fslist.add(fs);
            }
        }
        catch (Exception e2) {
            throw new InstallerException(e2);
        }
        return fslist;
    }

    private List<FileNameMapper> readMapper(IXMLElement parent) throws InstallerException {
        Iterator<IXMLElement> iter = parent.getChildrenNamed("mapper").iterator();
        ArrayList<FileNameMapper> mappers = new ArrayList<FileNameMapper>();
        try {
            while (iter.hasNext()) {
                Mapper.MapperType mappertype;
                IXMLElement f2 = iter.next();
                String attrib = this.requireAttribute(f2, "type");
                if (attrib != null) {
                    mappertype = Mapper.MapperType.getFromAttribute(attrib);
                    if (mappertype == null) {
                        throw new InstallerException("Unknown filename mapper type '" + attrib + "'");
                    }
                } else {
                    throw new InstallerException("Missing filename mapper type");
                }
                FileNameMapper mapper = (FileNameMapper)Class.forName(mappertype.getImplementation()).newInstance();
                if (mapper instanceof GlobPatternMapper) {
                    String boolval = this.getAttribute(f2, "casesensitive");
                    if (boolval != null) {
                        ((GlobPatternMapper)mapper).setCaseSensitive(Boolean.parseBoolean(boolval));
                    }
                } else {
                    throw new InstallerException("Filename mapper type \"\" currently not supported");
                }
                mapper.setFrom(this.replacer.substitute(this.requireAttribute(f2, "from")));
                mapper.setTo(this.replacer.substitute(this.requireAttribute(f2, "to")));
                mappers.add(mapper);
            }
        }
        catch (Exception e2) {
            throw new InstallerException(e2);
        }
        return mappers;
    }

    private void readAndAddIncludes(IXMLElement parent, FileSet fileset) throws InstallerException {
        for (IXMLElement f2 : parent.getChildrenNamed("include")) {
            fileset.createInclude().setName(this.replacer.substitute(this.requireAttribute(f2, "name")));
        }
    }

    private void readAndAddExcludes(IXMLElement parent, FileSet fileset) throws InstallerException {
        for (IXMLElement f2 : parent.getChildrenNamed("exclude")) {
            fileset.createExclude().setName(this.replacer.substitute(this.requireAttribute(f2, "name")));
        }
    }

    private int getConfigFileType(String varname, String type) throws InstallerException {
        int filetype = 0;
        if (type != null) {
            if (type.equalsIgnoreCase("options")) {
                filetype = 0;
            } else if (type.equalsIgnoreCase("xml")) {
                filetype = 2;
            } else if (type.equalsIgnoreCase("ini")) {
                filetype = 1;
            } else {
                this.parseError("Error in definition of dynamic variable " + varname + ": Unknown entry type " + type);
            }
        }
        return filetype;
    }

    protected Properties readVariables(IXMLElement parent) throws InstallerException {
        LinkedList<DynamicVariableImpl> dynamicVariables = null;
        IXMLElement vars = parent.getFirstChildNamed("variables");
        if (vars != null) {
            logger.fine("Reading variables for configuration action");
            dynamicVariables = new LinkedList<DynamicVariableImpl>();
            for (IXMLElement var : vars.getChildrenNamed("variable")) {
                IXMLElement filters;
                boolean escape;
                String filekey;
                String filesection;
                String stype;
                String entryname;
                String name = this.requireAttribute(var, "name");
                logger.fine("Reading variable '" + name + "'");
                DynamicVariableImpl dynamicVariable = new DynamicVariableImpl();
                dynamicVariable.setName(name);
                String value = this.getAttribute(var, "value");
                if (value != null) {
                    dynamicVariable.setValue(new PlainValue(value));
                } else {
                    IXMLElement valueElement = var.getFirstChildNamed("value");
                    if (valueElement != null) {
                        value = this.replacer.substitute(valueElement.getContent());
                        if (value == null) {
                            this.parseError("Empty value element for dynamic variable " + name);
                        }
                        dynamicVariable.setValue(new PlainValue(value));
                    }
                }
                value = this.getAttribute(var, "environment");
                if (value != null) {
                    if (dynamicVariable.getValue() == null) {
                        dynamicVariable.setValue(new EnvironmentValue(value));
                    } else {
                        this.parseError("Ambiguous environment value definition for dynamic variable " + name);
                    }
                }
                if ((value = this.getAttribute(var, "regkey")) != null) {
                    String regvalue = this.getAttribute(var, "regvalue");
                    if (dynamicVariable.getValue() == null) {
                        dynamicVariable.setValue(new RegistryValue(value, regvalue));
                    } else {
                        this.parseError("Ambiguous registry value definition for dynamic variable " + name);
                    }
                }
                if ((value = this.replacer.substitute(var.getAttribute("file"))) != null) {
                    String stype2 = var.getAttribute("type");
                    String filesection2 = var.getAttribute("section");
                    String filekey2 = this.requireAttribute(var, "key");
                    String escapeVal = var.getAttribute("escape");
                    boolean escape2 = true;
                    if (escapeVal != null) {
                        escape2 = Boolean.parseBoolean(escapeVal);
                    }
                    if (dynamicVariable.getValue() == null) {
                        dynamicVariable.setValue(new PlainConfigFileValue(value, this.getConfigFileType(name, stype2), filesection2, filekey2, escape2));
                    } else {
                        this.parseError("Ambiguous file value definition for dynamic variable " + name);
                    }
                }
                if ((value = var.getAttribute("zipfile")) != null) {
                    entryname = this.requireAttribute(var, "entry");
                    stype = var.getAttribute("type");
                    filesection = var.getAttribute("section");
                    filekey = this.requireAttribute(var, "key");
                    String escapeVal = var.getAttribute("escape");
                    escape = true;
                    if (escapeVal != null) {
                        escape = Boolean.parseBoolean(escapeVal);
                    }
                    if (dynamicVariable.getValue() == null) {
                        dynamicVariable.setValue(new ZipEntryConfigFileValue(value, entryname, this.getConfigFileType(name, stype), filesection, filekey, escape));
                    } else {
                        this.parseError("Ambiguous file value definition for dynamic variable " + name);
                    }
                }
                if ((value = this.replacer.substitute(var.getAttribute("jarfile"))) != null) {
                    entryname = this.requireAttribute(var, "entry");
                    stype = var.getAttribute("type");
                    filesection = var.getAttribute("section");
                    filekey = this.requireAttribute(var, "key");
                    String escapeVal = var.getAttribute("escape");
                    escape = true;
                    if (escapeVal != null) {
                        escape = Boolean.parseBoolean(escapeVal);
                    }
                    if (dynamicVariable.getValue() == null) {
                        dynamicVariable.setValue(new JarEntryConfigValue(value, entryname, this.getConfigFileType(name, stype), filesection, filekey, escape));
                    } else {
                        this.parseError("Ambiguous file value definition for dynamic variable " + name);
                    }
                }
                if ((value = this.getAttribute(var, "executable")) != null) {
                    if (dynamicVariable.getValue() == null) {
                        String dir = var.getAttribute("dir");
                        String exectype = var.getAttribute("type");
                        String boolval = var.getAttribute("stderr");
                        boolean stderr = false;
                        if (boolval != null) {
                            stderr = Boolean.parseBoolean(boolval);
                        }
                        if (value.length() <= 0) {
                            this.parseError("No command given in definition of dynamic variable " + name);
                        }
                        Vector<String> cmd = new Vector<String>();
                        cmd.add(value);
                        List<IXMLElement> args = var.getChildrenNamed("arg");
                        if (args != null) {
                            for (IXMLElement arg : args) {
                                String content = this.replacer.substitute(arg.getContent());
                                if (content == null) continue;
                                cmd.add(content);
                            }
                        }
                        String[] cmdarr = new String[cmd.size()];
                        if (exectype == null || exectype.equalsIgnoreCase("process")) {
                            dynamicVariable.setValue(new ExecValue(cmd.toArray(cmdarr), dir, false, stderr));
                        } else if (exectype.equalsIgnoreCase("shell")) {
                            dynamicVariable.setValue(new ExecValue(cmd.toArray(cmdarr), dir, true, stderr));
                        } else {
                            this.parseError("Bad execution type " + exectype + " given for dynamic variable " + name);
                        }
                    } else {
                        this.parseError("Ambiguous execution output value definition for dynamic variable " + name);
                    }
                }
                if (dynamicVariable.getValue() == null) {
                    this.parseError("No value specified at all for dynamic variable " + name);
                }
                if ((value = this.getAttribute(var, "checkonce")) != null) {
                    dynamicVariable.setCheckonce(Boolean.valueOf(value));
                }
                if ((value = this.getAttribute(var, "ignorefailure")) != null) {
                    dynamicVariable.setIgnoreFailure(Boolean.valueOf(value));
                }
                if ((filters = var.getFirstChildNamed("filters")) != null) {
                    List<IXMLElement> filterList = filters.getChildren();
                    for (IXMLElement filterElement : filterList) {
                        String filterName = filterElement.getName();
                        if (filterName.equals("regex")) {
                            String expression = filterElement.getAttribute("regexp");
                            String selectexpr = filterElement.getAttribute("select");
                            String replaceexpr = filterElement.getAttribute("replace");
                            String defaultvalue = filterElement.getAttribute("defaultvalue");
                            String scasesensitive = filterElement.getAttribute("casesensitive");
                            String sglobal = filterElement.getAttribute("global");
                            dynamicVariable.addFilter(new RegularExpressionFilter(expression, selectexpr, replaceexpr, defaultvalue, Boolean.valueOf(scasesensitive != null ? scasesensitive : "true"), Boolean.valueOf(sglobal != null ? sglobal : "false")));
                            continue;
                        }
                        if (filterName.equals("location")) {
                            String basedir = this.replacer.substitute(filterElement.getAttribute("basedir"));
                            dynamicVariable.addFilter(new LocationFilter(basedir));
                            continue;
                        }
                        if (filterName.equals("casestyle")) {
                            String style = filterElement.getAttribute("style");
                            dynamicVariable.addFilter(new CaseStyleFilter(style));
                            continue;
                        }
                        this.parseError(String.format("Unknown filter '%s'", filterName));
                    }
                }
                try {
                    dynamicVariable.validate();
                }
                catch (Exception e2) {
                    this.parseError("Error in definition of dynamic variable " + name + ": " + e2.getMessage());
                }
                String conditionid = this.getAttribute(var, CONDITION_ATTR);
                dynamicVariable.setConditionid(conditionid);
                dynamicVariables.add(dynamicVariable);
            }
        }
        return this.evaluateDynamicVariables(dynamicVariables);
    }

    private Properties evaluateDynamicVariables(List<DynamicVariable> dynamicvariables) throws InstallerException {
        Properties props = new Properties();
        if (dynamicvariables != null) {
            logger.fine("Evaluating configuration variables");
            RulesEngine rules = this.getInstallData().getRules();
            for (DynamicVariable dynvar : dynamicvariables) {
                String name = dynvar.getName();
                logger.fine("Evaluating configuration variable: " + name);
                boolean refresh = false;
                String conditionid = dynvar.getConditionid();
                logger.fine("Configuration variable condition: " + conditionid);
                if (conditionid != null && conditionid.length() > 0) {
                    if (rules != null && rules.isConditionTrue(conditionid)) {
                        logger.fine("Refresh configuration variable \"" + name + "\" based on global condition \" " + conditionid + "\"");
                        refresh = true;
                    }
                } else {
                    logger.fine("Refresh configuration variable \"" + name + "\" based on local condition \" " + conditionid + "\"");
                    refresh = true;
                }
                if (!refresh) continue;
                try {
                    if (!dynvar.isCheckonce() || !dynvar.isChecked()) {
                        String newValue = dynvar.evaluate(this.replacer);
                        if (newValue != null) {
                            logger.fine("Configuration variable " + name + ": " + newValue);
                            props.setProperty(name, newValue);
                        } else {
                            logger.fine("Configuration variable " + name + " unchanged: " + dynvar.getValue());
                        }
                    }
                    dynvar.setChecked();
                }
                catch (Exception e2) {
                    throw new InstallerException(e2);
                }
            }
        }
        return props;
    }

    protected String requireAttribute(IXMLElement element, String attribute) throws InstallerException {
        String value = this.getAttribute(element, attribute);
        if (value == null) {
            this.parseError(element, "<" + element.getName() + "> requires attribute '" + attribute + "'");
        }
        return value;
    }

    protected String getAttribute(IXMLElement element, String attribute) throws InstallerException {
        String value = element.getAttribute(attribute);
        if (value != null) {
            return this.substituteVariables(value);
        }
        return null;
    }

    protected void parseError(String message) throws InstallerException {
        throw new InstallerException("ConfigurationActionsSpec.xml:" + message);
    }

    protected void parseError(IXMLElement parent, String message) throws InstallerException {
        throw new InstallerException("ConfigurationActionsSpec.xml:" + parent.getLineNr() + ": " + message);
    }

    public static enum ConfigType {
        OPTIONS("options"),
        INI("ini"),
        XML("xml"),
        REGISTRY("registry");

        private static final Map<String, ConfigType> lookup;
        private String attribute;

        private ConfigType(String attribute) {
            this.attribute = attribute;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public static ConfigType getFromAttribute(String attribute) {
            if (attribute != null && lookup.containsKey(attribute)) {
                return lookup.get(attribute);
            }
            return null;
        }

        static {
            lookup = new HashMap<String, ConfigType>();
            for (ConfigType operation : EnumSet.allOf(ConfigType.class)) {
                lookup.put(operation.getAttribute(), operation);
            }
        }
    }
}

