/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui;

import com.izforge.izpack.gui.ConsoleTextArea;
import com.izforge.izpack.gui.ConsoleWrite;
import java.io.InputStreamReader;
import javax.swing.SwingUtilities;

class StdOut
extends Thread {
    private InputStreamReader output;
    private boolean processRunning;
    private ConsoleTextArea cta;
    private StringBuffer data;

    public StdOut(Process p2, ConsoleTextArea cta) {
        this.setDaemon(true);
        this.output = new InputStreamReader(p2.getInputStream());
        this.cta = cta;
        this.processRunning = true;
        this.data = new StringBuffer();
    }

    @Override
    public void run() {
        try {
            while (this.output.ready() || this.processRunning) {
                char[] array;
                int num;
                if (!this.output.ready() || (num = this.output.read(array = new char[255])) == -1) continue;
                String s2 = new String(array, 0, num);
                this.data.append(s2);
                SwingUtilities.invokeAndWait(new ConsoleWrite(this.cta, s2));
            }
        }
        catch (Exception e2) {
            System.err.println("Problem writing to standard output.");
            System.err.println(e2);
        }
    }

    public void done() {
        this.processRunning = false;
    }

    public String getData() {
        return this.data.toString();
    }
}

