/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.debugger;

import com.izforge.izpack.api.rules.Condition;
import java.util.ArrayList;
import java.util.List;

public class ConditionHistory {
    private final Condition condition;
    private final List<Object[]> values;
    private boolean newcondition;
    private boolean changedcondition;

    public ConditionHistory(Condition condition) {
        this.condition = condition;
        this.values = new ArrayList<Object[]>();
        this.newcondition = true;
        this.changedcondition = true;
    }

    public String getId() {
        return this.condition.getId();
    }

    public void addValue(boolean value, String comment) {
        if (this.values.size() == 0 || value != this.getLastValue()) {
            Object[] valuecomment = new Object[]{value, comment};
            this.values.add(valuecomment);
            if (this.values.size() == 1) {
                this.newcondition = true;
                this.changedcondition = true;
            } else {
                this.changedcondition = true;
            }
        }
    }

    public boolean getLastValue() {
        if (this.values.size() > 0) {
            return (Boolean)this.values.get(this.values.size() - 1)[0];
        }
        return false;
    }

    public int getValueCount() {
        return this.values.size();
    }

    public void clearState() {
        this.newcondition = false;
        this.changedcondition = false;
    }

    public boolean isNewcondition() {
        return this.newcondition;
    }

    public boolean isChangedcondition() {
        return this.changedcondition;
    }

    public String getConditionHistoryDetails() {
        StringBuffer details = new StringBuffer();
        details.append("<html><body>");
        details.append("<h3>Details of <b>");
        details.append(this.condition.getId());
        details.append("</b></h3>");
        for (int i2 = this.values.size() - 1; i2 >= 0; --i2) {
            Object[] condcomment = this.values.get(i2);
            details.append(i2 + 1);
            details.append(". ");
            details.append(condcomment[0].toString());
            details.append(" (");
            details.append(condcomment[1]);
            details.append(")<br>");
        }
        details.append("<h4>Dependencies</h4>");
        details.append(this.condition.getDependenciesDetails());
        details.append("</body></html>");
        return details.toString();
    }

    public String toString() {
        return Boolean.toString(this.getLastValue());
    }

    public int hashCode() {
        return this.condition.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConditionHistory) {
            return this.condition.getId().equals(((ConditionHistory)obj).condition.getId());
        }
        return false;
    }
}

