/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.merge.resolve;

import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.merge.Mergeable;
import com.izforge.izpack.merge.resolve.MergeableResolver;
import com.izforge.izpack.merge.resolve.ResolveUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PathResolver {
    private final MergeableResolver mergeableResolver;

    public PathResolver(MergeableResolver mergeableResolver) {
        this.mergeableResolver = mergeableResolver;
    }

    public Set<URL> resolvePath(String sourcePath) {
        Set<URL> result = this.findResources(sourcePath);
        if (result.isEmpty()) {
            throw new IzPackException("The path '" + sourcePath + "' is not present inside the classpath.\nThe current classpath is :" + ResolveUtils.getCurrentClasspath());
        }
        return result;
    }

    public List<Mergeable> getMergeableFromPath(String resourcePath) {
        Set<URL> urlList = this.resolvePath(resourcePath);
        ArrayList<Mergeable> result = new ArrayList<Mergeable>();
        for (URL url : urlList) {
            result.add(this.mergeableResolver.getMergeableFromURL(url, resourcePath));
        }
        return result;
    }

    public List<Mergeable> getMergeableFromPackageName(String dependPackage) {
        return this.getMergeableFromPath(dependPackage.replaceAll("\\.", "/") + "/");
    }

    public List<Mergeable> getMergeableJarFromPackageName(String packageName) {
        Set<URL> urlSet = ResolveUtils.getJarUrlForPackage(packageName);
        ArrayList<Mergeable> list = new ArrayList<Mergeable>();
        for (URL url : urlSet) {
            list.add(this.mergeableResolver.getMergeableFromURL(url));
        }
        return list;
    }

    public List<Mergeable> getMergeableFromPath(String resourcePath, String destination) {
        Set<URL> urlList = this.resolvePath(resourcePath);
        ArrayList<Mergeable> result = new ArrayList<Mergeable>();
        for (URL url : urlList) {
            result.add(this.mergeableResolver.getMergeableFromURLWithDestination(url, destination));
        }
        return result;
    }

    protected Set<URL> findResources(String resourcePath) {
        HashSet<URL> result = new HashSet<URL>();
        URL path = ResolveUtils.getFileFromPath(resourcePath);
        if (path != null) {
            result.add(path);
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> iterator = loader.getResources(resourcePath);
            while (iterator.hasMoreElements()) {
                URL url = iterator.nextElement();
                result.add(url);
            }
        }
        catch (IOException e2) {
            throw new IzPackException(e2);
        }
        return result;
    }

    protected MergeableResolver getMergeableResolver() {
        return this.mergeableResolver;
    }
}

