/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.path;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.panels.path.PathInputBase;
import com.izforge.izpack.panels.path.PathSelectionPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PathInputPanel
extends IzPanel
implements ActionListener {
    private static final long serialVersionUID = 3257566217698292531L;
    private static final Logger logger = Logger.getLogger(PathInputPanel.class.getName());
    protected String targetPanel;
    protected boolean mustExist = false;
    protected String[] existFiles = null;
    protected PathSelectionPanel pathSelectionPanel;
    protected String error;
    protected String warn;

    public PathInputPanel(Panel panel, String targetPanel, InstallerFrame parent, GUIInstallData installData, Resources resources, Log log) {
        super(panel, parent, installData, new IzPanelLayout(log), resources);
        this.targetPanel = targetPanel;
        this.error = this.getString("installer.error");
        this.warn = this.getString("installer.warning");
        String introText = this.getI18nStringForClass("intro", this.targetPanel);
        if (introText != null) {
            this.add(LabelFactory.createMultiLineLabel(introText));
            this.add(IzPanelLayout.createParagraphGap());
        }
        this.add((Component)this.createLabel("info", this.targetPanel, "open", 2, true), "nextLine");
        this.pathSelectionPanel = new PathSelectionPanel(this, installData, this.targetPanel, log);
        this.add((Component)this.pathSelectionPanel, "nextLine");
        this.createLayoutBottom();
        this.getLayoutHelper().completeLayout();
    }

    public String getPath() {
        String chosenPath = this.pathSelectionPanel.getPath();
        return PathInputBase.normalizePath(chosenPath);
    }

    public void createLayoutBottom() {
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        Object source = e2.getSource();
        if (source == this.pathSelectionPanel.getPathInputField()) {
            this.parent.navigateNext();
        }
    }

    protected String getMessage(String subkey) {
        String msg = this.getI18nStringForClass(subkey, this.targetPanel);
        if (msg == null) {
            msg = this.targetPanel + "." + subkey;
        }
        return msg;
    }

    @Override
    public boolean isValidated() {
        String path = this.getPath();
        String normalizedPath = PathInputBase.normalizePath(path);
        File file = new File(normalizedPath).getAbsoluteFile();
        if (normalizedPath.length() == 0 && !this.checkEmptyPath()) {
            return false;
        }
        this.pathSelectionPanel.setPath(normalizedPath);
        if (this.isMustExist()) {
            if (!this.checkExists(file) || !this.pathIsValid(true) || this.modifyInstallation() && !this.checkInstallationInformation(file)) {
                return false;
            }
        } else {
            if (!this.isWritable(file)) {
                this.emitError(this.error, this.getMessage("notwritable"));
                return false;
            }
            if (file.exists() ? !this.checkOverwrite(file) : !this.checkCreateDirectory(file)) {
                return false;
            }
        }
        if (!this.installData.getPlatform().isValidDirectoryPath(file)) {
            this.emitError(this.error, this.getMessage("syntax.error"));
            return false;
        }
        return true;
    }

    @Override
    public void panelActivate() {
        super.panelActivate();
        this.mustExist = this.modifyInstallation();
        PathInputBase.setInstallData(this.installData);
    }

    public boolean isMustExist() {
        return this.mustExist;
    }

    public void setMustExist(boolean mustExist) {
        this.mustExist = mustExist;
    }

    public String[] getExistFiles() {
        return this.existFiles;
    }

    public void setExistFiles(String[] strings) {
        this.existFiles = strings;
    }

    protected boolean checkExists(File file) {
        if (!file.exists()) {
            this.emitError(this.error, this.getMessage("required"));
            return false;
        }
        return true;
    }

    protected boolean checkEmptyPath() {
        if (this.isMustExist()) {
            this.emitError(this.error, this.getMessage("required"));
            return false;
        }
        return this.emitWarning(this.warn, this.getMessage("empty_target"));
    }

    protected boolean checkInstallationInformation(File path) {
        File info = new File(path, ".installationinformation");
        if (!info.exists()) {
            this.emitError(this.error, this.getMessage("required.forModificationInstallation"));
            return false;
        }
        return true;
    }

    protected boolean checkRequiredFilesExist(String path) {
        if (this.existFiles == null || path == null || path.isEmpty()) {
            return true;
        }
        for (String existFile : this.existFiles) {
            File file = new File(path, existFile).getAbsoluteFile();
            if (file.exists()) continue;
            return false;
        }
        return true;
    }

    protected boolean checkCreateDirectory(File dir) {
        boolean result = true;
        String show = this.getMetadata().getConfigurationOptionValue("ShowCreateDirectoryMessage", this.installData.getRules());
        if (show == null || Boolean.parseBoolean(show)) {
            result = this.emitNotificationFeedback(this.getMessage("createdir") + "\n" + dir);
        }
        return result;
    }

    protected boolean checkOverwrite(File dir) {
        boolean result = true;
        String show = this.getMetadata().getConfigurationOptionValue("ShowExistingDirectoryWarning", this.installData.getRules());
        File installationInfo = new File(dir, ".installationinformation");
        if (!installationInfo.exists()) {
            show = "true";
        }
        if ((show == null || Boolean.parseBoolean(show)) && dir.isDirectory() && dir.list().length > 0) {
            result = this.askWarningQuestion(this.warn, this.getMessage("exists_warn"), 37, 47) == 47;
        }
        return result;
    }

    protected boolean isWritable(File path) {
        return PathInputBase.isWritable(path);
    }

    protected boolean modifyInstallation() {
        return Boolean.valueOf(this.installData.getVariable("modify.izpack.install"));
    }

    protected boolean pathIsValid() {
        return this.pathIsValid(false);
    }

    protected boolean pathIsValid(boolean notifyUserIfInvalid) {
        String pathToBeChecked = this.getPath();
        boolean isValid = this.checkRequiredFilesExist(pathToBeChecked);
        if (!isValid && notifyUserIfInvalid) {
            String notValidMsg = this.getMessage("notValid");
            logger.log(Level.WARNING, String.format("%s: '%s'", notValidMsg, pathToBeChecked));
            this.emitError(this.error, notValidMsg);
        }
        return isValid;
    }
}

