/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileUtil {
    private static final Pattern WINDOWS_DRIVE_PATTERN = Pattern.compile("^/([a-zA-Z]:.+)$");

    public static File convertUrlToFile(URL url) {
        return new File(FileUtil.convertUrlToFilePath(url));
    }

    public static String convertUrlToFilePath(URL url) {
        try {
            String path;
            URI uri;
            try {
                uri = url.toURI();
            }
            catch (URISyntaxException e2) {
                String escaped = new URI("ignore", url.toString(), null).getRawSchemeSpecificPart();
                uri = new URI(escaped);
            }
            if ("jar".equals(uri.getScheme())) {
                uri = new URI(uri.getRawSchemeSpecificPart());
            }
            StringBuilder result = new StringBuilder();
            String host = uri.getHost();
            if (host != null && !host.isEmpty()) {
                result.append("//").append(host);
            }
            result.append(FileUtil.handleWindowsUrl((path = uri.getPath()) == null ? uri.getSchemeSpecificPart() : path));
            String encodedQuery = url.getQuery();
            if (encodedQuery != null && encodedQuery.isEmpty()) {
                result.append('?').append(URLDecoder.decode(encodedQuery, "UTF-8"));
            }
            return result.toString();
        }
        catch (UnsupportedEncodingException | URISyntaxException e3) {
            throw new RuntimeException(e3);
        }
    }

    private static String handleWindowsUrl(String path) {
        Matcher matcher = WINDOWS_DRIVE_PATTERN.matcher(path);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return path;
    }

    public static File getLockFile(String applicationName) {
        String tempDir = System.getProperty("java.io.tmpdir");
        String fileName = "iz-" + applicationName + ".tmp";
        return new File(tempDir, fileName);
    }

    public static List<String> getFileContent(String fileName) throws IOException {
        String aLine;
        BufferedReader reader;
        ArrayList<String> result = new ArrayList<String>();
        File aFile = new File(fileName);
        if (!aFile.isFile()) {
            return result;
        }
        try {
            reader = new BufferedReader(new FileReader(aFile));
        }
        catch (FileNotFoundException e2) {
            return result;
        }
        while ((aLine = reader.readLine()) != null) {
            result.add(aLine + "\n");
        }
        reader.close();
        return result;
    }

    public static long getFileDateTime(URL url) {
        if (url == null) {
            return -1L;
        }
        String fileName = url.getFile();
        if (fileName.charAt(0) == '/' || fileName.charAt(0) == '\\') {
            fileName = fileName.substring(1, fileName.length());
        }
        try {
            File file = new File(fileName);
            if (!file.isDirectory() && !file.isFile()) {
                return -1L;
            }
            return file.lastModified();
        }
        catch (Exception e2) {
            return -1L;
        }
    }

    public static String[] getFileNames(String dirPath, FilenameFilter fileNameFilter) {
        String[] fileNames = null;
        File dir = new File(dirPath);
        if (dir.isDirectory()) {
            fileNames = fileNameFilter != null ? dir.list(fileNameFilter) : dir.list();
        }
        return fileNames;
    }

    public static File getAbsoluteFile(String filename, String basedir) {
        if (filename == null) {
            return null;
        }
        File file = new File(filename);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(basedir, file.getPath());
    }

    public static String getRelativeFileName(File file, File basedir) throws IOException {
        int length;
        String canonicalBaseDirPath;
        if (!basedir.isDirectory()) {
            throw new IOException("Base path " + basedir + " is expected to be a directory");
        }
        String canonicalFilePath = file.getCanonicalPath();
        if (canonicalFilePath.startsWith(canonicalBaseDirPath = basedir.getCanonicalPath()) && (length = canonicalBaseDirPath.length()) < canonicalFilePath.length()) {
            return canonicalFilePath.substring(length + 1);
        }
        return null;
    }
}

