/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file.types;

import com.izforge.izpack.util.file.CompositeMapper;
import com.izforge.izpack.util.file.ContainerMapper;
import com.izforge.izpack.util.file.FileNameMapper;
import com.izforge.izpack.util.file.types.DataType;
import com.izforge.izpack.util.file.types.Path;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class Mapper
extends DataType
implements Cloneable {
    protected MapperType type = null;
    protected String classname = null;
    protected Path classpath = null;
    protected String from = null;
    protected String to = null;
    private ContainerMapper container = null;

    public void setType(MapperType type) {
        this.type = type;
    }

    public void add(FileNameMapper fileNameMapper) throws Exception {
        if (this.container == null) {
            if (this.type == null && this.classname == null) {
                this.container = new CompositeMapper();
            } else {
                FileNameMapper m2 = this.getImplementation();
                if (m2 instanceof ContainerMapper) {
                    this.container = (ContainerMapper)m2;
                } else {
                    throw new Exception(String.valueOf(m2) + " mapper implementation does not support nested mappers!");
                }
            }
        }
        this.container.add(fileNameMapper);
    }

    public void addConfiguredMapper(Mapper mapper) throws Exception {
        this.add(mapper.getImplementation());
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public FileNameMapper getImplementation() throws Exception {
        if (this.type == null && this.classname == null && this.container == null) {
            throw new Exception("nested mapper or one of the attributes type or classname is required");
        }
        if (this.container != null) {
            return this.container;
        }
        if (this.type != null && this.classname != null) {
            throw new Exception("must not specify both type and classname attribute");
        }
        try {
            FileNameMapper m2 = (FileNameMapper)this.getImplementationClass().newInstance();
            m2.setFrom(this.from);
            m2.setTo(this.to);
            return m2;
        }
        catch (Exception be) {
            throw be;
        }
        catch (Throwable t2) {
            throw new Exception(t2);
        }
    }

    protected Class getImplementationClass() throws ClassNotFoundException {
        String classname = this.classname;
        if (this.type != null) {
            classname = this.type.getImplementation();
        }
        ClassLoader loader = this.getClass().getClassLoader();
        return Class.forName(classname, true, loader);
    }

    public static enum MapperType {
        IDENTITY("identity"),
        FLATTEN("flatten"),
        GLOB("glob"),
        MERGE("merge"),
        REGEXP("regexp"),
        PACKAGE("package"),
        UNPACKAGE("unpackage");

        private static Map<String, MapperType> lookup;
        private static Hashtable<MapperType, String> implementations;
        private String attribute;

        private MapperType(String attribute) {
            this.attribute = attribute;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public static MapperType getFromAttribute(String attribute) {
            if (attribute != null && lookup.containsKey(attribute)) {
                return lookup.get(attribute);
            }
            return null;
        }

        public String getImplementation() {
            return implementations.get((Object)this);
        }

        static {
            lookup = new HashMap<String, MapperType>();
            for (MapperType mapperType : EnumSet.allOf(MapperType.class)) {
                lookup.put(mapperType.getAttribute(), mapperType);
            }
            implementations = new Hashtable();
            implementations.put(IDENTITY, "com.izforge.izpack.util.file.IdentityMapper");
            implementations.put(FLATTEN, "com.izforge.izpack.util.file.FlatFileNameMapper");
            implementations.put(GLOB, "com.izforge.izpack.util.file.GlobPatternMapper");
            implementations.put(MERGE, "com.izforge.izpack.util.file.MergingMapper");
            implementations.put(REGEXP, "com.izforge.izpack.util.file.RegexpPatternMapper");
            implementations.put(PACKAGE, "com.izforge.izpack.util.file.PackageNameMapper");
            implementations.put(UNPACKAGE, "com.izforge.izpack.util.file.UnPackageNameMapper");
        }
    }
}

