/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.injectors;

import java.lang.reflect.AccessibleObject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.annotations.Inject;
import org.picocontainer.behaviors.AbstractBehaviorFactory;
import org.picocontainer.injectors.AbstractInjectionFactory;
import org.picocontainer.injectors.AnnotatedFieldInjection;
import org.picocontainer.injectors.AnnotatedMethodInjection;
import org.picocontainer.injectors.ConstructorInjection;
import org.picocontainer.injectors.MethodInjection;
import org.picocontainer.injectors.SetterInjection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptingInjection
extends AbstractInjectionFactory {
    @Override
    public <T> ComponentAdapter<T> createComponentAdapter(ComponentMonitor componentMonitor, LifecycleStrategy lifecycleStrategy, Properties componentProperties, Object componentKey, Class<T> componentImplementation, Parameter ... parameters) throws PicoCompositionException {
        ComponentAdapter<T> componentAdapter = null;
        if ((componentAdapter = this.fieldAnnotatedInjectionAdapter(componentImplementation, componentMonitor, lifecycleStrategy, componentProperties, componentKey, componentAdapter, parameters)) != null) {
            return componentAdapter;
        }
        if ((componentAdapter = this.methodAnnotatedInjectionAdapter(componentImplementation, componentMonitor, lifecycleStrategy, componentProperties, componentKey, componentAdapter, parameters)) != null) {
            return componentAdapter;
        }
        if ((componentAdapter = this.setterInjectionAdapter(componentProperties, componentMonitor, lifecycleStrategy, componentKey, componentImplementation, componentAdapter, parameters)) != null) {
            return componentAdapter;
        }
        if ((componentAdapter = this.methodInjectionAdapter(componentProperties, componentMonitor, lifecycleStrategy, componentKey, componentImplementation, componentAdapter, parameters)) != null) {
            return componentAdapter;
        }
        return this.defaultInjectionAdapter(componentProperties, componentMonitor, lifecycleStrategy, componentKey, componentImplementation, parameters);
    }

    private <T> ComponentAdapter<T> defaultInjectionAdapter(Properties componentProperties, ComponentMonitor componentMonitor, LifecycleStrategy lifecycleStrategy, Object componentKey, Class<T> componentImplementation, Parameter ... parameters) {
        AbstractBehaviorFactory.removePropertiesIfPresent(componentProperties, Characteristics.CDI);
        return new ConstructorInjection().createComponentAdapter(componentMonitor, lifecycleStrategy, componentProperties, componentKey, componentImplementation, parameters);
    }

    private <T> ComponentAdapter<T> setterInjectionAdapter(Properties componentProperties, ComponentMonitor componentMonitor, LifecycleStrategy lifecycleStrategy, Object componentKey, Class<T> componentImplementation, ComponentAdapter<T> componentAdapter, Parameter ... parameters) {
        if (AbstractBehaviorFactory.removePropertiesIfPresent(componentProperties, Characteristics.SDI)) {
            componentAdapter = new SetterInjection().createComponentAdapter(componentMonitor, lifecycleStrategy, componentProperties, componentKey, componentImplementation, parameters);
        }
        return componentAdapter;
    }

    private <T> ComponentAdapter<T> methodInjectionAdapter(Properties componentProperties, ComponentMonitor componentMonitor, LifecycleStrategy lifecycleStrategy, Object componentKey, Class<T> componentImplementation, ComponentAdapter<T> componentAdapter, Parameter ... parameters) {
        if (AbstractBehaviorFactory.removePropertiesIfPresent(componentProperties, Characteristics.METHOD_INJECTION)) {
            componentAdapter = new MethodInjection().createComponentAdapter(componentMonitor, lifecycleStrategy, componentProperties, componentKey, componentImplementation, parameters);
        }
        return componentAdapter;
    }

    private <T> ComponentAdapter<T> methodAnnotatedInjectionAdapter(Class<T> componentImplementation, ComponentMonitor componentMonitor, LifecycleStrategy lifecycleStrategy, Properties componentProperties, Object componentKey, ComponentAdapter<T> componentAdapter, Parameter ... parameters) {
        if (this.injectionMethodAnnotated(componentImplementation)) {
            componentAdapter = new AnnotatedMethodInjection().createComponentAdapter(componentMonitor, lifecycleStrategy, componentProperties, componentKey, componentImplementation, parameters);
        }
        return componentAdapter;
    }

    private <T> ComponentAdapter<T> fieldAnnotatedInjectionAdapter(Class<T> componentImplementation, ComponentMonitor componentMonitor, LifecycleStrategy lifecycleStrategy, Properties componentProperties, Object componentKey, ComponentAdapter<T> componentAdapter, Parameter ... parameters) {
        if (this.injectionFieldAnnotated(componentImplementation)) {
            componentAdapter = new AnnotatedFieldInjection().createComponentAdapter(componentMonitor, lifecycleStrategy, componentProperties, componentKey, componentImplementation, parameters);
        }
        return componentAdapter;
    }

    private boolean injectionMethodAnnotated(final Class<?> componentImplementation) {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return AdaptingInjection.this.injectionAnnotated(componentImplementation.getDeclaredMethods());
            }
        });
    }

    private boolean injectionFieldAnnotated(final Class<?> componentImplementation) {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (componentImplementation.isInterface()) {
                    return false;
                }
                for (Class impl = componentImplementation; impl != Object.class; impl = impl.getSuperclass()) {
                    boolean injAnnotated = AdaptingInjection.this.injectionAnnotated(impl.getDeclaredFields());
                    if (!injAnnotated) continue;
                    return true;
                }
                return false;
            }
        });
    }

    private boolean injectionAnnotated(AccessibleObject[] objects) {
        for (AccessibleObject object : objects) {
            if (object.getAnnotation(Inject.class) == null) continue;
            return true;
        }
        return false;
    }
}

