/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.monitors;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.picocontainer.Behavior;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.ComponentMonitorStrategy;
import org.picocontainer.Injector;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.monitors.NullComponentMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractComponentMonitor
implements ComponentMonitor,
ComponentMonitorStrategy,
Serializable {
    private ComponentMonitor delegate;

    public AbstractComponentMonitor(ComponentMonitor delegate) {
        this.checkMonitor(delegate);
        this.delegate = delegate;
    }

    public AbstractComponentMonitor() {
        this(new NullComponentMonitor());
    }

    @Override
    public <T> Constructor<T> instantiating(PicoContainer container, ComponentAdapter<T> componentAdapter, Constructor<T> constructor) {
        return this.delegate.instantiating(container, componentAdapter, constructor);
    }

    @Override
    public <T> void instantiated(PicoContainer container, ComponentAdapter<T> componentAdapter, Constructor<T> constructor, Object instantiated, Object[] injected, long duration) {
        this.delegate.instantiated(container, componentAdapter, constructor, instantiated, injected, duration);
    }

    @Override
    public <T> void instantiationFailed(PicoContainer container, ComponentAdapter<T> componentAdapter, Constructor<T> constructor, Exception e2) {
        this.delegate.instantiationFailed(container, componentAdapter, constructor, e2);
    }

    @Override
    public Object invoking(PicoContainer container, ComponentAdapter<?> componentAdapter, Member member, Object instance, Object[] args) {
        return this.delegate.invoking(container, componentAdapter, member, instance, args);
    }

    @Override
    public void invoked(PicoContainer container, ComponentAdapter<?> componentAdapter, Member member, Object instance, long duration, Object[] args, Object retVal) {
        this.delegate.invoked(container, componentAdapter, member, instance, duration, args, retVal);
    }

    @Override
    public void invocationFailed(Member member, Object instance, Exception e2) {
        this.delegate.invocationFailed(member, instance, e2);
    }

    @Override
    public void lifecycleInvocationFailed(MutablePicoContainer container, ComponentAdapter<?> componentAdapter, Method method, Object instance, RuntimeException cause) {
        this.delegate.lifecycleInvocationFailed(container, componentAdapter, method, instance, cause);
    }

    @Override
    public Object noComponentFound(MutablePicoContainer container, Object componentKey) {
        return this.delegate.noComponentFound(container, componentKey);
    }

    @Override
    public Injector newInjector(Injector injector) {
        return injector;
    }

    @Override
    public Behavior newBehavior(Behavior behavior) {
        return behavior;
    }

    @Override
    public void changeMonitor(ComponentMonitor monitor) {
        this.checkMonitor(monitor);
        if (this.delegate instanceof ComponentMonitorStrategy) {
            ((ComponentMonitorStrategy)((Object)this.delegate)).changeMonitor(monitor);
        } else {
            this.delegate = monitor;
        }
    }

    @Override
    public ComponentMonitor currentMonitor() {
        if (this.delegate instanceof ComponentMonitorStrategy) {
            return ((ComponentMonitorStrategy)((Object)this.delegate)).currentMonitor();
        }
        return this.delegate;
    }

    private void checkMonitor(ComponentMonitor monitor) {
        if (monitor == null) {
            throw new NullPointerException("monitor");
        }
    }
}

