/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Application;

import au.com.aemo.Common.API.WebAPIAppAbout;
import au.com.aemo.Common.API.WebAPIAppConfiguration;
import au.com.aemo.Common.API.WebAPIAppStatus;
import au.com.aemo.Common.API.WebAPIAuthentication;
import au.com.aemo.Common.API.WebAPIAuthenticationRoles;
import au.com.aemo.Common.API.WebAPIAuthenticationUsers;
import au.com.aemo.Common.API.WebAPIAuthorisation;
import au.com.aemo.Common.API.WebAPIDatabaseStatus;
import au.com.aemo.Common.API.WebAPIFileSystemStatus;
import au.com.aemo.Common.API.WebAPIPasswordUpdate;
import au.com.aemo.Common.API.WebAPIServerStatus;
import au.com.aemo.Common.API.WebAPIServicesCatalog;
import au.com.aemo.Common.API.WebAPIWebCertificateManagement;
import au.com.aemo.Common.API.WebAPIWebHMACKeyManagement;
import au.com.aemo.Common.Alerting.AlertConfig;
import au.com.aemo.Common.Alerting.AlertManager;
import au.com.aemo.Common.Application.AppConfiguration;
import au.com.aemo.Common.Application.ApplicationExtensionInt;
import au.com.aemo.Common.Application.ApplicationInt;
import au.com.aemo.Common.Application.ApplicationManagerStartupOptions;
import au.com.aemo.Common.Application.ApplicationShutdown;
import au.com.aemo.Common.Application.ConfigurationManager;
import au.com.aemo.Common.Application.ConfigurationValueResolver;
import au.com.aemo.Common.Application.SignalHandlerImpl;
import au.com.aemo.Common.Authentication.AuthenticationConfig;
import au.com.aemo.Common.Authentication.AuthenticationManager;
import au.com.aemo.Common.Authentication.KeyManager;
import au.com.aemo.Common.Certificate.CertificateManager;
import au.com.aemo.Common.Certificate.CertificateStoreConfig;
import au.com.aemo.Common.DataVault.ApplicationDataVaultManager;
import au.com.aemo.Common.DataVault.DataVault;
import au.com.aemo.Common.DataVault.DataVaultConfig;
import au.com.aemo.Common.Database.DatabaseConfig;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.FileSystem.FilesystemManager;
import au.com.aemo.Common.Files.FilesystemMonitor;
import au.com.aemo.Common.Files.FilesystemMonitorAlert;
import au.com.aemo.Common.Files.FilesystemMonitorConfig;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Jobs.LockManager;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Network.DistributedMessagingConfig;
import au.com.aemo.Common.Network.DistributedMessagingManager;
import au.com.aemo.Common.Scheduler.JobSchedulerManager;
import au.com.aemo.Common.Threading.threadMonitor;
import au.com.aemo.Common.Web.WebAccessEnum;
import au.com.aemo.Common.Web.WebProxyConfig;
import au.com.aemo.Common.Web.WebServer;
import au.com.aemo.Common.Web.WebServerConfig;
import au.com.aemo.Common.Web.WebServerConfigIPAddress;
import au.com.aemo.Common.XML.XmlUtilities;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.DomReader;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import sun.misc.Signal;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Application configuration is consumed by trusted code")
public class ApplicationManager {
    private static Logger logger = LoggerFactory.getLogger(ApplicationManager.class);
    private ApplicationInt itsApplication;
    private List<ApplicationExtensionInt> itsExtensions;
    private Date itsStartDate = new Date();
    private String itsAppName;
    private String itsAppVersion;
    private String itsConfigPrefix;
    private UUID itsUUID = UUID.randomUUID();

    private ApplicationManager() {
        this.itsExtensions = new ArrayList<ApplicationExtensionInt>();
    }

    public static ApplicationManager getInstance() {
        return SingletonHolder.instance;
    }

    public ApplicationManagerStartupOptions buildStartOptions() {
        return new ApplicationManagerStartupOptions();
    }

    public Date getStartDate() {
        return this.itsStartDate;
    }

    public UUID getUUID() {
        return this.itsUUID;
    }

    public List<ApplicationExtensionInt> getExtensions() {
        return this.itsExtensions;
    }

    public synchronized void init(String string, String string2, String string3, String string4, Class clazz) throws Exception {
        this.init(string, string2, string3, string4, clazz, this.buildStartOptions().startDatabase().startWebServer().startDistributedMessaging().startFileSystemMonitor().startFileSystemManager());
    }

    public AppConfiguration init(String string, String string2, String string3, String string4, Class clazz, ApplicationManagerStartupOptions applicationManagerStartupOptions) throws Exception {
        ApplicationManager.initPreConfig(string2);
        Util_Logger.info(logger, "Starting " + string2 + " v" + string3 + " with configuration file " + string);
        this.itsAppName = string2;
        this.itsAppVersion = string3;
        this.itsConfigPrefix = string4;
        KeyManager.getInstance().loadKeyConfiguration();
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        configurationManager.configure(string);
        Properties properties = configurationManager.getProperties();
        AppConfiguration appConfiguration = new AppConfiguration();
        appConfiguration.CertificateStore = CertificateManager.loadConfigFromProperties(properties, "client");
        if (appConfiguration.CertificateStore != null) {
            appConfiguration.CertificateStore.AllowToCreate = applicationManagerStartupOptions.getCreateClientCertificateStore();
            appConfiguration.CertificateStore.setDefaultValues();
            CertificateManager.getInstance().setCertStoreConfig(appConfiguration.CertificateStore);
        }
        appConfiguration.DataVaults = ApplicationDataVaultManager.loadConfigFromProperties(properties);
        ApplicationDataVaultManager applicationDataVaultManager = ApplicationDataVaultManager.getInstance();
        applicationDataVaultManager.configure(appConfiguration.DataVaults);
        appConfiguration.AppName = string2;
        appConfiguration.AppVersion = string3;
        appConfiguration.AppClass = clazz;
        appConfiguration.Alert = AlertManager.loadConfigFromProperties(properties);
        if (applicationManagerStartupOptions.getStartWebServer()) {
            appConfiguration.WebServer = WebServer.loadConfigFromProperties(properties);
        }
        if (applicationManagerStartupOptions.getStartDatabase()) {
            appConfiguration.Database = DbManager.loadConfigFromProperties(properties);
        }
        appConfiguration.FilesystemMonitor = FilesystemMonitor.loadConfigFromProperties(properties);
        appConfiguration.DistributedMessaging = DistributedMessagingManager.loadConfigFromProperties(properties);
        appConfiguration.AppExtensionClass = Util.getProperty(properties, "application_extension_class", null);
        appConfiguration.FilesystemManager = properties;
        appConfiguration.WebProxy = WebProxyConfig.loadConfigFromProperties(properties);
        appConfiguration.LockManager = LockManager.loadConfigFromProperties(properties);
        this.initPostConfig(appConfiguration, applicationManagerStartupOptions);
        return appConfiguration;
    }

    private AppConfiguration loadConfig(Class clazz, String string, Class clazz2, List<Class> list, ApplicationManagerStartupOptions applicationManagerStartupOptions) throws Exception {
        AppConfiguration appConfiguration = (AppConfiguration)clazz2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
        XStream xStream = XmlUtilities.getConverter();
        xStream.processAnnotations(AppConfiguration.class);
        xStream.processAnnotations(WebServerConfig.class);
        xStream.processAnnotations(WebProxyConfig.class);
        xStream.processAnnotations(WebServerConfigIPAddress.class);
        xStream.processAnnotations(WebAccessEnum.class);
        xStream.processAnnotations(AlertConfig.class);
        xStream.processAnnotations(DatabaseConfig.class);
        xStream.processAnnotations(AuthenticationConfig.class);
        xStream.processAnnotations(FilesystemMonitorConfig.class);
        xStream.processAnnotations(FilesystemMonitorAlert.class);
        xStream.processAnnotations(DataVaultConfig.class);
        xStream.processAnnotations(DataVault.class);
        xStream.processAnnotations(DistributedMessagingConfig.class);
        xStream.processAnnotations(CertificateStoreConfig.class);
        if (list != null) {
            for (Class object2 : list) {
                xStream.processAnnotations(object2);
            }
        }
        final ConfigurationValueResolver configurationValueResolver = new ConfigurationValueResolver();
        xStream.unmarshal((HierarchicalStreamReader)new DomReader(document){

            public String getValue() {
                String string = super.getValue();
                String string2 = configurationValueResolver.resolveValue(string, false);
                return string2;
            }
        }, (Object)appConfiguration);
        if (appConfiguration.CertificateStore != null) {
            appConfiguration.CertificateStore.setDefaultValues();
            appConfiguration.CertificateStore.AllowToCreate = applicationManagerStartupOptions.getCreateClientCertificateStore();
            CertificateManager.getInstance().setCertStoreConfig(appConfiguration.CertificateStore);
        }
        ApplicationDataVaultManager applicationDataVaultManager = ApplicationDataVaultManager.getInstance();
        applicationDataVaultManager.configure(appConfiguration.DataVaults);
        if (applicationDataVaultManager.isEnabled()) {
            xStream.unmarshal((HierarchicalStreamReader)new DomReader(document){

                public String getValue() {
                    String string = super.getValue();
                    String string2 = configurationValueResolver.resolveValue(string, true);
                    return string2;
                }
            }, (Object)appConfiguration);
        }
        appConfiguration.applyDefaults();
        return appConfiguration;
    }

    public AppConfiguration init(String string, String string2, Class clazz, String string3, Class clazz2, List<Class> list, ApplicationManagerStartupOptions applicationManagerStartupOptions) throws Exception {
        ApplicationManager.initPreConfig(string);
        Util_Logger.info(logger, "Starting " + string + " v" + string2 + " with configuration file " + string3);
        this.itsAppName = string;
        this.itsAppVersion = string2;
        KeyManager.getInstance().loadKeyConfiguration();
        AppConfiguration appConfiguration = this.loadConfig(clazz, string3, clazz2, list, applicationManagerStartupOptions);
        appConfiguration.AppName = string;
        appConfiguration.AppVersion = string2;
        appConfiguration.AppClass = clazz;
        this.initPostConfig(appConfiguration, applicationManagerStartupOptions);
        return appConfiguration;
    }

    private static void initPreConfig(String string) throws Exception {
        String string2 = InetAddress.getLocalHost().getHostName();
        System.setProperty("hostname", string2);
        System.setProperty("app_name", string);
        TimeZone timeZone = TimeZone.getTimeZone("Australia/Brisbane");
        TimeZone.setDefault(timeZone);
        Locale.setDefault(Locale.ENGLISH);
        Thread.currentThread().setName(string + "-Main");
    }

    private void initPostConfig(AppConfiguration appConfiguration, ApplicationManagerStartupOptions applicationManagerStartupOptions) throws Exception {
        Object object;
        Object object2;
        if (appConfiguration.WebProxy != null && !Util.isBlank(appConfiguration.WebProxy.WebProxyHost) && appConfiguration.WebProxy.WebProxyPort != null) {
            System.setProperty("http.proxyHost", appConfiguration.WebProxy.WebProxyHost);
            System.setProperty("http.proxyPort", appConfiguration.WebProxy.WebProxyPort);
            System.setProperty("https.proxyHost", appConfiguration.WebProxy.WebProxyHost);
            System.setProperty("https.proxyPort", appConfiguration.WebProxy.WebProxyPort);
        }
        if (!Util.isBlank(appConfiguration.AppExtensionClass)) {
            for (Object object3 : object2 = Util.getColumns(appConfiguration.AppExtensionClass, ',')) {
                if (Util.isBlank((String)object3)) continue;
                Class<?> clazz = Class.forName((String)object3);
                ApplicationExtensionInt applicationExtensionInt = (ApplicationExtensionInt)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.itsExtensions.add(applicationExtensionInt);
                Util_Logger.info(logger, "Added extension library " + applicationExtensionInt.name() + " " + applicationExtensionInt.version());
            }
        }
        if (applicationManagerStartupOptions.getStartDatabase()) {
            DbManager.initDbPool(appConfiguration);
        }
        object2 = threadMonitor.getInstance();
        ((threadMonitor)object2).setAppDetails(appConfiguration);
        AlertManager.configureAlert(appConfiguration);
        if (applicationManagerStartupOptions.getStartAuthenticationManager() && appConfiguration.Authentication != null) {
            AuthenticationManager.getInstance().configure(appConfiguration.Authentication);
        }
        if (applicationManagerStartupOptions.getStartFileSystemMonitor() && appConfiguration.FilesystemMonitor != null) {
            FilesystemMonitor.getInstance().configure(appConfiguration.FilesystemMonitor);
        }
        if (applicationManagerStartupOptions.getStartDistributedMessaging() && appConfiguration.DistributedMessaging != null) {
            object = DistributedMessagingManager.getInstance();
            ((DistributedMessagingManager)object).init(appConfiguration.DistributedMessaging);
            ((DistributedMessagingManager)object).start();
        }
        if (appConfiguration.LockManager != null) {
            LockManager.getInstance().configure(appConfiguration.LockManager);
        }
        if (applicationManagerStartupOptions.getStartWebServer() && appConfiguration.WebServer != null) {
            object = WebServer.getInstance();
            ((WebServer)object).init(appConfiguration.WebServer);
            ((WebServer)object).addHandler(WebAPIServerStatus.class);
            if (appConfiguration.WebServer.WebServiceCatalogEnable.booleanValue()) {
                ((WebServer)object).addHandler(WebAPIServicesCatalog.class);
            }
            if (applicationManagerStartupOptions.getStartDatabase()) {
                ((WebServer)object).addHandler(WebAPIDatabaseStatus.class);
            }
            ((WebServer)object).addHandler(WebAPIAppStatus.class);
            ((WebServer)object).addHandler(WebAPIAppConfiguration.class);
            ((WebServer)object).addHandler(WebAPIAppAbout.class);
            ((WebServer)object).addHandler(WebAPIFileSystemStatus.class);
            if (appConfiguration.Authentication != null) {
                ((WebServer)object).addHandler(WebAPIAuthentication.class);
                ((WebServer)object).addHandler(WebAPIAuthorisation.class);
                ((WebServer)object).addHandler(WebAPIAuthenticationRoles.class);
                ((WebServer)object).addHandler(WebAPIAuthenticationUsers.class);
                ((WebServer)object).addHandler(WebAPIPasswordUpdate.class);
            }
            if (appConfiguration.WebServer.HTTPS != null || appConfiguration.CertificateStore != null) {
                ((WebServer)object).addHandler(WebAPIWebCertificateManagement.class);
            }
            ((WebServer)object).addHandler(WebAPIWebHMACKeyManagement.class);
            ((WebServer)object).start();
        }
        if (applicationManagerStartupOptions.getStartFileSystemManager()) {
            object = FilesystemManager.getInstance();
            ((FilesystemManager)object).configure(this.itsAppName, this.itsAppVersion, this.itsConfigPrefix, appConfiguration.FilesystemManager);
            ((FilesystemManager)object).start();
        }
        if (this.itsExtensions != null) {
            for (ApplicationExtensionInt applicationExtensionInt : this.itsExtensions) {
                try {
                    applicationExtensionInt.initialise();
                }
                catch (Exception exception) {
                    Util_Logger.errorNoRaise(logger, "Error initialising application extension " + applicationExtensionInt.name() + ": " + exception.getMessage(), exception);
                }
            }
        }
    }

    public void register(ApplicationInt applicationInt) {
        this.itsApplication = applicationInt;
        if (this.itsExtensions != null) {
            for (ApplicationExtensionInt applicationExtensionInt : this.itsExtensions) {
                try {
                    applicationExtensionInt.start();
                }
                catch (Exception exception) {
                    Util_Logger.errorNoRaise(logger, "Error starting application extension " + applicationExtensionInt.name() + ": " + exception.getMessage(), exception);
                }
            }
        }
    }

    public void registerWithShutdown(ApplicationInt applicationInt) {
        this.register(applicationInt);
        String string = System.getProperty("shutdownSignal");
        if (Util.isBlank(string)) {
            Util_Logger.debug(logger, "Adding runtime shutdown hook");
            Runtime.getRuntime().addShutdownHook(new ApplicationShutdown());
        } else {
            SignalHandlerImpl signalHandlerImpl = new SignalHandlerImpl();
            for (String string2 : Util.getColumns(string, ',')) {
                Util_Logger.debug(logger, "Adding shutdown handler for signal [" + string2 + "]");
                Signal.handle(new Signal(string2), signalHandlerImpl);
            }
        }
    }

    public ApplicationInt getApplication() {
        return this.itsApplication;
    }

    public Properties getConfiguration() {
        return this.itsApplication.getConfiguration();
    }

    public void shutdown(ApplicationInt applicationInt) {
        Util_Logger.info(logger, "Shutting down " + this.itsAppName + " service");
        if (this.itsExtensions != null) {
            for (ApplicationExtensionInt applicationExtensionInt : this.itsExtensions) {
                try {
                    applicationExtensionInt.stop();
                }
                catch (Exception exception) {
                    Util_Logger.errorNoRaise(logger, "Error stopping application extension " + applicationExtensionInt.name() + ": " + exception.getMessage(), exception);
                }
            }
        }
        threadMonitor.getInstance().stop();
        WebServer.getInstance().stop();
        JobSchedulerManager.getInstance().stop();
        if (applicationInt != null) {
            applicationInt.stop();
        }
        threadMonitor.getInstance().wakeUpThreads();
        if (applicationInt != null) {
            applicationInt.finaliseShutdown();
        }
        FilesystemManager.getInstance().stop();
        DistributedMessagingManager.getInstance().stop();
        Util_Logger.info(logger, this.itsAppName + " stopped");
    }

    public void shutdown() {
        this.shutdown(this.itsApplication);
    }

    private static class SingletonHolder {
        private static ApplicationManager instance = new ApplicationManager();

        private SingletonHolder() {
        }
    }
}

